/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invk;

import com.sonicsw.xqimpl.util.MessageFormatter;
import java.io.PrintStream;
import java.io.PrintWriter;

public class ESBException
extends Exception {
    public static final int UNSPECIFIED = -1;
    public static final int EXTERNAL_ERROR = 0;
    public static final int WSDL_ERROR = 1;
    public static final int OPERATION_ERROR = 2;
    public static final int MESSAGECONTEXT_ERROR = 3;
    public static final int ENDPOINT_ERROR = 4;
    public static final int MESSAGE_ERROR = 5;
    public static final String INVK_ERRORS_RESOURCE_BUNDLE = "com.sonicsw.xqimpl.invk.InvkErrors";
    protected Throwable m_exception;
    protected int m_errorCode;

    public ESBException(String resourceBundleBaseName, String message, Object[] arguments, int errorCode) {
        super(MessageFormatter.formatMessage((String)resourceBundleBaseName, (String)message, (Object[])arguments));
        this.m_errorCode = errorCode;
    }

    public ESBException(String reason, Object[] arguments, int errorCode) {
        this(INVK_ERRORS_RESOURCE_BUNDLE, reason, arguments, errorCode);
    }

    public ESBException(String reason, int errorCode) {
        this(INVK_ERRORS_RESOURCE_BUNDLE, reason, null, errorCode);
    }

    public ESBException(String reason, Object[] arguments, int errorCode, Throwable exception) {
        this(INVK_ERRORS_RESOURCE_BUNDLE, reason, arguments, errorCode);
        this.m_exception = exception;
    }

    public ESBException(Throwable exception) {
        this.m_exception = exception;
    }

    public final void setLinkedException(Throwable exception) {
        this.m_exception = exception;
    }

    public final Throwable getLinkedException() {
        return this.m_exception;
    }

    public final void setErrorID(int errorCode) {
        this.m_errorCode = errorCode;
    }

    public final int getErrorCode() {
        return this.m_errorCode;
    }

    @Override
    public String getMessage() {
        String str;
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.getMessage());
        if (this.m_exception != null && (str = this.m_exception.getMessage()) != null && !"".equals(str)) {
            buffer.append(" (").append(str).append(")");
        }
        return buffer.toString();
    }

    @Override
    public String getLocalizedMessage() {
        String str;
        StringBuilder buffer = new StringBuilder();
        buffer.append(super.getLocalizedMessage());
        if (this.m_exception != null && (str = this.m_exception.getLocalizedMessage()) != null && !"".equals(str)) {
            buffer.append(" (").append(str).append(")");
        }
        return buffer.toString();
    }

    @Override
    public final void printStackTrace() {
        if (this.m_exception != null) {
            this.m_exception.printStackTrace();
        }
        super.printStackTrace();
    }

    @Override
    public final void printStackTrace(PrintStream stream) {
        if (this.m_exception != null) {
            this.m_exception.printStackTrace(stream);
        }
        super.printStackTrace(stream);
    }

    @Override
    public final void printStackTrace(PrintWriter writer) {
        if (this.m_exception != null) {
            this.m_exception.printStackTrace(writer);
        }
        super.printStackTrace(writer);
    }
}

