/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.script.wsdl;

import com.sonicsw.esb.ws.invocation.ESBWSException;
import com.sonicsw.esb.ws.invocation.ESBWSOperation;
import com.sonicsw.esb.ws.invocation.ESBWSService;
import com.sonicsw.xqimpl.script.wsdl.PortInfo;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelper;
import com.sonicsw.xqimpl.script.wsdl.WSDLHelperException;
import com.sonicsw.xqimpl.script.wsdl.WSDLOperation;
import com.sonicsw.xqimpl.script.wsdl.WSDLUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class WSDLServiceHelper
implements ESBWSService {
    private Definition m_def = null;
    private Service m_service = null;
    private Map m_portMap = null;
    private String m_wsdlLocation = null;
    private QName m_qname = null;
    private WSDLHelper m_wsdlHelper = null;

    WSDLServiceHelper(WSDLHelper helper, String wsdlLocation, Service service) {
        this.m_wsdlHelper = helper;
        this.m_wsdlLocation = wsdlLocation;
        this.m_def = this.m_wsdlHelper.getDefinition();
        this.m_service = service;
        this.m_qname = service == null ? WSDLHelper.DEFAULT_SERVICE_QNAME : service.getQName();
    }

    public String[] getPortNamesArray() throws WSDLHelperException {
        if (this.m_portMap == null) {
            this.m_portMap = new HashMap();
            if (this.m_service == null) {
                Map bindings = this.m_def.getBindings();
                if (bindings.isEmpty()) {
                    Map portTypes = this.m_def.getPortTypes();
                    for (PortType pt : portTypes.values()) {
                        String displayName = this.makePrefixedName(pt.getQName());
                        this.m_portMap.put(displayName, new PortInfo(this, displayName, pt));
                    }
                } else {
                    for (Binding binding : bindings.values()) {
                        PortType pt = binding.getPortType();
                        String displayName = this.makePrefixedName(pt.getQName());
                        this.m_portMap.put(displayName, new PortInfo(this, displayName, binding));
                    }
                }
            } else {
                Map ports = this.m_service.getPorts();
                for (Port p : ports.values()) {
                    String displayName = p.getName();
                    try {
                        PortInfo pi = new PortInfo(this, displayName, p);
                        this.m_portMap.put(displayName, pi);
                    }
                    catch (WSDLHelperException wSDLHelperException) {}
                }
            }
        }
        Set portNames = this.m_portMap.keySet();
        return portNames.toArray(new String[portNames.size()]);
    }

    public WSDLOperation[] getOperationsArray(String portName) throws WSDLHelperException {
        if (this.m_portMap == null) {
            this.getPortNamesArray();
        }
        if (portName == null) {
            throw new WSDLHelperException("null-port-name", null);
        }
        PortInfo portInfo = (PortInfo)this.m_portMap.get(portName);
        if (portInfo == null) {
            throw new WSDLHelperException("port-not-found", new Object[]{portName});
        }
        List opList = portInfo.getOperations();
        WSDLOperation[] ops = new WSDLOperation[opList.size()];
        for (int i = 0; i < opList.size(); ++i) {
            ops[i] = new WSDLOperation(this, portInfo, (Operation)opList.get(i));
        }
        return ops;
    }

    String getPartBaseType(Part part) throws WSDLHelperException {
        if (WSDLUtils.isElement(part)) {
            return "xsd:anyType";
        }
        QName typename = WSDLUtils.getPartTypeName(part);
        return this.getBaseType(typename);
    }

    String getBaseType(QName qname) throws WSDLHelperException {
        String baseType = this.m_wsdlHelper.getBaseTypeName(qname);
        if (baseType == null) {
            return "xsd:anyType";
        }
        return baseType;
    }

    String makePrefixedName(QName qname) {
        return this.m_def.getPrefix(qname.getNamespaceURI()) + ":" + qname.getLocalPart();
    }

    Service getService() {
        return this.m_service;
    }

    public String getLocation() {
        return this.m_wsdlLocation;
    }

    public QName getServiceName() {
        return this.m_qname;
    }

    @Override
    public QName getName() {
        return this.m_qname;
    }

    @Override
    public String getURI() {
        return this.m_qname.getNamespaceURI();
    }

    @Override
    public String getLocalName() {
        return this.m_qname.getLocalPart();
    }

    @Override
    public String getDisplayName() {
        if (this.m_service == null) {
            return "ESB-Default";
        }
        return this.makePrefixedName(this.m_qname);
    }

    public WSDLHelper getWSDLHelper() {
        return this.m_wsdlHelper;
    }

    @Override
    public List getOperations(String portName) throws ESBWSException {
        return Arrays.asList(this.getOperationsArray(portName));
    }

    @Override
    public List getPortNames() throws ESBWSException {
        return Arrays.asList(this.getPortNamesArray());
    }

    @Override
    public ESBWSOperation getOperation(String portName, String opName) throws ESBWSException {
        List ops = this.getOperations(portName);
        for (WSDLOperation op : ops) {
            if (!op.getName().equals(opName)) continue;
            return op;
        }
        return null;
    }
}

