/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.xmlstream;

import com.sonicsw.xq.service.xcbr.utils.OSBoolean;
import com.sonicsw.xq.service.xcbr.xmlstream.OutputXML;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLAttributeName;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidAttributeNameException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidAttributeValueException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;

public class XMLAttribute
implements OutputXML {
    protected String _name;
    String _value;
    protected static final String XML_ATTRIBUTE_VALUE_DELIMITER = "\"";
    protected static final String XML_ATTRIBUTE_VALUE_EQUALS = "=";
    private static final String XML_ATTRIBUTE_SPACER = " ";

    XMLAttribute(String aName, String aValue) throws XMLInvalidAttributeNameException, XMLInvalidAttributeValueException {
        if (aName != null) {
            if (XMLAttributeName.isValidXMLAttributeName(aName)) {
                this._name = aName;
                this._value = aValue;
            } else {
                throw new XMLInvalidAttributeNameException();
            }
        }
    }

    XMLAttribute(String argName, int argValue) {
        this(argName, Integer.toString(argValue));
    }

    XMLAttribute(String argName, boolean argBoolean) {
        this(argName, OSBoolean.booleanAsString(argBoolean));
    }

    @Override
    public void print(XMLOutputStream aStream) {
        if (this._name != null) {
            aStream.add(this._name + XML_ATTRIBUTE_VALUE_EQUALS + XML_ATTRIBUTE_VALUE_DELIMITER);
            if (this._value != null) {
                aStream.add(this._value);
            }
            aStream.add(XML_ATTRIBUTE_VALUE_DELIMITER);
        }
    }

    public String toString() {
        StringBuilder returnValue = new StringBuilder(this.getName() + XML_ATTRIBUTE_SPACER);
        returnValue.append(XML_ATTRIBUTE_VALUE_DELIMITER);
        if (this._value != null) {
            returnValue.append(this._value);
        }
        returnValue.append(XML_ATTRIBUTE_VALUE_DELIMITER);
        return returnValue.toString();
    }

    protected String getName() {
        return this._name;
    }

    protected void setValue(String aValue) {
        this._value = aValue;
    }
}

