/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xq.service.xcbr.xmlstream;

import com.sonicsw.xq.service.xcbr.xmlstream.OutputXML;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLAttribute;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLDuplicateAttributeException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidAttributeNameException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLInvalidAttributeValueException;
import com.sonicsw.xq.service.xcbr.xmlstream.XMLOutputStream;
import java.util.HashMap;
import java.util.Map;

public class XMLAttributes
implements OutputXML {
    private XMLAttribute _attribute;
    private HashMap<String, XMLAttribute> _keyedAttributes;
    private static final String ATTRIBUTE_SPACER = " ";

    public void addAttribute(String aName, String aValue) throws XMLInvalidAttributeNameException, XMLInvalidAttributeValueException, XMLDuplicateAttributeException {
        if (aName != null) {
            if (this.getAttribute(aName) != null) {
                throw new XMLDuplicateAttributeException(aName);
            }
            XMLAttribute value = new XMLAttribute(aName, aValue);
            if (this.size() == 0) {
                this._attribute = value;
            } else if (this.size() == 1) {
                this._keyedAttributes = new HashMap();
                this._keyedAttributes.put(this._attribute.getName(), this._attribute);
                this._keyedAttributes.put(aName, value);
                this._attribute = null;
            } else {
                this._keyedAttributes.put(aName, value);
                this._attribute = null;
            }
        }
    }

    public void setAttribute(String aName, String aValue) throws XMLInvalidAttributeNameException, XMLInvalidAttributeValueException {
        block2: {
            try {
                this.addAttribute(aName, aValue);
            }
            catch (XMLDuplicateAttributeException e) {
                XMLAttribute currentAttr = this.getAttribute(aName);
                if (currentAttr == null) break block2;
                currentAttr.setValue(aValue);
            }
        }
    }

    @Override
    public void print(XMLOutputStream aStream) {
        if (this._attribute != null) {
            aStream.add(ATTRIBUTE_SPACER);
            this._attribute.print(aStream);
        } else if (this._keyedAttributes != null) {
            for (Map.Entry<String, XMLAttribute> attributeEntry : this._keyedAttributes.entrySet()) {
                aStream.add(ATTRIBUTE_SPACER);
                attributeEntry.getValue().print(aStream);
            }
        }
    }

    protected int size() {
        int size = 0;
        if (!this.isEmpty()) {
            if (this._attribute != null) {
                size = 1;
            } else if (this._keyedAttributes != null) {
                size = this._keyedAttributes.size();
            }
        }
        return size;
    }

    private XMLAttribute getAttribute(String aValue) {
        if (this._attribute != null) {
            return this._attribute;
        }
        if (this._keyedAttributes != null) {
            return this._keyedAttributes.get(aValue);
        }
        return null;
    }

    private boolean isEmpty() {
        return this._attribute == null && this._keyedAttributes == null;
    }
}

