/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.endpoint.container.jca;

import com.sonicsw.xq.XQEndpointCreationException;
import com.sonicsw.xq.XQEndpointException;
import com.sonicsw.xq.XQLog;
import com.sonicsw.xq.XQMessageFactory;
import com.sonicsw.xq.adapter.XQMessageListenerFactory;
import com.sonicsw.xq.adapter.XQResourceAdapter;
import com.sonicsw.xqimpl.config.XQEndpointConfig;
import com.sonicsw.xqimpl.config.XQEndpointTypeConfig;
import com.sonicsw.xqimpl.endpoint.container.DispatcherMessageListenerFactory;
import com.sonicsw.xqimpl.endpoint.container.jca.JCABaseEndpoint;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAConnectionManager;
import com.sonicsw.xqimpl.endpoint.container.jca.JCAInterimConnection;
import com.sonicsw.xqimpl.service.IXQMessageListener;
import java.util.HashMap;
import java.util.Map;

public class JCAInterimEndpoint
extends JCABaseEndpoint {
    private HashMap m_factories = new HashMap();
    private HashMap m_specs = new HashMap();

    public JCAInterimEndpoint(XQEndpointConfig config, XQEndpointTypeConfig typeConfig, XQLog log, JCAInterimConnection connection, XQMessageFactory messageFactory, JCAConnectionManager connectionManager) throws XQEndpointCreationException {
        super(config, typeConfig, log, connection, messageFactory, connectionManager);
    }

    @Override
    public boolean isJMS() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMessageListener(String name) throws Exception {
        HashMap hashMap = this.m_factories;
        synchronized (hashMap) {
            if (this.m_factories.containsKey(name)) {
                DispatcherMessageListenerFactory factory = (DispatcherMessageListenerFactory)this.m_factories.remove(name);
                Map spec = (Map)this.m_specs.remove(name);
                ((JCAInterimConnection)this.m_connection).getResourceAdapter().unsubscribe((XQMessageListenerFactory)factory, spec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessageListener(String name, IXQMessageListener msgListener, Map<String, Object> subscriptionSpec) throws XQEndpointException {
        JCAInterimConnection connection = (JCAInterimConnection)this.m_connection;
        if (!connection.hasResourceAdapter()) {
            throw new XQEndpointException("XQResourceAdapter must be specified for JCA Endpoints used as entries");
        }
        XQResourceAdapter resourceAdapter = connection.getResourceAdapter();
        DispatcherMessageListenerFactory factory = new DispatcherMessageListenerFactory(msgListener, this.m_messageAdapter);
        try {
            subscriptionSpec.putAll(this.m_messageAdapter.createSubscriptionSpec());
            resourceAdapter.subscribe((XQMessageListenerFactory)factory, subscriptionSpec);
            HashMap hashMap = this.m_factories;
            synchronized (hashMap) {
                this.m_factories.put(name, factory);
                this.m_specs.put(name, subscriptionSpec);
            }
        }
        catch (Exception e) {
            throw new XQEndpointException((Throwable)e);
        }
    }

    public boolean isInListener() {
        return false;
    }

    @Override
    public void destroy() {
    }
}

