/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap;

import com.sonicsw.esb.ws.invocation.ESBWSCommand;
import com.sonicsw.xqimpl.invkimpl.WSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.axissoap.SoapProviderInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.BaseExceptionCreator;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.GeneralWSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.RawSoapWSInvocationException;
import com.sonicsw.xqimpl.invkimpl.wsif.providers.common.UncheckedWSInvocationException;
import com.sonicsw.xqimpl.util.DOMUtils;
import com.sonicsw.xqimpl.util.MessageFormatter;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class AxisFaultExceptionCreator
extends BaseExceptionCreator {
    private static String s_soap = "http://schemas.xmlsoap.org/soap/envelope/";

    public AxisFaultExceptionCreator(ESBWSCommand command) {
        super(command);
    }

    public WSInvocationException createException(AxisFault fault, Message responseMsg, boolean faultAsSoap) {
        if (responseMsg != null) {
            try {
                Element response = null;
                try {
                    response = responseMsg.getSOAPEnvelope().getAsDOM();
                }
                catch (AxisFault f) {
                    return this.createSoapProviderException(f, "error-retrieving-soap-envelope", new Object[]{responseMsg.getSOAPPartAsString()});
                }
                if (this.isFault(response)) {
                    String faultString = MessageFormatter.formatMessage((String)"com.sonicsw.xqimpl.invkimpl.InvkImplErrors", (String)"fault-string", (Object[])new Object[]{fault.getFaultString(), fault.getFaultCode()});
                    if (faultAsSoap) {
                        return new RawSoapWSInvocationException(responseMsg.getSOAPEnvelope(), faultString, null);
                    }
                    Element detail = this.getFaultDetail(response);
                    if (detail != null) {
                        Element header;
                        WSInvocationException result = this.getFaultDefinition(detail, faultString, false);
                        if (result == null && (result = this.getFaultDefinition(header = this.getFaultHeader(response), faultString, true)) == null) {
                            return new UncheckedWSInvocationException(detail.getChildNodes(), faultString, null);
                        }
                        return result;
                    }
                    Element header = this.getFaultHeader(response);
                    if (header != null) {
                        WSInvocationException result = this.getFaultDefinition(header, faultString, true);
                        if (result == null) {
                            return new UncheckedWSInvocationException(faultString, null);
                        }
                        return result;
                    }
                    return new UncheckedWSInvocationException(faultString, null);
                }
                return new RawSoapWSInvocationException(this.createSoapProviderException(fault));
            }
            catch (Exception e) {
                return new GeneralWSInvocationException(e.getMessage(), null, e);
            }
        }
        return this.createSoapProviderException(fault);
    }

    private WSInvocationException createSoapProviderException(AxisFault fault) {
        return this.createSoapProviderException(fault, null, null);
    }

    private WSInvocationException createSoapProviderException(AxisFault fault, String msg, Object[] arguments) {
        String message = msg;
        if (message == null) {
            message = fault.getFaultString();
        }
        if (fault.detail != null) {
            if (fault.detail instanceof WSInvocationException) {
                return (WSInvocationException)((Object)fault.detail);
            }
            return new SoapProviderInvocationException(message, arguments, fault.detail);
        }
        Element[] details = fault.getFaultDetails();
        Element stackTrace = null;
        for (int count = 0; count < details.length; ++count) {
            String ln;
            String ns = details[count].getNamespaceURI();
            if (!"http://xml.apache.org/axis/".equals(ns) || !"stackTrace".equals(ln = details[count].getLocalName())) continue;
            stackTrace = details[count];
            break;
        }
        String stackTraceString = null;
        if (stackTrace != null) {
            Text text = DOMUtils.getFirstTextChild(stackTrace);
            stackTraceString = text.getData();
        }
        return new SoapProviderInvocationException(message, arguments, stackTraceString);
    }

    private boolean isFault(Element soapEnvelope) {
        Element body = this.getElementByTagNameNS(soapEnvelope, s_soap, "Body");
        if (body == null) {
            return false;
        }
        Element fault = this.getElementByTagNameNS(body, s_soap, "Fault");
        return fault != null;
    }

    private Element getFaultDetail(Element soapEnvelope) {
        Element body = this.getElementByTagNameNS(soapEnvelope, s_soap, "Body");
        if (body == null) {
            return null;
        }
        Element fault = this.getElementByTagNameNS(body, s_soap, "Fault");
        if (fault == null) {
            return null;
        }
        Element detail = this.getElementByTagName(body, "detail");
        if (detail == null) {
            return null;
        }
        return detail;
    }

    private Element getFaultHeader(Element soapEnvelope) {
        Element header = this.getElementByTagNameNS(soapEnvelope, s_soap, "Header");
        return header;
    }
}

