/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.jeri;

import com.sonicsw.esb.jeri.DebugCommunicationFactory;
import com.sonicsw.esb.jeri.DebugDestination;
import com.sonicsw.esb.jeri.IClientCommunicator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.jms.JMSException;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;

public class DebugEndpoint
implements Endpoint,
Serializable {
    static final long serialVersionUID = 3317419669192347994L;
    private DebugDestination m_replyDestination;
    private String m_jeriUUID;
    private String m_correlationID;

    public DebugEndpoint(DebugDestination replyDestination, String jeriUUID, String correlationID) throws JMSException {
        this.m_replyDestination = replyDestination;
        this.m_jeriUUID = jeriUUID;
        this.m_correlationID = correlationID;
    }

    @Override
    public OutboundRequestIterator newRequest(InvocationConstraints constraints) {
        return new DebugOutboundRequestIterator();
    }

    private final class DebugOutboundRequestIterator
    implements OutboundRequestIterator {
        DebugOutboundRequestIterator() {
        }

        @Override
        public synchronized boolean hasNext() {
            try {
                IClientCommunicator communicator = DebugCommunicationFactory.getClientCommunicator();
                return communicator.isOK(DebugEndpoint.this.m_jeriUUID);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public synchronized OutboundRequest next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new DebugOutboundRequest();
        }
    }

    private final class DebugOutboundRequest
    implements OutboundRequest {
        private DebugSenderStream m_senderStream = new DebugSenderStream(this);
        private InputStream m_responseStream = null;

        DebugOutboundRequest() {
        }

        protected void finalize() throws Throwable {
        }

        @Override
        public OutputStream getRequestOutputStream() {
            return this.m_senderStream;
        }

        @Override
        public InputStream getResponseInputStream() {
            return this.m_responseStream;
        }

        @Override
        public void populateContext(Collection context) {
        }

        @Override
        public InvocationConstraints getUnfulfilledConstraints() {
            return InvocationConstraints.EMPTY;
        }

        @Override
        public boolean getDeliveryStatus() {
            return true;
        }

        @Override
        public void abort() {
        }

        private class DebugSenderStream
        extends OutputStream {
            private ByteArrayOutputStream m_delegator = new ByteArrayOutputStream();

            DebugSenderStream(DebugOutboundRequest outboundRequest) {
            }

            @Override
            public void write(int value) throws IOException {
                this.m_delegator.write(value);
            }

            @Override
            public void write(byte[] byteArray) throws IOException {
                this.m_delegator.write(byteArray);
            }

            @Override
            public void write(byte[] byteArray, int int1, int int2) throws IOException {
                this.m_delegator.write(byteArray, int1, int2);
            }

            @Override
            public void flush() throws IOException {
                this.m_delegator.flush();
            }

            @Override
            public void close() throws IOException {
                IClientCommunicator communicator = DebugCommunicationFactory.getClientCommunicator();
                try {
                    byte[] response = communicator.makeRequest(DebugEndpoint.this.m_jeriUUID, DebugEndpoint.this.m_correlationID, this.m_delegator.toByteArray(), DebugEndpoint.this.m_replyDestination.getJMSDestination());
                    DebugOutboundRequest.this.m_responseStream = new ByteArrayInputStream(response);
                }
                catch (JMSException e) {
                    IOException ioe = new IOException(e.getMessage());
                    ioe.initCause(e);
                    DebugOutboundRequest.this.m_responseStream = null;
                    throw ioe;
                }
                catch (IOException e) {
                    DebugOutboundRequest.this.m_responseStream = null;
                    throw e;
                }
                this.m_delegator.close();
                super.close();
            }
        }
    }
}

