/*
 * Decompiled with CFR 0.152.
 */
package net.jini.activation;

import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.server.RMIClassLoader;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.jini.export.Exporter;
import net.jini.security.Security;

public abstract class ActivationGroup
extends java.rmi.activation.ActivationGroup {
    private static ActivationGroup currGroup;

    protected ActivationGroup(ActivationGroupID id) throws RemoteException {
        super(id);
    }

    public static synchronized java.rmi.activation.ActivationGroup createGroup(ActivationGroupID id, ActivationGroupDesc desc, long incarnation) throws ActivationException {
        String className = desc.getClassName();
        if (className == null || !ActivationGroup.isAssignableFrom(className, desc.getLocation())) {
            throw new ActivationException("group class not subclass");
        }
        currGroup = (ActivationGroup)java.rmi.activation.ActivationGroup.createGroup((ActivationGroupID)id, (ActivationGroupDesc)desc, (long)incarnation);
        return currGroup;
    }

    private static boolean isAssignableFrom(final String className, final String location) throws ActivationException {
        try {
            Class cl = (Class)Security.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return RMIClassLoader.loadClass(location, className);
                }
            });
            return ActivationGroup.class.isAssignableFrom(cl);
        }
        catch (PrivilegedActionException e) {
            throw new ActivationException("unable to load group class", (Throwable)e.getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean inactive(ActivationID id, Exporter exporter) throws ActivationException, RemoteException {
        Class<ActivationGroup> clazz = ActivationGroup.class;
        synchronized (ActivationGroup.class) {
            ActivationGroup group = currGroup;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (group == null) {
                throw new ActivationException("group is not active");
            }
            return group.inactiveObject(id, exporter);
        }
    }

    public abstract boolean inactiveObject(ActivationID var1, Exporter var2) throws ActivationException, RemoteException;
}

