/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.kerberos;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.jeri.internal.connection.BasicServerConnManager;
import com.sun.jini.jeri.internal.connection.ServerConnManager;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import com.sun.security.jgss.GSSUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;
import net.jini.jeri.kerberos.KerberosEndpoint;
import net.jini.jeri.kerberos.KerberosUtil;
import net.jini.security.Security;
import net.jini.security.SecurityContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public final class KerberosServerEndpoint
implements ServerEndpoint {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.kerberos.server");
    private static final Executor systemThreadPool = (Executor)Security.doPrivileged(new GetThreadPoolAction(false));
    private Subject serverSubject;
    private static final Object classLock = new Object();
    private static GSSManager gssManager;
    private static final int maxCacheSize;
    private final KerberosUtil.SoftCache softCache;
    private KerberosPrincipal serverPrincipal;
    private String serverHost;
    private final int port;
    private final SocketFactory csf;
    private final ServerSocketFactory ssf;
    private final ListenEndpointImpl listenEndpoint;
    ServerConnManager serverConnManager = new BasicServerConnManager();
    private static final InvocationConstraints INTEGRITY_REQUIRED_CONSTRAINTS;
    private static final InvocationConstraints INTEGRITY_PREFERRED_CONSTRAINTS;

    private KerberosServerEndpoint(Subject serverSubject, KerberosPrincipal serverPrincipal, String serverHost, int port, SocketFactory csf, ServerSocketFactory ssf) throws UnsupportedConstraintException {
        boolean usePrincipalInSubject;
        boolean useCurrentSubject = serverSubject == null;
        boolean bl = usePrincipalInSubject = serverPrincipal == null;
        if (useCurrentSubject) {
            final AccessControlContext acc = AccessController.getContext();
            serverSubject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Subject.getSubject(acc);
                }
            });
        }
        Exception detailedException = null;
        if (usePrincipalInSubject) {
            if (serverSubject == null) {
                detailedException = new UnsupportedConstraintException("Forgot JAAS login?  Using default serverSubject but no subject is associated with the current access control context.");
            } else {
                try {
                    serverPrincipal = KerberosServerEndpoint.findServerPrincipal(serverSubject);
                }
                catch (Exception e) {
                    detailedException = e;
                }
            }
        } else if (useCurrentSubject) {
            try {
                KerberosUtil.checkAuthPermission(serverPrincipal, null, "listen");
                if (serverSubject == null) {
                    detailedException = new UnsupportedConstraintException("Forgot JAAS login?  Using default serverSubject but no subject is associated with the current access control context.");
                }
            }
            catch (SecurityException e) {
                serverSubject = null;
            }
        }
        if (detailedException != null) {
            if (logger.isLoggable(Levels.FAILED)) {
                KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "constructor", "construction failed", null, detailedException);
            }
            KerberosUtil.secureThrow(detailedException, new UnsupportedConstraintException("Either the caller has not been granted the right AuthenticationPermission, or there is no default server subject (<code>Subject.getSubject(AccessController.getContext())</code> returns <code>null</code>), or no appropriate Kerberos principal and its corresponding key can be found in the current subject."));
        }
        this.serverSubject = serverSubject;
        this.serverPrincipal = serverPrincipal;
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port number out of range 0-65535: port = " + port);
        }
        this.serverHost = serverHost;
        this.port = port;
        this.csf = csf;
        this.ssf = ssf;
        this.softCache = new KerberosUtil.SoftCache(maxCacheSize);
        this.listenEndpoint = new ListenEndpointImpl();
        logger.log(Level.FINE, "created {0}", this);
    }

    public static KerberosServerEndpoint getInstance(int port) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(null, null, null, port, null, null);
    }

    public static KerberosServerEndpoint getInstance(String serverHost, int port) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(null, null, serverHost, port, null, null);
    }

    public static KerberosServerEndpoint getInstance(String serverHost, int port, SocketFactory csf, ServerSocketFactory ssf) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(null, null, serverHost, port, csf, ssf);
    }

    public static KerberosServerEndpoint getInstance(Subject serverSubject, KerberosPrincipal serverPrincipal, String serverHost, int port) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(serverSubject, serverPrincipal, serverHost, port, null, null);
    }

    public static KerberosServerEndpoint getInstance(Subject serverSubject, KerberosPrincipal serverPrincipal, String serverHost, int port, SocketFactory csf, ServerSocketFactory ssf) throws UnsupportedConstraintException {
        return new KerberosServerEndpoint(serverSubject, serverPrincipal, serverHost, port, csf, ssf);
    }

    public String getHost() {
        return this.serverHost;
    }

    public int getPort() {
        return this.port;
    }

    public KerberosPrincipal getPrincipal() {
        return this.serverPrincipal;
    }

    public SocketFactory getSocketFactory() {
        return this.csf;
    }

    public ServerSocketFactory getServerSocketFactory() {
        return this.ssf;
    }

    public InvocationConstraints checkConstraints(InvocationConstraints constraints) throws UnsupportedConstraintException {
        InvocationConstraints unfulfilledConstraints;
        if (constraints == null) {
            throw new NullPointerException();
        }
        try {
            for (InvocationConstraint c : constraints.requirements()) {
                if (KerberosUtil.isSupportableConstraint(c)) continue;
                throw new UnsupportedConstraintException("A constraint unsupportable by this endpoint has been required: " + c);
            }
            if (KerberosServerEndpoint.getKey(this.serverSubject, this.serverPrincipal) == null) {
                throw new UnsupportedConstraintException("Failed to find a valid Kerberos key corresponding to serverPrincipal (" + this.serverPrincipal + ") in serverSubject.");
            }
            HashSet<KerberosPrincipal> cpCandidates = new HashSet<KerberosPrincipal>();
            Iterator iter = constraints.requirements().iterator();
            while (iter.hasNext()) {
                if (KerberosUtil.collectCpCandidates((InvocationConstraint)iter.next(), cpCandidates)) continue;
                throw new UnsupportedConstraintException("Client principal constraint related conflicts found in the given set of constraints: " + constraints);
            }
            if (cpCandidates.size() == 0) {
                cpCandidates.add(new KerberosPrincipal("anyone"));
            }
            boolean doable = false;
            KerberosUtil.ConfigIter citer = new KerberosUtil.ConfigIter(cpCandidates, this.serverPrincipal, true);
            block5: while (citer.hasNext()) {
                KerberosUtil.Config config = citer.next();
                for (InvocationConstraint c : constraints.requirements()) {
                    if (KerberosUtil.isSatisfiable(config, c)) continue;
                    continue block5;
                }
                doable = true;
                break;
            }
            if (!doable) {
                throw new UnsupportedConstraintException("Conflicts found in the given set of constraints: " + constraints);
            }
            unfulfilledConstraints = InvocationConstraints.EMPTY;
            if (KerberosUtil.containsConstraint(constraints.requirements(), Integrity.YES)) {
                unfulfilledConstraints = KerberosUtil.INTEGRITY_REQUIRED_CONSTRAINTS;
            } else if (KerberosUtil.containsConstraint(constraints.preferences(), Integrity.YES)) {
                unfulfilledConstraints = KerberosUtil.INTEGRITY_PREFERRED_CONSTRAINTS;
            }
        }
        catch (UnsupportedConstraintException uce) {
            if (logger.isLoggable(Levels.FAILED)) {
                KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, constraints}, uce);
            }
            throw uce;
        }
        catch (SecurityException se) {
            if (logger.isLoggable(Levels.FAILED)) {
                KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkConstraints", "check constraints for {0}\nwith {1}\nthrows", new Object[]{this, constraints}, se);
            }
            throw se;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "checkConstraints() has determined that this endpoint can support the given constraints:\n{0}.\nWhile assistances are needed from upper layers to satisfy constraints:\n{1}", new Object[]{constraints, unfulfilledConstraints});
        }
        return unfulfilledConstraints;
    }

    public Endpoint enumerateListenEndpoints(ServerEndpoint.ListenContext listenContext) throws IOException {
        if (this.serverHost == null) {
            InetAddress localAddr;
            try {
                localAddr = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getLocalHost();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                UnknownHostException uhe = (UnknownHostException)e.getCause();
                if (logger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "enumerateListenEndpoints", "InetAddress.getLocalHost() throws", null, uhe);
                }
                InetAddress.getLocalHost();
                throw new UnknownHostException("Host name cleared due to insufficient caller permissions");
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkConnect(localAddr.getHostName(), -1);
                }
                catch (SecurityException e) {
                    SecurityException se = new SecurityException("Access to resolve local host denied");
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "enumerateListenEndpoints", "caller does not have permission to resolve local host", null, se);
                    }
                    throw se;
                }
            }
            this.serverHost = localAddr.getHostAddress();
        }
        ListenCookieImpl cookie = this.checkListenCookie(listenContext.addListenEndpoint(this.listenEndpoint));
        return KerberosEndpoint.getInstance(this.serverHost, cookie.getLocalPort(), this.serverPrincipal, this.csf);
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() ^ System.identityHashCode(this.serverSubject) ^ this.serverPrincipal.hashCode() ^ (this.serverHost != null ? this.serverHost.hashCode() : 0) ^ this.port ^ (this.ssf != null ? this.ssf.hashCode() : 0) ^ (this.csf != null ? this.csf.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KerberosServerEndpoint)) {
            return false;
        }
        KerberosServerEndpoint ose = (KerberosServerEndpoint)obj;
        return this.serverSubject == ose.serverSubject && this.serverPrincipal.equals(ose.serverPrincipal) && Util.equals(this.serverHost, ose.serverHost) && this.port == ose.port && Util.sameClassAndEquals(this.csf, ose.csf) && Util.sameClassAndEquals(this.ssf, ose.ssf);
    }

    public String toString() {
        return "KerberosServerEndpoint[serverPrincipal=" + this.serverPrincipal + " serverHost= " + this.serverHost + " serverPort= " + this.port + (this.ssf == null ? "" : " ssf = " + this.ssf.toString()) + (this.csf == null ? "" : " csf = " + this.csf.toString()) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KerberosPrincipal findServerPrincipal(Subject subject) throws UnsupportedConstraintException {
        Set<Principal> pset = subject.getPrincipals();
        HashSet<Principal> kpset = new HashSet<Principal>(pset.size());
        Set<Principal> set = pset;
        synchronized (set) {
            for (Principal principal : pset) {
                if (!(principal instanceof KerberosPrincipal)) continue;
                kpset.add(principal);
            }
        }
        if (kpset.isEmpty()) {
            throw new UnsupportedConstraintException("No KerberosPrincipal found in the serverSubject.");
        }
        boolean hasAuthPerm = false;
        for (KerberosPrincipal kerberosPrincipal : kpset) {
            try {
                if (KerberosServerEndpoint.getKey(subject, kerberosPrincipal) != null) {
                    return kerberosPrincipal;
                }
                hasAuthPerm = true;
            }
            catch (SecurityException e) {}
        }
        if (hasAuthPerm) {
            throw new UnsupportedConstraintException("Cannot find any Kerberos key in the serverSubject corresponding to one of its principals.");
        }
        throw new SecurityException("Caller does not have AuthenticationPermission to access Kerberos keys of any principal in the serverSubject.");
    }

    private static KerberosKey getKey(final Subject subject, final KerberosPrincipal principal) {
        KerberosUtil.checkAuthPermission(principal, null, "listen");
        if (subject == null) {
            return null;
        }
        return (KerberosKey)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                Set<Object> creds;
                Set<Object> set = creds = subject.getPrivateCredentials();
                synchronized (set) {
                    for (Object cred : creds) {
                        KerberosKey key;
                        if (!(cred instanceof KerberosKey) || (key = (KerberosKey)cred).isDestroyed() || !key.getPrincipal().equals(principal)) continue;
                        return key;
                    }
                }
                return null;
            }
        });
    }

    private ListenCookieImpl checkListenCookie(Object cookie) {
        if (!(cookie instanceof ListenCookieImpl)) {
            throw new IllegalArgumentException("Cookie with unexpected type: " + cookie);
        }
        ListenCookieImpl listenCookie = (ListenCookieImpl)cookie;
        if (!this.listenEndpoint.equals(listenCookie.getListenEndpoint())) {
            throw new IllegalArgumentException("ListenEndpoint mis-match, enclosing lep is:\n" + this.listenEndpoint + "\nwhile cookie's enclosing lep is:\n" + listenCookie.getListenEndpoint());
        }
        return listenCookie;
    }

    static {
        maxCacheSize = (Integer)Security.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.kerberos.KerberosServerEndpoint.maxCacheSize", 256));
        INTEGRITY_REQUIRED_CONSTRAINTS = new InvocationConstraints(Integrity.YES, null);
        INTEGRITY_PREFERRED_CONSTRAINTS = new InvocationConstraints(null, Integrity.YES);
    }

    private final class ServerConnectionImpl
    extends KerberosUtil.Connection
    implements ServerConnection {
        private final ListenHandleImpl listenHandle;
        private GSSCredential clientCred;
        private Subject clientSubject;
        private InputStream istream;
        private OutputStream ostream;
        private InboundRequestHandleImpl handleWithEncryption;
        private InboundRequestHandleImpl handleWithoutEncryption;
        private final Object lock;
        private boolean closed;

        ServerConnectionImpl(Socket sock, ListenHandleImpl listenHandle) throws IOException {
            block5: {
                block4: {
                    super(sock);
                    this.lock = new Object();
                    this.listenHandle = listenHandle;
                    this.connectionLogger = logger;
                    try {
                        sock.setTcpNoDelay(true);
                    }
                    catch (SocketException e) {
                        if (!logger.isLoggable(Levels.HANDLED)) break block4;
                        KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "constructor", "failed to setTcpNoDelay option for {0}", new Object[]{sock}, e);
                    }
                }
                try {
                    sock.setKeepAlive(true);
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block5;
                    KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "constructor", "failed to setKeepAlive option for {0}", new Object[]{sock}, e);
                }
            }
            this.istream = new KerberosUtil.ConnectionInputStream(this);
            this.ostream = new KerberosUtil.ConnectionOutputStream(this);
        }

        public InputStream getInputStream() throws IOException {
            return this.istream;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.ostream;
        }

        public SocketChannel getChannel() {
            return null;
        }

        public InboundRequestHandle processRequestData(InputStream in, OutputStream out) throws IOException {
            try {
                if (this.clientCred != null) {
                    try {
                        if (this.clientCred.getRemainingLifetime() <= 0) {
                            this.close();
                            throw new SecurityException("Delegated client credential expired.");
                        }
                    }
                    catch (GSSException e) {
                        this.close();
                        SecurityException se = new SecurityException("Failed to getRemainingLifetime from the delegated client credential.");
                        se.initCause(e);
                        throw se;
                    }
                }
                if (!KerberosServerEndpoint.this.serverSubject.getPrincipals().contains(KerberosServerEndpoint.this.serverPrincipal)) {
                    throw new SecurityException("serverSubject no longer contains serverPrincipal: " + KerberosServerEndpoint.this.serverPrincipal + ", failing the connection...");
                }
                if (!this.listenHandle.checkKey()) {
                    throw new SecurityException("serverSubject no longer contains the server key or the server key has been destroyed, failing the connection...");
                }
                return this.doEncryption ? this.handleWithEncryption : this.handleWithoutEncryption;
            }
            catch (SecurityException se) {
                if (logger.isLoggable(Levels.FAILED)) {
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "processRequestData", "connection {0} throws", new Object[]{this}, se);
                }
                this.close();
                throw se;
            }
        }

        public void checkPermissions(InboundRequestHandle handle) {
            this.checkRequestHandle(handle);
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkAccept(this.sock.getInetAddress().getHostAddress(), this.sock.getPort());
                KerberosUtil.checkAuthPermission(KerberosServerEndpoint.this.serverPrincipal, this.clientPrincipal, "accept");
            }
        }

        public InvocationConstraints checkConstraints(InboundRequestHandle handle, InvocationConstraints constraints) throws UnsupportedConstraintException {
            InboundRequestHandleImpl rh = this.checkRequestHandle(handle);
            if (constraints == null) {
                throw new NullPointerException("constraints can not be null");
            }
            CacheKey key = new CacheKey(rh, constraints);
            Object result = KerberosServerEndpoint.this.softCache.get(key);
            if (result != null) {
                if (result instanceof UnsupportedConstraintException) {
                    throw (UnsupportedConstraintException)result;
                }
                return (InvocationConstraints)result;
            }
            Iterator iter = constraints.requirements().iterator();
            while (iter.hasNext()) {
                try {
                    InvocationConstraint c = (InvocationConstraint)iter.next();
                    if (!KerberosUtil.isSupportableConstraint(c)) {
                        UnsupportedConstraintException e = new UnsupportedConstraintException("A constraint unsupportable by this endpoint has been required: " + c);
                        KerberosServerEndpoint.this.softCache.put(key, e);
                        throw e;
                    }
                    if (KerberosUtil.isSatisfiable(rh.config, c)) continue;
                    UnsupportedConstraintException e = new UnsupportedConstraintException("A required constraint (" + c + ") is not " + "satisfied by this connection: " + this);
                    KerberosServerEndpoint.this.softCache.put(key, e);
                    throw e;
                }
                catch (UnsupportedConstraintException uce) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkConstraints", "connection {0}\ndoes not satisfies {1},\nthrows", new Object[]{this, constraints}, uce);
                    }
                    throw uce;
                }
            }
            InvocationConstraints unfulfilledConstraints = InvocationConstraints.EMPTY;
            if (KerberosUtil.containsConstraint(constraints.requirements(), Integrity.YES)) {
                unfulfilledConstraints = KerberosUtil.INTEGRITY_REQUIRED_CONSTRAINTS;
            } else if (KerberosUtil.containsConstraint(constraints.preferences(), Integrity.YES)) {
                unfulfilledConstraints = KerberosUtil.INTEGRITY_PREFERRED_CONSTRAINTS;
            }
            KerberosServerEndpoint.this.softCache.put(key, unfulfilledConstraints);
            return unfulfilledConstraints;
        }

        public void populateContext(InboundRequestHandle handle, Collection context) {
            this.checkRequestHandle(handle);
            Util.populateContext(context, this.sock.getInetAddress());
            Util.populateContext(context, this.clientSubject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.listenHandle.remove(this);
            super.close();
        }

        public String toString() {
            StringBuffer b = new StringBuffer("KerberosServerEndpoint.ServerConnectionImpl[");
            b.append("clientPrincipal=" + this.clientPrincipal);
            b.append(" serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal);
            b.append(" doEncryption=" + this.doEncryption);
            b.append(" doDelegation=" + this.doDelegation);
            b.append(" client=" + this.sock.getInetAddress().getHostName());
            b.append(":" + this.sock.getPort());
            b.append(" server=" + this.sock.getLocalAddress().getHostName());
            b.append(":" + this.sock.getLocalPort());
            b.append(']');
            return b.toString();
        }

        void establishContext() throws IOException, GSSException {
            this.gssContext = gssManager.createContext(this.listenHandle.serverCred);
            byte[] token = null;
            while (!this.gssContext.isEstablished()) {
                token = new byte[this.dis.readInt()];
                this.dis.readFully(token);
                if ((token = this.gssContext.acceptSecContext(token, 0, token.length)) == null) continue;
                this.dos.writeInt(token.length);
                this.dos.write(token);
                this.dos.flush();
            }
            if (!this.gssContext.getIntegState()) {
                throw new IOException("Established GSSContext does not support integrity.");
            }
            this.doEncryption = this.gssContext.getConfState();
            this.doDelegation = this.gssContext.getCredDelegState();
            GSSName clientName = this.gssContext.getSrcName();
            this.clientPrincipal = new KerberosPrincipal(((Object)clientName).toString());
            if (this.gssContext.getCredDelegState()) {
                this.clientCred = this.gssContext.getDelegCred();
            }
            this.clientSubject = GSSUtil.createSubject(clientName, this.clientCred);
            this.clientSubject.setReadOnly();
            this.handleWithEncryption = new InboundRequestHandleImpl(true);
            this.handleWithoutEncryption = new InboundRequestHandleImpl(false);
        }

        private InboundRequestHandleImpl checkRequestHandle(Object h) {
            if (h != this.handleWithEncryption && h != this.handleWithoutEncryption) {
                throw new IllegalArgumentException("Unknown InboundRequestHandle: " + h);
            }
            return (InboundRequestHandleImpl)h;
        }

        private final class CacheKey {
            private final InboundRequestHandleImpl handle;
            private final InvocationConstraints constraints;

            CacheKey(InboundRequestHandleImpl handle, InvocationConstraints constraints) {
                this.handle = handle;
                this.constraints = constraints;
            }

            public int hashCode() {
                return this.handle.hashCode() ^ System.identityHashCode(this.constraints);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey okey = (CacheKey)o;
                return this.handle == okey.handle && this.constraints == okey.constraints;
            }
        }

        private final class InboundRequestHandleImpl
        implements InboundRequestHandle {
            final KerberosUtil.Config config;

            InboundRequestHandleImpl(boolean encry) {
                this.config = new KerberosUtil.Config(ServerConnectionImpl.this.clientPrincipal, KerberosServerEndpoint.this.serverPrincipal, encry, ServerConnectionImpl.this.doDelegation);
            }
        }
    }

    private final class ConnectionHandler
    implements Runnable {
        private final ServerConnectionImpl connection;
        private final RequestDispatcher dispatcher;
        private final SecurityContext securityContext;

        ConnectionHandler(ServerConnectionImpl connection, RequestDispatcher dispatcher, SecurityContext securityContext) {
            this.connection = connection;
            this.dispatcher = dispatcher;
            this.securityContext = securityContext;
        }

        public void run() {
            Throwable t = null;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        try {
                            Subject.doAs(KerberosServerEndpoint.this.serverSubject, new PrivilegedExceptionAction(){

                                public Object run() throws IOException, GSSException {
                                    ConnectionHandler.this.connection.establishContext();
                                    return null;
                                }
                            });
                        }
                        catch (PrivilegedActionException pe) {
                            throw pe.getException();
                        }
                        logger.log(Level.FINE, "established GSSContext for {0}", ConnectionHandler.this.connection);
                        return null;
                    }
                });
                AccessController.doPrivileged(this.securityContext.wrap(new PrivilegedAction(){

                    public Object run() {
                        KerberosServerEndpoint.this.serverConnManager.handleConnection(ConnectionHandler.this.connection, ConnectionHandler.this.dispatcher);
                        return null;
                    }
                }), this.securityContext.getAccessControlContext());
            }
            catch (PrivilegedActionException pe) {
                t = pe.getException();
            }
            catch (Throwable throwable) {
                t = throwable;
            }
            if (t != null) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    KerberosUtil.logThrow(logger, Levels.HANDLED, this.getClass(), "run", "connection handling thread {0} throws", new Object[]{this}, t);
                }
                this.connection.close();
            }
        }

        public String toString() {
            return "KerberosServerEndpoint.ConnectionHandler[serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal + " localPort=" + this.connection.sock.getLocalPort() + " remotePort=" + this.connection.sock.getPort() + "]";
        }
    }

    private final class ListenHandleImpl
    implements ServerEndpoint.ListenHandle {
        private final RequestDispatcher dispatcher;
        private final SecurityContext securityContext;
        private KerberosKey serverKey;
        final GSSCredential serverCred;
        ListenCookieImpl listenCookie;
        private final ServerSocket serverSocket;
        private final Set connections = new HashSet();
        private final Object lock = new Object();
        private boolean closed = false;
        private long acceptFailureTime = 0L;
        private int acceptFailureCount;

        ListenHandleImpl(RequestDispatcher dispatcher, KerberosKey serverKey, GSSCredential serverCred, ServerSocket serverSocket, SecurityContext securityContext) {
            this.dispatcher = dispatcher;
            this.serverKey = serverKey;
            this.serverCred = serverCred;
            this.serverSocket = serverSocket;
            this.securityContext = securityContext;
            this.listenCookie = new ListenCookieImpl(serverSocket.getLocalPort());
        }

        void startAccepting() {
            systemThreadPool.execute(new Runnable(){

                public void run() {
                    ListenHandleImpl.this.executeAcceptLoop();
                }
            }, this.toString() + " accept loop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void executeAcceptLoop() {
            while (true) {
                block33: {
                    block32: {
                        socket = null;
                        connection = null;
                        done = false;
                        try {
                            try {
                                socket = this.serverSocket.accept();
                                var4_4 = this.lock;
                                synchronized (var4_4) {
                                    if (this.closed) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 21, 10, 31] lbl11 : MonitorExitStatement: MONITOREXIT : var4_4
                                        var8_9 = null;
                                        if (done != false) return;
                                        if (connection != null) {
                                            connection.close();
                                            return;
                                        }
                                        if (socket == null) return;
                                        break block32;
                                    }
                                    connection = new ServerConnectionImpl(socket, this);
                                    this.connections.add(connection);
                                }
                                KerberosServerEndpoint.access$300().log(Level.FINE, "{0} accepted", connection);
                                handler = new ConnectionHandler(connection, this.dispatcher, this.securityContext);
                                KerberosServerEndpoint.access$1200().execute(handler, handler.toString());
                                done = true;
                                break block33;
                            }
                            catch (Throwable t) {
                                var5_7 = this.lock;
                                synchronized (var5_7) {
                                    if (this.closed) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 21, 9, 27, 13] lbl33 : MonitorExitStatement: MONITOREXIT : var5_7
                                        var8_9 = null;
                                        if (done != false) return;
                                        if (connection != null) {
                                            connection.close();
                                            return;
                                        }
                                        if (socket == null) return;
                                        try {
                                            socket.close();
                                            return;
                                        }
                                        catch (IOException e) {
                                            return;
                                        }
                                    }
                                }
                                try {
                                    if (KerberosServerEndpoint.access$300().isLoggable(Level.WARNING)) {
                                        KerberosUtil.logThrow(KerberosServerEndpoint.access$300(), Level.WARNING, this.getClass(), "executeAcceptLoop", "accept loop for {0} throws", new Object[]{this}, t);
                                    }
                                }
                                catch (Throwable tt) {
                                    // empty catch block
                                }
                                v0 = knownFailure = t instanceof Exception != false || t instanceof OutOfMemoryError != false || t instanceof NoClassDefFoundError != false;
                                if (!knownFailure || !this.continueAfterAcceptFailure(t)) {
                                    try {
                                        this.serverSocket.close();
                                    }
                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    if (knownFailure == false) throw (Error)t;
                                    var8_9 = null;
                                    if (done != false) return;
                                    if (connection != null) {
                                        connection.close();
                                        return;
                                    }
                                    if (socket == null) return;
                                    ** try [egrp 8[TRYBLOCK] [16 : 325->332)] { 
lbl67:
                                    // 1 sources

                                    socket.close();
                                    return;
lbl69:
                                    // 1 sources

                                    catch (IOException e) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                var8_9 = null;
                                if (done) continue;
                                if (connection != null) {
                                    connection.close();
                                    continue;
                                }
                                if (socket == null) continue;
                                try {}
                                catch (IOException e) {}
                                socket.close();
                                continue;
                            }
                        }
                        catch (Throwable var7_12) {
                            var8_9 = null;
                            if (done != false) throw var7_12;
                            if (connection != null) {
                                connection.close();
                                throw var7_12;
                            }
                            if (socket == null) throw var7_12;
                            ** try [egrp 8[TRYBLOCK] [16 : 325->332)] { 
lbl92:
                            // 1 sources

                            socket.close();
                            throw var7_12;
lbl94:
                            // 1 sources

                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var7_12;
                        }
                    }
                    try {}
                    catch (IOException e) {
                        return;
                    }
                    socket.close();
                    return;
                }
                var8_9 = null;
                if (done) continue;
                if (connection != null) {
                    connection.close();
                    continue;
                }
                if (socket == null) continue;
                try {}
                catch (IOException e) {}
                socket.close();
            }
        }

        public ServerEndpoint.ListenCookie getCookie() {
            return this.listenCookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            Iterator iter = this.connections.iterator();
            while (iter.hasNext()) {
                ((ServerConnectionImpl)iter.next()).close();
            }
            this.connections.clear();
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.serverCred.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
            logger.log(Level.FINE, "Listen operation {0} has been closed", this);
        }

        public String toString() {
            return "KerberosServerEndpoint.ListenHandleImpl[serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal + " portListening = " + this.serverSocket.getLocalPort() + (KerberosServerEndpoint.this.ssf == null ? "" : " ssf = " + KerberosServerEndpoint.this.ssf.toString()) + (KerberosServerEndpoint.this.csf == null ? "" : " csf = " + KerberosServerEndpoint.this.csf.toString()) + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(ServerConnectionImpl connection) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.closed) {
                    this.connections.remove(connection);
                }
            }
        }

        private boolean checkKey() {
            if (this.serverKey.isDestroyed()) {
                return false;
            }
            return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Set<Object> creds;
                    Set<Object> set = creds = KerberosServerEndpoint.this.serverSubject.getPrivateCredentials();
                    synchronized (set) {
                        Iterator<Object> iter = creds.iterator();
                        while (iter.hasNext()) {
                            if (ListenHandleImpl.this.serverKey != iter.next()) continue;
                            return Boolean.TRUE;
                        }
                    }
                    return Boolean.FALSE;
                }
            });
        }

        private boolean continueAfterAcceptFailure(Throwable t) {
            int NFAIL = 10;
            int NMSEC = 5000;
            long now = System.currentTimeMillis();
            if (this.acceptFailureTime == 0L || now - this.acceptFailureTime > 5000L) {
                this.acceptFailureTime = now;
                this.acceptFailureCount = 0;
            } else {
                ++this.acceptFailureCount;
                if (this.acceptFailureCount >= 10) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            return true;
        }
    }

    private final class ListenCookieImpl
    implements ServerEndpoint.ListenCookie {
        int localPort;

        ListenCookieImpl(int localPort) {
            this.localPort = localPort;
        }

        ListenEndpointImpl getListenEndpoint() {
            return KerberosServerEndpoint.this.listenEndpoint;
        }

        int getLocalPort() {
            return this.localPort;
        }
    }

    private final class ListenEndpointImpl
    implements ServerEndpoint.ListenEndpoint {
        private ListenEndpointImpl() {
        }

        public void checkPermissions() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkListen(KerberosServerEndpoint.this.port);
                    KerberosUtil.checkAuthPermission(KerberosServerEndpoint.this.serverPrincipal, null, "listen");
                }
                catch (SecurityException se) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "checkPermissions", "check permissions for {0}\nthrows", new Object[]{this}, se);
                    }
                    throw se;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ServerEndpoint.ListenHandle listen(RequestDispatcher requestDispatcher) throws IOException {
            ServerSocket serverSocket;
            GSSCredential serverCred;
            KerberosKey serverKey;
            block20: {
                if (requestDispatcher == null) {
                    throw new NullPointerException("null dispatcher is passed in");
                }
                try {
                    if (KerberosServerEndpoint.this.serverSubject != null && !KerberosServerEndpoint.this.serverSubject.getPrincipals().contains(KerberosServerEndpoint.this.serverPrincipal)) {
                        throw new UnsupportedConstraintException("Failed to find serverPrincipal " + KerberosServerEndpoint.this.serverPrincipal + "in serverSubject's principal set, cannot listen.");
                    }
                    serverKey = KerberosServerEndpoint.getKey(KerberosServerEndpoint.this.serverSubject, KerberosServerEndpoint.this.serverPrincipal);
                    if (serverKey == null) {
                        throw new UnsupportedConstraintException("No valid Kerberos key in the server subject for " + KerberosServerEndpoint.this.serverPrincipal + ", cannot listen.");
                    }
                    Object object = classLock;
                    synchronized (object) {
                        if (gssManager == null) {
                            gssManager = GSSManager.getInstance();
                        }
                    }
                    try {
                        serverCred = (GSSCredential)Security.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws GSSException {
                                return KerberosUtil.getGSSCredential(KerberosServerEndpoint.this.serverSubject, KerberosServerEndpoint.this.serverPrincipal, gssManager, 2);
                            }
                        });
                    }
                    catch (PrivilegedActionException pe) {
                        GSSException ge = (GSSException)pe.getException();
                        throw new UnsupportedConstraintException("Failed to get GSSCredential for server principal: " + KerberosServerEndpoint.this.serverPrincipal, ge);
                    }
                }
                catch (UnsupportedConstraintException uce) {
                    if (!logger.isLoggable(Levels.FAILED)) throw uce;
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "listen", "listen for {0}\nthrows", new Object[]{this}, uce);
                    throw uce;
                }
                catch (SecurityException se) {
                    if (!logger.isLoggable(Levels.FAILED)) throw se;
                    KerberosUtil.logThrow(logger, Levels.FAILED, this.getClass(), "listen", "listen for {0}\nthrows", new Object[]{this}, se);
                    throw se;
                }
                boolean done = false;
                try {
                    if (KerberosServerEndpoint.this.ssf != null) {
                        serverSocket = KerberosServerEndpoint.this.ssf.createServerSocket(KerberosServerEndpoint.this.port);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "created {0} using factory {1}", new Object[]{serverSocket, KerberosServerEndpoint.this.ssf});
                        }
                    } else {
                        serverSocket = new ServerSocket(KerberosServerEndpoint.this.port);
                        logger.log(Level.FINE, "created {0}", serverSocket);
                    }
                    done = true;
                    Object var7_10 = null;
                    if (done) break block20;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (done) throw throwable;
                    try {
                        serverCred.dispose();
                        throw throwable;
                    }
                    catch (GSSException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (GSSException e) {}
                serverCred.dispose();
            }
            ListenHandleImpl listenHandle = new ListenHandleImpl(requestDispatcher, serverKey, serverCred, serverSocket, Security.getContext());
            listenHandle.startAccepting();
            return listenHandle;
        }

        public int hashCode() {
            int hash = this.getClass().getName().hashCode() ^ System.identityHashCode(KerberosServerEndpoint.this.serverSubject) ^ KerberosServerEndpoint.this.serverPrincipal.hashCode() ^ KerberosServerEndpoint.this.port;
            if (KerberosServerEndpoint.this.ssf != null) {
                hash ^= KerberosServerEndpoint.this.ssf.hashCode();
            }
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ListenEndpointImpl)) {
                return false;
            }
            ListenEndpointImpl ole = (ListenEndpointImpl)obj;
            KerberosServerEndpoint ose = ole.getServerEndpoint();
            return KerberosServerEndpoint.this.serverSubject == ose.serverSubject && KerberosServerEndpoint.this.serverPrincipal.equals(ose.serverPrincipal) && KerberosServerEndpoint.this.port == ose.port && Util.sameClassAndEquals(KerberosServerEndpoint.this.ssf, ose.ssf);
        }

        public String toString() {
            return "KerberosServerEndpoint.ListenEndpointImpl[serverPrincipal=" + KerberosServerEndpoint.this.serverPrincipal + " serverPort = " + KerberosServerEndpoint.this.port + (KerberosServerEndpoint.this.ssf == null ? "" : " ssf = " + KerberosServerEndpoint.this.ssf.toString()) + (KerberosServerEndpoint.this.csf == null ? "" : " csf = " + KerberosServerEndpoint.this.csf.toString()) + "]";
        }

        private KerberosServerEndpoint getServerEndpoint() {
            return KerberosServerEndpoint.this;
        }
    }
}

