/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run;

import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.RunHandler;
import com.sonicsw.xqimpl.Version;
import com.sonicsw.xqimpl.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class RunHandlerFactory {
    public static final String ESBWS_TYPE = "ESBWS";
    public static final String ESBDB_TYPE = "ESBDB";
    public static final String ESBSERIVCE_TYPE = "ESBSERVICE";
    public static final String ESBXSLT_TYPE = "ESBXSLT";
    public static final String ESBXCBR_TYPE = "ESBXCBR";
    public static final String OSVR_TYPE = "OSERVER";
    public static final String XMLSERVER_XACTION_TYPE = "XMLSERVER_XACTION";
    public static final String XMLSERVER_XSLT_TYPE = "XMLSERVER_XSLT";
    public static final String XMLSERVER_XQUERY_TYPE = "XMLSERVER_XQUERY";
    public static final String BPEL_SCRIPT_TYPE = "ESBPEL";
    public static final String BPEL_SERVICE_TYPE = "BPELSRV";
    public static final String CONNECT_SERVICE_TYPE = "CONNECTSERVICE";
    private String m_runHandlerPropertyFileURL = "sonicfs:///System/SonicESB/" + Version.getMajorMinorVersion() + "/dev/RunHandlerFactory.properties";
    private Properties m_runHandlerProps = null;
    private Map m_runHandlerMap = new HashMap();
    private static RunHandlerFactory m_runHandlerFactory = null;

    public static synchronized RunHandlerFactory getInstance() {
        if (m_runHandlerFactory == null) {
            m_runHandlerFactory = new RunHandlerFactory();
        }
        return m_runHandlerFactory;
    }

    private RunHandlerFactory() {
    }

    public void setRunHandlerFactoryPropertiesURL(String URL) {
        this.m_runHandlerPropertyFileURL = URL;
    }

    public void setRunHandlerFactoryProperties(Properties props) {
        this.m_runHandlerProps = props;
    }

    public synchronized RunHandler createRunHandler(String type) throws RunException {
        if (this.m_runHandlerProps == null) {
            InputStream stream = null;
            try {
                stream = URLUtil.getInputStream((URL)new URL(this.m_runHandlerPropertyFileURL));
                if (stream == null) {
                    throw new RunException("Unable to load properties file at: " + this.m_runHandlerPropertyFileURL);
                }
                Properties properties = new Properties();
                try {
                    properties.load(stream);
                }
                catch (IOException e) {
                    throw new RunException(e);
                }
                this.m_runHandlerProps = properties;
            }
            catch (MalformedURLException e) {
                throw new RunException(e);
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {}
            }
        }
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        Class<?> runHandlerClass = (Class<?>)this.m_runHandlerMap.get(type);
        if (runHandlerClass == null) {
            String classFile = this.m_runHandlerProps.getProperty(type);
            if (classFile == null) {
                throw new RunException("Run handler undefined for type: " + type);
            }
            try {
                runHandlerClass = Class.forName(classFile, false, cloader);
            }
            catch (ClassNotFoundException e) {
                throw new RunException(e);
            }
            this.m_runHandlerMap.put(type, runHandlerClass);
        }
        try {
            RunHandler result = (RunHandler)runHandlerClass.newInstance();
            return result;
        }
        catch (InstantiationException e) {
            throw new RunException(e);
        }
        catch (IllegalAccessException e) {
            throw new RunException(e);
        }
    }
}

