/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.impl;

import com.sonicsw.esb.jeri.IExporterSource;
import com.sonicsw.esb.jeri.esb.ESBPreferredEndpointTracker;
import com.sonicsw.esb.run.Location;
import com.sonicsw.esb.run.LocationContext;
import com.sonicsw.esb.run.RemoteRunContext;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.event.CustomEvent;
import com.sonicsw.esb.run.impl.Run;
import com.sonicsw.esb.run.impl.util.PreferredExporterFactory;
import com.sonicsw.esb.run.impl.util.RunUtils;
import com.sonicsw.esb.run.request.EventRequest;
import com.sonicsw.esb.run.request.impl.WrappedEventRequestImpl;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Stack;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class RunContext
implements com.sonicsw.esb.run.RunContext {
    private static final long serialVersionUID = -8080517882141741446L;
    public static final String RUN_CONTEXT_PART_CONTENT_ID = "SonicESB.RUN_CONTEXT_PART_CONTENT_ID";
    protected final Uuid m_runID;
    protected final Run.RunProxy m_run;
    protected String m_trackingID = null;
    protected Uuid m_runContextMarker = null;
    protected RemoteRunContext m_remoteRunContext = null;
    private Stack m_contextStack = new Stack();
    private boolean m_remoteRunContextReadOnly = false;

    protected RunContext(Run.RunProxy runProxy) throws RunException {
        try {
            this.m_run = runProxy;
            this.m_runID = UuidFactory.create((String)runProxy.getRunID());
        }
        catch (Exception e) {
            throw new RunException("Failed to create Run Context", e);
        }
    }

    public RunContext(RunContext runContext) {
        this.m_run = runContext.m_run;
        this.m_runID = runContext.m_runID;
        this.m_trackingID = runContext.m_trackingID;
        this.m_runContextMarker = runContext.m_runContextMarker;
        this.m_remoteRunContext = runContext.m_remoteRunContext;
        this.m_contextStack = (Stack)runContext.m_contextStack.clone();
    }

    @Override
    public String getRunID() {
        return this.m_runID.toString();
    }

    @Override
    public String getTrackingID() {
        return this.m_trackingID;
    }

    @Override
    public void setTrackingID(String trackingID) {
        this.m_trackingID = trackingID;
    }

    public synchronized String getTestContextMarker() {
        if (this.m_runContextMarker != null) {
            return this.m_runContextMarker.toString();
        }
        return null;
    }

    public synchronized String markTestContext() {
        this.m_runContextMarker = UuidFactory.generate();
        return this.m_runContextMarker.toString();
    }

    public synchronized void clearTestContextMarker() {
        this.m_runContextMarker = null;
    }

    @Override
    public RemoteRunContext getRemoteRunContext() {
        return this.m_remoteRunContext;
    }

    @Override
    public void setRemoteRunContextReadOnly(boolean readOnly) {
        this.m_remoteRunContextReadOnly = readOnly;
    }

    @Override
    public void push(Location location) {
        this.m_contextStack.push(location);
    }

    @Override
    public Location pop() {
        return (Location)this.m_contextStack.pop();
    }

    @Override
    public void close() throws RunException {
        try {
            if (this.m_run != null) {
                this.m_run.close();
            }
        }
        catch (Exception e) {
            throw new RunException("Failed to close Run session", e);
        }
    }

    @Override
    public void replaceCurrentFrame(Location location) {
        int size = this.m_contextStack.size();
        if (size > 0) {
            this.pop();
            this.push(location);
        }
    }

    @Override
    public Stack getStack() {
        return this.m_contextStack;
    }

    public int getStackDepth() {
        return this.m_contextStack.size();
    }

    @Override
    public Location peekCurrentFrame() {
        return (Location)this.m_contextStack.peek();
    }

    @Override
    public void process(LocationContext context) throws RunException {
        Exporter exporter = null;
        RemoteTestContext remoteTestContext = new RemoteTestContext();
        remoteTestContext.setReadOnly(this.m_remoteRunContextReadOnly);
        try {
            exporter = context.getExporterFactory().createExporter();
            this.m_remoteRunContext = (RemoteRunContext)exporter.export((Remote)remoteTestContext);
            com.sonicsw.esb.run.impl.Location location = (com.sonicsw.esb.run.impl.Location)context.getLocation().clone();
            location.setTestContextMarker(this.getTestContextMarker());
            location.setCurrentStackDepth(this.getStackDepth());
            List requests = this.m_run.getEventRequests(location);
            for (EventRequest request : requests) {
                if (!request.isEnabled()) continue;
                request.process(context);
            }
        }
        catch (RunException e) {
            throw e;
        }
        catch (RemoteException e) {
            RunException te = RunUtils.createRunException(e);
            throw te;
        }
        catch (Exception e) {
            throw new RunException("Failed to process Requests at " + context.getLocation(), e);
        }
        finally {
            if (exporter != null) {
                exporter.unexport(true);
            }
            this.m_remoteRunContext = null;
        }
    }

    @Override
    public void sendEvent(CustomEvent event) throws RunException {
        Location location = event.getLocation();
        WrappedEventRequestImpl request = new WrappedEventRequestImpl(this.m_run, location, event);
        com.sonicsw.esb.run.impl.LocationContext locationContext = new com.sonicsw.esb.run.impl.LocationContext(location, null, new PreferredExporterFactory((IExporterSource)ESBPreferredEndpointTracker.getInstance(), this.getRunID()), this);
        locationContext.setRemoteLocationData(event.getData());
        request.process(locationContext);
    }

    public class RemoteTestContext
    implements com.sonicsw.esb.run.impl.RemoteRunContext {
        private boolean m_isReadOnly = false;

        @Override
        public String getTestContextMarker() {
            return RunContext.this.getTestContextMarker();
        }

        @Override
        public String markTestContext() {
            return RunContext.this.markTestContext();
        }

        @Override
        public void clearTestContextMarker() {
            RunContext.this.clearTestContextMarker();
        }

        @Override
        public String getTrackingID() {
            return RunContext.this.getTrackingID();
        }

        @Override
        public void setTrackingID(String trackingID) throws RemoteException {
            if (this.m_isReadOnly) {
                throw new RemoteException("RemoteRunContext is read-only");
            }
            RunContext.this.setTrackingID(trackingID);
        }

        @Override
        public Stack getStack() {
            return RunContext.this.getStack();
        }

        @Override
        public int getStackDepth() {
            return RunContext.this.getStackDepth();
        }

        @Override
        public boolean isReadOnly() {
            return this.m_isReadOnly;
        }

        public void setReadOnly(boolean value) {
            this.m_isReadOnly = value;
        }
    }
}

