/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.esb.run.impl.util;

import com.sonicsw.esb.jeri.JERIDisconnectException;
import com.sonicsw.esb.jeri.JERITimeoutException;
import com.sonicsw.esb.jeri.esb.ESBPreferredEndpointTracker;
import com.sonicsw.esb.run.RunContext;
import com.sonicsw.esb.run.RunDisconnectException;
import com.sonicsw.esb.run.RunException;
import com.sonicsw.esb.run.RunTimeoutException;
import com.sonicsw.esb.run.impl.Run;
import com.sonicsw.xq.XQMessage;
import com.sonicsw.xq.XQMessageException;
import com.sonicsw.xq.XQPart;
import com.sonicsw.xqimpl.service.RMEMessage;
import com.sonicsw.xqimpl.service.XQMessageInternal;
import com.sonicsw.xqimpl.service.debug.DebugObjectInputStream;
import com.sonicsw.xqimpl.util.ClassLoaderManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;

public class RunUtils {
    public static final String RUN_CONTEXT_MSG_TYPE = "SonicESB.RUN_CONTEXT_MSG_TYPE";
    private static final String FAULT_TYPE = "FAULT";
    private static final String EXIT_TYPE = "EXIT";
    private static final String INBOX_TYPE = "INBOX";

    public static XQMessage populateMessageWithRun(XQMessage msg, Run run) throws RunException {
        com.sonicsw.esb.run.impl.RunContext runContext = run.getRunContext();
        try {
            byte[] serializedRunContext = RunUtils.serializeRunContext(runContext);
            RunUtils.addInboxRunContextPart(msg, serializedRunContext);
            msg.setStringHeader("SonicESB.REMOTE_JERI_UUID", run.getRunID());
            return msg;
        }
        catch (Exception e) {
            throw new RunException(e);
        }
    }

    public static byte[] serializeRunContext(RunContext context) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(context);
        oos.flush();
        byte[] serializedRunContext = baos.toByteArray();
        oos.close();
        return serializedRunContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RunContext unserializeRunContext(byte[] runContextBytes) throws IOException, ClassNotFoundException {
        ClassLoader oldLoader = ClassLoaderManager.setThreadContextClassLoader((ClassLoader)ClassLoaderManager.getInstance().getDefaultClassLoader());
        try {
            RunContext runContext;
            DebugObjectInputStream is = new DebugObjectInputStream((InputStream)new ByteArrayInputStream(runContextBytes));
            RunContext runContext2 = runContext = (RunContext)is.readObject();
            return runContext2;
        }
        finally {
            ClassLoaderManager.setThreadContextClassLoader((ClassLoader)oldLoader);
        }
    }

    private static void populateMessageWithRunContext(XQMessage runMessage, byte[] serializedRunContext, String type) throws XQMessageException {
        XQMessageInternal msg = (XQMessageInternal)runMessage;
        XQPart part = msg.createPart();
        part.setContent((Object)serializedRunContext, "application/octet-stream");
        part.getHeader().setValue(RUN_CONTEXT_MSG_TYPE, type);
        part.setContentId("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        if (msg.doesPartExist("SonicESB.RUN_CONTEXT_PART_CONTENT_ID")) {
            msg.removePart("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        }
        msg.addPart(part);
    }

    public static void addFaultRunContextPart(XQMessage runMessage, byte[] serializedRunContext) throws XQMessageException {
        RunUtils.populateMessageWithRunContext(runMessage, serializedRunContext, FAULT_TYPE);
    }

    public static void addExitRunContextPart(XQMessage runMessage, byte[] serializedRunContext) throws XQMessageException {
        RunUtils.populateMessageWithRunContext(runMessage, serializedRunContext, EXIT_TYPE);
    }

    public static void addInboxRunContextPart(XQMessage runMessage, byte[] serializedTestContext) throws XQMessageException {
        RunUtils.populateMessageWithRunContext(runMessage, serializedTestContext, INBOX_TYPE);
    }

    public static byte[] retrieveRunContext(XQMessage runMessage) throws XQMessageException {
        if (runMessage.doesPartExist("SonicESB.RUN_CONTEXT_PART_CONTENT_ID")) {
            XQPart part = runMessage.getPart("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
            byte[] result = (byte[])part.getContent();
            runMessage.removePart("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
            return result;
        }
        return null;
    }

    public static boolean isFaultMessage(XQMessage runMessage) throws XQMessageException {
        if (runMessage.doesPartExist("SonicESB.RUN_CONTEXT_PART_CONTENT_ID")) {
            XQPart part = runMessage.getPart("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
            return part.getHeader().getValue(RUN_CONTEXT_MSG_TYPE).equals(FAULT_TYPE);
        }
        return false;
    }

    public static boolean isRMEMessage(XQMessage runMessage) throws XQMessageException {
        if (runMessage.doesPartExist("SonicESB.RUN_CONTEXT_PART_CONTENT_ID")) {
            return false;
        }
        try {
            return RMEMessage.isRME((XQMessage)runMessage);
        }
        catch (XQMessageException e) {
            return false;
        }
    }

    public static boolean isExitMessage(XQMessage runMessage) throws XQMessageException {
        if (runMessage.doesPartExist("SonicESB.RUN_CONTEXT_PART_CONTENT_ID")) {
            XQPart part = runMessage.getPart("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
            return part.getHeader().getValue(RUN_CONTEXT_MSG_TYPE).equals(EXIT_TYPE);
        }
        return false;
    }

    public static void removeRunInfo(XQMessage runMessage) throws XQMessageException {
        if (runMessage.doesPartExist("SonicESB.RUN_CONTEXT_PART_CONTENT_ID")) {
            runMessage.removePart("SonicESB.RUN_CONTEXT_PART_CONTENT_ID");
        }
    }

    public static RunException createRunException(RemoteException ex) {
        Throwable t = ex.getCause();
        if (t != null) {
            if (t instanceof JERIDisconnectException) {
                return new RunDisconnectException("Run Disconnected", t);
            }
            if (t instanceof JERITimeoutException) {
                return new RunTimeoutException("Run Timed Out", t);
            }
            return new RunException("Run Client Closed", t);
        }
        return new RunException("Run Client Closed", ex);
    }

    public static boolean setupJERIEnvironment(XQMessage msg) {
        ESBPreferredEndpointTracker tracker;
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        String entryEndpointName = (String)internalMsg.getSidebandProperty("SonicESB.OriginalEntryEndpoint");
        String UUID = (String)internalMsg.getSidebandProperty("SonicESB.JERI_UUID");
        if (entryEndpointName != null && UUID != null && !(tracker = ESBPreferredEndpointTracker.getInstance()).containsUUID(UUID)) {
            tracker.addUuidMap(UUID, entryEndpointName);
            return true;
        }
        return false;
    }

    public static void cleanupJERIEnvironment(XQMessage msg) {
        XQMessageInternal internalMsg = (XQMessageInternal)msg;
        String uuid = (String)internalMsg.getSidebandProperty("SonicESB.JERI_UUID");
        if (uuid != null) {
            ESBPreferredEndpointTracker tracker = ESBPreferredEndpointTracker.getInstance();
            tracker.removeUUID(uuid);
        }
    }
}

