/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.monitor;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.metrics.IAggregateMetric;
import com.sonicsw.mf.common.metrics.IAggregateMetricsData;
import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.impl.MetricsData;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.IEnterpriseAware;
import com.sonicsw.mf.common.runtime.IEnterpriseStateAccess;
import com.sonicsw.mf.common.runtime.IMonitoredMetrics;
import com.sonicsw.mf.common.runtime.IMonitoredNotifications;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.MonitoredMetrics;
import com.sonicsw.mf.common.runtime.impl.MonitoredNotifications;
import com.sonicsw.mf.framework.AbstractFrameworkComponent;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.INotificationHandler;
import com.sonicsw.mf.framework.monitor.CollectionMonitor;
import com.sonicsw.mf.framework.monitor.IEventHolder;
import com.sonicsw.mf.framework.monitor.IHistoryStorageListener;
import com.sonicsw.mf.framework.monitor.IOffloadListener;
import com.sonicsw.mf.framework.monitor.NotificationManager;
import com.sonicsw.mf.framework.monitor.offload.AnalyticsOffloader;
import com.sonicsw.mf.framework.monitor.storage.IHistoryStorage;
import com.sonicsw.mf.framework.monitor.storage.fs.FSStorage;
import com.sonicsw.mf.framework.monitor.storage.jdbc.JDBCStorage;
import com.sonicsw.mf.framework.util.NotificationForwarder;
import com.sonicsw.mf.mgmtapi.runtime.ICollectionsMonitorProxy;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.sdf.AbstractMFComponentTracing;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public final class CollectionsMonitor
extends AbstractFrameworkComponent
implements INotificationHandler,
IOffloadListener,
IHistoryStorageListener,
IEnterpriseAware {
    private String m_configID;
    ICanonicalName m_componentName;
    IHistoryStorage m_store;
    AnalyticsOffloader m_offloader;
    NotificationForwarder m_notificationForwarder;
    NotificationManager m_notificationManager;
    private long m_maxStorageSize;
    private HashMap m_collectionMonitors = new HashMap();
    private IMetricsRegistrar m_metricsRegistrar;
    private SdfMFTracingIntegration m_SdfMFTracingIntegration;
    private Integer m_historyDurationHours = 48;
    boolean m_saveMonitoredNotifications = true;
    boolean m_saveThresholdNotifications = true;
    public static final String THRESHOLD_NOTIFICATION_TYPE = "Threshold";
    public static final String[] THRESHOLD_NOTIFICATION_TYPES = new String[]{INotification.CATEGORY_TEXT[0] + '.' + INotification.SUBCATEGORY_TEXT[2] + '.' + "Threshold"};
    private final String[] m_thresholdNotificationSources = new String[1];
    private IEnterpriseStateAccess m_enterpriseStateAccessor;
    private static final String MONITOR_TRACE_MASK_VALUES = "16=received notifications,32=forwarded notifications,64=storage failure details,128=metric poll timeouts,256=metric enabling,512=monitoring request failures,1024=storage activity,2048=metric polling,4096=offload failure details";
    public static final int TRACE_RECEIVED_NOTIFICATIONS = 16;
    public static final int TRACE_FORWARDED_NOTIFICATIONS = 32;
    public static final int TRACE_STORAGE_FAILURES = 64;
    public static final int TRACE_METRIC_POLL_TIMEOUTS = 128;
    public static final int TRACE_METRIC_ENABLING = 256;
    public static final int TRACE_REQUEST_FAILURES = 512;
    public static final int TRACE_STORAGE_ACTIVITY = 1024;
    public static final int TRACE_METRIC_POLLING = 2048;
    public static final int TRACE_OFFLOAD_FAILURES = 4096;
    private static final INotification[] EMPTY_NOTIFICATION_ARRAY = new INotification[0];
    private static final IHistoricalMetric[] EMPTY_HISTORICAL_METRIC_ARRAY = new IHistoricalMetric[0];
    private static final IAggregateMetric[] EMPTY_AGGREGATE_METRIC_ARRAY = new IAggregateMetric[0];
    private static final Reference[] EMPTY_REFERENCE_ARRAY = new Reference[0];
    public static final IMetricIdentity STORAGE_METRICS_STOREDPERMINUTE_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"storage", "metrics", "StoredPerMinute"});
    private static IStatistic m_metricsStoredPerMinute;
    public static final IMetricIdentity STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC;
    private static IStatistic m_notificationsStoredPerMinute;
    public static final IMetricIdentity MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID;
    private static IStatistic m_averageMetricLatencyStatistic;
    public static final IMetricIdentity MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID;
    private static IStatistic m_minMetricLatencyStatistic;
    public static final IMetricIdentity MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID;
    private static IStatistic m_maxMetricLatencyStatistic;
    public static final IMetricIdentity MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID;
    private static IStatistic m_metricsReceivedPerSecond;
    public static final IMetricIdentity MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID;
    private static IStatistic m_notificationsReceivedPerSecond;
    private static final ArrayList ATTRIBUTE_INFOS;
    private static final ArrayList OPERATION_INFOS;
    private static final ArrayList NOTIFICATION_INFOS;
    private static final int MAX_RETRIEVAL_LIMIT = 0x100000;

    public MBeanAttributeInfo[] getAttributeInfos() {
        return ATTRIBUTE_INFOS.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    public MBeanOperationInfo[] getOperationInfos() {
        return OPERATION_INFOS.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    public MBeanNotificationInfo[] getNotificationInfos() {
        return NOTIFICATION_INFOS.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    public void init(IComponentContext context) {
        Long maxStorageSize;
        Boolean saveThresholdNotifications;
        Boolean saveMonitoredNotifications;
        Integer notificationSubscriptionRenewalInterval;
        AnalyticsOffloader offloader = AnalyticsOffloader.getInstance();
        if (offloader.isDeployed()) {
            this.m_offloader = offloader;
            this.m_offloader.init();
            this.m_offloader.setOffloadListener(this);
        }
        this.m_notificationForwarder = new NotificationForwarder((IFrameworkComponentContext)context);
        this.m_notificationManager = new NotificationManager((IFrameworkComponentContext)context);
        IElement cmElement = context.getConfiguration(true);
        this.m_configID = cmElement.getIdentity().getName();
        IAttributeSet cmAttributes = cmElement.getAttributes();
        Integer historyDurationHours = (Integer)cmAttributes.getAttribute("HISTORY_DURATION_HOURS");
        if (historyDurationHours != null) {
            this.setHistoryDurationHours(historyDurationHours);
        }
        if ((notificationSubscriptionRenewalInterval = (Integer)cmAttributes.getAttribute("NOTIFICATION_SUBSCRIPTION_TIMEOUT")) != null) {
            this.setNotificationSubscriptionRenewalInterval(notificationSubscriptionRenewalInterval);
        }
        if ((saveMonitoredNotifications = (Boolean)cmAttributes.getAttribute("SAVE_MONITORED_NOTIFICATIONS")) != null) {
            this.setSaveMonitoredNotifications(saveMonitoredNotifications);
        }
        if ((saveThresholdNotifications = (Boolean)cmAttributes.getAttribute("SAVE_THRESHOLD_NOTIFICATIONS")) != null) {
            this.setSaveThresholdNotifications(saveThresholdNotifications);
        }
        maxStorageSize = (maxStorageSize = (Long)cmAttributes.getAttribute("MAX_STORAGE_SIZE")) != null ? maxStorageSize : 100L;
        this.setMaxStorageSize(maxStorageSize);
        super.init(context);
        this.m_componentName = this.m_context.getComponentName();
        this.m_thresholdNotificationSources[0] = this.m_componentName.getCanonicalName();
        IAttributeSet jdbcStorageAttrs = (IAttributeSet)cmAttributes.getAttribute("JDBC_HISTORY_STORAGE");
        if (this.m_offloader == null) {
            if (jdbcStorageAttrs == null) {
                this.m_store = this.getFSStorage((IAttributeSet)cmAttributes.getAttribute("FS_HISTORY_STORAGE"));
                this.m_store.setMaxStorageSize(this.m_maxStorageSize);
                this.m_store.setHistoryStorageListener(this);
            } else {
                this.m_store = this.getJDBCStorage(jdbcStorageAttrs);
                this.m_store.setMaxStorageSize(this.m_maxStorageSize);
                this.m_store.setHistoryStorageListener(this);
            }
        }
        this.setTraceMask(super.getTraceMask());
        this.m_metricsRegistrar = this.m_context.initMetricsManagement(CollectionsMonitor.getMetricsInfo());
    }

    public synchronized void enableMetrics(IMetricIdentity[] ids) {
        boolean INTERVAL_MODE = true;
        boolean NO_HISTORY = false;
        boolean REFRESHED_VALUES_OVER_COLLECTION_INTERVAL_HISTORY = true;
        int REFRESHED_VALUES_AND_UPDATE_COUNTS_OVER_COLLECTION_INTERVAL_HISTORY = 2;
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)ICollectionsMonitorProxy.STORAGE_METRICS_STOREDPERMINUTE_METRIC_ID)) {
                m_metricsStoredPerMinute = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                this.m_metricsRegistrar.registerMetric(ICollectionsMonitorProxy.STORAGE_METRICS_STOREDPERMINUTE_METRIC_ID, m_metricsStoredPerMinute);
                continue;
            }
            if (ids[i].equals((Object)ICollectionsMonitorProxy.STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC_ID)) {
                m_notificationsStoredPerMinute = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                this.m_metricsRegistrar.registerMetric(ICollectionsMonitorProxy.STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC_ID, m_notificationsStoredPerMinute);
                continue;
            }
            if (ids[i].equals((Object)ICollectionsMonitorProxy.MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID) && m_averageMetricLatencyStatistic == null) {
                m_averageMetricLatencyStatistic = this.getM_notificationsReceivedPerSecond42181(true, (short)2);
                this.m_metricsRegistrar.registerMetric(ICollectionsMonitorProxy.MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID, m_averageMetricLatencyStatistic);
                continue;
            }
            if (ids[i].equals((Object)ICollectionsMonitorProxy.MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID) && m_maxMetricLatencyStatistic == null) {
                m_maxMetricLatencyStatistic = StatisticsFactory.createStatistic((short)3, (boolean)false, (IStatisticProvider[])null, (short)1);
                m_maxMetricLatencyStatistic.setInitialValue(0L);
                this.m_metricsRegistrar.registerMetric(ICollectionsMonitorProxy.MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID, m_maxMetricLatencyStatistic);
                continue;
            }
            if (ids[i].equals((Object)ICollectionsMonitorProxy.MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID) && m_minMetricLatencyStatistic == null) {
                m_minMetricLatencyStatistic = StatisticsFactory.createStatistic((short)4, (boolean)false, (IStatisticProvider[])null, (short)1);
                m_minMetricLatencyStatistic.setInitialValue(60000L);
                this.m_metricsRegistrar.registerMetric(ICollectionsMonitorProxy.MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID, m_minMetricLatencyStatistic);
                continue;
            }
            if (ids[i].equals((Object)ICollectionsMonitorProxy.MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID) && m_metricsReceivedPerSecond == null) {
                m_metricsReceivedPerSecond = this.getM_notificationsReceivedPerSecond42181(true, (short)1);
                this.m_metricsRegistrar.registerMetric(ICollectionsMonitorProxy.MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID, m_metricsReceivedPerSecond);
                continue;
            }
            if (!ids[i].equals((Object)ICollectionsMonitorProxy.MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID) || m_notificationsReceivedPerSecond != null) continue;
            m_notificationsReceivedPerSecond = this.getM_notificationsReceivedPerSecond42181(true, (short)1);
            this.m_metricsRegistrar.registerMetric(ICollectionsMonitorProxy.MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID, m_notificationsReceivedPerSecond);
        }
    }

    private IStatistic getM_notificationsReceivedPerSecond42181(boolean INTERVAL_MODE, short REFRESHED_VALUES_OVER_COLLECTION_INTERVAL_HISTORY) {
        return StatisticsFactory.createStatistic((short)2, (boolean)INTERVAL_MODE, (IStatisticProvider[])null, (short)REFRESHED_VALUES_OVER_COLLECTION_INTERVAL_HISTORY);
    }

    public synchronized void disableMetrics(IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)ICollectionsMonitorProxy.STORAGE_METRICS_STOREDPERMINUTE_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(ICollectionsMonitorProxy.STORAGE_METRICS_STOREDPERMINUTE_METRIC_ID);
                m_metricsStoredPerMinute = null;
            } else if (ids[i].equals((Object)ICollectionsMonitorProxy.STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC_ID)) {
                this.m_metricsRegistrar.unregisterMetric(ICollectionsMonitorProxy.STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC_ID);
                m_notificationsStoredPerMinute = null;
            }
            if (ids[i].equals((Object)MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID) && m_averageMetricLatencyStatistic != null) {
                m_averageMetricLatencyStatistic = this.unregisterMetric(MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID, m_averageMetricLatencyStatistic);
                continue;
            }
            if (ids[i].equals((Object)MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID) && m_maxMetricLatencyStatistic != null) {
                m_maxMetricLatencyStatistic = this.unregisterMetric(MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID, m_maxMetricLatencyStatistic);
                continue;
            }
            if (ids[i].equals((Object)MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID) && m_minMetricLatencyStatistic != null) {
                m_minMetricLatencyStatistic = this.unregisterMetric(MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID, m_minMetricLatencyStatistic);
                continue;
            }
            if (ids[i].equals((Object)MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID) && m_metricsReceivedPerSecond != null) {
                m_metricsReceivedPerSecond = this.unregisterMetric(MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID, m_metricsReceivedPerSecond);
                continue;
            }
            if (!ids[i].equals((Object)MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID) || m_notificationsReceivedPerSecond == null) continue;
            m_notificationsReceivedPerSecond = this.unregisterMetric(MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID, m_notificationsReceivedPerSecond);
        }
    }

    private IStatistic unregisterMetric(IMetricIdentity MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID, IStatistic m_maxMetricLatencyStatistic) {
        this.m_metricsRegistrar.unregisterMetric(MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID, m_maxMetricLatencyStatistic);
        return null;
    }

    private IHistoryStorage getFSStorage(IAttributeSet fsStorageAttrs) {
        String directory;
        String rootDirectory = ".";
        if (fsStorageAttrs != null && (directory = (String)fsStorageAttrs.getAttribute("DIRECTORY")) != null) {
            rootDirectory = directory;
        }
        return new FSStorage(rootDirectory, this.m_componentName.getComponentName(), this.m_context);
    }

    private IHistoryStorage getJDBCStorage(IAttributeSet jdbcStorageAttrs) {
        String driver = (String)jdbcStorageAttrs.getAttribute("DRIVER");
        String url = (String)jdbcStorageAttrs.getAttribute("URL");
        String user = (String)jdbcStorageAttrs.getAttribute("USER");
        String password = (String)jdbcStorageAttrs.getAttribute("PASSWORD");
        String blobSQLType = (String)jdbcStorageAttrs.getAttribute("BLOB_SQL_TYPE");
        String tnfError = (String)jdbcStorageAttrs.getAttribute("TABLE_NOT_FOUND_ERROR");
        String ucError = (String)jdbcStorageAttrs.getAttribute("UNIQUE_CONSTRAINT_ERROR");
        return new JDBCStorage(driver, url, user, password, blobSQLType, tnfError, ucError, this.m_componentName.getComponentName(), this.m_context);
    }

    public synchronized void start() {
        this.m_SdfMFTracingIntegration = new SdfMFTracingIntegration();
        this.m_SdfMFTracingIntegration.register();
        if (this.m_state == 3) {
            return;
        }
        if (this.m_store != null) {
            this.m_store.setExpireAfter(this.m_historyDurationHours * 60 * 60 * 1000);
            this.m_store.open();
        }
        if (this.m_offloader != null) {
            this.m_offloader.start();
        }
        this.updateMonitoredCollections();
        Runnable subscriber = new Runnable(){

            @Override
            public void run() {
                CollectionsMonitor.this.waitForContainerBoot();
                if (CollectionsMonitor.this.m_container.isClosing()) {
                    return;
                }
                CollectionsMonitor.this.m_notificationManager.subscribe(null);
            }
        };
        this.m_frameworkContext.scheduleTask(subscriber, new Date(System.currentTimeMillis()));
        super.start();
    }

    public synchronized void stop() {
        if (this.m_state == 1) {
            return;
        }
        Object[] collections = this.m_collectionMonitors.keySet().toArray();
        for (int i = 0; i < collections.length; ++i) {
            this.removeCollectionMonitor((String)collections[i]);
        }
        this.m_collectionMonitors.clear();
        this.m_notificationManager.cleanup();
        if (this.m_offloader != null) {
            this.m_offloader.stop();
        }
        if (this.m_store != null) {
            this.m_store.close();
        }
        super.stop();
    }

    public void destroy() {
        this.m_notificationManager = null;
        this.m_store = null;
        if (this.m_offloader != null) {
            this.m_offloader.destroy();
            this.m_offloader = null;
        }
        super.destroy();
    }

    public synchronized void handleElementChange(IElementChange elementChange) {
        String configID = elementChange.getElement().getIdentity().getName();
        if (configID.equals(this.m_configID)) {
            this.handleCollectionsMonitorElementChange(elementChange);
        } else {
            CollectionMonitor monitor = (CollectionMonitor)this.m_collectionMonitors.get(configID);
            if (monitor != null) {
                monitor.handleElementChange(elementChange);
            }
        }
    }

    public String getTraceMaskValues() {
        return super.getTraceMaskValues() + "," + MONITOR_TRACE_MASK_VALUES;
    }

    public void setTraceMask(Integer traceMask) {
        this.setTraceMask(traceMask, false);
    }

    private void setTraceMask(Integer traceMask, boolean fromSDF) {
        if (!fromSDF && this.m_SdfMFTracingIntegration != null) {
            if (this.m_SdfMFTracingIntegration.wasUpdated()) {
                return;
            }
            this.m_SdfMFTracingIntegration.setTraceMask(traceMask);
        }
        super.setTraceMask(traceMask);
        if (this.m_notificationForwarder != null) {
            this.m_notificationForwarder.setDebug((this.m_traceMask & 0x20) > 0);
        }
        if (this.m_notificationManager != null) {
            this.m_notificationManager.setDebug((this.m_traceMask & 0x10) > 0);
        }
        FSStorage.setTraceMask(traceMask);
    }

    public void clearHistory() {
        if (this.m_store != null) {
            this.m_store.clear();
        }
    }

    public INotification[] getThresholdNotificationHistory(Long latest, Long earliest) {
        if (this.m_store == null) {
            return new INotification[0];
        }
        Iterator iterator = this.m_store.getNotifications(THRESHOLD_NOTIFICATION_TYPES, this.m_thresholdNotificationSources, latest, earliest);
        return CollectionsMonitor.addNotifications(iterator);
    }

    public INotification[] getNotificationHistory(String collectionID, String[] notificationTypes, Long latest, Long earliest) {
        if (this.m_store == null) {
            return new INotification[0];
        }
        Iterator iterator = this.m_store.getNotifications(notificationTypes, this.getComponentNames(collectionID), latest, earliest);
        return CollectionsMonitor.addNotifications(iterator);
    }

    private static INotification[] addNotifications(Iterator iterator) {
        ArrayList<INotification> list = new ArrayList<INotification>();
        while (iterator.hasNext()) {
            IEventHolder holder = (IEventHolder)iterator.next();
            INotification notification = (INotification)holder.getEvent();
            list.add(notification);
        }
        return list.toArray(EMPTY_NOTIFICATION_ARRAY);
    }

    public IAggregateMetricsData getAggregateMetricsData(String collectionID, IMetricIdentity[] metricIDs, Long latestCurrency, Long lookbackPeriod) {
        if (this.m_store == null) {
            return new MetricsData();
        }
        String[] components = this.getComponentNames(collectionID);
        long latest = latestCurrency;
        long earliest = latest - lookbackPeriod;
        Iterator iterator = this.m_store.getMetrics(metricIDs, this.getComponentNames(collectionID), latest, earliest);
        ArrayList list = CollectionsMonitor.addMetrics(iterator);
        IHistoricalMetric[] recordedMetrics = list.toArray(EMPTY_HISTORICAL_METRIC_ARRAY);
        ArrayList<IAggregateMetric> aggregatedMetrics = new ArrayList<IAggregateMetric>();
        HashMap useableMetrics = new HashMap();
        HashSet<String> sources = new HashSet<String>();
        for (int i = 0; i < metricIDs.length; ++i) {
            useableMetrics.clear();
            sources.clear();
            long[] aggregateValues = new long[]{0L, 0L, Long.MIN_VALUE, Long.MAX_VALUE};
            long aggregateCurrency = 0L;
            int contributerCount = 0;
            IMetricIdentity aggregatedID = null;
            for (int j = 0; j < recordedMetrics.length; ++j) {
                String source;
                IMetricIdentity id = recordedMetrics[j].getMetricIdentity();
                if (!id.equals((Object)metricIDs[i]) || sources.contains(source = recordedMetrics[j].getSource())) continue;
                sources.add(source);
                aggregatedID = id;
                long value = recordedMetrics[j].getValue();
                aggregateValues[0] = aggregateValues[0] + value;
                aggregateValues[1] = aggregateValues[1] + value;
                if (aggregateValues[2] < value) {
                    aggregateValues[2] = value;
                }
                if (aggregateValues[3] > value) {
                    aggregateValues[3] = value;
                }
                aggregateCurrency = Math.round(((double)aggregateCurrency * (double)contributerCount + (double)recordedMetrics[j].getCurrencyTimestamp()) / (double)(++contributerCount));
            }
            if (contributerCount == 0) continue;
            aggregateValues[1] = Math.round((double)aggregateValues[1] / (double)contributerCount);
            aggregatedMetrics.add(MetricsFactory.createMetric((String[])sources.toArray(IEmptyArray.EMPTY_STRING_ARRAY), aggregatedID, (long[])aggregateValues, (long)aggregateCurrency));
        }
        IAggregateMetric[] metrics = aggregatedMetrics.toArray(EMPTY_AGGREGATE_METRIC_ARRAY);
        return MetricsFactory.createMetricsData((IAggregateMetric[])metrics, (long)0L);
    }

    public IMonitoredNotifications getStoredNotifications(String[] collectionIDs, Long lastObtainedTimestamp, Long maxLookbackPeriod) {
        if (this.m_store == null) {
            return new MonitoredNotifications();
        }
        long currentTime = System.currentTimeMillis();
        long startTime = this.determineStartTimeForRetrieval(currentTime, lastObtainedTimestamp, maxLookbackPeriod);
        MonitoredNotifications monitoredNotifications = new MonitoredNotifications();
        long deltaTime = currentTime - startTime;
        if (deltaTime <= 0L) {
            monitoredNotifications.setLatestTimestamp(currentTime);
            monitoredNotifications.setMoreDataToRetrieve(false);
            return monitoredNotifications;
        }
        if (collectionIDs == null || collectionIDs.length == 0) {
            monitoredNotifications.setLatestTimestamp(currentTime);
            monitoredNotifications.setMoreDataToRetrieve(false);
            return monitoredNotifications;
        }
        Vector compNamesVec = this.buildComponentVectorFromCollectionIDs(collectionIDs);
        long lastRetrievedTimestamp = currentTime;
        int totalSize = 0;
        boolean additionalDataToReturn = false;
        boolean maxExceeded = false;
        Iterator it = this.m_store.getNotifications(compNamesVec.toArray(IEmptyArray.EMPTY_STRING_ARRAY), currentTime, startTime);
        if (it != null) {
            while (it.hasNext()) {
                IEventHolder holder = (IEventHolder)it.next();
                INotification notification = (INotification)holder.getEvent();
                long timestamp = holder.getStorageTimestamp();
                if (maxExceeded && timestamp > lastRetrievedTimestamp) {
                    additionalDataToReturn = true;
                    break;
                }
                lastRetrievedTimestamp = timestamp;
                monitoredNotifications.addNotification(notification);
                int notificationLength = notification.toString().getBytes().length;
                if ((totalSize += notificationLength) < 0x100000) continue;
                maxExceeded = true;
            }
        }
        monitoredNotifications.setLatestTimestamp(++lastRetrievedTimestamp);
        monitoredNotifications.setMoreDataToRetrieve(additionalDataToReturn);
        return monitoredNotifications;
    }

    public IMonitoredMetrics getStoredMetrics(String[] collectionIDs, Long lastObtainedTimestamp, Long maxLookbackPeriod) {
        if (this.m_store == null) {
            return new MonitoredMetrics();
        }
        long currentTime = System.currentTimeMillis();
        long startTime = this.determineStartTimeForRetrieval(currentTime, lastObtainedTimestamp, maxLookbackPeriod);
        MonitoredMetrics monitoredMetrics = new MonitoredMetrics();
        long deltaTime = currentTime - startTime;
        if (deltaTime <= 0L) {
            monitoredMetrics.setLatestTimestamp(currentTime);
            monitoredMetrics.setMoreDataToRetrieve(false);
            return monitoredMetrics;
        }
        if (collectionIDs == null || collectionIDs.length == 0) {
            monitoredMetrics.setLatestTimestamp(currentTime);
            monitoredMetrics.setMoreDataToRetrieve(false);
            return monitoredMetrics;
        }
        Vector compNamesVec = this.buildComponentVectorFromCollectionIDs(collectionIDs);
        long lastRetrievedTimestamp = currentTime;
        int totalSize = 0;
        boolean additionalDataToReturn = false;
        boolean maxExceeded = false;
        Iterator it = this.m_store.getMetrics(compNamesVec.toArray(IEmptyArray.EMPTY_STRING_ARRAY), currentTime, startTime);
        if (it != null) {
            while (it.hasNext()) {
                IEventHolder holder = (IEventHolder)it.next();
                IHistoricalMetric metric = (IHistoricalMetric)holder.getEvent();
                long timestamp = holder.getStorageTimestamp();
                if (maxExceeded && timestamp > lastRetrievedTimestamp) {
                    additionalDataToReturn = true;
                    break;
                }
                lastRetrievedTimestamp = timestamp;
                monitoredMetrics.addMetric(metric);
                int metricLength = metric.toString().getBytes().length;
                totalSize += metricLength;
                if ((totalSize += metric.getSource().length()) < 0x100000) continue;
                maxExceeded = true;
            }
        }
        monitoredMetrics.setLatestTimestamp(++lastRetrievedTimestamp);
        monitoredMetrics.setMoreDataToRetrieve(additionalDataToReturn);
        return monitoredMetrics;
    }

    public static IMetricInfo[] getMetricsInfo() {
        IMetricInfo[] infos = new IMetricInfo[7];
        boolean INSTANCE = true;
        String extendedData = null;
        boolean DYNAMIC = true;
        boolean LOWALERTS = true;
        boolean HIGHALERTS = true;
        infos[0] = MetricsFactory.createMetricInfo((IMetricIdentity)ICollectionsMonitorProxy.STORAGE_METRICS_STOREDPERMINUTE_METRIC_ID, (short)10, (String)"Number of monitored metric values stored per minute.", extendedData, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"metrics stored per minute");
        infos[1] = MetricsFactory.createMetricInfo((IMetricIdentity)ICollectionsMonitorProxy.STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC_ID, (short)10, (String)"Number of monitored notifications stored per minute.", extendedData, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"notifications stored per minute");
        infos[2] = MetricsFactory.createMetricInfo((IMetricIdentity)ICollectionsMonitorProxy.MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID, (short)5, (String)"Average latency in metrics reporting over collection interval.", extendedData, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"milliseconds");
        infos[3] = MetricsFactory.createMetricInfo((IMetricIdentity)ICollectionsMonitorProxy.MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID, (short)3, (String)"Min latency in metrics reporting over collection interval.", extendedData, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"millisecond");
        infos[4] = MetricsFactory.createMetricInfo((IMetricIdentity)ICollectionsMonitorProxy.MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID, (short)4, (String)"Max latency in metrics reporting over collection interval.", extendedData, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"milliseconds");
        infos[5] = MetricsFactory.createMetricInfo((IMetricIdentity)ICollectionsMonitorProxy.MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID, (short)8, (String)"Metrics per second over collection interval.", extendedData, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"per second");
        infos[6] = MetricsFactory.createMetricInfo((IMetricIdentity)ICollectionsMonitorProxy.MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID, (short)8, (String)"Notifications per second over collection interval.", extendedData, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"per second");
        return infos;
    }

    public IMetricsData getMetricHistory(String collectionID, IMetricIdentity[] metricIDs, Long latest, Long earliest) {
        if (this.m_store == null) {
            return new MetricsData();
        }
        Iterator iterator = this.m_store.getMetrics(metricIDs, this.getComponentNames(collectionID), latest, earliest);
        ArrayList list = CollectionsMonitor.addMetrics(iterator);
        return MetricsFactory.createMetricsData((IMetric[])list.toArray(EMPTY_HISTORICAL_METRIC_ARRAY), (long)0L);
    }

    private static ArrayList addMetrics(Iterator iterator) {
        ArrayList<IHistoricalMetric> list = new ArrayList<IHistoricalMetric>();
        while (iterator.hasNext()) {
            IEventHolder holder = (IEventHolder)iterator.next();
            IHistoricalMetric metric = (IHistoricalMetric)holder.getEvent();
            list.add(metric);
        }
        return list;
    }

    public String[] getMonitoredCollections() {
        String[] monitoredCollections = this.m_collectionMonitors.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        return monitoredCollections;
    }

    public IMetricInfo[] getMonitoredMetricsInfo(String collectionID) {
        CollectionMonitor monitor = (CollectionMonitor)this.m_collectionMonitors.get(collectionID);
        return monitor.getMonitoredMetricsInfo();
    }

    public String[] getInstanceMetricNames(String collectionID, IMetricIdentity id) {
        CollectionMonitor monitor = (CollectionMonitor)this.m_collectionMonitors.get(collectionID);
        return monitor.getInstanceMetricNames(id);
    }

    public MBeanNotificationInfo[] getForwardedNotificationsInfo(String collectionID) {
        CollectionMonitor monitor = (CollectionMonitor)this.m_collectionMonitors.get(collectionID);
        return monitor.getForwardedNotificationsInfo();
    }

    public Integer getHistoryDurationHours() {
        return this.m_historyDurationHours;
    }

    public synchronized void setHistoryDurationHours(Integer hours) {
        if (hours < 0) {
            throw new IllegalArgumentException("History duration (hours) must be >= 0");
        }
        this.m_historyDurationHours = hours;
    }

    private synchronized void setNotificationSubscriptionRenewalInterval(Integer interval) {
        if (interval != null) {
            this.m_notificationManager.setNotificationSubscriptionRenewalInterval(interval.longValue() * 1000L);
        }
    }

    public Boolean getSaveMonitoredNotifications() {
        return new Boolean(this.m_saveMonitoredNotifications);
    }

    public synchronized void setSaveMonitoredNotifications(Boolean save) {
        this.m_saveMonitoredNotifications = save;
    }

    public Boolean getSaveThresholdNotifications() {
        return new Boolean(this.m_saveThresholdNotifications);
    }

    public synchronized void setSaveThresholdNotifications(Boolean save) {
        this.m_saveThresholdNotifications = save;
    }

    public synchronized Long getMaxStorageSize() {
        return new Long(this.m_maxStorageSize);
    }

    public synchronized void setMaxStorageSize(Long maxStorageSize) {
        this.m_maxStorageSize = maxStorageSize;
    }

    public void handleNotification(INotification notification) {
        this.m_notificationManager.handleNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForContainerBoot() {
        IContainer iContainer = this.m_container;
        synchronized (iContainer) {
            try {
                while (!this.m_container.isBooted() && !this.m_container.isClosing()) {
                    this.m_container.wait(1000L);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    private void updateMonitoredCollections() {
        int i;
        IElement cmElement = this.m_context.getConfiguration(true);
        IAttributeSet cmAttributes = cmElement.getAttributes();
        IAttributeList collectionsList = (IAttributeList)cmAttributes.getAttribute("COLLECTIONS");
        Reference[] collectionIDs = collectionsList.getItems().toArray(EMPTY_REFERENCE_ARRAY);
        String[] monitoredCollections = this.m_collectionMonitors.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
        ArrayList<String> deletedCollections = new ArrayList<String>();
        block0: for (int i2 = 0; i2 < monitoredCollections.length; ++i2) {
            for (int j = 0; j < collectionIDs.length; ++j) {
                if (collectionIDs[j].getElementName().equals(monitoredCollections[i2])) continue block0;
            }
            deletedCollections.add(monitoredCollections[i2]);
        }
        ArrayList<String> newCollections = new ArrayList<String>();
        block2: for (i = 0; i < collectionIDs.length; ++i) {
            for (int j = 0; j < monitoredCollections.length; ++j) {
                if (collectionIDs[i].getElementName().equals(monitoredCollections[j])) continue block2;
            }
            newCollections.add(collectionIDs[i].getElementName());
        }
        for (i = deletedCollections.size() - 1; i >= 0; --i) {
            this.removeCollectionMonitor((String)deletedCollections.get(i));
        }
        for (i = newCollections.size() - 1; i >= 0; --i) {
            this.addCollectionMonitor((String)newCollections.get(i));
        }
    }

    private void handleCollectionsMonitorElementChange(IElementChange elementChange) {
        if (elementChange.getChangeType() == 1) {
            IDeltaElement changeElement = (IDeltaElement)elementChange.getElement();
            IDeltaAttributeSet attrs = (IDeltaAttributeSet)changeElement.getDeltaAttributes();
            String[] mods = attrs.getModifiedAttributesNames();
            this.updateRuntimeWithChangedConfig(mods, attrs);
            mods = attrs.getNewAttributesNames();
            this.updateRuntimeWithChangedConfig(mods, attrs);
            mods = attrs.getDeletedAttributesNames();
            this.updateRuntimeWithDeletedConfig(mods);
        }
    }

    private void updateRuntimeWithChangedConfig(String[] attributeNames, IDeltaAttributeSet attrs) {
        try {
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeNames[i].compareTo("HISTORY_DURATION_HOURS") == 0) {
                    this.setHistoryDurationHours((Integer)attrs.getNewValue("HISTORY_DURATION_HOURS"));
                }
                if (attributeNames[i].compareTo("SAVE_MONITORED_NOTIFICATIONS") == 0) {
                    this.setSaveMonitoredNotifications((Boolean)attrs.getNewValue("SAVE_MONITORED_NOTIFICATIONS"));
                }
                if (attributeNames[i].compareTo("SAVE_THRESHOLD_NOTIFICATIONS") == 0) {
                    this.setSaveThresholdNotifications((Boolean)attrs.getNewValue("SAVE_THRESHOLD_NOTIFICATIONS"));
                }
                if (attributeNames[i].compareTo("COLLECTIONS") == 0) {
                    this.updateMonitoredCollections();
                }
                if (!attributeNames[i].equals("NOTIFICATION_SUBSCRIPTION_TIMEOUT")) continue;
                this.setNotificationSubscriptionRenewalInterval((Integer)attrs.getNewValue("NOTIFICATION_SUBSCRIPTION_TIMEOUT"));
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying attributes from configuration change", (Throwable)e, 2);
        }
    }

    private void updateRuntimeWithDeletedConfig(String[] attributeNames) {
        try {
            for (int i = 0; i < attributeNames.length; ++i) {
                if (attributeNames[i].compareTo("HISTORY_DURATION_HOURS") == 0) {
                    this.setHistoryDurationHours(48);
                }
                if (attributeNames[i].compareTo("SAVE_MONITORED_NOTIFICATIONS") == 0) {
                    this.setSaveMonitoredNotifications(true);
                }
                if (attributeNames[i].compareTo("SAVE_THRESHOLD_NOTIFICATIONS") == 0) {
                    this.setSaveThresholdNotifications(true);
                }
                if (attributeNames[i].compareTo("NOTIFICATION_SUBSCRIPTION_TIMEOUT") != 0) continue;
                this.setNotificationSubscriptionRenewalInterval(new Integer(30));
            }
        }
        catch (Exception e) {
            this.m_context.logMessage("Error modifying attributes from configuration change", (Throwable)e, 2);
        }
    }

    private synchronized void addCollectionMonitor(String collectionConfigID) {
        CollectionMonitor collectionMonitor = new CollectionMonitor(collectionConfigID, this.m_frameworkContext, this);
        this.m_collectionMonitors.put(collectionConfigID, collectionMonitor);
    }

    private synchronized void removeCollectionMonitor(String collectionConfigID) {
        CollectionMonitor collectionMonitor = (CollectionMonitor)this.m_collectionMonitors.remove(collectionConfigID);
        collectionMonitor.cleanup();
    }

    private String[] getComponentNames(String collectionID) {
        CollectionMonitor monitor = (CollectionMonitor)this.m_collectionMonitors.get(collectionID);
        if (monitor == null) {
            throw new IllegalArgumentException("Unknown collection: collectionID = " + collectionID);
        }
        return monitor.getCollectionComponents();
    }

    private long determineStartTimeForRetrieval(long endTime, Long lastObtainedTimestamp, Long maxLookbackPeriod) {
        long earliestLookbackTime;
        long lastTimestamp;
        long startTime = endTime;
        startTime = lastObtainedTimestamp != null ? ((lastTimestamp = Math.abs(lastObtainedTimestamp)) < endTime ? (maxLookbackPeriod != null ? (lastTimestamp < (earliestLookbackTime = endTime - Math.abs(maxLookbackPeriod)) ? earliestLookbackTime : lastTimestamp) : lastTimestamp) : this.retrieveStartTime(maxLookbackPeriod, startTime, endTime)) : this.retrieveStartTime(maxLookbackPeriod, startTime, endTime);
        return startTime;
    }

    private long retrieveStartTime(Long maxLookbackPeriod, long startTimeParam, long endTime) {
        long startTime = startTimeParam;
        if (maxLookbackPeriod != null) {
            startTime = endTime - Math.abs(maxLookbackPeriod);
        }
        return startTime;
    }

    private Vector buildComponentVectorFromCollectionIDs(String[] collectionIDs) {
        if (collectionIDs == null) {
            throw new IllegalArgumentException("Illegal input array of collectionIDs: array reference must not be null");
        }
        Vector<String> compNamesVec = new Vector<String>();
        int m = collectionIDs.length;
        for (int i = 0; i < m; ++i) {
            String[] componentNames = null;
            try {
                componentNames = this.getComponentNames(collectionIDs[i]);
                int n = componentNames.length;
                for (int j = 0; j < n; ++j) {
                    if (compNamesVec.contains(componentNames[j])) continue;
                    compNamesVec.add(componentNames[j]);
                }
                continue;
            }
            catch (IllegalArgumentException iae) {
                if (this.m_state != 3) continue;
                this.m_context.logMessage("Unknown component collection encountered: collectionID = " + collectionIDs[i] + " - it will be ignored.", 2);
            }
        }
        return compNamesVec;
    }

    @Override
    public void onMetricStored(IMetric metric) {
        this.updateStatValue(m_metricsStoredPerMinute);
        this.updateCollectorMetrics(metric);
    }

    private void updateCollectorMetrics(IMetric metric) {
        long latency = System.currentTimeMillis() - metric.getCurrencyTimestamp();
        IStatistic stat = m_minMetricLatencyStatistic;
        if (stat != null) {
            stat.updateValue(latency);
        }
        if ((stat = m_maxMetricLatencyStatistic) != null) {
            stat.updateValue(latency);
        }
        if ((stat = m_averageMetricLatencyStatistic) != null) {
            stat.updateValue(latency);
        }
        this.updateStatValue(m_metricsReceivedPerSecond);
    }

    @Override
    public void onNotificationStored(INotification notification) {
        this.updateStatValue(m_notificationsStoredPerMinute);
        this.updateStatValue(m_notificationsReceivedPerSecond);
    }

    private void updateStatValue(IStatistic m_notificationsReceivedPerSecond) {
        IStatistic stat = m_notificationsReceivedPerSecond;
        if (stat != null) {
            stat.updateValue(1L);
        }
    }

    @Override
    public void onMetricsOffloaded(IMetric[] metric) {
        long time = System.currentTimeMillis();
        for (int i = 0; i < metric.length; ++i) {
            this.updateCollectorMetrics(metric[i]);
        }
    }

    @Override
    public void onNotificationOffloaded(INotification notification) {
        this.updateStatValue(m_notificationsReceivedPerSecond);
    }

    public void setEnterpriseStateAccess(IEnterpriseStateAccess s) {
        this.m_enterpriseStateAccessor = s;
    }

    public boolean isEnterprise() {
        return this.m_enterpriseStateAccessor.isEnterprise();
    }

    static {
        STORAGE_NOTIFICATIONS_STOREDPERMINUTE_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"storage", "notifications", "StoredPerMinute"});
        MONITOR_METRICS_AVERAGE_METRICLATENCY_METRIC_ID = MetricsFactory.createMetricIdentity((String[])new String[]{"monitor", "metrics", "AverageMetricLatency"});
        MONITOR_METRICS_MIN_METRICLATENCY_METRIC_ID = MetricsFactory.createMetricIdentity((String[])new String[]{"monitor", "metrics", "MinMetricLatency"});
        MONITOR_METRICS_MAX_METRICLATENCY_METRIC_ID = MetricsFactory.createMetricIdentity((String[])new String[]{"monitor", "metrics", "MaxMetricLatency"});
        MONITOR_METRICS_METRICS_PER_SECOND_METRIC_ID = MetricsFactory.createMetricIdentity((String[])new String[]{"monitor", "metrics", "MetricsPerSecond"});
        MONITOR_NOTIFICATIONS_NOTIFICATIONS_PER_SECOND_METRIC_ID = MetricsFactory.createMetricIdentity((String[])new String[]{"monitor", "notifications", "NotificationsPerSecond"});
        ATTRIBUTE_INFOS = new ArrayList();
        OPERATION_INFOS = new ArrayList();
        NOTIFICATION_INFOS = new ArrayList();
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("HistoryDurationHours", Integer.class.getName(), "Duration (hours) for which historical monitoring data will be held.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("SaveMonitoredNotifications", Boolean.class.getName(), "Flag indicating if a history of monitored notifications should be maintained.", true, true, false));
        ATTRIBUTE_INFOS.add(new MBeanAttributeInfo("SaveThresholdNotifications", Boolean.class.getName(), "Flag indicating if a history of threshold notifications should be maintained.", true, true, false));
        MBeanParameterInfo[] mbParamInfos = null;
        OPERATION_INFOS.add(new MBeanOperationInfo("clearHistory", "Clears all notification/metric history maintained by this monitor.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, Void.class.getName(), 1));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("latest", Long.class.getName(), "The time of the latest threshold notification to be returned."), new MBeanParameterInfo("earliest", Long.class.getName(), "The time of the earliest threshold notification to be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getThresholdNotificationHistory", "Gets recorded notifications for the given collection and notification types, between the given dates. Notifications are returned in date order with most recent first.", mbParamInfos, INotification[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionID", String.class.getName(), "The configuration ID to the monitored collection."), new MBeanParameterInfo("notificationTypes", String[].class.getName(), "The (canonical) notification types of interest."), new MBeanParameterInfo("latest", Long.class.getName(), "The time of the latest monitored notification to be returned."), new MBeanParameterInfo("earliest", Long.class.getName(), "The time of the earliest monitored notification to be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getNotificationHistory", "Gets recorded notifications for the given collection and notification types, between the given dates. Notifications are returned in date order with most recent first.", mbParamInfos, INotification[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionID", String.class.getName(), "The configuration ID to the monitored collection."), new MBeanParameterInfo("metricIDs", IMetricIdentity[].class.getName(), "The metric identities for which aggregate data is sought."), new MBeanParameterInfo("latestCurrency", Long.class.getName(), "The time of the latest metric value to be used to compute the aggregate data.."), new MBeanParameterInfo("lookbackPeriod", Long.class.getName(), "The period to lookback for metric values.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getAggregateMetricsData", "Gets aggregated metrics for a collection, based from recorded metrics of the given time window.", mbParamInfos, IAggregateMetricsData.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionIDs", String[].class.getName(), "The configuration ID(s) of the monitored collection(s)."), new MBeanParameterInfo("lastReceivedTimestamp", Long.class.getName(), "The timestamp of the last retrieved metric, or the timr of the last retrieval attempt."), new MBeanParameterInfo("lookbackPeriod", Long.class.getName(), "The period to look back for metric values.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getStoredMetrics", "Returns an instance of IMonitoredMetrics containing copies of the stored metrics for the specified component collection(s), for the given time window, up to a total size of approximately 1Mb, and a flag to indicate if there are more metrics to be retrieved.", mbParamInfos, IMonitoredMetrics.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionIDs", String[].class.getName(), "The configuration ID(s) of the monitored collection(s)."), new MBeanParameterInfo("lastReceivedTimestamp", Long.class.getName(), "The timestamp of the last retrieved notification, or the time of the last retrieval attempt."), new MBeanParameterInfo("lookbackPeriod", Long.class.getName(), "The period to look back for notification values.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getStoredNotifications", "Returns an instance of IMonitoredNotifications containing copies of the stored notifications for a collection, for the given time window, up to a total size of approximately 1Mb, and a flag to indicate if there are more notifications to be retrieved.", mbParamInfos, IMonitoredNotifications.class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionID", String.class.getName(), "The configuration ID to the monitored collection."), new MBeanParameterInfo("metricIDs", IMetricIdentity[].class.getName(), "The metric identities of interest."), new MBeanParameterInfo("latest", Long.class.getName(), "The time of the latest monitored metric value to be returned."), new MBeanParameterInfo("earliest", Long.class.getName(), "The time of the earliest monitored metric value to be returned.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getMetricHistory", "Gets recorded metrics for the given collection and metrics, between the given dates. Metrics are returned in date order with most recent first.", mbParamInfos, IMetricsData.class.getName(), 0));
        OPERATION_INFOS.add(new MBeanOperationInfo("getMonitoredCollections", "Gets the list of collections being monitored by this monitor.", IEmptyArray.EMPTY_PARAMETER_INFO_ARRAY, String[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionID", String.class.getName(), "The configuration ID to the monitored collection.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getForwardedNotificationsInfo", "Gets the meta-data for the notifications being forwarded by this monitor.", mbParamInfos, MBeanNotificationInfo[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionID", String.class.getName(), "The configuration ID to the monitored collection.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getMonitoredMetricsInfo", "Gets the meta-data for the metrics being forwarded by this monitor.", mbParamInfos, IMetricInfo[].class.getName(), 0));
        mbParamInfos = new MBeanParameterInfo[]{new MBeanParameterInfo("collectionID", String.class.getName(), "The configuration ID to the monitored collection."), new MBeanParameterInfo("id", IMetricIdentity.class.getName(), "The metric identity for which instance names are sought.")};
        OPERATION_INFOS.add(new MBeanOperationInfo("getInstanceMetricNames", "Gets the instance metric names for a monitored metric of a specified collection.", mbParamInfos, String[].class.getName(), 0));
        String[] notifTypes = null;
        notifTypes = new String[]{INotification.CATEGORY_TEXT[0], INotification.SUBCATEGORY_TEXT[2], THRESHOLD_NOTIFICATION_TYPE};
        NOTIFICATION_INFOS.add(new MBeanNotificationInfo(notifTypes, "com.sonicsw.mf.jmx.client.MFNotification", "Sent when a notification monitoring threshold has been broken."));
    }

    private class SdfMFTracingIntegration
    extends AbstractMFComponentTracing {
        private boolean m_updateTraceLevelWasCalled;

        SdfMFTracingIntegration() {
            super("sonic.mf.monitor." + CollectionsMonitor.this.m_context.getComponentName().getComponentName().replace(' ', '_'), CollectionsMonitor.this.getTraceMaskValues());
            this.m_updateTraceLevelWasCalled = false;
            this.setTraceMask();
        }

        private void setTraceMask() {
            this.setTraceMask(new Integer(CollectionsMonitor.this.m_traceMask));
        }

        boolean wasUpdated() {
            return this.m_updateTraceLevelWasCalled;
        }

        public void updateTraceLevel(String doiIDNotUsed, HashMap parameters, StringBuffer buffer) {
            super.updateTraceLevel(doiIDNotUsed, parameters, buffer);
            this.m_updateTraceLevelWasCalled = true;
            CollectionsMonitor.this.setTraceMask(this.getCurrentMask(), true);
        }
    }
}

