/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.monitor.storage.fs;

import com.odi.Database;
import com.odi.DatabaseNotFoundException;
import com.odi.DatabaseNotOpenException;
import com.odi.DatabaseRootNotFoundException;
import com.odi.NoTransactionInProgressException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreConstants;
import com.odi.Placement;
import com.odi.Session;
import com.odi.Transaction;
import com.odi.util.DuplicateIndexException;
import com.odi.util.IndexedCollection;
import com.odi.util.OSTreeSet;
import com.odi.util.query.Query;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.framework.monitor.IHistoryStorageListener;
import com.sonicsw.mf.framework.monitor.storage.EventHolder;
import com.sonicsw.mf.framework.monitor.storage.IHistoryStorage;
import com.sonicsw.mf.framework.monitor.storage.StorageException;
import com.sonicsw.mf.framework.monitor.storage.fs.PSEMetric;
import com.sonicsw.mf.framework.monitor.storage.fs.PSENotification;
import com.sonicsw.mf.framework.monitor.storage.fs.PSEObject;
import com.sonicsw.mx.util.FIFO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public final class FSStorage
implements IHistoryStorage {
    public static final long DEFAULT_EXPIRE_AFTER = 172800000L;
    public static final long MIN_EXPIRE_AFTER = 3600000L;
    private static final int EXPIRE_BATCH_SIZE = 1000;
    public static final long BYTES_PER_MEGABYTE = 0x100000L;
    private static final String NOTIFICATIONS = "Notifications";
    private static final String METRICS = "Metrics";
    private static final String NOTIFICATIONS_AND_METRICS_A = "NotificationsAndMetricsA";
    private static final String NOTIFICATIONS_AND_METRICS_B = "NotificationsAndMetricsB";
    private long m_expireAfter = 172800000L;
    public static final int MAX_COMPONENTS_PER_QUERY = Integer.getInteger("sonicsw.mf.monitor.componentsPerQuery", 600);
    private IComponentContext m_context;
    private File m_directory;
    private Thread m_writerThread;
    private Thread m_expirerThread;
    private long m_maxStorageSize;
    private boolean m_isClosing = false;
    private boolean m_needToRecreateStorage = false;
    private Object m_expirerThreadLockObj = new Object();
    private Object m_writerThreadLockObj = new Object();
    private Store[] m_stores = new Store[2];
    private static final int MAX_SIZE = 250;
    private HashSet[] m_metricsRecentlyStored = new HashSet[]{new HashSet(250), new HashSet(250)};
    private FIFO m_metricsToBeStored = new FIFO();
    private FIFO m_notificationsToBeStored = new FIFO();
    private static ClassLoader m_ctxClassLoader = FSStorage.class.getClassLoader();
    private static int m_traceMask;
    private IHistoryStorageListener m_historyStorageListener;

    public FSStorage(String rootDirectory, String instanceName, IComponentContext context) throws StorageException {
        this.m_context = context;
        ICanonicalName name = context.getComponentName();
        this.m_directory = new File(rootDirectory + File.separatorChar + name.getDomainName() + '.' + name.getContainerName() + '.' + name.getComponentName());
        if (this.m_directory.exists()) {
            if (!this.m_directory.isDirectory()) {
                throw new StorageException("Failed storage initialization: bad storage directory [" + this.m_directory.getPath() + ']');
            }
        } else if (!this.m_directory.mkdirs()) {
            throw new StorageException("Failed storage initialization: unable to create storage directory [" + this.m_directory.getPath() + ']');
        }
        this.m_stores[0] = new Store();
        this.m_stores[1] = new Store();
    }

    @Override
    public void open() throws StorageException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        this.m_isClosing = false;
        try {
            Thread.currentThread().setContextClassLoader(m_ctxClassLoader);
            this.m_stores[0].setDbName(NOTIFICATIONS_AND_METRICS_A);
            this.m_stores[1].setDbName(NOTIFICATIONS_AND_METRICS_B);
            this.m_stores[0].open();
            this.m_writerThread = new Writer();
            this.m_expirerThread = new Expirer();
            this.m_writerThread.start();
            this.m_expirerThread.start();
        }
        catch (Throwable e) {
            this.cleanup();
            throw new StorageException("Failed to open storage.", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxClassLoader);
        }
    }

    @Override
    public synchronized void close() throws StorageException {
        this.cleanup();
    }

    @Override
    public synchronized void setExpireAfter(long expireAfter) {
        if (expireAfter < 3600000L) {
            throw new IllegalArgumentException("Can use expiration > 3600000 milliseconds");
        }
        this.m_expireAfter = expireAfter;
    }

    @Override
    public synchronized long getExpireAfter() {
        return this.m_expireAfter;
    }

    @Override
    public void setMaxStorageSize(long maxStorageSize) {
        this.m_maxStorageSize = maxStorageSize > 0x7FFFFFFFFFFL ? Long.MAX_VALUE : maxStorageSize * 0x100000L;
    }

    @Override
    public long getMaxStorageSize() {
        return this.m_maxStorageSize / 0x100000L;
    }

    @Override
    public void clear() throws StorageException {
        if (this.m_stores != null) {
            this.clearPSEObjects(NOTIFICATIONS);
            this.clearPSEObjects(METRICS);
        }
    }

    public void finalize() {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeNotification(INotification notification) throws StorageException {
        Object object = this.m_writerThreadLockObj;
        synchronized (object) {
            this.m_writerThreadLockObj.notifyAll();
        }
        object = this.m_notificationsToBeStored;
        synchronized (object) {
            try {
                this.m_notificationsToBeStored.add((Object)new PSENotification(notification));
            }
            catch (Exception e) {
                throw new StorageException("Failed to store notification: " + notification.getType(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMetrics(IMetric[] metrics, String source) throws StorageException {
        Object object = this.m_writerThreadLockObj;
        synchronized (object) {
            this.m_writerThreadLockObj.notifyAll();
        }
        object = this.m_metricsToBeStored;
        synchronized (object) {
            for (int i = 0; i < metrics.length; ++i) {
                try {
                    this.m_metricsToBeStored.add((Object)new PSEMetric(metrics[i], source));
                    continue;
                }
                catch (Exception e) {
                    throw new StorageException("Failed to store metric: " + metrics[i].getMetricIdentity().getName(), e);
                }
            }
        }
    }

    @Override
    public Iterator getNotifications(String[] notificationTypes, String[] notificationSources, long latest, long earliest) throws StorageException {
        StringBuffer expression = FSStorage.buildBaseExpression(earliest, latest);
        for (int i = 0; i < notificationTypes.length; ++i) {
            FSStorage.appendDoublePipes(expression, i);
            expression.append("getType().equals(\"").append(notificationTypes[i]).append("\")");
        }
        expression.append(')');
        return this.aggregateQuerySources(PSENotification.class, expression.toString(), notificationSources, NOTIFICATIONS);
    }

    @Override
    public Iterator getNotifications(String[] notificationSources, long latest, long earliest) throws StorageException {
        StringBuffer expression = FSStorage.buildBaseExpressionStorage(earliest, latest);
        return this.aggregateQuerySources(PSENotification.class, expression.toString(), notificationSources, NOTIFICATIONS);
    }

    @Override
    public Iterator getMetrics(IMetricIdentity[] metricIDs, String[] componentIdentities, long latest, long earliest) throws StorageException {
        StringBuffer expression = FSStorage.buildBaseExpression(earliest, latest);
        for (int i = 0; i < metricIDs.length; ++i) {
            FSStorage.appendDoublePipes(expression, i);
            expression.append("getName().equals(\"").append(metricIDs[i].getName()).append("\")");
        }
        expression.append(')');
        return this.aggregateQuerySources(PSEMetric.class, expression.toString(), componentIdentities, METRICS);
    }

    private static StringBuffer buildBaseExpression(long earliest, long latest) {
        StringBuffer expression = new StringBuffer();
        expression.append("getTimestamp()<=").append(0L - earliest).append('L');
        expression.append("&&");
        expression.append("getTimestamp()>=").append(0L - latest).append('L');
        expression.append("&&(");
        return expression;
    }

    @Override
    public Iterator getMetrics(String[] componentIdentities, long latest, long earliest) throws StorageException {
        StringBuffer expression = FSStorage.buildBaseExpressionStorage(earliest, latest);
        return this.aggregateQuerySources(PSEMetric.class, expression.toString(), componentIdentities, METRICS);
    }

    private static StringBuffer buildBaseExpressionStorage(long earliest, long latest) {
        StringBuffer expression = new StringBuffer();
        expression.append("getStorageTimestamp()>=").append(earliest).append('L');
        expression.append("&&");
        expression.append("getStorageTimestamp()<=").append(latest).append('L');
        return expression;
    }

    private Iterator aggregateQuerySources(Class storageClass, String baseExpression, String[] sources, String type) {
        ArrayList result = new ArrayList();
        int idx = 0;
        while (idx < sources.length) {
            StringBuffer expression = new StringBuffer(baseExpression);
            expression.append("&&(");
            for (int i = 0; i < MAX_COMPONENTS_PER_QUERY && idx < sources.length; ++idx, ++i) {
                FSStorage.appendDoublePipes(expression, i);
                expression.append("getSource().equals(\"").append(sources[idx]).append("\")");
            }
            expression.append(')');
            List partResult = this.getPSEObjects(storageClass, expression.toString(), type);
            result.addAll(partResult);
        }
        return result.iterator();
    }

    private static void appendDoublePipes(StringBuffer expression, int i) {
        if (i > 0) {
            expression.append("||");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void cleanup() {
        Store[] storeArray;
        this.m_isClosing = true;
        if (this.m_expirerThread != null) {
            storeArray = this.m_expirerThreadLockObj;
            // MONITORENTER : this.m_expirerThreadLockObj
            this.m_expirerThreadLockObj.notifyAll();
            // MONITOREXIT : storeArray
        }
        if (this.m_writerThread != null) {
            storeArray = this.m_writerThreadLockObj;
            // MONITORENTER : storeArray
            this.m_writerThreadLockObj.notifyAll();
            // MONITOREXIT : storeArray
        }
        storeArray = this.m_stores;
        // MONITORENTER : this.m_stores
        int index = 0;
        while (true) {
            if (index >= 2) {
                // MONITOREXIT : storeArray
                return;
            }
            this.m_stores[index].close();
            ++index;
        }
    }

    private void expireData() throws Exception {
        long olderThan = System.currentTimeMillis() - this.m_expireAfter;
        Query query = null;
        StringBuffer expression = new StringBuffer();
        expression.append("getTimestamp()>").append(0L - olderThan).append('L');
        query = new Query(PSENotification.class, expression.toString());
        if (this.m_stores != null) {
            this.expirePSEObjects(query, NOTIFICATIONS);
        }
        query = new Query(PSEMetric.class, expression.toString());
        if (this.m_stores != null) {
            this.expirePSEObjects(query, METRICS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expirePSEObjects(Query query, String type) {
        long elapsedTime = System.currentTimeMillis();
        Store[] storeArray = this.m_stores;
        synchronized (this.m_stores) {
            if (this.m_isClosing) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(m_ctxClassLoader);
            }
            catch (Exception e) {
                throw new StorageException("Failed to expire/clear history", e);
            }
            for (int index = 0; index < 2; ++index) {
                if (this.m_stores[index] == null || this.m_stores[index].m_session == null) continue;
                try {
                    int count;
                    this.m_stores[index].m_session.join();
                    Transaction txn = null;
                    try {
                        txn = this.m_stores[index].m_session.currentTransaction();
                    }
                    catch (NoTransactionInProgressException e) {
                        txn = Transaction.begin((int)7);
                    }
                    Set set = (Set)this.m_stores[index].m_database.getRoot(type);
                    do {
                        Iterator iterator = query.iterator((Collection)set);
                        Object[] objsToBeExpired = new Object[1000];
                        for (count = 0; iterator.hasNext() && count < 1000; ++count) {
                            objsToBeExpired[count] = iterator.next();
                        }
                        for (int i = 0; i < count; ++i) {
                            set.remove(objsToBeExpired[i]);
                            ObjectStore.destroy((Object)objsToBeExpired[i]);
                            objsToBeExpired[i] = null;
                        }
                    } while (count >= 1000);
                    txn.commit();
                    Transaction.begin((int)7);
                    Session.leave();
                    continue;
                }
                catch (Exception e) {
                    this.leaveSession(ctxClassLoader);
                    throw new StorageException("Failed to expire/clear history", e);
                }
            }
            try {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
            catch (Exception e) {
                throw new StorageException("Failed to expire/clear history", e);
            }
            if ((m_traceMask & 0x400) > 0) {
                StringBuffer traceMessage = new StringBuffer("Storage expire: ");
                traceMessage.append("duration (millis)=").append(System.currentTimeMillis() - elapsedTime);
                traceMessage.append(", type=").append(type);
                this.m_context.logMessage(traceMessage.toString(), 7);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPSEObjects(String type) {
        Store[] storeArray = this.m_stores;
        synchronized (this.m_stores) {
            if (this.m_isClosing) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(m_ctxClassLoader);
            }
            catch (Exception e) {
                throw new StorageException("Failed to expire/clear history", e);
            }
            for (int index = 0; index < 2; ++index) {
                if (this.m_stores[index] == null || this.m_stores[index].m_session == null) continue;
                Store store = this.m_stores[index];
                try {
                    store.m_session.join();
                    Transaction txn = null;
                    txn = FSStorage.retrieveTransaction(store);
                    Set set = null;
                    set = type.equals(NOTIFICATIONS) ? store.m_notifications : store.m_metrics;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        ObjectStore.destroy(iterator.next());
                    }
                    set.clear();
                    txn.commit();
                    Transaction.begin((int)7);
                    Session.leave();
                    continue;
                }
                catch (Exception e) {
                    this.leaveSession(ctxClassLoader);
                    throw new StorageException("Failed to clear history", e);
                }
            }
            try {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
            catch (Exception e) {
                throw new StorageException("Failed to expire/clear history", e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeQueuedObjects() throws StorageException {
        int metricsToBeStored = 0;
        int metricsStored = 0;
        int notificationsToBeStored = 0;
        int notificationsStored = 0;
        long elapsedTime = 0L;
        Store[] storeArray = this.m_stores;
        synchronized (this.m_stores) {
            if (this.m_isClosing) {
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return;
            }
            if (this.m_stores[0].m_database.getSizeInBytes() >= this.m_maxStorageSize) {
                this.swapStores();
            }
            Store store = this.m_stores[0];
            FIFO fIFO = this.m_metricsToBeStored;
            synchronized (fIFO) {
                metricsToBeStored = this.m_metricsToBeStored.size();
            }
            fIFO = this.m_notificationsToBeStored;
            synchronized (fIFO) {
                notificationsToBeStored = this.m_notificationsToBeStored.size();
            }
            if (metricsToBeStored == 0 && notificationsToBeStored == 0) {
                // ** MonitorExit[var7_6] (shouldn't be in output)
                return;
            }
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(m_ctxClassLoader);
                Transaction txn = null;
                elapsedTime = System.currentTimeMillis();
                store.m_session.join();
                txn = FSStorage.retrieveTransaction(store);
                Set set = null;
                FIFO fIFO2 = this.m_metricsToBeStored;
                synchronized (fIFO2) {
                    metricsToBeStored = this.m_metricsToBeStored.size();
                    if (metricsToBeStored > 0) {
                        set = (Set)store.m_database.getRoot(METRICS);
                        for (PSEMetric pseMetric : this.m_metricsToBeStored) {
                            String pseMetricID = pseMetric.getTimestamp() + pseMetric.getName() + pseMetric.getSource();
                            if (this.m_metricsRecentlyStored[0].contains(pseMetricID) || this.m_metricsRecentlyStored[1].contains(pseMetricID)) continue;
                            if (this.m_metricsRecentlyStored[0].size() >= 250) {
                                HashSet hashSet = this.m_metricsRecentlyStored[1];
                                this.m_metricsRecentlyStored[1] = this.m_metricsRecentlyStored[0];
                                this.m_metricsRecentlyStored[0] = hashSet;
                                this.m_metricsRecentlyStored[0].clear();
                            }
                            if (pseMetric != null && pseMetric.getName() != null && pseMetric.getName().length() > 256) {
                                String traceMessage = " Cannot Monitor Metric : The max encoded key length is 256, provided encoded key length is " + pseMetric.getName().length() + " (key =" + pseMetric.getName() + ")";
                                this.m_context.logMessage(traceMessage.toString(), 2);
                                continue;
                            }
                            this.m_metricsRecentlyStored[0].add(pseMetricID);
                            set.add(pseMetric);
                            if (this.m_historyStorageListener != null) {
                                this.m_historyStorageListener.onMetricStored(pseMetric.getMetric());
                            }
                            ++metricsStored;
                        }
                        this.m_metricsToBeStored.clear();
                    }
                }
                fIFO2 = this.m_notificationsToBeStored;
                synchronized (fIFO2) {
                    notificationsToBeStored = this.m_notificationsToBeStored.size();
                    if (notificationsToBeStored > 0) {
                        set = (Set)store.m_database.getRoot(NOTIFICATIONS);
                        for (PSENotification notification : this.m_notificationsToBeStored) {
                            set.add(notification);
                            if (this.m_historyStorageListener != null) {
                                this.m_historyStorageListener.onNotificationStored(notification.getNotification());
                            }
                            ++notificationsStored;
                        }
                        this.m_notificationsToBeStored.clear();
                    }
                }
                txn.commit(2);
                elapsedTime = System.currentTimeMillis() - elapsedTime;
                if ((metricsToBeStored > 0 || notificationsToBeStored > 0) && (m_traceMask & 0x400) > 0) {
                    StringBuffer traceMessage = new StringBuffer("Storage write: ");
                    traceMessage.append("duration (millis)=").append(elapsedTime);
                    if (metricsToBeStored > 0) {
                        traceMessage.append(", metrics to be stored=").append(metricsToBeStored).append(", metrics actually stored=").append(metricsStored);
                    }
                    if (notificationsToBeStored > 0) {
                        traceMessage.append(", notifications to be stored=").append(notificationsToBeStored).append(", notifications actually stored=").append(notificationsStored);
                    }
                    this.m_context.logMessage(traceMessage.toString(), 7);
                }
                Transaction.begin((int)7);
                this.m_needToRecreateStorage = false;
            }
            catch (Exception e) {
                throw new StorageException("Failed to store history", e);
            }
            finally {
                this.leaveSession(ctxClassLoader);
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return;
        }
    }

    private static Transaction retrieveTransaction(Store store) {
        Transaction txn = null;
        try {
            txn = store.m_session.currentTransaction();
        }
        catch (NoTransactionInProgressException e) {
            txn = Transaction.begin((int)7);
        }
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getPSEObjects(Class storageClass, String expression, String type) {
        Query query = new Query(storageClass, expression);
        ArrayList<EventHolder> results = new ArrayList<EventHolder>();
        Set set = null;
        long elapsedTime = System.currentTimeMillis();
        Store[] storeArray = this.m_stores;
        synchronized (this.m_stores) {
            if (this.m_isClosing) {
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return null;
            }
            ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(m_ctxClassLoader);
            }
            catch (Exception e) {
                throw new StorageException("Failed to retrieve history: " + expression.toString(), e);
            }
            for (int index = 0; index < 2; ++index) {
                if (this.m_stores[index] == null || this.m_stores[index].m_session == null) continue;
                Store store = this.m_stores[index];
                try {
                    store.m_session.join();
                    set = (Set)store.m_database.getRoot(type);
                    Iterator iterator = query.iterator((Collection)set);
                    while (iterator.hasNext()) {
                        PSEObject obj = (PSEObject)iterator.next();
                        EventHolder holder = new EventHolder(obj.getObject(), obj.getStorageTimestamp());
                        results.add(holder);
                    }
                    Session.leave();
                    continue;
                }
                catch (Exception e) {
                    this.leaveSession(ctxClassLoader);
                    throw new StorageException("Failed to retrieve history: " + expression.toString(), e);
                }
            }
            try {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
            catch (Exception e) {
                throw new StorageException("Failed to retrieve history: " + expression.toString(), e);
            }
            if ((m_traceMask & 0x400) > 0) {
                StringBuffer traceMessage = new StringBuffer("Storage read: ");
                traceMessage.append("duration (millis)=").append(System.currentTimeMillis() - elapsedTime);
                traceMessage.append(", type=").append(type);
                traceMessage.append(", query expression='").append(expression).append("'");
                this.m_context.logMessage(traceMessage.toString(), 7);
            }
            return results;
        }
    }

    private void leaveSession(ClassLoader ctxClassLoader) {
        Session.leave();
        Thread.currentThread().setContextClassLoader(ctxClassLoader);
        this.m_stores.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapStores() throws StorageException {
        long elapsedTime = System.currentTimeMillis();
        Store[] storeArray = this.m_stores;
        synchronized (this.m_stores) {
            Store temp = null;
            temp = this.m_stores[0];
            this.m_stores[0] = this.m_stores[1];
            this.m_stores[1] = temp;
            this.m_stores[0].close();
            this.m_stores[0].removeDbFile();
            try {
                this.m_stores[0].open();
            }
            catch (Throwable e) {
                this.cleanup();
                throw new StorageException("Failed to open storage.", e);
            }
            if ((m_traceMask & 0x400) > 0) {
                StringBuffer traceMessage = new StringBuffer("Storage swap: ");
                traceMessage.append("duration (millis)=").append(System.currentTimeMillis() - elapsedTime);
                this.m_context.logMessage(traceMessage.toString(), 7);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueues() {
        FIFO fIFO = this.m_notificationsToBeStored;
        synchronized (fIFO) {
            this.m_notificationsToBeStored.clear();
        }
        fIFO = this.m_metricsToBeStored;
        synchronized (fIFO) {
            this.m_metricsToBeStored.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverActiveStore() throws StorageException {
        this.clearQueues();
        Store[] storeArray = this.m_stores;
        synchronized (this.m_stores) {
            if (this.m_needToRecreateStorage || !this.reopenActiveStore()) {
                this.recreateActiveStore();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void recreateActiveStore() throws StorageException {
        this.m_stores[0].forceClose();
        this.m_stores[0].removeDbFile();
        try {
            this.m_stores[0].open();
            this.m_context.logMessage("Recreated storage", 3);
        }
        catch (Throwable e) {
            this.cleanup();
            throw new StorageException("recreateActiveStore: Failed to recreate storage.", e);
        }
    }

    private boolean reopenActiveStore() {
        this.m_stores[0].forceClose();
        try {
            this.m_stores[0].open();
            this.m_needToRecreateStorage = true;
            this.m_context.logMessage("Recovered and reopened storage", 3);
            return true;
        }
        catch (Throwable e) {
            this.m_context.logMessage("recoverActiveStore: Failed to recover storage", e, 2);
            return false;
        }
    }

    static byte[] toBytes(Serializable object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(object);
        return baos.toByteArray();
    }

    static Object fromBytes(byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    public static void setTraceMask(Integer traceMask) {
        m_traceMask = traceMask;
    }

    @Override
    public void setHistoryStorageListener(IHistoryStorageListener listener) {
        this.m_historyStorageListener = listener;
    }

    private class Store
    implements ObjectStoreConstants {
        Session m_session;
        Database m_database;
        String m_dbFileName;
        Set m_notifications;
        Set m_metrics;

        private Store() {
        }

        void setDbName(String dbFileName) {
            this.m_dbFileName = dbFileName;
        }

        void removeDbFile() {
            File logFile;
            File dbFile = new File(FSStorage.this.m_directory, this.m_dbFileName + ".odb");
            if (dbFile.exists()) {
                if (dbFile.isDirectory()) {
                    this.removePSE2Storage(dbFile);
                    return;
                }
                if (!dbFile.delete()) {
                    throw new StorageException("Failed to remove database file: " + this.m_dbFileName + ".odb");
                }
            }
            if ((logFile = new File(FSStorage.this.m_directory, this.m_dbFileName + ".log")).exists() && !logFile.delete()) {
                throw new StorageException("Failed to remove log file: " + this.m_dbFileName + ".log");
            }
        }

        void setupIndexedCollection(Database database, Class storageClass, String[] indexMemberNames, String rootName) throws IOException {
            IndexedCollection indexedCollection = null;
            try {
                indexedCollection = (IndexedCollection)database.getRoot(rootName);
                return;
            }
            catch (DatabaseRootNotFoundException databaseRootNotFoundException) {
                indexedCollection = new OSTreeSet((Placement)database);
                database.createRoot(rootName, (Object)indexedCollection);
                for (int i = 0; i < indexMemberNames.length; ++i) {
                    try {
                        indexedCollection.addIndex(storageClass, indexMemberNames[i], i == 0, true);
                        continue;
                    }
                    catch (DuplicateIndexException duplicateIndexException) {
                        // empty catch block
                    }
                }
                return;
            }
        }

        void open() {
            Properties props = new Properties();
            props.setProperty("com.odi.stringPoolSize", "0");
            this.m_session = Session.create(null, (Properties)props);
            try {
                Session.leave();
                this.m_session.join();
                Transaction.setDefaultRetain((int)2);
                File dbFile = new File(FSStorage.this.m_directory, this.m_dbFileName + ".odb");
                if (dbFile.exists() && !dbFile.isDirectory()) {
                    throw new StorageException(FSStorage.this.m_directory.getCanonicalPath() + " is obsolete. It must be removed before the Collection Monitored is started");
                }
                try {
                    this.m_database = Database.open((String)dbFile.getCanonicalPath(), (int)7);
                }
                catch (DatabaseNotFoundException e) {
                    this.m_database = Database.create((String)dbFile.getCanonicalPath(), (int)438);
                }
                Transaction.begin((int)7);
                this.setupIndexedCollection(this.m_database, PSENotification.class, new String[]{"getTimestamp()", "getStorageTimestamp()", "getType()", "getSource()"}, FSStorage.NOTIFICATIONS);
                this.m_notifications = (Set)this.m_database.getRoot(FSStorage.NOTIFICATIONS);
                try {
                    this.m_session.currentTransaction().commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Transaction.begin((int)7);
                this.setupIndexedCollection(this.m_database, PSEMetric.class, new String[]{"getTimestamp()", "getStorageTimestamp()", "getName()", "getSource()"}, FSStorage.METRICS);
                this.m_metrics = (Set)this.m_database.getRoot(FSStorage.METRICS);
                try {
                    this.m_session.currentTransaction().commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Transaction.begin((int)7);
            }
            catch (StorageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new StorageException("Failed storage initialization: unable to open store", e);
            }
            finally {
                Session.leave();
            }
        }

        void close() {
            if (this.m_session != null) {
                try {
                    Session.leave();
                    this.m_session.join();
                    try {
                        Transaction txn = this.m_session.currentTransaction();
                        txn.commit();
                    }
                    catch (NoTransactionInProgressException noTransactionInProgressException) {
                        // empty catch block
                    }
                    try {
                        this.closeMDatabase();
                    }
                    catch (DatabaseNotOpenException databaseNotOpenException) {
                        // empty catch block
                    }
                }
                finally {
                    this.resetLocalFields();
                }
            }
        }

        void forceClose() {
            if (this.m_session != null) {
                try {
                    Session.leave();
                    try {
                        this.m_session.join();
                        Transaction txn = this.m_session.currentTransaction();
                        txn.commit();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        this.closeMDatabase();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                finally {
                    this.resetLocalFields();
                }
            }
        }

        private void resetLocalFields() {
            Session.leave();
            this.m_session.terminate();
            this.m_session = null;
            this.m_database = null;
            this.m_notifications = null;
            this.m_metrics = null;
        }

        private void closeMDatabase() {
            if (this.m_database != null) {
                this.m_database.close();
            }
        }

        private void removePSE2Storage(File dir) {
            String[] fileList = dir.list();
            for (int i = 0; i < fileList.length; ++i) {
                File crntFile = new File(dir, fileList[i]);
                if (crntFile.isDirectory()) {
                    this.removePSE2Storage(crntFile);
                    continue;
                }
                if (crntFile.delete()) continue;
                throw new StorageException("Could not delete  the database file: " + crntFile.getAbsolutePath());
            }
            if (!dir.delete()) {
                throw new StorageException("Could not delete the database directory  " + dir.getAbsolutePath());
            }
        }
    }

    private class Writer
    extends Thread {
        private static final long WRITER_BATCHING_PERIOD = 1000L;

        private Writer() {
            super("CollectionsMonitor Storage Writer");
            super.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!FSStorage.this.m_isClosing) {
                Object object = FSStorage.this.m_writerThreadLockObj;
                synchronized (object) {
                    try {
                        FSStorage.this.m_writerThreadLockObj.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (FSStorage.this.m_isClosing) {
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (FSStorage.this.m_isClosing) {
                    return;
                }
                try {
                    FSStorage.this.writeQueuedObjects();
                }
                catch (Exception e) {
                    FSStorage.this.m_context.logMessage("Failed to write history to storage", (Throwable)e, 2);
                    try {
                        FSStorage.this.recoverActiveStore();
                    }
                    catch (StorageException se) {
                        FSStorage.this.m_context.logMessage("Failed to recover storage", (Throwable)se, 1);
                        throw se;
                    }
                }
            }
            return;
        }
    }

    private class Expirer
    extends Thread {
        private static final long EXPIRATION_PERIOD = 30000L;

        private Expirer() {
            super("CollectionsMonitor Storage Expirer");
            super.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!FSStorage.this.m_isClosing) {
                Object object = FSStorage.this.m_expirerThreadLockObj;
                synchronized (object) {
                    try {
                        FSStorage.this.m_expirerThreadLockObj.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (FSStorage.this.m_isClosing) {
                    return;
                }
                try {
                    FSStorage.this.expireData();
                    FSStorage.this.m_needToRecreateStorage = false;
                    continue;
                }
                catch (Exception e) {
                    FSStorage.this.m_context.logMessage("Failed to delete expired history", (Throwable)e, 2);
                    try {
                        FSStorage.this.recoverActiveStore();
                        continue;
                    }
                    catch (StorageException se) {
                        FSStorage.this.m_context.logMessage("Failed to recover storage", (Throwable)se, 1);
                        continue;
                    }
                }
                break;
            }
            return;
        }
    }
}

