/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.monitor.storage.fs;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.util.HashPersistent;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.framework.monitor.storage.fs.FSStorage;
import com.sonicsw.mf.framework.monitor.storage.fs.PSEObject;
import java.io.Serializable;

public class PSEMetric
implements IPersistent,
IPersistentHooks,
PSEObject {
    private int ODITheHashCode = HashPersistent.getNextHashCode();
    private transient ObjectReference ODIref;
    public transient byte ODIObjectState;
    private transient IMetric m_metric;
    static ClassInfo myOdiClassInfoInstance = PSEMetric.getClassInfoInstance();
    private long m_timestamp;
    private long m_storageTimestamp;
    private String m_name;
    private String m_source;
    private byte[] m_bytes;

    PSEMetric(IMetric metric, String source) throws Exception {
        this.m_timestamp = 0L - metric.getCurrencyTimestamp();
        this.m_storageTimestamp = System.currentTimeMillis();
        this.m_name = new String(metric.getMetricIdentity().getName());
        this.m_source = new String(source);
        this.m_bytes = FSStorage.toBytes((Serializable)MetricsFactory.createMetric((String)source, (IMetric)metric));
        this.m_metric = metric;
    }

    @Override
    public long getTimestamp() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.m_timestamp;
    }

    @Override
    public long getStorageTimestamp() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.m_storageTimestamp;
    }

    public String getName() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.m_name;
    }

    public String getSource() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.m_source;
    }

    @Override
    public Object getObject() throws Exception {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_bytes != null) {
            ObjectStore.fetch((byte[])this.m_bytes);
        }
        return FSStorage.fromBytes(this.m_bytes);
    }

    public void postInitializeContents() {
    }

    public void preDestroyPersistent() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        if (this.m_name != null) {
            ObjectStore.destroy((Object)this.m_name);
            if ((this.ODIObjectState & 2) != 0) {
                ObjectStore.dirty((IPersistent)this);
            }
            this.m_name = null;
        }
        if (this.m_source != null) {
            ObjectStore.destroy((Object)this.m_source);
            if ((this.ODIObjectState & 2) != 0) {
                ObjectStore.dirty((IPersistent)this);
            }
            this.m_source = null;
        }
        if (this.m_bytes != null) {
            ObjectStore.destroy((Object)this.m_bytes);
            if ((this.ODIObjectState & 2) != 0) {
                ObjectStore.dirty((IPersistent)this);
            }
            this.m_bytes = null;
        }
    }

    public ObjectReference ODIgetRef() {
        return this.ODIref;
    }

    public void ODIsetRef(ObjectReference objectreference) {
        this.ODIref = objectreference;
    }

    public byte ODIgetState() {
        return this.ODIObjectState;
    }

    public void ODIsetState(byte byte0) {
        this.ODIObjectState = byte0;
    }

    protected synchronized Object clone() throws CloneNotSupportedException {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        PSEMetric psemetric = (PSEMetric)super.clone();
        psemetric.ODITheHashCode = psemetric.ODIComputeHashCode();
        psemetric.ODIref = null;
        psemetric.ODIObjectState = 0;
        return psemetric;
    }

    public void preFlushContents() {
    }

    public void preClearContents() {
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return this.ODITheHashCode;
    }

    private int ODIComputeHashCode() {
        return HashPersistent.getNextHashCode();
    }

    public void initializeContents(GenericObject genericobject) {
        ClassInfo classinfo = myOdiClassInfoInstance;
        this.ODITheHashCode = genericobject.getIntField(1, classinfo);
        this.m_timestamp = genericobject.getLongField(2, classinfo);
        this.m_storageTimestamp = genericobject.getLongField(3, classinfo);
        this.m_name = genericobject.getStringField(4, classinfo);
        this.m_source = genericobject.getStringField(5, classinfo);
        this.m_bytes = (byte[])genericobject.getArrayField(6, classinfo);
    }

    public void flushContents(GenericObject genericobject) {
        ClassInfo classinfo = myOdiClassInfoInstance;
        genericobject.setIntField(1, this.ODITheHashCode, classinfo);
        genericobject.setLongField(2, this.m_timestamp, classinfo);
        genericobject.setLongField(3, this.m_storageTimestamp, classinfo);
        genericobject.setStringField(4, this.m_name, classinfo);
        genericobject.setStringField(5, this.m_source, classinfo);
        genericobject.setArrayField(6, (Object)this.m_bytes, classinfo);
    }

    public void clearContents() {
        this.ODITheHashCode = 0;
        this.m_timestamp = 0L;
        this.m_storageTimestamp = 0L;
        this.m_name = null;
        this.m_source = null;
        this.m_bytes = null;
    }

    public PSEMetric(ClassInfo classinfo) {
    }

    private static final ClassInfo getClassInfoInstance() {
        return ClassInfo.get(PSEMetric.class);
    }

    public String toString() {
        if (this.ODIObjectState < 0) {
            ObjectStore.fetch((IPersistent)this);
        }
        return "{PSEMetric: m_timestamp=" + this.m_timestamp + ",m_name=" + this.m_name + ",m_source=" + this.m_source + '}';
    }

    public IMetric getMetric() {
        return this.m_metric;
    }
}

