/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.monitor.offload;

import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.runtime.ICanonicalName;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.framework.monitor.IOffloadListener;
import com.sonicsw.mf.framework.monitor.offload.AnalyticsOffloadException;
import com.sonicsw.mf.framework.monitor.offload.spi.IAnalyticsOffload;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class AnalyticsOffloader {
    private static AnalyticsOffloader m_singleton;
    private ServiceLoader<IAnalyticsOffload> m_loader = ServiceLoader.load(IAnalyticsOffload.class);
    private IOffloadListener m_listener = null;

    private AnalyticsOffloader() {
    }

    public static synchronized AnalyticsOffloader getInstance() {
        if (m_singleton == null) {
            m_singleton = new AnalyticsOffloader();
        }
        return m_singleton;
    }

    public boolean isDeployed() {
        return this.m_loader.iterator().hasNext();
    }

    public IOffloadListener getOffloadListener() {
        return this.m_listener;
    }

    public void setOffloadListener(IOffloadListener m_listener) {
        this.m_listener = m_listener;
    }

    public void init() throws AnalyticsOffloadException {
        try {
            for (IAnalyticsOffload d : this.m_loader) {
                d.init();
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
            throw new AnalyticsOffloadException(serviceError);
        }
    }

    public void destroy() throws AnalyticsOffloadException {
        try {
            for (IAnalyticsOffload d : this.m_loader) {
                d.destroy();
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
        }
    }

    public void start() throws AnalyticsOffloadException {
        try {
            for (IAnalyticsOffload d : this.m_loader) {
                d.start();
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
        }
    }

    public void stop() throws AnalyticsOffloadException {
        try {
            for (IAnalyticsOffload d : this.m_loader) {
                d.stop();
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
        }
    }

    public void offloadNotification(INotification notification) throws AnalyticsOffloadException {
        try {
            if (this.m_listener != null) {
                this.m_listener.onNotificationOffloaded(notification);
            }
            for (IAnalyticsOffload d : this.m_loader) {
                d.offloadNotification(notification);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
        }
    }

    public void offloadMetrics(IMetric[] metrics, String source) throws AnalyticsOffloadException {
        try {
            if (this.m_listener != null) {
                this.m_listener.onMetricsOffloaded(metrics);
            }
            CanonicalName sourceCanonicalName = new CanonicalName(source);
            for (IAnalyticsOffload d : this.m_loader) {
                d.offloadMetrics(metrics, (ICanonicalName)sourceCanonicalName);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
        }
    }
}

