/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassControl;
import com.odi.filter.FieldMap;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.util.ClassFileSource;
import com.odi.filter.util.ClassPath;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class FilterEnv {
    boolean verboseOption = false;
    boolean quietOption = false;
    int dumpLevel = 0;
    boolean noWriteOption = false;
    boolean modifyJavaClassesOption = false;
    boolean allowFinalFieldModifications = false;
    boolean disableThisHookHoisting;
    boolean disableInitializerAnnotationSuppression;
    boolean disableArrayHookCaching;
    boolean disableArrayElementFetch = false;
    boolean forceOverwriteOption = false;
    boolean updateInPlaceOption = false;
    boolean addDefaultHashCodeOption = true;
    boolean optimizeClassInfoOption = true;
    boolean annotateTransientFields = true;
    boolean jdk12CompilerCompatibility = false;
    int errorsEncountered = 0;
    File destinationDirectory = null;
    String classInfoSuffix = "ClassInfo";
    Hashtable classMap = new Hashtable(203);
    Hashtable missingClasses = new Hashtable(11);
    Hashtable renamedMap = new Hashtable(203);
    Hashtable translations = new Hashtable(11);
    ClassPath classPathOption;
    ClassPath destClassPath;
    ClassControl genSummaryClass;
    String genSummary;
    Vector incSummaries = new Vector();
    Hashtable fieldSuppressions = new Hashtable();
    Hashtable classSuppressions = new Hashtable();
    FieldMap indexableFields = new FieldMap();
    FieldMap ignoreTransientFields = new FieldMap();
    FieldMap addedTransientFields = new FieldMap();
    FieldMap addedEmbeddedField = new FieldMap();
    FieldMap noAnnotateFields = new FieldMap();
    FieldMap annotateFields = new FieldMap();
    Hashtable explicitHashCodeClasses = new Hashtable();

    public boolean needsClassInfo(String classname) {
        return this.addedEmbeddedField.classHasEntry(classname) || this.addedTransientFields.classHasEntry(classname) || this.ignoreTransientFields.classHasEntry(classname);
    }

    public void error(String err) {
        ++this.errorsEncountered;
        System.out.print("Error: ");
        System.out.println(err);
    }

    public void error(String err, Throwable th) {
        this.error(err);
        th.printStackTrace(System.out);
    }

    public void warning(String warn) {
        if (!this.quiet()) {
            System.out.print("Warning: ");
            System.out.println(warn);
        }
    }

    public void warning(String warn, String classname) {
        if (!this.quiet() && !this.classWarningsSuppressed(classname)) {
            System.out.print("Warning: ");
            System.out.println(warn);
        }
    }

    public void warning(String warn, String classname, String fieldname) {
        if (!(this.quiet() || this.classWarningsSuppressed(classname) || this.fieldWarningsSuppressed(classname, fieldname))) {
            System.out.print("Warning: ");
            System.out.println(warn);
        }
    }

    public void message(String mess) {
        if (this.verbose()) {
            System.out.println(mess);
        }
    }

    public int errorCount() {
        return this.errorsEncountered;
    }

    public boolean verbose() {
        return this.verboseOption;
    }

    public boolean quiet() {
        return this.quietOption;
    }

    public boolean forceOverwrite() {
        return this.forceOverwriteOption;
    }

    public boolean updateInPlace() {
        return this.updateInPlaceOption;
    }

    public boolean addDefaultHashCode() {
        return this.addDefaultHashCodeOption;
    }

    public boolean optimizeClassInfo() {
        return this.optimizeClassInfoOption;
    }

    public String classInfoSuffix() {
        return this.classInfoSuffix;
    }

    boolean annotateTransientFields() {
        return this.annotateTransientFields;
    }

    public boolean dump(int level) {
        return this.dumpLevel >= level;
    }

    public boolean writeClasses() {
        return !this.noWriteOption && this.errorsEncountered == 0;
    }

    public boolean doArrayOptimization() {
        return !this.disableArrayHookCaching;
    }

    public boolean doThisOptimization() {
        return !this.disableThisHookHoisting;
    }

    public boolean doArrayElementFetch() {
        return !this.disableArrayElementFetch;
    }

    public boolean doInitializerOptimization() {
        return !this.disableInitializerAnnotationSuppression;
    }

    public boolean modifyJavaClasses() {
        return this.modifyJavaClassesOption;
    }

    public boolean allowFinalModifications() {
        return this.allowFinalFieldModifications;
    }

    public boolean isKnownPersistent(String className) {
        return className.equals("java/lang/String") || className.equals("java/lang/Integer") || className.equals("java/lang/Number") || className.equals("java/lang/Short") || className.equals("java/lang/Byte") || className.equals("java/lang/Long") || className.equals("java/lang/Float") || className.equals("java/lang/Double") || className.equals("java/lang/Character") || className.equals("java/lang/Boolean") || className.equals("java/math/BigInteger") || className.equals("java/math/BigDecimal") || className.equals("java/util/Locale");
    }

    public ClassControl addClass(ClassFile newClass, ClassFileSource friend) {
        String className = newClass.className().asString();
        ClassFileSource source = friend.friendSource(className);
        ClassControl control = new ClassControl(source, newClass, this);
        control.noteUpdate(this);
        control.setPersistType(0);
        this.classMap.put(className, control);
        return control;
    }

    public ClassControl addClass(ClassFile newClass) {
        String className = newClass.className().asString();
        ClassFileSource source = new ClassFileSource(className, (File)null);
        ClassControl control = new ClassControl(source, newClass, this);
        control.noteUpdate(this);
        control.setPersistType(0);
        this.classMap.put(className, control);
        return control;
    }

    public boolean canFindClass(String className) {
        return this.findClass(className) != null;
    }

    public ClassControl getClass(String className) {
        return (ClassControl)this.classMap.get(className);
    }

    public ClassControl findClass(String className) {
        ClassControl cc = (ClassControl)this.classMap.get(className);
        if (cc == null && this.missingClasses.get(className) == null) {
            cc = this.lookupClass(className);
            if (cc != null) {
                this.message("Adding class " + cc.userClassName() + " from " + cc.sourceName());
                this.classMap.put(className, cc);
            } else {
                this.missingClasses.put(className, className);
            }
        }
        return cc;
    }

    public ClassControl lookupClass(String className) {
        ClassFileSource source = this.classPathOption.findClass(className);
        while (source != null) {
            ClassControl control = null;
            try {
                control = new ClassControl(source, this);
                if (control.className() != null && control.className().equals(className)) {
                    return control;
                }
            }
            catch (UnsupportedClassVersionError ucve) {
                System.err.println(className + " - " + ucve.getMessage());
            }
            catch (ClassFormatError e) {
                // empty catch block
            }
            source = source.nextSource(className);
        }
        return null;
    }

    public ClassControl getRenamedClass(String className) {
        return (ClassControl)this.renamedMap.get(className);
    }

    public Vector collectClasses(int persistType) {
        Vector<ClassControl> v = new Vector<ClassControl>();
        Enumeration e = this.classMap.elements();
        while (e.hasMoreElements()) {
            ClassControl cc = (ClassControl)e.nextElement();
            if (cc.persistType() != persistType) continue;
            v.addElement(cc);
        }
        return v;
    }

    public Vector collectAllClasses() {
        Vector v = new Vector();
        Enumeration e = this.classMap.elements();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return v;
    }

    public ClassFileSource lookupDestClass(String className) {
        if (this.destClassPath == null && this.destinationDirectory != null) {
            this.destClassPath = new ClassPath(this.destinationDirectory.getPath());
        }
        return this.destClassPath == null ? null : this.destClassPath.findClass(className);
    }

    public void setClassPath(String path) {
        this.message("setting class path to " + path);
        this.classPathOption = new ClassPath(path);
    }

    void setDestinationDirectory(String dir) {
        File dest = new File(dir);
        if (this.destinationDirectory != null) {
            this.error("Attempt to set the destination directory to " + dir + ", but it has already been set to " + this.destinationDirectory.getPath());
        }
        if (dest.isDirectory()) {
            this.destinationDirectory = dest;
        } else {
            this.error("The destination directory " + dir + " does not exist.");
        }
    }

    void excludeDestinationDirectory() {
        if (this.destinationDirectory != null) {
            this.classPathOption.remove(this.destinationDirectory);
        }
    }

    void moveDestinationDirectoryToEnd() {
        if (this.destinationDirectory != null && this.classPathOption.remove(this.destinationDirectory)) {
            this.classPathOption.append(this.destinationDirectory);
        }
    }

    void setVerbose(boolean beVerbose) {
        this.verboseOption = beVerbose;
    }

    void setQuiet(boolean beQuiet) {
        this.quietOption = beQuiet;
    }

    void setModifyJavaClasses(boolean allowMods) {
        this.modifyJavaClassesOption = allowMods;
    }

    void setAllowFinalModifications(boolean allowMods) {
        this.allowFinalFieldModifications = allowMods;
    }

    void setNoWrite(boolean dontWrite) {
        this.noWriteOption = dontWrite;
    }

    void setNoArrayOptimization(boolean dontOpt) {
        this.disableArrayHookCaching = dontOpt;
        this.disableArrayElementFetch = dontOpt;
    }

    void setNoThisOptimization(boolean dontOpt) {
        this.disableThisHookHoisting = dontOpt;
    }

    void setNoInitializerOptimization(boolean dontOpt) {
        this.disableInitializerAnnotationSuppression = dontOpt;
    }

    void setNoOptimization(boolean dontOpt) {
        this.disableArrayHookCaching = dontOpt;
        this.disableThisHookHoisting = dontOpt;
        this.disableInitializerAnnotationSuppression = dontOpt;
        this.disableArrayElementFetch = dontOpt;
    }

    void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwriteOption = forceOverwrite;
    }

    void setUpdateInPlace(boolean inPlace) {
        this.updateInPlaceOption = inPlace;
    }

    void setAddDefaultHashCode(boolean addHashCode) {
        this.addDefaultHashCodeOption = addHashCode;
    }

    void setOptimizeClassInfo(boolean optimizeClassInfo) {
        this.optimizeClassInfoOption = optimizeClassInfo;
    }

    void setClassInfoSuffix(String suffix) {
        int i = 0;
        while (i < suffix.length()) {
            if (Character.isJavaIdentifierStart(suffix.charAt(i++))) continue;
            this.error("The ClassInfo suffix " + suffix + " contains invalid characters");
        }
        this.classInfoSuffix = suffix;
    }

    void setAnnotateTransientFields(boolean annotate) {
        this.annotateTransientFields = annotate;
    }

    void setJDK12CompilerCompatibility(boolean val) {
        this.jdk12CompilerCompatibility = val;
    }

    boolean getJDK12CompilerCompatibility() {
        return this.jdk12CompilerCompatibility;
    }

    void setPackageTranslation(String origPackage, String newPackage) {
        if (origPackage.equals(".")) {
            origPackage = "";
        }
        if (newPackage.equals(".")) {
            newPackage = "";
        }
        String validOrigPackage = FilterEnv.validVMPackage(origPackage);
        String validNewPackage = FilterEnv.validVMPackage(newPackage);
        if (validOrigPackage == null) {
            this.error("The name \"" + origPackage + "\" is not a valid package name.");
        } else if (validNewPackage == null) {
            this.error("The name \"" + newPackage + "\" is not a valid package name.");
        }
        this.translations.put(validOrigPackage, validNewPackage);
    }

    void suppressClassWarnings(String className) {
        this.classSuppressions.put(className, className);
    }

    void suppressFieldWarnings(String fullFieldName) {
        this.fieldSuppressions.put(fullFieldName, fullFieldName);
    }

    void addHashCode(String className) {
        this.explicitHashCodeClasses.put(className, className);
    }

    boolean hashCodeRequested(String className) {
        return this.explicitHashCodeClasses.get(className) != null;
    }

    void makeFieldIndexable(String fullFieldName) {
        this.indexableFields.addField(fullFieldName);
    }

    void processedIndexableField(String className, String fieldName) {
        if (this.isFieldIndexable(className, fieldName)) {
            this.indexableFields.markField(className, fieldName);
        }
    }

    boolean isFieldIndexable(String className, String fieldName) {
        return this.indexableFields.containsField(className, fieldName);
    }

    void addIgnoreTransientField(String fullFieldName) {
        this.ignoreTransientFields.addField(fullFieldName);
    }

    boolean isIgnoreTransientField(String className, String fieldName) {
        return this.ignoreTransientFields.containsField(className, fieldName);
    }

    void addTransientField(String fullFieldName) {
        this.addedTransientFields.addField(fullFieldName);
    }

    boolean isAddedTransientField(String className, String fieldName) {
        return this.addedTransientFields.containsField(className, fieldName);
    }

    void addEmbeddedField(String fullFieldName, int maxSize) {
        this.addedEmbeddedField.addField(fullFieldName);
        this.addedEmbeddedField.associateValue(fullFieldName, new Integer(maxSize));
    }

    void addEmbeddedField(String fullFieldName) {
        this.addedEmbeddedField.addField(fullFieldName);
    }

    boolean isEmbeddedField(String className, String fieldName) {
        return this.addedEmbeddedField.containsField(className, fieldName);
    }

    void processedEmbeddedField(String className, String fieldName) {
        if (this.isEmbeddedField(className, fieldName)) {
            this.addedEmbeddedField.markField(className, fieldName);
        }
    }

    Integer getEmbeddedFieldSize(String className, String fieldName) {
        return (Integer)this.addedEmbeddedField.getValue(className, fieldName);
    }

    void addNoAnnotateField(String fullFieldName) {
        this.noAnnotateFields.addField(fullFieldName);
    }

    void addAnnotateField(String fullFieldName) {
        this.annotateFields.addField(fullFieldName);
    }

    boolean isNoAnnotateField(ClassControl fieldCC, String fieldName) {
        boolean skipAnnotation;
        Boolean noAnnotation = fieldCC.getNoAnnotateField(fieldName);
        if (noAnnotation != null) {
            return noAnnotation;
        }
        String vmClassName = fieldCC.className();
        if (this.noAnnotateFields.containsField(vmClassName, fieldName)) {
            skipAnnotation = true;
        } else if (this.annotateFields.containsField(vmClassName, fieldName)) {
            skipAnnotation = false;
        } else if (this.annotateTransientFields) {
            skipAnnotation = false;
        } else {
            boolean isTransientField;
            if (this.isAddedTransientField(vmClassName, fieldName)) {
                isTransientField = true;
            } else if (this.isIgnoreTransientField(vmClassName, fieldName)) {
                isTransientField = false;
            } else {
                ClassFile cfile = fieldCC.classFile();
                ClassField field = cfile.findField(fieldName);
                if (field == null) {
                    this.warning("field " + fieldName + " of class " + fieldCC.userClassName() + " was not found and is " + "assumed to be persistent.");
                    isTransientField = false;
                } else {
                    isTransientField = field.isTransient();
                }
            }
            skipAnnotation = isTransientField;
        }
        noAnnotation = new Boolean(skipAnnotation);
        fieldCC.setNoAnnotateField(fieldName, noAnnotation);
        return skipAnnotation;
    }

    void setSummaryClass(ClassControl summaryClass) {
        this.genSummaryClass = summaryClass;
    }

    ClassControl getSummaryClass() {
        return this.genSummaryClass;
    }

    void setSummary(String summaryName) {
        this.genSummary = summaryName;
    }

    String getSummary() {
        return this.genSummary;
    }

    void addIncludedSummary(String summaryName) {
        this.incSummaries.addElement(summaryName);
    }

    Vector getIncludedSummaries() {
        return this.incSummaries;
    }

    static String validVMPackage(String pkg) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < pkg.length()) {
            if (i != 0) {
                if (pkg.charAt(i) != '.') {
                    return null;
                }
                buf.append("/");
                if (++i == pkg.length()) {
                    return null;
                }
            }
            if (!Character.isJavaIdentifierStart(pkg.charAt(i))) {
                return null;
            }
            buf.append(pkg.charAt(i++));
            while (i < pkg.length() && Character.isJavaIdentifierPart(pkg.charAt(i))) {
                buf.append(pkg.charAt(i++));
            }
        }
        return buf.toString();
    }

    private boolean classWarningsSuppressed(String classname) {
        return this.classSuppressions.get(classname) != null;
    }

    private boolean fieldWarningsSuppressed(String classname, String fieldName) {
        return this.fieldSuppressions.get(classname + "." + fieldName) != null;
    }
}

