/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.AnnotationConstants;
import com.odi.filter.ClassAction;
import com.odi.filter.classfile.Insn;

class InsnNote
implements AnnotationConstants {
    Insn insn;
    int insnFlags;
    int argWord;
    int argReg = -1;
    String stackSig;
    ClassAction targetClassAction;

    InsnNote next() {
        return null;
    }

    final String sig() {
        return this.stackSig;
    }

    final ClassAction targetClassAction() {
        return this.targetClassAction;
    }

    final int arg() {
        return this.argWord;
    }

    final boolean fetchThis() {
        return (this.insnFlags & 1) != 0;
    }

    final void dontFetchThis() {
        this.insnFlags &= 0xFFFFFFFE;
    }

    final boolean dirtyThis() {
        return (this.insnFlags & 2) != 0;
    }

    final void dontDirtyThis() {
        this.insnFlags &= 0xFFFFFFFD;
    }

    final boolean evictThis() {
        return (this.insnFlags & 0x1000) != 0;
    }

    final void dontEvictThis() {
        this.insnFlags &= 0xFFFFEFFF;
    }

    final boolean unconditional() {
        return (this.insnFlags & 0x100) != 0;
    }

    final boolean fetchObject() {
        return (this.insnFlags & 4) != 0;
    }

    final boolean dirtyObject() {
        return (this.insnFlags & 8) != 0;
    }

    final boolean fetchPersistent() {
        return (this.insnFlags & 0x10) != 0;
    }

    final boolean dirtyPersistent() {
        return (this.insnFlags & 0x20) != 0;
    }

    final boolean evictPersistent() {
        return (this.insnFlags & 0x800) != 0;
    }

    final boolean fetchArray() {
        return (this.insnFlags & 0x40) != 0;
    }

    final boolean dirtyArray() {
        return (this.insnFlags & 0x80) != 0;
    }

    final int arrayElementType() {
        return this.insnFlags & 0x78000000;
    }

    final boolean inLoop() {
        return (this.insnFlags & 0x200) != 0;
    }

    final boolean checkNull() {
        return (this.insnFlags & 0x400) != 0;
    }

    final int getArgReg() {
        return this.argReg;
    }

    final void setArgReg(int reg) {
        this.argReg = reg;
    }

    InsnNote(Insn i, int flags, int argWord, String stackSig, ClassAction targetClassAction) {
        this.insn = i;
        this.insnFlags = flags;
        this.stackSig = stackSig;
        this.argWord = argWord;
        this.targetClassAction = targetClassAction;
    }
}

