/*
 * Decompiled with CFR 0.152.
 */
package com.odi.tools;

import com.odi.Database;
import com.odi.IPersistent;
import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstClass;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.ExceptionTable;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.VMConstants;
import com.odi.imp.ByteArrayClassLoader;
import com.odi.imp.Utilities;
import java.io.IOException;

public class ClassBuilder
implements VMConstants {
    private ByteArrayClassLoader classLoader;
    final String schemaString;
    final String className;
    int position = 0;
    ClassFile classFile;

    public static Class findClass(String className, Database db) throws ClassNotFoundException {
        Class c;
        block3: {
            c = null;
            try {
                c = Utilities.findClass(className);
            }
            catch (ClassNotFoundException e) {
                String schemaString = ((com.odi.imp.Database)db).serverGetSchemaString();
                if (schemaString != null) {
                    c = new ClassBuilder(schemaString, className).buildClass();
                }
                if (c != null) break block3;
                throw e;
            }
        }
        return c;
    }

    public static void findAllClasses(Database db) {
        String[] classNames = ((com.odi.imp.Database)db).serverGetSchemaClasses();
        int numClasses = classNames.length;
        for (int i = 0; i < numClasses; ++i) {
            try {
                ClassBuilder.findClass(classNames[i], db);
                continue;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
    }

    public static void createHollowConstructor(ClassFile cFile) {
        ConstantPool pool = cFile.pool();
        ConstClass thisClass = cFile.className();
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod classInfoCtorMethod = new ClassMethod(1, pool.addUtf8("<init>"), pool.addUtf8("(Lcom/odi/ClassInfo;)V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        ConstClass superClass = cFile.superName();
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(43));
        insn = insn.append(Insn.create(183, pool.addMethodRef(superClass.asString(), "<init>", "(Lcom/odi/ClassInfo;)V")));
        int stackMax = 2;
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), stackMax, 2, firstInsn, new ExceptionTable(), new AttributeVector()));
        cFile.addMethod(classInfoCtorMethod);
    }

    private ClassBuilder(String schemaString, String className) {
        this.schemaString = schemaString;
        this.className = className;
        this.classLoader = Utilities.getClassLoader();
    }

    private Class findClass(String className) throws ClassNotFoundException {
        Class c;
        block3: {
            c = null;
            try {
                c = Utilities.findClass(className);
            }
            catch (ClassNotFoundException e) {
                if (this.schemaString != null) {
                    c = new ClassBuilder(this.schemaString, className).buildClass();
                }
                if (c != null) break block3;
                throw e;
            }
        }
        return c;
    }

    private Class findInterface(String ifaceName) {
        Class c;
        block2: {
            c = null;
            try {
                c = Utilities.findClass(ifaceName);
            }
            catch (ClassNotFoundException e) {
                if (this.schemaString == null) break block2;
                c = new ClassBuilder(this.schemaString, ifaceName).buildInterface();
            }
        }
        return c;
    }

    private Class buildClass() {
        if (this.position > 0) {
            return null;
        }
        int startOfClass = this.schemaString.indexOf("C" + this.className + ";");
        if (startOfClass < 0) {
            return null;
        }
        int startOfDefinition = startOfClass + this.className.length() + 3;
        String superClassName = "com.odi.util.DynamicPersistent";
        boolean needsPersistence = true;
        if (this.schemaString.charAt(startOfDefinition) == 'B') {
            int endOfBaseClass = this.schemaString.indexOf(";", startOfDefinition);
            superClassName = this.schemaString.substring(startOfDefinition + 1, endOfBaseClass);
            Class supClass = null;
            try {
                supClass = this.findClass(superClassName);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (supClass == null) {
                return null;
            }
            needsPersistence = !IPersistent.class.isAssignableFrom(supClass);
        }
        this.classFile = new ClassFile(Utilities.getClassVMName(this.className), Utilities.getClassVMName(superClassName));
        ConstantPool pool = this.classFile.pool();
        this.classFile.setAccessFlags(1);
        ConstClass javaioSerializable = pool.addClass("java/io/Serializable");
        this.classFile.addInterface(javaioSerializable);
        ClassBuilder.createHollowConstructor(this.classFile);
        if (needsPersistence) {
            ConstClass COModiIPersistent = pool.addClass("com/odi/IPersistent");
            this.classFile.addInterface(COModiIPersistent);
        }
        this.position = startOfDefinition;
        if (!superClassName.equals("com.odi.util.DynamicPersistent")) {
            this.position += superClassName.length() + 2;
        }
        while (this.findNextField()) {
        }
        byte[] bytes = this.getClassFileBytes();
        if (bytes == null) {
            return null;
        }
        Class theClass = this.classLoader.addClass(this.className, bytes);
        return theClass;
    }

    private Class buildInterface() {
        this.classFile = new ClassFile(Utilities.getClassVMName(this.className), Utilities.getClassVMName("java.lang.Object"));
        this.classFile.setAccessFlags(513);
        byte[] bytes = this.getClassFileBytes();
        Class theClass = this.classLoader.addClass(this.className, bytes);
        return theClass;
    }

    private boolean findNextField() {
        if (this.schemaString.charAt(this.position) == '}') {
            return false;
        }
        ++this.position;
        int endOfFieldName = this.schemaString.indexOf(";", this.position);
        String fieldName = this.schemaString.substring(this.position, endOfFieldName);
        this.position += fieldName.length() + 1;
        return this.handleType(fieldName, 0);
    }

    private boolean handleType(String fieldName, int dims) {
        char ch = this.schemaString.charAt(this.position);
        if (ch == 'L') {
            ch = 'f';
        }
        if (Character.isLowerCase(ch)) {
            switch (ch) {
                case 'b': {
                    ++this.position;
                    this.addField(Byte.TYPE.getName(), fieldName, dims);
                    return true;
                }
                case 'l': {
                    ++this.position;
                    this.addField(Character.TYPE.getName(), fieldName, dims);
                    return true;
                }
                case 'd': {
                    ++this.position;
                    this.addField(Short.TYPE.getName(), fieldName, dims);
                    return true;
                }
                case 'f': {
                    ++this.position;
                    this.addField(Integer.TYPE.getName(), fieldName, dims);
                    return true;
                }
                case 'h': {
                    ++this.position;
                    this.addField(Long.TYPE.getName(), fieldName, dims);
                    return true;
                }
                case 'm': {
                    ++this.position;
                    this.addField(Float.TYPE.getName(), fieldName, dims);
                    return true;
                }
                case 'n': {
                    ++this.position;
                    this.addField(Double.TYPE.getName(), fieldName, dims);
                    return true;
                }
                case 'k': {
                    ++this.position;
                    this.addField(Boolean.TYPE.getName(), fieldName, dims);
                    return true;
                }
            }
        }
        if (this.schemaString.regionMatches(this.position, "[]o", 0, 3)) {
            this.position += 3;
            this.addField("java.lang.String", fieldName, dims);
            return true;
        }
        if (ch == 'T' || ch == 'S') {
            ++this.position;
            int endOfType = this.schemaString.indexOf(";", this.position);
            String fieldTypeName = this.schemaString.substring(this.position, endOfType);
            if (ch == 'S') {
                this.findInterface(fieldTypeName);
            }
            this.position += fieldTypeName.length() + 1;
            this.addField(fieldTypeName, fieldName, dims);
            return true;
        }
        if (ch == 'O') {
            ++this.position;
            this.addField("java.lang.Object", fieldName, dims);
            return true;
        }
        if (ch == 'P') {
            ++this.position;
            this.addField("com.odi.Persistent", fieldName, dims);
            return true;
        }
        if (ch == 'W') {
            ch = this.schemaString.charAt(this.position + 1);
            if (ch == 'k') {
                this.position += 2;
                this.addField("java.lang.Boolean", fieldName, dims);
                return true;
            }
            if (ch == 'b') {
                this.position += 2;
                this.addField("java.lang.Byte", fieldName, dims);
                return true;
            }
            if (ch == 'd') {
                this.position += 2;
                this.addField("java.lang.Short", fieldName, dims);
                return true;
            }
            if (ch == 'l') {
                this.position += 2;
                this.addField("java.lang.Character", fieldName, dims);
                return true;
            }
            if (ch == 'f') {
                this.position += 2;
                this.addField("java.lang.Integer", fieldName, dims);
                return true;
            }
            if (ch == 'm') {
                this.position += 2;
                this.addField("java.lang.Float", fieldName, dims);
                return true;
            }
            ++this.position;
            return false;
        }
        if (ch == 'Q') {
            this.position += 2;
            this.addField("com.odi.jcpp.CPlusPlus", fieldName, dims);
            return true;
        }
        if (ch == '[') {
            dims = 0;
            while (this.schemaString.charAt(this.position) == '[') {
                ++dims;
                this.position += 2;
            }
            return this.handleType(fieldName, dims);
        }
        return false;
    }

    private void addField(String fieldTypeName, String fieldName, int dims) {
        if (dims > 0) {
            fieldTypeName = Utilities.makeArrayClassName(fieldTypeName, dims);
        }
        String signature = Utilities.getClassNameSignature(fieldTypeName);
        this.doAddField(signature, fieldName, dims);
    }

    private void doAddField(String signature, String fieldName, int dims) {
        ConstantPool pool = this.classFile.pool();
        this.classFile.addField(new ClassField(1, pool.addUtf8(fieldName), pool.addUtf8(signature), new AttributeVector()));
    }

    private byte[] getClassFileBytes() {
        try {
            return this.classFile.getBytes();
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

