/*
 * Decompiled with CFR 0.152.
 */
package com.odi.tools;

import com.odi.Database;
import com.odi.ObjectStore;
import com.odi.Session;
import com.odi.Transaction;
import com.odi.tools.ClassBuilder;
import com.odi.util.query.Query;

class ShowDB {
    ShowDB() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.err.println("usage: osjshowdb [-showObjs] [-showData] [-query \"elementType::expression\"] dbname.odb...");
            System.exit(1);
        }
        Session session = Session.create(null, null);
        session.join();
        ObjectStore.setAutoOpenMode(6);
        boolean showObjs = false;
        boolean showData = false;
        Query query = null;
        try {
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].startsWith("-showO")) {
                    showObjs = true;
                    continue;
                }
                if (argv[i].startsWith("-showD")) {
                    showData = true;
                    continue;
                }
                if (argv[i].startsWith("-q")) {
                    if (++i == argv.length) {
                        System.err.println("-query needs a value: elementType::expression");
                        System.exit(1);
                    }
                    try {
                        String queryString = argv[i];
                        Class elementType = ShowDB.getElementType(queryString);
                        String expression = ShowDB.getQueryExpression(queryString);
                        query = new Query(elementType, expression);
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Invalid Query String.  Needs \"::\"between the elementType and expression");
                        System.exit(1);
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("Invalid element type threw exception: " + e);
                        System.exit(1);
                    }
                }
                Database db = Database.open(argv[i], 6);
                Transaction t = Transaction.begin(6);
                ClassBuilder.findAllClasses(db);
                if (query == null) {
                    db.show(System.out, showObjs, showData);
                } else {
                    db.show(System.out, showObjs, showData, query);
                }
                t.commit();
                db.close();
            }
        }
        finally {
            session.terminate();
        }
        System.exit(0);
    }

    private static Class getElementType(String queryString) throws ClassNotFoundException, StringIndexOutOfBoundsException {
        int endOfClass = queryString.indexOf("::");
        String className = queryString.substring(0, endOfClass);
        return Class.forName(className);
    }

    private static String getQueryExpression(String queryString) throws StringIndexOutOfBoundsException {
        int startOfExpression = queryString.indexOf("::") + 2;
        return queryString.substring(startOfExpression);
    }

    static {
        try {
            Class.forName("com.odi.util.BTreeNodeFactory");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

