/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.NoSessionException;
import com.odi.ObjectStore;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.util.OSVectorEntry;
import com.odi.util.OSVectorIterator;
import com.odi.util.SubList;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OSVector
implements Collection,
IPersistent,
IPersistentHooks,
Cloneable,
Serializable {
    static final long serialVersionUID = 2271938799889113703L;
    private int ODITheHashCode;
    private transient ObjectReference ref;
    public transient byte objectState;
    private OSVectorEntry[] elementEntryData;
    protected int elementCount;
    int bucketIncrement;
    int entryTableSize;
    private static boolean lazyAllocationDefault = false;
    static final int TINY_ENTRY_TABLE_SIZE = 8;
    static final int SMALL_ENTRY_TABLE_SIZE = 32;
    static final int MEDIUM_ENTRY_TABLE_SIZE = 64;
    static final int LARGE_ENTRY_TABLE_SIZE = 128;
    private static final ClassInfo OSVI = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSVector"));

    @Override
    public void initializeContents(GenericObject genObject) {
        this.ODITheHashCode = genObject.getIntField(1, OSVI);
        this.elementEntryData = (OSVectorEntry[])genObject.getArrayField(2, OSVI);
        this.elementCount = genObject.getIntField(3, OSVI);
        this.bucketIncrement = genObject.getIntField(4, OSVI);
        this.entryTableSize = genObject.getIntField(5, OSVI);
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setIntField(1, this.ODITheHashCode, OSVI);
        genObject.setArrayField(2, this.elementEntryData, OSVI);
        genObject.setIntField(3, this.elementCount, OSVI);
        genObject.setIntField(4, this.bucketIncrement, OSVI);
        genObject.setIntField(5, this.entryTableSize, OSVI);
    }

    @Override
    public void clearContents() {
        this.ODITheHashCode = 0;
        this.elementEntryData = null;
        this.elementCount = 0;
        this.bucketIncrement = 0;
        this.entryTableSize = 0;
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte objectState) {
        this.objectState = objectState;
    }

    private void fetch() {
        if (this.objectState < 0) {
            ObjectManager.fetch(this);
        }
    }

    private void dirty() {
        if ((this.objectState & 2) != 0) {
            ObjectManager.dirty(this);
        }
    }

    public OSVector(int initialBufferSize, int capacityIncrement) {
        this(initialBufferSize, capacityIncrement, lazyAllocationDefault);
    }

    private int computeEntryTableSize(int capacity) {
        if (capacity <= 8) {
            return 8;
        }
        if (capacity <= 32) {
            return 32;
        }
        if (capacity <= 64) {
            return 64;
        }
        return 128;
    }

    public OSVector(int initialBufferSize, int capacityIncrement, boolean lazy) {
        this.ODITheHashCode = super.hashCode();
        this.entryTableSize = this.computeEntryTableSize(initialBufferSize);
        if (initialBufferSize < 1) {
            initialBufferSize = 1;
        }
        int elementEntryCount = (initialBufferSize - 1) / this.entryTableSize + 1;
        this.bucketIncrement = (capacityIncrement - 1) / this.entryTableSize + 1;
        if (lazy) {
            this.elementCount = -elementEntryCount;
        } else {
            this.allocateBuckets(elementEntryCount);
        }
    }

    private void allocateBuckets(int elementEntryCount) {
        this.elementEntryData = new OSVectorEntry[elementEntryCount];
        for (int i = 0; i < elementEntryCount; ++i) {
            this.elementEntryData[i] = new OSVectorEntry(this.entryTableSize);
        }
        this.elementCount = 0;
    }

    public OSVector(int initialBufferSize) {
        this(initialBufferSize, initialBufferSize);
    }

    public OSVector() {
        this(10);
    }

    public OSVector(ClassInfo ignored) {
    }

    protected OSVector(char ignored) {
    }

    final int GetElementEntryIndex(int elementIndex) {
        return elementIndex / this.entryTableSize;
    }

    final int GetElementDataIndex(int elementIndex) {
        return elementIndex % this.entryTableSize;
    }

    private Object[] fetchTableAndBucket(int bkt) {
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
            ObjectStore.fetch(this.elementEntryData[bkt]);
            ObjectStore.fetch(this.elementEntryData[bkt].elementData);
        }
        return this.elementEntryData[bkt].elementData;
    }

    private Object[] fetchBucket(int bkt) {
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData[bkt]);
            ObjectStore.fetch(this.elementEntryData[bkt].elementData);
        }
        return this.elementEntryData[bkt].elementData;
    }

    private Object[] dirtyBucket(int bkt) {
        Object[] bucket = this.fetchTableAndBucket(bkt);
        if (this.ref != null) {
            ObjectStore.dirty(bucket);
        }
        return bucket;
    }

    public synchronized void destroy() {
        ObjectStore.destroy(this);
    }

    @Override
    public void preDestroyPersistent() {
        if (this.ref == null) {
            return;
        }
        this.fetch();
        if (this.elementEntryData == null) {
            return;
        }
        ObjectStore.fetch(this.elementEntryData);
        for (int bkt = 0; bkt < this.elementEntryData.length; ++bkt) {
            this.elementEntryData[bkt].destroy();
        }
        ObjectStore.destroy(this.elementEntryData);
    }

    public synchronized void addElement(Object obj) {
        this.dirty();
        if (this.elementEntryData == null) {
            this.allocateBuckets(-this.elementCount);
        } else {
            this.ensureCapacity(this.elementCount + 1);
        }
        int entryIndex = this.GetElementEntryIndex(this.elementCount);
        int elementDataIndex = this.GetElementDataIndex(this.elementCount);
        this.dirtyBucket((int)entryIndex)[elementDataIndex] = obj;
        ++this.elementCount;
    }

    public final synchronized int capacity() {
        this.fetch();
        return this.elementEntryData == null ? -this.elementCount * this.entryTableSize : this.elementEntryData.length * this.entryTableSize;
    }

    @Override
    public final boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final synchronized void copyInto(Object[] anArray) {
        this.fetch();
        if (this.elementEntryData == null) {
            return;
        }
        if (anArray == null && this.elementCount > 0) {
            throw new NullPointerException("The anArray argument to OSVector.copyInto is null.");
        }
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
        }
        ObjectStore.dirty(anArray);
        int elementIndex = 0;
        while (elementIndex < this.elementCount) {
            int entryIndex = elementIndex / this.entryTableSize;
            Object[] elementData = this.fetchBucket(entryIndex);
            for (int idx = 0; idx < this.entryTableSize && elementIndex < this.elementCount; ++idx, ++elementIndex) {
                anArray[elementIndex] = elementData[idx];
            }
        }
    }

    public final synchronized Object elementAt(int index) {
        this.fetch();
        if (this.elementEntryData == null || index >= this.elementCount || index < 0) {
            throw new ArrayIndexOutOfBoundsException("elementAt(" + index + ")");
        }
        return this.fetchTableAndBucket(this.GetElementEntryIndex(index))[this.GetElementDataIndex(index)];
    }

    public final synchronized Object firstElement() {
        this.fetch();
        if (this.elementCount <= 0) {
            throw new NoSuchElementException();
        }
        return this.fetchTableAndBucket(0)[0];
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        if (minCapacity > this.capacity()) {
            this.dirty();
            if (this.elementEntryData == null) {
                this.entryTableSize = this.computeEntryTableSize(minCapacity);
                this.elementCount = -((minCapacity - 1) / this.entryTableSize + 1);
                return;
            }
            int minBucketCapacity = (minCapacity - 1) / this.entryTableSize + 1;
            if (this.ref != null) {
                ObjectStore.fetch(this.elementEntryData);
            }
            OSVectorEntry[] oldEntryData = this.elementEntryData;
            int newBucketCapacity = this.elementEntryData.length + this.bucketIncrement;
            if (newBucketCapacity < minBucketCapacity) {
                newBucketCapacity = minBucketCapacity;
            }
            this.elementEntryData = new OSVectorEntry[newBucketCapacity];
            System.arraycopy(oldEntryData, 0, this.elementEntryData, 0, oldEntryData.length);
            for (int i = oldEntryData.length; i < newBucketCapacity; ++i) {
                this.elementEntryData[i] = new OSVectorEntry(this.entryTableSize);
            }
            ObjectStore.destroy(oldEntryData);
        }
    }

    public final int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(Object elem, int index) {
        this.fetch();
        if (this.elementEntryData == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("indexOf(" + index + ")");
            }
            return -1;
        }
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException("indexOf(" + index + ")");
        }
        if (index == this.elementCount) {
            return -1;
        }
        if (elem != null) {
            ObjectStore.fetch(elem);
        }
        int entryIndex = this.GetElementEntryIndex(index);
        int elementIndex = this.GetElementDataIndex(index);
        int lastEntry = this.GetElementEntryIndex(this.elementCount - 1);
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
        }
        int bucketLimit = this.entryTableSize;
        for (int i = entryIndex; i <= lastEntry; ++i) {
            Object[] elementData = this.fetchBucket(i);
            if (i == lastEntry) {
                bucketLimit = this.GetElementDataIndex(this.elementCount - 1) + 1;
            }
            for (int j = elementIndex; j < bucketLimit; ++j) {
                if (elementData[j] != null) {
                    ObjectStore.fetch(elementData[j]);
                }
                if ((elem != null || elementData[j] != null) && (elem == null || !elem.equals(elementData[j]))) continue;
                return j + i * this.entryTableSize;
            }
            elementIndex = 0;
        }
        return -1;
    }

    public final int lastIndexOf(Object elem) {
        this.fetch();
        return this.lastIndexOf(elem, this.elementEntryData == null ? 0 : this.elementCount);
    }

    public final synchronized int lastIndexOf(Object elem, int index) {
        this.fetch();
        if (this.elementEntryData == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("lastIndexOf(" + index + ")");
            }
            return -1;
        }
        if (index < 0 || index > this.elementCount) {
            throw new IndexOutOfBoundsException("lastIndexOf(" + index + ")");
        }
        if (elem != null) {
            ObjectStore.fetch(elem);
        }
        int entryIndex = this.GetElementEntryIndex(--index);
        int elementIndex = this.GetElementDataIndex(index);
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
        }
        while (index >= 0) {
            Object[] elementData = this.fetchBucket(entryIndex);
            for (int j = elementIndex; j >= 0; --j) {
                if (elementData[j] != null) {
                    ObjectStore.fetch(elementData[j]);
                }
                if ((elem != null || elementData[j] != null) && (elem == null || !elem.equals(elementData[j]))) continue;
                return j + entryIndex * this.entryTableSize;
            }
            index -= elementIndex + 1;
            elementIndex = this.entryTableSize - 1;
            --entryIndex;
        }
        return -1;
    }

    public final synchronized Object lastElement() {
        this.fetch();
        if (this.elementEntryData == null || this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.fetchTableAndBucket(this.GetElementEntryIndex(this.elementCount - 1))[this.GetElementDataIndex(this.elementCount - 1)];
    }

    public synchronized void setSize(int newSize) {
        this.dirty();
        if (this.elementEntryData == null) {
            this.allocateBuckets(-this.elementCount);
        }
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            int entryIndex = this.GetElementEntryIndex(newSize);
            int elementIndex = this.GetElementDataIndex(newSize);
            int lastUpdateIndex = this.GetElementEntryIndex(this.elementCount - 1);
            if (this.ref != null) {
                ObjectStore.fetch(this.elementEntryData);
            }
            for (int j = entryIndex; j <= lastUpdateIndex; ++j) {
                Object[] elementData = this.dirtyBucket(j);
                for (int i = elementIndex; i < this.entryTableSize; ++i) {
                    elementData[i] = null;
                }
                elementIndex = 0;
            }
        }
        this.elementCount = newSize;
    }

    @Override
    public final int size() {
        this.fetch();
        return this.elementEntryData == null ? 0 : this.elementCount;
    }

    @Override
    public final boolean isEmpty() {
        this.fetch();
        return this.elementCount <= 0;
    }

    public final synchronized void trimToSize() {
        int minBuckets = (this.size() - 1) / this.entryTableSize + 1;
        if (this.elementEntryData == null) {
            this.elementCount = -1;
            this.entryTableSize = this.computeEntryTableSize(0);
            return;
        }
        if (minBuckets < this.elementEntryData.length) {
            this.dirty();
            OSVectorEntry[] newEntryData = new OSVectorEntry[minBuckets];
            if (this.ref != null) {
                ObjectStore.fetch(this.elementEntryData);
            }
            System.arraycopy(this.elementEntryData, 0, newEntryData, 0, minBuckets);
            for (int i = minBuckets + 1; i < this.elementEntryData.length; ++i) {
                this.elementEntryData[i].destroy();
            }
            ObjectStore.destroy(this.elementEntryData);
            this.elementEntryData = newEntryData;
        }
    }

    public final synchronized Enumeration elements() {
        return new OSVectorIterator(this);
    }

    public synchronized void setElementAt(Object obj, int index) {
        this.fetch();
        if (this.elementEntryData == null || index >= this.elementCount || index < 0) {
            throw new IndexOutOfBoundsException("setElementAt(" + index + ")");
        }
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
        }
        this.dirtyBucket((int)this.GetElementEntryIndex((int)index))[this.GetElementDataIndex((int)index)] = obj;
    }

    public synchronized void removeElementAt(int index) {
        int init;
        this.fetch();
        if (this.elementEntryData == null || index >= this.elementCount || index < 0) {
            throw new IndexOutOfBoundsException("removeElementAt(" + index + ")");
        }
        this.dirty();
        int elementIndex = this.GetElementDataIndex(index);
        int entryBuckets = this.GetElementEntryIndex(this.elementCount - 1) + 1;
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
        }
        for (int i = init = this.GetElementEntryIndex(index); i < entryBuckets; ++i) {
            int nElements;
            Object[] elementData = this.dirtyBucket(i);
            if (i != init) {
                this.elementEntryData[i - 1].elementData[this.entryTableSize - 1] = elementData[0];
            }
            if ((nElements = this.entryTableSize - elementIndex - 1) > 0) {
                System.arraycopy(elementData, elementIndex + 1, elementData, elementIndex, nElements);
            }
            elementIndex = 0;
        }
        this.elementEntryData[entryBuckets - 1].elementData[this.entryTableSize - 1] = null;
        --this.elementCount;
    }

    public synchronized void insertElementAt(Object obj, int index) {
        int init;
        this.fetch();
        if (this.elementEntryData == null) {
            this.dirty();
            this.allocateBuckets(-this.elementCount);
        }
        if (index > this.elementCount || index < 0) {
            throw new IndexOutOfBoundsException("insertElementAt(" + index + ")");
        }
        this.dirty();
        int insertEntry = this.GetElementEntryIndex(index);
        int insertElement = this.GetElementDataIndex(index);
        int bucketTopIndex = this.GetElementDataIndex(this.elementCount);
        this.ensureCapacity(this.elementCount + 1);
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
        }
        int copyStart = 0;
        for (int entry = init = this.GetElementEntryIndex(this.elementCount); entry >= insertEntry; --entry) {
            Object[] elementData = this.dirtyBucket(entry);
            if (entry != init) {
                this.elementEntryData[entry + 1].elementData[0] = elementData[this.entryTableSize - 1];
            }
            int elementsToCopy = bucketTopIndex;
            if (entry == insertEntry) {
                elementsToCopy -= insertElement;
                copyStart = insertElement;
            }
            if (elementsToCopy > 0) {
                System.arraycopy(elementData, copyStart, elementData, copyStart + 1, elementsToCopy);
            }
            bucketTopIndex = this.entryTableSize - 1;
        }
        this.elementEntryData[insertEntry].elementData[insertElement] = obj;
        ++this.elementCount;
    }

    public final synchronized boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i >= 0) {
            this.removeElementAt(i);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        this.dirty();
        if (this.elementEntryData == null) {
            return;
        }
        if (this.ref != null) {
            ObjectStore.fetch(this.elementEntryData);
        }
        int lastEntryIndex = this.GetElementEntryIndex(this.elementCount - 1);
        for (int i = 0; i <= lastEntryIndex; ++i) {
            Object[] elementData = this.dirtyBucket(i);
            for (int j = 0; j < this.entryTableSize; ++j) {
                elementData[j] = null;
            }
        }
        this.elementCount = 0;
    }

    @Override
    public int hashCode() {
        block2: {
            try {
                this.fetch();
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block2;
                throw e;
            }
        }
        return this.ODITheHashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public synchronized Object clone() {
        this.fetch();
        try {
            OSVector vect = (OSVector)super.clone();
            vect.recomputeHashCode();
            vect.ODIsetRef(null);
            vect.ODIsetState((byte)0);
            if (this.elementEntryData == null) {
                return vect;
            }
            if (this.ref != null) {
                ObjectStore.fetch(this.elementEntryData);
            }
            vect.elementEntryData = new OSVectorEntry[this.elementEntryData.length];
            for (int i = 0; i < this.elementEntryData.length; ++i) {
                vect.elementEntryData[i] = (OSVectorEntry)this.elementEntryData[i].clone();
            }
            return vect;
        }
        catch (CloneNotSupportedException e) {
            throw new FatalInternalException("Attempt to clone OSVector failed");
        }
    }

    public final synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        this.fetch();
        buf.append("[");
        for (int i = 0; i < this.elementCount; ++i) {
            Object o;
            if (i > 0) {
                buf.append(", ");
            }
            if ((o = this.elementAt(i)) == null) {
                buf.append("(null)");
                continue;
            }
            ObjectStore.fetch(o);
            buf.append(o.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    private void recomputeHashCode() {
        this.ODITheHashCode = super.hashCode();
    }

    public static void setLazyAllocationDefault(boolean lazyDefault) {
        lazyAllocationDefault = lazyDefault;
    }

    public static boolean getLazyAllocationDefault() {
        return lazyAllocationDefault;
    }

    public boolean isLazy() {
        return this.elementEntryData == null;
    }

    @Override
    public synchronized Iterator iterator() {
        return new OSVectorIterator(this);
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] anArray = new Object[this.size()];
        this.copyInto(anArray);
        return anArray;
    }

    public Object[] toArray(Object[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            a[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public boolean add(Object obj) {
        this.addElement(obj);
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        return this.removeElement(obj);
    }

    public synchronized boolean containsAll(Collection coll) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean addAll(Collection coll) {
        if (coll.isEmpty()) {
            return false;
        }
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return true;
    }

    public synchronized boolean removeAll(Collection coll) {
        boolean modified = false;
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            int index = this.lastIndexOf(iter.next());
            if (index == -1) continue;
            modified = true;
            this.removeElementAt(index);
        }
        return modified;
    }

    public synchronized boolean retainAll(Collection coll) {
        boolean modified = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (coll.contains(obj)) continue;
            modified = true;
            iter.remove();
        }
        return modified;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    public Object get(int index) {
        return this.elementAt(index);
    }

    public synchronized Object set(int index, Object obj) {
        Object prev = this.elementAt(index);
        this.setElementAt(obj, index);
        return prev;
    }

    public void add(int index, Object obj) {
        this.insertElementAt(obj, index);
    }

    public synchronized Object remove(int index) {
        Object prev = this.elementAt(index);
        this.removeElementAt(index);
        return prev;
    }

    public synchronized void removeRange(int from, int to) {
        if (from < 0 || from >= this.size() || to > this.size() || to < from) {
            throw new IndexOutOfBoundsException("removeRange(" + from + "," + to + ")");
        }
        for (int i = from; i < to; ++i) {
            this.removeElementAt(from);
        }
    }

    public synchronized boolean addAll(int index, Collection coll) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("addAll(" + index + ",...)");
        }
        if (coll.isEmpty()) {
            return false;
        }
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            this.insertElementAt(iter.next(), index++);
        }
        return true;
    }

    public List subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    public synchronized ListIterator listIterator() {
        return new OSVectorIterator(this);
    }

    public synchronized ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("listIterator(" + index + ")");
        }
        return new OSVectorIterator(this, index);
    }
}

