/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.impl.ExecUtility;
import com.sonicsw.mf.common.runtime.impl.RemoteExecResult;
import com.sonicsw.mf.common.util.Container;
import com.sonicsw.mf.framework.agent.ContainerUtil;
import com.sonicsw.mf.framework.agent.PBE;
import com.sonicsw.mf.framework.agent.PBEString;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public final class ContainerSetup {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String SH_LAUNCHER_SCRIPT = "launchcontainer.sh";
    private static final String CENTRAL_CONNECTION_SETUP_PROP = "CENTRAL_CONNECTION";
    private static final String SONIC_CONTAINERS_DIR_FILE = "sonic_containers_directory.txt";
    static final String WIN_SERVICE_INSTALL_FAILED_TEXT = "com.sonicsw.mf.framework.agent.HostManager.setupContainer failed to install Windows Service: ";
    static final String SH_CHMOD_FAILURE_TEXT = "Failed to set the 'executable' bit of SH files: ";
    static final String UNIX_BATCH_LAUNCHER_SCRIPT = "launchcontainer_batch.sh";
    static final String INI_PROPS_FILE = "container_ini.prop";
    static final String WINDOWS_SERVICE_SCRIPT = "winservice.bat";
    static final String WINDOWS_SERVICE_NAME_PROP = "WINDOWS_SERVICE_NAME";
    public static final String CONTAINER_TEMPLATES_DIR = "container_templates";
    public static final boolean ON_WINDOWS = File.separatorChar == '\\';
    public static final String JAVA_EXEC = System.getProperty("java.home") + "/bin/java" + (ON_WINDOWS ? ".exe" : "");
    public static final String CONTAINER_INI_FILE = "container.ini";
    public static final String SONIC_HOME_SCRIPT_VAR = "SONIC_HOME";
    public static final String SONIC_LAUNCHER_JRE_PROP = "SONIC_LAUNCHER_JRE";
    private static final String SET_ENC_PWD_SCRIPT_NAME = "set_encryption_pwd";
    private static final String BAT_POSTFIX = ".BAT";
    private static final String SH_POSTFIX = ".SH";
    private static final String BAT_COMMENT = "REM";
    private static final String SH_COMMENT = "#";
    private static final String TAILOR_MARKER = "@";
    private static final String SONIC_LAUNCHER_VERSION_PROP = "SONIC_LAUNCHER_VERSION";
    private static final String DEFAULT_PROPS_FILE = "defaults.prop";
    private static final String MANDATORY_PROPS_FILE = "mandatory.prop";
    private static final String PATH_PROPS_FILE = "paths.prop";
    private static final String DFLT_USER_PROP = "DefaultUser";
    private static final String DFLT_PASSWORD_PROP = "DefaultPassword";
    private static final char BAT_PATH_DELIM = '\\';
    private static final char SH_PATH_DELIM = '/';
    private static final String DFLT_USER = System.getProperty("sonicsw.mf.DefaultUser");
    private static final String DFLT_PASSWORD = System.getProperty("sonicsw.mf.DefaultPassword");
    private static final String INI_ENC_PASSWORD = System.getProperty("sonicsw.mf.password");
    private String m_propValuesFileName;
    private Properties m_pathProps;

    public static void mainTest(String[] args) throws Exception {
        String encryptedFileName = "OOO_ENC";
        String clearedFileName = "OOO_CLEAR";
        String password = "my_password";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter p = new PrintWriter(out);
        p.println("udi");
        p.println("debbie");
        p.close();
        byte[] clearData = out.toByteArray();
        System.out.println("Encrypting with password " + password);
        byte[] encryptedData = PBE.encrypt(clearData, password);
        RandomAccessFile encFile = new RandomAccessFile(encryptedFileName, "rw");
        encFile.write(encryptedData);
        encFile.close();
        PBEString pbeString = new PBEString();
        String encryptedPwd = pbeString.encrypt(password);
        String clearPwd = new String(PBE.decrypt(encryptedPwd.getBytes()));
        System.out.println("Encrypting  password " + encryptedPwd);
        System.out.println("Decrypted  password " + clearPwd);
        File inpFile = new File(encryptedFileName);
        long dataLength = inpFile.length();
        RandomAccessFile src = new RandomAccessFile(encryptedFileName, "r");
        byte[] encData = new byte[(int)dataLength];
        src.read(encData);
        src.close();
        byte[] clearedBytes = PBE.decrypt(encData, clearPwd);
        encFile = new RandomAccessFile(clearedFileName, "rw");
        encFile.write(clearedBytes);
        encFile.close();
        System.out.println("Decrypted  with cleared password " + clearPwd);
    }

    public static void mainTestDMSetup(String[] args) throws Exception {
    }

    public static void main(String[] args) throws Exception {
        String propValuesFileName = args[0];
        String launcherFilesRootDirPath = args[1];
        ContainerSetup.setupContainer(args[1], args[0], null, null, INI_ENC_PASSWORD, true);
    }

    public static File setupContainer(String launcherFilesRootDirPath, Properties propValues) throws Exception {
        return ContainerSetup.setupContainer(launcherFilesRootDirPath, null, propValues, null, null, false);
    }

    public static File setupContainer(IDirectoryAdminService adminDS, String containerConfigPath, String dsConfigPath, String launcherVersion, String sonicHomePath, Properties unconfiguredProps, String INIEncPassword) throws Exception {
        IDirectoryFileSystemService fsDS = (IDirectoryFileSystemService)adminDS;
        String dsBootFileContent = dsConfigPath != null ? adminDS.exportDSBootFileString(fsDS.logicalToStorage(dsConfigPath)) : null;
        IDirElement containerConfig = adminDS.getElement(fsDS.logicalToStorage(containerConfigPath), false);
        File sonicHome = new File(sonicHomePath);
        File launcherHome = new File(sonicHome, "Launcher/" + launcherVersion);
        return ContainerSetup.setupContainer(containerConfigPath, (IElement)containerConfig, launcherHome.getAbsolutePath(), unconfiguredProps, dsBootFileContent, INIEncPassword);
    }

    static File setupContainer(String launcherFilesRootDirPath, Properties propValues, String INIEncPassword) throws Exception {
        return ContainerSetup.setupContainer(launcherFilesRootDirPath, null, propValues, null, INIEncPassword, false);
    }

    static File setupContainer(String containerDSPath, IElement containerConfig, String launcherFilesRootDirPath, Properties unconfiguredProps, String dsBootFileContent, String INIEncPassword) throws Exception {
        Container.bootConfigurationToSetupProp((IElement)containerConfig, (Properties)unconfiguredProps);
        unconfiguredProps.setProperty("CONTAINER_PATH", containerDSPath);
        Properties allProps = unconfiguredProps;
        return ContainerSetup.setupContainer(launcherFilesRootDirPath, null, allProps, dsBootFileContent, INIEncPassword, false);
    }

    private static File setupContainer(String launcherFilesRootDirPath, String propValuesFileName, Properties propValues, String dsBootFileContent, String INIEncPassword, boolean printMsg) throws Exception {
        Properties props = propValues;
        if (props == null) {
            props = ContainerUtil.readProperties(new FileInputStream(propValuesFileName));
        }
        String domainName = (String)props.get("DOMAIN_NAME");
        File launcherFilesRootDirFile = new File(launcherFilesRootDirPath);
        File sonicHome = launcherFilesRootDirFile.getParentFile().getParentFile();
        File containersDir = ContainerSetup.findSonicContainersDir(sonicHome);
        File templatesDir = new File(launcherFilesRootDirFile, CONTAINER_TEMPLATES_DIR);
        String templatesDirPath = templatesDir.getAbsolutePath();
        String containerPath = (String)props.get("CONTAINER_PATH");
        if (containerPath == null) {
            throw new IOException("The \"CONTAINER_PATH\" attribute  is missing");
        }
        EntityName pathE = new EntityName(containerPath);
        String containerName = pathE.getBaseName();
        File destDir = ContainerSetup.findContainerDir(containersDir, domainName, containerName);
        props.put(SONIC_HOME_SCRIPT_VAR, sonicHome.getAbsolutePath());
        props.put("WORKING_DIRECTORY", destDir.getAbsolutePath());
        if (!props.containsKey(SONIC_LAUNCHER_JRE_PROP)) {
            props.put(SONIC_LAUNCHER_JRE_PROP, JAVA_EXEC);
        }
        boolean windowsServiceWasSpecified = true;
        if (!props.containsKey(WINDOWS_SERVICE_NAME_PROP)) {
            windowsServiceWasSpecified = false;
            props.put(WINDOWS_SERVICE_NAME_PROP, "Sonic " + containerName + " Service (" + domainName + ")");
        }
        if (!templatesDir.exists()) {
            throw new IOException("The " + templatesDirPath + " directory does not exist.");
        }
        if (!templatesDir.isDirectory()) {
            throw new IOException(templatesDirPath + " is not a directory.");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new IOException(destDir.getAbsolutePath() + " is not a directory.");
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException("Failed to create " + destDir.getAbsolutePath());
        }
        String version = launcherFilesRootDirFile.getName();
        props.put(SONIC_LAUNCHER_VERSION_PROP, version);
        if (DFLT_USER != null) {
            props.put(DFLT_USER_PROP, DFLT_USER);
        }
        if (DFLT_PASSWORD != null) {
            props.put(DFLT_PASSWORD_PROP, DFLT_PASSWORD);
        }
        ContainerSetup setup = new ContainerSetup(propValuesFileName);
        setup.setDefaults(templatesDir, props);
        setup.checkManadatory(templatesDir, props);
        setup.createPathPropsTable(templatesDir);
        setup.tailorFiles(templatesDir, destDir, props);
        if (!ON_WINDOWS) {
            setup.createUnixBatchLauncher(destDir);
            ContainerSetup.unixChmodSHFilesToExecutables(destDir);
        }
        if (INIEncPassword == null) {
            setup.generateINIClearFile(templatesDir, destDir, props);
            new File(destDir, "set_encryption_pwd.bat").delete();
            new File(destDir, "set_encryption_pwd.sh").delete();
        } else {
            setup.generateINIEncryptedFile(templatesDir, destDir, props, INIEncPassword);
            setup.createEncryptionPwdScripts(destDir, INIEncPassword);
        }
        String winServiceName = (String)props.get(WINDOWS_SERVICE_NAME_PROP);
        if (dsBootFileContent != null) {
            ContainerUtil.encryptAndStore(dsBootFileContent, new File(destDir, "ds.xml").getAbsolutePath(), INIEncPassword);
        }
        if (ON_WINDOWS && windowsServiceWasSpecified) {
            ContainerSetup.registerWS(destDir, winServiceName, props);
        }
        if (printMsg) {
            String msg = "Container \"" + containerName + "\" was set up in \"" + destDir.getAbsolutePath() + "\"";
            System.out.println(ContainerUtil.createLogMessage(null, null, msg, 3));
        }
        return destDir;
    }

    private static void registerWS(File workingDir, String winServiceName, Properties properties) throws Exception {
        String containerPath = (String)properties.get("CONTAINER_PATH");
        if (containerPath == null) {
            throw new Exception("The \"CONTAINER_PATH\" property is mandatory");
        }
        String scriptName = new File(workingDir, WINDOWS_SERVICE_SCRIPT).getAbsolutePath();
        String[] exeCmd = new String[]{scriptName, "/remove"};
        ExecUtility.exec((String[])exeCmd, null, (String)workingDir.getAbsolutePath(), null);
        exeCmd = new String[]{scriptName, "/install"};
        RemoteExecResult result = ExecUtility.exec((String[])exeCmd, null, (String)workingDir.getAbsolutePath(), null);
        if (!result.isSuccessful()) {
            throw new Exception(WIN_SERVICE_INSTALL_FAILED_TEXT + result.getOutput());
        }
        String wsResultText = ExecUtility.execResultOutputToString((IRemoteExecResult)result);
        if (result.getExitCode() != 0) {
            throw new Exception(WIN_SERVICE_INSTALL_FAILED_TEXT + wsResultText);
        }
        if (wsResultText != null && wsResultText.length() > 0) {
            System.out.println("Windows Service registration message: " + wsResultText);
        }
    }

    public ContainerSetup() {
    }

    private ContainerSetup(String propValuesFileName) {
        this.m_propValuesFileName = propValuesFileName;
    }

    private void checkManadatory(File templatesDir, Properties tailorProps) throws IOException {
        Properties mandatoryProps = ContainerUtil.readProperties(new FileInputStream(new File(templatesDir, MANDATORY_PROPS_FILE)));
        Enumeration<Object> mandatoryList = mandatoryProps.keys();
        while (mandatoryList.hasMoreElements()) {
            String prop = (String)mandatoryList.nextElement();
            String description = (String)mandatoryProps.get(prop);
            if (prop.startsWith("connection.")) {
                prop = prop.substring("connection.".length());
            }
            if (tailorProps.containsKey(prop)) continue;
            throw new IOException("Mandatory property \"" + prop + "\" - " + description + " - is missing from " + (this.m_propValuesFileName != null ? this.m_propValuesFileName : "properties"));
        }
    }

    private void createPathPropsTable(File templatesDir) throws IOException {
        this.m_pathProps = ContainerUtil.readProperties(new FileInputStream(new File(templatesDir, PATH_PROPS_FILE)));
    }

    private void setDefaults(File templatesDir, Properties tailorProps) throws IOException {
        File defaults_file = new File(templatesDir, DEFAULT_PROPS_FILE);
        if (!defaults_file.exists()) {
            return;
        }
        Properties dfltProps = ContainerUtil.readProperties(new FileInputStream(defaults_file));
        Enumeration<Object> dfltList = dfltProps.keys();
        while (dfltList.hasMoreElements()) {
            String prop = (String)dfltList.nextElement();
            if (tailorProps.containsKey(prop)) continue;
            String val = (String)dfltProps.get(prop);
            tailorProps.put(prop, val);
        }
    }

    private void tailorFiles(File templatesDir, File destDir, Properties tailorProps) throws IOException {
        String[] templateFiles = templatesDir.list();
        for (int i = 0; i < templateFiles.length; ++i) {
            boolean batFile = ContainerSetup.isBATFile(templateFiles[i]);
            boolean shFile = ContainerSetup.isSHFile(templateFiles[i]);
            if (!batFile && !shFile || batFile && !ON_WINDOWS) continue;
            ContainerSetup.tailorFile(new File(templatesDir, templateFiles[i]), new File(destDir, templateFiles[i]), tailorProps, this.m_pathProps, ContainerSetup.isBATFile(templateFiles[i]));
        }
    }

    private void generateINIClearFile(File templatesDir, File destDir, Properties tailorProps) throws IOException {
        File generatedINIFile = new File(destDir, CONTAINER_INI_FILE);
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(generatedINIFile, false)), true);
        this.generateINI(templatesDir, writer, tailorProps);
    }

    private void generateINIEncryptedFile(File templatesDir, File destDir, Properties tailorProps, String INIEncPassword) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.generateINI(templatesDir, new PrintWriter(out), tailorProps);
        byte[] encryptedData = PBE.encrypt(out.toByteArray(), INIEncPassword);
        RandomAccessFile encFile = new RandomAccessFile(new File(destDir, CONTAINER_INI_FILE), "rw");
        encFile.write(encryptedData);
        encFile.close();
    }

    private void generateINI(File templatesDir, PrintWriter writer, Properties tailorProps) throws IOException {
        String temp = tailorProps.getProperty(CENTRAL_CONNECTION_SETUP_PROP);
        boolean centralConnection = temp == null ? false : new Boolean(temp);
        Properties props = ContainerUtil.readProperties(new FileInputStream(new File(templatesDir, INI_PROPS_FILE)));
        Enumeration<Object> iniList = props.keys();
        while (iniList.hasMoreElements()) {
            String val;
            String prop;
            String tailoredProp = prop = (String)iniList.nextElement();
            if (prop.startsWith("connection.")) {
                tailoredProp = prop.substring("connection.".length());
                if (centralConnection) {
                    prop = "CentralConnection." + tailoredProp;
                }
            }
            if ((val = (String)tailorProps.get(tailoredProp)) == null) continue;
            writer.println(prop + "=" + val);
        }
        Enumeration<Object> tailorPropList = tailorProps.keys();
        while (tailorPropList.hasMoreElements()) {
            String prop = (String)tailorPropList.nextElement();
            if (!prop.regionMatches(true, 0, "SystemProperty.", 0, "SystemProperty.".length())) continue;
            writer.println(prop + "=" + (String)tailorProps.get(prop));
        }
        writer.close();
    }

    private void createEncryptionPwdScripts(File destDir, String INIEncPassword) throws IOException {
        PrintWriter writer;
        StringBuffer sb;
        String tmp = new PBEString().encrypt(INIEncPassword);
        if (this.lastCharRemovable(tmp)) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (this.lastCharRemovable(tmp)) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        String encryptedPwd = tmp;
        if (ON_WINDOWS) {
            sb = new StringBuffer();
            sb.append("set PASSWORDPROPERTY=-D").append("sonicsw.mf.password").append("=").append(encryptedPwd).append(NEWLINE);
            sb.append("set WS_PASSWORDPROPERTY=").append(encryptedPwd);
            writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(new File(destDir, "set_encryption_pwd.bat"), false)), true);
            writer.println(sb.toString());
            writer.close();
        }
        sb = new StringBuffer();
        sb.append("#!/bin/sh").append(NEWLINE);
        sb.append("PASSWORDPROPERTY=\"-D").append("sonicsw.mf.password").append("=").append(encryptedPwd).append("\"");
        writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(new File(destDir, "set_encryption_pwd.sh"), false)), true);
        writer.println(sb.toString());
        writer.close();
    }

    private void createUnixBatchLauncher(File workingDir) throws IOException {
        String shLauncher = new File(workingDir, SH_LAUNCHER_SCRIPT).getAbsolutePath();
        File batchLauncher = new File(workingDir, UNIX_BATCH_LAUNCHER_SCRIPT);
        StringBuffer sb = new StringBuffer();
        sb.append("#!/bin/sh").append(NEWLINE);
        sb.append("\"").append(shLauncher).append("\" > \"$1\" 2>&1 &");
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(batchLauncher, false)), true);
        writer.println(sb.toString());
        writer.close();
    }

    private boolean lastCharRemovable(String encPwd) {
        if (encPwd.length() <= 1) {
            return false;
        }
        char lastChar = encPwd.charAt(encPwd.length() - 1);
        return lastChar == '\n' || lastChar == '\r';
    }

    public static void tailorFile(File srcFile, File trgtFile, Properties tailorProps, Properties pathProps, boolean batFile) throws IOException {
        String srcLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(srcFile)));
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(trgtFile, false)), true);
        while ((srcLine = reader.readLine()) != null) {
            String commentPrefix;
            String string = commentPrefix = batFile ? BAT_COMMENT : SH_COMMENT;
            if (srcLine.toUpperCase().startsWith(commentPrefix)) {
                writer.println(srcLine);
                continue;
            }
            writer.println(ContainerSetup.tailorLine(srcLine, tailorProps, pathProps, batFile));
        }
        reader.close();
        writer.close();
    }

    private static String tailorLine(String srcLine, Properties tailorProps, Properties pathProps, boolean batFile) {
        Enumeration<Object> tailorList = tailorProps.keys();
        String resultLine = srcLine;
        while (tailorList.hasMoreElements()) {
            String prop = (String)tailorList.nextElement();
            if (srcLine.indexOf(TAILOR_MARKER + prop + TAILOR_MARKER) == -1) continue;
            String val = (String)tailorProps.get(prop);
            if (pathProps.containsKey(prop)) {
                char newDelim = batFile ? (char)'\\' : '/';
                char oldDelim = batFile ? (char)'/' : '\\';
                val = val.replace(oldDelim, newDelim);
            }
            if (!batFile) {
                val = "\"" + val + "\"";
            }
            String oldString = TAILOR_MARKER + prop + TAILOR_MARKER;
            int start = srcLine.indexOf(oldString);
            resultLine = srcLine.substring(0, start);
            resultLine = resultLine + prop + "=" + val + srcLine.substring(start + oldString.length());
        }
        return resultLine;
    }

    public static void unixChmodSHFilesToExecutables(File rootDir) throws IOException {
        ArrayList shList = ContainerSetup.findSHFiles(rootDir);
        if (shList.isEmpty()) {
            return;
        }
        ContainerSetup.unixChmodSHFilesToExecutables(shList);
    }

    public static void unixChmodSHFilesToExecutables(ArrayList shList) throws IOException {
        String[] exeCmd = new String[shList.size() + 2];
        exeCmd[0] = "chmod";
        exeCmd[1] = "oug+x";
        for (int i = 0; i < shList.size(); ++i) {
            exeCmd[i + 2] = ((File)shList.get(i)).getAbsolutePath();
        }
        RemoteExecResult result = ExecUtility.exec((String[])exeCmd, null, (String)".", null);
        if (!result.isSuccessful()) {
            throw new IOException(SH_CHMOD_FAILURE_TEXT + result.getOutput());
        }
        if (result.getExitCode() != 0) {
            throw new IOException(SH_CHMOD_FAILURE_TEXT + ExecUtility.execResultOutputToString((IRemoteExecResult)result));
        }
    }

    public static File findSonicContainersDir(File sonicHome) throws IOException {
        File dirConfigurationFile = new File(sonicHome, SONIC_CONTAINERS_DIR_FILE);
        if (!dirConfigurationFile.exists()) {
            return new File(sonicHome, "Containers");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(dirConfigurationFile)));
        String line = reader.readLine();
        reader.close();
        if (line == null) {
            throw new IOException("The \"" + dirConfigurationFile.getAbsolutePath() + "\" file is empty");
        }
        String containersDirString = line.trim();
        File containersDir = new File(containersDirString);
        if (containersDir.isAbsolute()) {
            return containersDir;
        }
        return new File(sonicHome, containersDir.getPath());
    }

    public static File findContainerDir(File containersDir, String domainName, String containerName) {
        return new File(containersDir, domainName + "." + containerName);
    }

    private static ArrayList findSHFiles(File fileOrDir) {
        ArrayList list = new ArrayList();
        ContainerSetup.findFilesByType(list, fileOrDir, ".sh");
        return list;
    }

    private static void findFilesByType(ArrayList list, File fileOrDir, String type) {
        if (fileOrDir.isDirectory()) {
            if (fileOrDir.getName().endsWith(".cache")) {
                return;
            }
            String[] files = fileOrDir.list();
            for (int i = 0; i < files.length; ++i) {
                ContainerSetup.findFilesByType(list, new File(fileOrDir, files[i]), type);
            }
        } else if (fileOrDir.getPath().endsWith(type)) {
            list.add(fileOrDir);
        }
    }

    private static boolean isBATFile(String fileName0) {
        return ContainerSetup.isTypeFile(fileName0, BAT_POSTFIX);
    }

    private static boolean isSHFile(String fileName0) {
        return ContainerSetup.isTypeFile(fileName0, SH_POSTFIX);
    }

    private static boolean isTypeFile(String fileName0, String prefix) {
        String fileName = fileName0.toUpperCase();
        return fileName.endsWith(prefix);
    }
}

