/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.comm.ConnectTimeoutException;
import com.sonicsw.mf.comm.InvokeTimeoutCommsException;
import com.sonicsw.mf.comm.InvokeTimeoutException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.runtime.impl.ExecUtility;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponent;
import com.sonicsw.mf.framework.agent.EncryptionException;
import com.sonicsw.mf.framework.agent.PBE;
import com.sonicsw.mf.framework.agent.PBEString;
import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.LoaderInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ContainerUtil {
    private static final String CACHE_PWD_FILE = "p_file";
    private static final String FRAMEWORK_COMPONENT_INTERFACE_NAME = IFrameworkComponent.class.getName();
    private static final ThreadLocal<SimpleDateFormat> SIMPLE_DATE_FORMAT_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        }
    };

    static boolean isFrameworkComponent(Class componentClass) {
        Class<?>[] interfaces = componentClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(FRAMEWORK_COMPONENT_INTERFACE_NAME)) continue;
            return true;
        }
        Class superClass = componentClass.getSuperclass();
        if (superClass == null || superClass.getName().startsWith("java.")) {
            return false;
        }
        return ContainerUtil.isFrameworkComponent(superClass);
    }

    static void updateDefaultClassLoader(IContainer container, URLClassLoader classLoader, String classpath) throws Exception {
        if (classpath.length() == 0) {
            return;
        }
        URL[] urls = classLoader.getURLs();
        HashSet<File> set = new HashSet<File>();
        for (int i = 0; i < urls.length; ++i) {
            String path;
            if (!urls[i].getProtocol().equals("file") || (path = urls[i].getPath()).indexOf("_MFArchive") <= 0) continue;
            set.add(new File(path.substring(1)));
        }
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        block1: while (st.hasMoreElements()) {
            String path;
            URL url = new URL(st.nextToken());
            if (url.getProtocol().equals("file") && (path = url.getPath()).indexOf("_MFArchive") > -1) {
                File file = new File(path.substring(1));
                if (set.contains(file)) continue;
                File dir = file.getParentFile();
                String fileVersion = file.getName();
                String fileName = fileVersion.substring(fileVersion.indexOf(46) + 1);
                fileVersion = fileVersion.substring(0, fileVersion.indexOf(46));
                for (File existingFile : set) {
                    if (existingFile.equals(file)) continue block1;
                    File existingDir = existingFile.getParentFile();
                    if (!existingDir.equals(dir)) continue;
                    String existingFileVersion = existingFile.getName();
                    String existingFileName = existingFileVersion.substring(existingFileVersion.indexOf(46) + 1);
                    existingFileVersion = existingFileVersion.substring(0, existingFileVersion.indexOf(46));
                    if (!existingFileName.equals(fileName) || existingFileVersion.equals(fileVersion)) continue;
                    container.logMessage(null, "Component will be loaded using older code:" + IContainer.NEWLINE + IContainer.NEWLINE + "An older version of the cached archive \"" + fileName + "\" already exists on the container's classpath; " + "the container must be restarted to correct this." + IContainer.NEWLINE, 2);
                    continue block1;
                }
                set.add(file);
            }
            Class<?> classLoaderClass = classLoader.getClass();
            Method appendURLMethod = classLoaderClass.getMethod("appendURL", URL.class);
            appendURLMethod.invoke((Object)classLoader, url);
        }
    }

    static Object transferObject(Object obj, ClassLoader loader) {
        ByteArrayOutputStream arrayOut = new ByteArrayOutputStream(5120);
        try {
            ObjectOutputStream out = new ObjectOutputStream(arrayOut);
            out.writeObject(obj);
            out.flush();
        }
        catch (Exception e) {
            return obj;
        }
        try {
            ByteArrayInputStream arrayIn = new ByteArrayInputStream(arrayOut.toByteArray());
            LoaderInputStream in = new LoaderInputStream((InputStream)arrayIn, loader);
            return in.readObject();
        }
        catch (Exception e) {
            return obj;
        }
    }

    public static String extractDSConfigIDFromContainerConfig(IElement containerConfig) {
        IAttributeSet containerAttrs = containerConfig.getAttributes();
        IAttributeSet componentsAttrs = (IAttributeSet)containerAttrs.getAttribute("COMPONENTS");
        if (componentsAttrs == null) {
            return null;
        }
        Object[] components = componentsAttrs.getAttributes().entrySet().toArray();
        for (int i = 0; i < components.length; ++i) {
            Map.Entry componentEntry = (Map.Entry)components[i];
            String componentName = (String)componentEntry.getKey();
            if (!componentName.equals("DIRECTORY SERVICE")) continue;
            IAttributeSet compSet = (IAttributeSet)componentEntry.getValue();
            return ((Reference)compSet.getAttribute("CONFIG_REF")).getElementName();
        }
        return null;
    }

    public static IDirElement[] importConfigurations(File configFile, String encryptedPassword) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(configFile, "r");
        byte[] bytes = new byte[(int)raf.length()];
        raf.read(bytes);
        raf.close();
        if (encryptedPassword != null) {
            bytes = ContainerUtil.decryptBytes(bytes, encryptedPassword);
        }
        return ElementFactory.importElementsFromXML((String)new String(bytes), null);
    }

    public static IDirElement importConfiguration(File configFile, String encryptedPassword, String elType) throws Exception {
        IDirElement[] elements = ContainerUtil.importConfigurations(configFile, encryptedPassword);
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getIdentity().getType().equals(elType)) continue;
            return elements[i];
        }
        return null;
    }

    public static IDirElement importConfiguration(File configFile, String encryptedPassword) throws Exception {
        RandomAccessFile raf = new RandomAccessFile(configFile, "r");
        byte[] bytes = new byte[(int)raf.length()];
        raf.read(bytes);
        raf.close();
        if (encryptedPassword != null) {
            bytes = ContainerUtil.decryptBytes(bytes, encryptedPassword);
        }
        return ElementFactory.importFromXML((String)new String(bytes), null);
    }

    public static void encryptAndStore(String content, String filePath, String encryptedPassword) throws Exception {
        File storeFile = new File(filePath);
        if (encryptedPassword != null) {
            String clearPwd = new String(PBE.decrypt(encryptedPassword.getBytes()));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(out);
            writer.println(content);
            writer.close();
            byte[] encryptedData = PBE.encrypt(out.toByteArray(), clearPwd);
            storeFile.delete();
            RandomAccessFile encFile = new RandomAccessFile(storeFile, "rw");
            encFile.write(encryptedData);
            encFile.close();
        } else {
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(storeFile, false)), true);
            writer.println(content);
            writer.close();
        }
    }

    public static byte[] decryptBytes(byte[] bytes, String encryptedPassword) throws EncryptionException {
        String password = new String(PBE.decrypt(encryptedPassword.getBytes()));
        return PBE.decrypt(bytes, password);
    }

    public static String createLogMessage(String id, String message, int severityLevel) {
        return ContainerUtil.createLogMessage(null, id, message, severityLevel);
    }

    public static String createLogMessage(String containerID, String id, String message, int severityLevel) {
        StringBuffer timestampedMessage = new StringBuffer();
        timestampedMessage.append('[');
        timestampedMessage.append(SIMPLE_DATE_FORMAT_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis())));
        timestampedMessage.append("]");
        if (containerID != null) {
            timestampedMessage.append(" {");
            timestampedMessage.append(containerID);
            timestampedMessage.append('}');
        }
        if (id != null) {
            timestampedMessage.append(" ID=");
            timestampedMessage.append(id);
        }
        timestampedMessage.append(" (");
        timestampedMessage.append(Level.LEVEL_TEXT[severityLevel]);
        timestampedMessage.append(") ");
        timestampedMessage.append(message);
        return timestampedMessage.toString();
    }

    public static String appendThrowableToMessage(String message, Throwable exception) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(IContainer.NEWLINE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        ContainerUtil.printStackTrace(exception, writer);
        byte[] data = out.toByteArray();
        buffer.append(new String(data));
        return buffer.toString();
    }

    public static String printStackTrace(Throwable exception, String message) {
        return ExecUtility.printStackTrace((Throwable)exception, (String)message);
    }

    static void printStackTrace(Throwable exception, PrintWriter writer) {
        ExecUtility.printStackTrace((Throwable)exception, (PrintWriter)writer);
    }

    public static boolean isCausedByTimeout(Throwable exception) {
        Throwable cause;
        if (exception instanceof ConnectTimeoutException || exception instanceof InvokeTimeoutCommsException || exception instanceof InvokeTimeoutException) {
            return true;
        }
        Class<?> exceptionClass = exception.getClass();
        try {
            Method getTargetExceptionMethod = exceptionClass.getMethod("getTargetException", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable targetException = (Throwable)getTargetExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (targetException != null) {
                return ContainerUtil.isCausedByTimeout(targetException);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        try {
            Method getTargetErrorMethod = exceptionClass.getMethod("getTargetError", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable targetError = (Throwable)getTargetErrorMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (targetError != null) {
                return ContainerUtil.isCausedByTimeout(targetError);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        try {
            Method getLinkedExceptionMethod = exceptionClass.getMethod("getLinkedException", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable linkedException = (Throwable)getLinkedExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (linkedException != null) {
                return ContainerUtil.isCausedByTimeout(linkedException);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        try {
            Method getCauseMethod = exceptionClass.getMethod("getCause", IEmptyArray.EMPTY_CLASS_ARRAY);
            cause = (Throwable)getCauseMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (cause != null) {
                return ContainerUtil.isCausedByTimeout(cause);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
        try {
            Method getActualExceptionMethod = exceptionClass.getMethod("getActualException", IEmptyArray.EMPTY_CLASS_ARRAY);
            cause = (Throwable)getActualExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (cause != null) {
                return ContainerUtil.isCausedByTimeout(cause);
            }
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public static void storeCachePassword(File cacheDirectory, String password) throws Exception {
        File storageFile = new File(cacheDirectory, CACHE_PWD_FILE);
        if (password == null) {
            if (storageFile.exists()) {
                storageFile.delete();
            }
            return;
        }
        ObjectOutputStream storageStream = new ObjectOutputStream(new FileOutputStream(storageFile));
        storageStream.writeObject(new PBEString().encrypt(password));
        storageStream.close();
    }

    public static String retrieveCachePassword(File cacheDirectory, boolean delFile) throws Exception {
        File storageFile = new File(cacheDirectory, CACHE_PWD_FILE);
        if (!storageFile.exists()) {
            return null;
        }
        ObjectInputStream storageStream = new ObjectInputStream(new FileInputStream(storageFile));
        String pwd = new PBEString().decrypt((String)storageStream.readObject());
        storageStream.close();
        if (delFile) {
            storageFile.delete();
        }
        return pwd;
    }

    public static Properties readProperties(InputStream inputStream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        Properties props = new Properties();
        while ((line = reader.readLine()) != null) {
            int eqIndex = line.indexOf(61);
            if (eqIndex == -1) continue;
            String key = line.substring(0, eqIndex);
            String value = line.substring(eqIndex + 1);
            props.setProperty(key, value);
        }
        reader.close();
        return props;
    }
}

