/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.agent;

import com.sonicsw.mf.common.runtime.IFaultTolerantState;
import com.sonicsw.mf.common.runtime.NonRecoverableStateChangeException;
import com.sonicsw.mf.common.runtime.RecoverableStateChangeException;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.agent.ContainerImpl;
import com.sonicsw.mf.framework.util.StateManager;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import progress.message.jclient.DeliveryMode;

class PingThread
extends Thread
implements MessageListener {
    private static final String MESSAGE_TYPE = "MESSAGE_TYPE";
    private static final short REQUEST_MESSAGE = 1;
    private static final short REPLY_MESSAGE = 2;
    private static final String SENDER_FT_STATE = "SENDER_FT_STATE";
    private StateManager m_FTStateMgr;
    private ContainerImpl m_containerImpl;
    private Connection m_pingConnection;
    private Session m_pingSession;
    private String m_pingTopicName;
    private String m_pingTopicName4peer;
    private Topic m_pingTopic;
    private Topic m_pingTopic4peer;
    private MessageProducer m_sender;
    private MessageConsumer m_receiver;
    private volatile int m_pingInterval;
    private volatile int m_pingTimeout;
    private String m_ftRole;
    private boolean m_backupStartActive;
    private Object m_reqRepLock = new Object();
    private volatile String m_requestID;
    private volatile boolean m_hasReplied = false;
    private volatile Message m_reply = null;
    private volatile long m_lastPeerPingRequest;
    private volatile boolean m_isSuspended = false;

    PingThread(Connection connection, String topicName, String topicName4peer, int faultDetectInterval, int faultDetectTimeout, String ftRole, boolean backupStartActive, StateManager stateMgr, ContainerImpl containerImpl) throws JMSException {
        super("PingThread on topic " + topicName);
        this.m_containerImpl = containerImpl;
        this.m_FTStateMgr = stateMgr;
        this.m_pingInterval = faultDetectInterval;
        this.m_pingTimeout = faultDetectTimeout;
        this.m_ftRole = ftRole;
        this.m_backupStartActive = backupStartActive;
        this.m_pingConnection = connection;
        this.m_pingTopicName = topicName;
        this.m_pingTopicName4peer = topicName4peer;
        this.setupPingChannel();
    }

    Connection getConnection() {
        return this.m_pingConnection;
    }

    private synchronized void setupPingChannel() throws JMSException {
        this.cleanupPingChannel();
        if (this.m_pingConnection == null) {
            throw new JMSException("fault detect connection is null");
        }
        this.m_pingSession = this.m_pingConnection.createSession(false, 1);
        this.m_pingTopic4peer = this.m_pingSession.createTopic(this.m_pingTopicName4peer);
        this.m_sender = this.m_pingSession.createProducer(null);
        this.m_sender.setDeliveryMode(DeliveryMode.NON_PERSISTENT_REPLICATED);
        this.m_sender.setPriority(9);
        this.m_pingTopic = this.m_pingSession.createTopic(this.m_pingTopicName);
        this.m_receiver = this.m_pingSession.createConsumer((Destination)this.m_pingTopic);
        this.m_receiver.setMessageListener((MessageListener)this);
        this.m_pingConnection.start();
    }

    void setPingInterval(int pingInterval) {
        this.m_pingInterval = pingInterval;
    }

    void setPingTimeout(int pingTimeout) {
        this.m_pingTimeout = pingTimeout;
    }

    void setPingTopicNameForPeer(String topicName4peer) throws JMSException {
        this.m_pingTopicName4peer = topicName4peer;
        if (this.m_pingSession != null) {
            this.m_pingTopic4peer = this.m_pingSession.createTopic(this.m_pingTopicName4peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message request() throws JMSException, InterruptedException {
        TextMessage request = this.m_pingSession.createTextMessage();
        request.setShortProperty(MESSAGE_TYPE, (short)1);
        request.setShortProperty(SENDER_FT_STATE, this.m_FTStateMgr.getState(null));
        while (true) {
            Object object = this.m_reqRepLock;
            synchronized (object) {
                this.m_sender.send((Destination)this.m_pingTopic4peer, (Message)request);
                long startTime = System.currentTimeMillis();
                this.m_hasReplied = false;
                this.m_requestID = request.getJMSMessageID();
                if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0 && (this.m_containerImpl.m_agent.getTraceMask() & 1) > 0) {
                    this.m_containerImpl.logMessage(null, "FT container ping request sent, ID=" + this.m_requestID + ", timeout=" + this.m_pingTimeout, 7);
                }
                this.m_reqRepLock.wait(this.m_pingTimeout * 1000);
                if (this.m_hasReplied) {
                    return this.m_reply;
                }
                if (this.m_lastPeerPingRequest > System.currentTimeMillis() || this.m_lastPeerPingRequest < startTime) break;
            }
        }
        return null;
    }

    @Override
    public void run() {
        try {
            JMSException lastJMSException = null;
            while (!this.isInterrupted()) {
                try {
                    Message reply = this.request();
                    if (!this.m_isSuspended) {
                        this.handleReply(reply);
                    }
                    if (lastJMSException != null) {
                        this.m_containerImpl.logMessage(null, "...FT container ping request sent", 2);
                    }
                    lastJMSException = null;
                }
                catch (JMSException jmsE) {
                    if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0) {
                        this.m_containerImpl.logMessage(null, "Failed to send FT container ping request, trace follows...", jmsE, 7);
                        this.m_containerImpl.logMessage(null, "retrying ...", 7);
                    } else if (lastJMSException == null) {
                        this.m_containerImpl.logMessage(null, "Failed to send FT container ping request, retrying ...", 2);
                    }
                    lastJMSException = jmsE;
                }
                PingThread.sleep(this.m_pingInterval * 1000);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.cleanupPingChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleReply(Message reply) {
        int peerFTState = -1;
        if (reply == null) {
            peerFTState = 99;
            if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0) {
                this.m_containerImpl.logMessage(null, "FT container ping timeout", 7);
            }
        } else {
            try {
                peerFTState = reply.getShortProperty(SENDER_FT_STATE);
                if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0 && (this.m_containerImpl.m_agent.getTraceMask() & 1) > 0) {
                    this.m_containerImpl.logMessage(null, "FT container ping reply received, ID=" + reply.getJMSCorrelationID() + ", peer state=" + IFaultTolerantState.STATE_TEXT[peerFTState], 7);
                }
            }
            catch (JMSException jmsE) {
                IContainer container = ContainerImpl.getContainer();
                if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0) {
                    container.logMessage(null, "Failed to get the FT container peer state, trace follows...", jmsE, 7);
                    container.logMessage(null, "retrying...", jmsE, 7);
                }
                container.logMessage(null, "Failed to get the FT container peer state, retrying...", 2);
            }
        }
        try {
            if (this.m_ftRole.equalsIgnoreCase("PRIMARY")) {
                switch (this.m_FTStateMgr.getState(null)) {
                    case 1: {
                        switch (peerFTState) {
                            case 2: {
                                this.m_FTStateMgr.requestStateChange((short)1, (short)3, null);
                                return;
                            }
                            case 1: 
                            case 3: 
                            case 99: {
                                this.m_containerImpl.setFailingOver(true);
                                this.m_FTStateMgr.requestStateChange((short)1, (short)2, null);
                                return;
                            }
                        }
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        switch (peerFTState) {
                            case 2: {
                                return;
                            }
                            case 1: 
                            case 3: 
                            case 99: {
                                Boolean allowFailover = null;
                                if (this.m_containerImpl != null) {
                                    allowFailover = this.m_containerImpl.getAllowFailover();
                                }
                                if (allowFailover == null) return;
                                if (allowFailover == false) return;
                                this.m_containerImpl.setFailingOver(true);
                                this.m_FTStateMgr.requestStateChange((short)3, (short)2, null);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            if (!this.m_ftRole.equalsIgnoreCase("BACKUP")) return;
            switch (this.m_FTStateMgr.getState(null)) {
                case 1: {
                    switch (peerFTState) {
                        case 2: {
                            this.m_FTStateMgr.requestStateChange((short)1, (short)3, null);
                            return;
                        }
                        case 1: 
                        case 3: {
                            return;
                        }
                        case 99: {
                            if (!this.m_backupStartActive) break;
                            this.m_containerImpl.setFailingOver(true);
                            this.m_FTStateMgr.requestStateChange((short)1, (short)2, null);
                            return;
                        }
                    }
                    return;
                }
                case 2: {
                    switch (peerFTState) {
                        case 2: {
                            this.m_FTStateMgr.requestStateChange((short)2, (short)3, null);
                            return;
                        }
                    }
                    return;
                }
                case 3: {
                    switch (peerFTState) {
                        case 3: 
                        case 99: {
                            Boolean allowFailover = null;
                            if (this.m_containerImpl != null) {
                                allowFailover = this.m_containerImpl.getAllowFailover();
                            }
                            if (allowFailover == null) return;
                            if (allowFailover == false) return;
                            this.m_containerImpl.setFailingOver(true);
                            this.m_FTStateMgr.requestStateChange((short)3, (short)2, null);
                            return;
                        }
                    }
                    return;
                }
            }
            return;
        }
        catch (RecoverableStateChangeException re) {
            this.m_containerImpl.logMessage(null, re, 2);
            return;
        }
        catch (NonRecoverableStateChangeException nre) {
            this.m_containerImpl.logMessage(null, nre, 2);
            return;
        }
        finally {
            this.m_containerImpl.setFailingOver(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        block11: {
            try {
                Object reply;
                if (msg == null) {
                    return;
                }
                if (msg.getShortProperty(MESSAGE_TYPE) == 1) {
                    this.m_lastPeerPingRequest = System.currentTimeMillis();
                    Message request = msg;
                    this.m_requestID = request.getJMSMessageID();
                    if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0 && (this.m_containerImpl.m_agent.getTraceMask() & 1) > 0) {
                        this.m_containerImpl.logMessage(null, "FT container ping request received, ID=" + this.m_requestID + ", timeout=" + this.m_pingTimeout, 7);
                    }
                    reply = this.m_pingSession.createTextMessage();
                    reply.setShortProperty(MESSAGE_TYPE, (short)2);
                    reply.setShortProperty(SENDER_FT_STATE, this.m_FTStateMgr.getState(null));
                    reply.setJMSCorrelationID(this.m_requestID);
                    this.m_sender.send((Destination)this.m_pingTopic4peer, (Message)reply);
                    if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0 && (this.m_containerImpl.m_agent.getTraceMask() & 1) > 0) {
                        this.m_containerImpl.logMessage(null, "FT container ping reply sent, ID=" + this.m_requestID, 7);
                    }
                }
                if (msg.getShortProperty(MESSAGE_TYPE) != 2) break block11;
                String correlationID = msg.getJMSCorrelationID();
                reply = this.m_reqRepLock;
                synchronized (reply) {
                    if (correlationID.equals(this.m_requestID)) {
                        this.m_reply = msg;
                        this.m_hasReplied = true;
                        this.m_reqRepLock.notifyAll();
                    }
                }
            }
            catch (JMSException e) {
                IContainer container = ContainerImpl.getContainer();
                if ((this.m_containerImpl.m_agent.getTraceMask() & 0x800) > 0) {
                    this.m_containerImpl.logMessage(null, "FT container ping failure, trace follows...", e, 7);
                    this.m_containerImpl.logMessage(null, "retrying...", 7);
                }
                container.logMessage(null, "FT container ping failure, retrying...", 2);
            }
        }
    }

    synchronized void suspendActiveState() {
        try {
            this.m_isSuspended = this.m_FTStateMgr.requestStateChange((short)2, (short)3, null);
            if (!this.m_isSuspended) {
                IContainer container = ContainerImpl.getContainer();
                container.logMessage(null, "Failed to suspend the container from " + IFaultTolerantState.STATE_TEXT[this.m_FTStateMgr.getState(null)], 2);
            }
        }
        catch (RecoverableStateChangeException re) {
            this.m_containerImpl.logMessage(null, re, 2);
        }
        catch (NonRecoverableStateChangeException nre) {
            this.m_containerImpl.logMessage(null, nre, 2);
        }
    }

    synchronized void resumeAfterSuspend() {
        this.m_isSuspended = false;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.cleanupPingChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cleanupPingChannel() {
        if (this.m_receiver != null) {
            try {
                this.m_receiver.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            finally {
                this.m_receiver = null;
            }
        }
        if (this.m_sender != null) {
            try {
                this.m_sender.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            finally {
                this.m_sender = null;
            }
        }
        if (this.m_pingSession != null) {
            try {
                this.m_pingSession.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            finally {
                this.m_pingSession = null;
            }
        }
    }
}

