/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IValidationElementChange;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.DeltaElement;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.VersionMisMatchException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.framework.directory.impl.DirectoryService;
import com.sonicsw.mf.framework.directory.storage.PackedDirUtil;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class BackReferenceMgr {
    protected DirectoryService m_ds;
    protected IDirElement m_backRefTypeListElement;
    private boolean m_isRestrictedBackupDS;
    public static final String BACK_REF_TYPE_LIST_ELEMENT = "back_ref_type_list";
    public static final String BACK_REF_DIR = "back_refs";
    private static final String BACK_REF_TYPE_LIST_ELEMENT_PATH = "/_MFSchema/back_ref_type_list";
    private static final String BACK_REF_DIR_PATH = "/_MFSystem/back_refs";

    public BackReferenceMgr(DirectoryService ds, boolean isRestrictedBackupDS) throws DirectoryServiceException {
        this.m_ds = ds;
        this.m_isRestrictedBackupDS = isRestrictedBackupDS;
        this.setBackReferenceTypes(IEmptyArray.EMPTY_STRING_ARRAY, false);
    }

    public void setBackReferenceTypes(String[] typeList) throws DirectoryServiceException {
        this.setBackReferenceTypes(typeList, false);
    }

    public void setBackReferencesTypes(Element backRefElement) throws DirectoryServiceException {
        IAttributeSet typeAttrs = backRefElement.getAttributes();
        Set typeKeys = typeAttrs.getAttributes().keySet();
        String[] typeNames = new String[typeKeys.size()];
        typeKeys.toArray(typeNames);
        this.setBackReferenceTypes(typeNames, true);
    }

    static String getBackRefElementPath() {
        return BACK_REF_TYPE_LIST_ELEMENT_PATH;
    }

    private void setBackReferenceTypes(String[] typeList, boolean deleteOld) throws DirectoryServiceException {
        try {
            IDirElement element = this.m_ds.getElement(BACK_REF_TYPE_LIST_ELEMENT_PATH, false);
            if (this.m_isRestrictedBackupDS) {
                this.m_backRefTypeListElement = element;
                return;
            }
            HashMap existingTypes = null;
            if (element != null) {
                existingTypes = element.getAttributes().getAttributes();
                this.m_ds.deleteElement(BACK_REF_TYPE_LIST_ELEMENT_PATH, null);
            }
            this.m_backRefTypeListElement = ElementFactory.createElement((String)BACK_REF_TYPE_LIST_ELEMENT_PATH, (String)"backRefTypeList", (String)"100");
            IAttributeSet refTypes = this.m_backRefTypeListElement.getAttributes();
            if (existingTypes != null && !deleteOld) {
                for (String type : existingTypes.keySet()) {
                    refTypes.setStringAttribute(type, type);
                }
            }
            for (int i = 0; i < typeList.length; ++i) {
                String[] typesNotSupported = PackedDirUtil.ELEMENT_PACKING_TYPES;
                for (int j = 0; j < typesNotSupported.length; ++j) {
                    if (!typeList[i].equals(typesNotSupported[j])) continue;
                    throw new DirectoryServiceException("The " + typeList[i] + " type cannot be defined for back reference support.");
                }
                refTypes.setStringAttribute(typeList[i], typeList[i]);
            }
            this.m_ds.setElement(this.m_backRefTypeListElement.doneUpdate(), null);
        }
        catch (ConfigException e) {
            throw new Error(e.toString(), e);
        }
    }

    public String[] getBackReferenceTypes() throws DirectoryServiceException {
        return this.m_backRefTypeListElement.getAttributes().getAttributes().keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    public void resetBackReferences() throws DirectoryServiceException {
        this.setBackReferenceTypes(IEmptyArray.EMPTY_STRING_ARRAY, true);
    }

    void deleteBackRefDir() throws DirectoryServiceException {
        this.deleteDirectory(BACK_REF_DIR_PATH);
    }

    void scanDSandPopulateBackRefTree() throws DirectoryServiceException {
        IDirElement[] elements = this.m_ds.getAllElements("/", false);
        for (int i = 0; i < elements.length; ++i) {
            this.elementCreated(elements[i]);
        }
        IDirIdentity[] dids = this.m_ds.listDirectories("/");
        for (int i = 0; i < dids.length; ++i) {
            if (dids[i].getName().startsWith("_MFSystem")) continue;
            this.scanDSandPopulateBackRefTree(dids[i].getName());
        }
    }

    void scanDSandPopulateBackRefTree(String dirPath) throws DirectoryServiceException {
        IDirElement[] elements = this.m_ds.getAllElements(dirPath, false);
        for (int i = 0; i < elements.length; ++i) {
            this.elementCreated(elements[i]);
        }
        IDirIdentity[] dids = this.m_ds.listDirectories(dirPath);
        for (int i = 0; i < dids.length; ++i) {
            this.scanDSandPopulateBackRefTree(dids[i].getName());
        }
    }

    public AttributeName[] getReferences(String elementPath) throws DirectoryServiceException {
        try {
            IDirElement backRefElement = this.getBackRefElement(elementPath, true);
            if (backRefElement == null) {
                return new AttributeName[0];
            }
            Collection backRefs = backRefElement.getAttributes().getAttributes().values();
            AttributeName[] references = new AttributeName[backRefs.size()];
            Iterator it = backRefs.iterator();
            int i = 0;
            while (it.hasNext()) {
                byte[] bytes = (byte[])it.next();
                ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                ObjectInputStream objectIn = new ObjectInputStream(in);
                references[i] = (AttributeName)objectIn.readObject();
                ++i;
            }
            return references;
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to references to " + elementPath, (Throwable)e);
        }
    }

    public void addBackReference(String referToElement, AttributeName attrName) throws DirectoryServiceException {
        try {
            IDirElement backRefElement = this.getBackRefElement(referToElement);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(attrName);
            byte[] bytes = out.toByteArray();
            objectOut.close();
            backRefElement.getAttributes().setBytesAttribute(attrName.toString(), bytes);
            this.setBackRefElement(referToElement, backRefElement);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to add back reference '" + attrName + "' to " + referToElement, (Throwable)e);
        }
    }

    public void deleteBackReference(String referToElement, AttributeName attrName) throws DirectoryServiceException {
        try {
            IDirElement backRefElement = this.getBackRefElement(referToElement);
            backRefElement.getAttributes().deleteAttribute(attrName.toString());
            this.setBackRefElement(referToElement, backRefElement);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to delete back reference '" + attrName + "' to " + referToElement, (Throwable)e);
        }
    }

    public void updateBackReferences(IValidationElementChange[] changes) throws DirectoryServiceException {
        try {
            block7: for (int i = 0; i < changes.length; ++i) {
                switch (changes[i].getChangeType()) {
                    case 0: {
                        this.elementCreated((IDirElement)changes[i].getElement());
                        continue block7;
                    }
                    case 1: {
                        IDirElement currentElement = (IDirElement)changes[i].getBeforeImage();
                        IDeltaElement delta = (IDeltaElement)changes[i].getElement();
                        this.elementModified(currentElement, delta);
                        continue block7;
                    }
                    case 2: {
                        IDirElement deletedElement = (IDirElement)changes[i].getBeforeImage();
                        if (deletedElement == null) continue block7;
                        this.elementDeleted(deletedElement);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to update back references", (Throwable)e);
        }
    }

    public void elementCreated(IDirElement element) throws DirectoryServiceException {
        try {
            this.updateBackReferences(null, element);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to create back references", (Throwable)e);
        }
    }

    public void elementModified(IDirElement currentElement, IDeltaElement delta) throws DirectoryServiceException {
        try {
            IDirElement updatedElement = (IDirElement)currentElement.createWritableClone();
            ((Element)updatedElement).doApplyDelta((IDeltaElement)((DeltaElement)delta).createClone());
            this.updateBackReferences(currentElement, updatedElement);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to update back references", (Throwable)e);
        }
    }

    public void elementDeleted(IDirElement element) throws DirectoryServiceException {
        try {
            this.deleteBackReferences(element);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to delete back references", (Throwable)e);
        }
    }

    public void elementDeleted(String elementName) throws DirectoryServiceException {
        this.elementDeleted(this.m_ds.getElementAsIs(elementName, true));
    }

    public void updateBackReferences(IDirElement currentElement, IDirElement updatedElement) throws DirectoryServiceException {
        try {
            String referToElement;
            if (!this.tracksReferences(updatedElement)) {
                return;
            }
            HashMap addedRefs = new HashMap();
            HashMap deletedRefs = new HashMap();
            BackReferenceMgr.getReferenceChanges(currentElement, updatedElement, addedRefs, deletedRefs);
            for (AttributeName addedRefAttr : addedRefs.keySet()) {
                referToElement = (String)addedRefs.get(addedRefAttr);
                if (referToElement.indexOf("/NO_STORAGE:") != -1) continue;
                this.addBackReference(referToElement, addedRefAttr);
            }
            for (AttributeName deletedRefAttr : deletedRefs.keySet()) {
                referToElement = (String)deletedRefs.get(deletedRefAttr);
                if (referToElement.indexOf("/NO_STORAGE:") != -1) continue;
                this.deleteBackReference(referToElement, deletedRefAttr);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to update back references", (Throwable)e);
        }
    }

    public void deleteBackReferences(IDirElement element) throws DirectoryServiceException {
        try {
            if (!this.tracksReferences(element)) {
                return;
            }
            HashMap references = new HashMap();
            BackReferenceMgr.findReferences(element, references);
            for (AttributeName deletedRefAttr : references.keySet()) {
                String referToElement = (String)references.get(deletedRefAttr);
                if (referToElement.indexOf("/NO_STORAGE:") != -1) continue;
                this.deleteBackReference(referToElement, deletedRefAttr);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to delete back references", (Throwable)e);
        }
    }

    public static void getReferenceChanges(IDirElement currentElement, IDirElement updatedElement, HashMap addedRefs, HashMap deletedRefs) throws VersionMisMatchException {
        HashMap updatedReferences = new HashMap();
        BackReferenceMgr.findReferences(updatedElement, updatedReferences);
        if (currentElement == null) {
            addedRefs.putAll(updatedReferences);
            return;
        }
        HashMap currentReferences = new HashMap();
        BackReferenceMgr.findReferences(currentElement, currentReferences);
        for (AttributeName currentRefAttr : currentReferences.keySet()) {
            if (updatedReferences.containsKey(currentRefAttr)) {
                if (currentReferences.get(currentRefAttr).equals(updatedReferences.get(currentRefAttr))) continue;
                addedRefs.put(currentRefAttr, updatedReferences.get(currentRefAttr));
                deletedRefs.put(currentRefAttr, currentReferences.get(currentRefAttr));
                continue;
            }
            deletedRefs.put(currentRefAttr, currentReferences.get(currentRefAttr));
        }
        for (AttributeName updatedRefAttr : updatedReferences.keySet()) {
            if (currentReferences.containsKey(updatedRefAttr)) continue;
            addedRefs.put(updatedRefAttr, updatedReferences.get(updatedRefAttr));
        }
    }

    public static void findReferences(IDirElement element, HashMap references) {
        boolean subclassOnly = element.getSuperElementName() != null;
        BackReferenceMgr.findReferences(element.getAttributes(), references, new AttributeName(element.getIdentity().getName(), true));
    }

    public static void findReferences(IAttributeSet attSet, HashMap references, AttributeName myName) {
        HashMap map = attSet.getAttributes();
        Set keys = map.keySet();
        for (String key : keys) {
            Object value = map.get(key);
            if (value instanceof IAttributeSet) {
                BackReferenceMgr.findReferences((IAttributeSet)value, references, myName.createClone().setNextComponent(key));
                continue;
            }
            if (value instanceof IAttributeList) {
                BackReferenceMgr.findReferences((IAttributeList)value, references, myName.createClone().setNextComponent(key));
                continue;
            }
            if (!(value instanceof Reference)) continue;
            references.put(myName.createClone().setNextComponent(key), ((Reference)value).getElementName());
        }
    }

    public static void findReferences(IAttributeList attList, HashMap references, AttributeName myName) {
        for (int i = 0; i < attList.getCount(); ++i) {
            Object value = attList.getItem(i);
            if (value instanceof IAttributeSet) {
                BackReferenceMgr.findReferences((IAttributeSet)value, references, myName.createClone().setNextComponent(i));
                continue;
            }
            if (value instanceof IAttributeList) {
                BackReferenceMgr.findReferences((IAttributeList)value, references, myName.createClone().setNextComponent(i));
                continue;
            }
            if (!(value instanceof Reference)) continue;
            references.put(myName.createClone().setNextComponent(i), ((Reference)value).getElementName());
        }
    }

    IDirElement getBackRefElement(String elementName) throws DirectoryServiceException {
        return this.getBackRefElement(elementName, false);
    }

    IDirElement getBackRefElement(String elementName, boolean doNotCreate) throws DirectoryServiceException {
        try {
            IDirElement element = null;
            EntityName name = new EntityName(BACK_REF_DIR_PATH + elementName);
            try {
                element = this.m_ds.getStorage().getElement(name);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (element == null && !doNotCreate) {
                element = ElementFactory.createElement((String)(BACK_REF_DIR_PATH + elementName), (String)"backRef", (String)"100");
                this.m_ds.getStorage().setElement(name, element, true);
            }
            return element;
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to get back references for " + elementName, (Throwable)e);
        }
    }

    void setBackRefElement(String elementName, IDirElement element) throws DirectoryServiceException {
        try {
            EntityName name = new EntityName(BACK_REF_DIR_PATH + elementName);
            if (element.getAttributes().getAttributes().size() == 0) {
                this.m_ds.getStorage().deleteElement(name);
            } else {
                this.m_ds.getStorage().setElement(name, element, true);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to set back references for " + elementName, (Throwable)e);
        }
    }

    void deleteBackRefElement(String elementName) throws DirectoryServiceException {
        try {
            EntityName name = new EntityName(BACK_REF_DIR_PATH + elementName);
            this.m_ds.getStorage().deleteElement(name);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to delete back references for " + elementName, (Throwable)e);
        }
    }

    boolean tracksReferences(IDirElement element) {
        Object tmp = this.m_backRefTypeListElement.getAttributes().getAttribute(element.getIdentity().getType());
        return tmp != null;
    }

    void deleteDirectory(String path) throws DirectoryServiceException {
        try {
            EntityName name = new EntityName(path);
            if (!this.m_ds.getStorage().directoryExists(name)) {
                return;
            }
            IElementIdentity[] ids = this.m_ds.getStorage().listElements(name);
            for (int i = 0; i < ids.length; ++i) {
                this.m_ds.getStorage().deleteElement(new EntityName(ids[i].getName()));
            }
            IDirIdentity[] dirIds = this.m_ds.getStorage().listDirectories(name);
            for (int i = 0; i < dirIds.length; ++i) {
                this.deleteDirectory(dirIds[i].getName());
            }
            this.m_ds.getStorage().deleteDirectory(name);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Failed to delete directory '" + path + "'", (Throwable)e);
        }
    }
}

