/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.function.Double9Function;
import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.RCDoubleMatrix2D;
import cern.colt.matrix.impl.SelectedDenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;

public class DenseDoubleMatrix2D
extends DoubleMatrix2D {
    static final long serialVersionUID = 1020177651L;
    protected double[] elements;

    public DenseDoubleMatrix2D(double[][] dArray) {
        this(dArray.length, dArray.length == 0 ? 0 : dArray[0].length);
        this.assign(dArray);
    }

    public DenseDoubleMatrix2D(int n, int n2) {
        this.setUp(n, n2);
        this.elements = new double[n * n2];
    }

    protected DenseDoubleMatrix2D(int n, int n2, double[] dArray, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = dArray;
        this.isNoView = false;
    }

    public DoubleMatrix2D assign(double[][] dArray) {
        if (this.isNoView) {
            if (dArray.length != this.rows) {
                throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
            }
            int n = this.columns * (this.rows - 1);
            int n2 = this.rows;
            while (--n2 >= 0) {
                double[] dArray2 = dArray[n2];
                if (dArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + this.columns());
                }
                System.arraycopy(dArray2, 0, this.elements, n, this.columns);
                n -= this.columns;
            }
        } else {
            super.assign(dArray);
        }
        return this;
    }

    public DoubleMatrix2D assign(double d) {
        double[] dArray = this.elements;
        int n = this.index(0, 0);
        int n2 = this.columnStride;
        int n3 = this.rowStride;
        int n4 = this.rows;
        while (--n4 >= 0) {
            int n5 = n;
            int n6 = this.columns;
            while (--n6 >= 0) {
                dArray[n5] = d;
                n5 += n2;
            }
            n += n3;
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleFunction doubleFunction) {
        double[] dArray = this.elements;
        if (dArray == null) {
            throw new InternalError();
        }
        int n = this.index(0, 0);
        int n2 = this.columnStride;
        int n3 = this.rowStride;
        if (doubleFunction instanceof Mult) {
            double d = ((Mult)doubleFunction).multiplicator;
            if (d == 1.0) {
                return this;
            }
            if (d == 0.0) {
                return this.assign(0.0);
            }
            int n4 = this.rows;
            while (--n4 >= 0) {
                int n5 = n;
                int n6 = this.columns;
                while (--n6 >= 0) {
                    int n7 = n5;
                    dArray[n7] = dArray[n7] * d;
                    n5 += n2;
                }
                n += n3;
            }
        } else {
            int n8 = this.rows;
            while (--n8 >= 0) {
                int n9 = n;
                int n10 = this.columns;
                while (--n10 >= 0) {
                    dArray[n9] = doubleFunction.apply(dArray[n9]);
                    n9 += n2;
                }
                n += n3;
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        Object object;
        if (!(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            return super.assign(doubleMatrix2D);
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        if (denseDoubleMatrix2D == this) {
            return this;
        }
        this.checkShape(denseDoubleMatrix2D);
        if (this.isNoView && denseDoubleMatrix2D.isNoView) {
            System.arraycopy(denseDoubleMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseDoubleMatrix2D)) {
            object = denseDoubleMatrix2D.copy();
            if (!(object instanceof DenseDoubleMatrix2D)) {
                return super.assign(denseDoubleMatrix2D);
            }
            denseDoubleMatrix2D = (DenseDoubleMatrix2D)object;
        }
        object = this.elements;
        double[] dArray = denseDoubleMatrix2D.elements;
        if (object == null || dArray == null) {
            throw new InternalError();
        }
        int n = this.columnStride;
        int n2 = denseDoubleMatrix2D.columnStride;
        int n3 = this.rowStride;
        int n4 = denseDoubleMatrix2D.rowStride;
        int n5 = denseDoubleMatrix2D.index(0, 0);
        int n6 = this.index(0, 0);
        int n7 = this.rows;
        while (--n7 >= 0) {
            int n8 = n6;
            int n9 = n5;
            int n10 = this.columns;
            while (--n10 >= 0) {
                object[n8] = dArray[n9];
                n8 += n;
                n9 += n2;
            }
            n6 += n3;
            n5 += n4;
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D, DoubleDoubleFunction doubleDoubleFunction) {
        if (!(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            return super.assign(doubleMatrix2D, doubleDoubleFunction);
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        this.checkShape(doubleMatrix2D);
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix2D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        int n = this.columnStride;
        int n2 = denseDoubleMatrix2D.columnStride;
        int n3 = this.rowStride;
        int n4 = denseDoubleMatrix2D.rowStride;
        int n5 = denseDoubleMatrix2D.index(0, 0);
        int n6 = this.index(0, 0);
        if (doubleDoubleFunction == Functions.mult) {
            int n7 = this.rows;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = n5;
                int n10 = this.columns;
                while (--n10 >= 0) {
                    int n11 = n8;
                    dArray[n11] = dArray[n11] * dArray2[n9];
                    n8 += n;
                    n9 += n2;
                }
                n6 += n3;
                n5 += n4;
            }
        } else if (doubleDoubleFunction == Functions.div) {
            int n12 = this.rows;
            while (--n12 >= 0) {
                int n13 = n6;
                int n14 = n5;
                int n15 = this.columns;
                while (--n15 >= 0) {
                    int n16 = n13;
                    dArray[n16] = dArray[n16] / dArray2[n14];
                    n13 += n;
                    n14 += n2;
                }
                n6 += n3;
                n5 += n4;
            }
        } else if (doubleDoubleFunction instanceof PlusMult) {
            double d = ((PlusMult)doubleDoubleFunction).multiplicator;
            if (d == 0.0) {
                return this;
            }
            if (d == 1.0) {
                int n17 = this.rows;
                while (--n17 >= 0) {
                    int n18 = n6;
                    int n19 = n5;
                    int n20 = this.columns;
                    while (--n20 >= 0) {
                        int n21 = n18;
                        dArray[n21] = dArray[n21] + dArray2[n19];
                        n18 += n;
                        n19 += n2;
                    }
                    n6 += n3;
                    n5 += n4;
                }
            } else if (d == -1.0) {
                int n22 = this.rows;
                while (--n22 >= 0) {
                    int n23 = n6;
                    int n24 = n5;
                    int n25 = this.columns;
                    while (--n25 >= 0) {
                        int n26 = n23;
                        dArray[n26] = dArray[n26] - dArray2[n24];
                        n23 += n;
                        n24 += n2;
                    }
                    n6 += n3;
                    n5 += n4;
                }
            } else {
                int n27 = this.rows;
                while (--n27 >= 0) {
                    int n28 = n6;
                    int n29 = n5;
                    int n30 = this.columns;
                    while (--n30 >= 0) {
                        int n31 = n28;
                        dArray[n31] = dArray[n31] + d * dArray2[n29];
                        n28 += n;
                        n29 += n2;
                    }
                    n6 += n3;
                    n5 += n4;
                }
            }
        } else {
            int n32 = this.rows;
            while (--n32 >= 0) {
                int n33 = n6;
                int n34 = n5;
                int n35 = this.columns;
                while (--n35 >= 0) {
                    dArray[n33] = doubleDoubleFunction.apply(dArray[n33], dArray2[n34]);
                    n33 += n;
                    n34 += n2;
                }
                n6 += n3;
                n5 += n4;
            }
        }
        return this;
    }

    public double getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D instanceof SelectedDenseDoubleMatrix2D) {
            SelectedDenseDoubleMatrix2D selectedDenseDoubleMatrix2D = (SelectedDenseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == selectedDenseDoubleMatrix2D.elements;
        }
        if (doubleMatrix2D instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
            return this.elements == denseDoubleMatrix2D.elements;
        }
        return false;
    }

    protected int index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public DoubleMatrix2D like(int n, int n2) {
        return new DenseDoubleMatrix2D(n, n2);
    }

    public DoubleMatrix1D like1D(int n) {
        return new DenseDoubleMatrix1D(n);
    }

    protected DoubleMatrix1D like1D(int n, int n2, int n3) {
        return new DenseDoubleMatrix1D(n, this.elements, n2, n3);
    }

    public void setQuick(int n, int n2, double d) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = d;
    }

    protected DoubleMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseDoubleMatrix2D(this.elements, nArray, nArray2, 0);
    }

    public void zAssign8Neighbors(DoubleMatrix2D doubleMatrix2D, Double9Function double9Function) {
        if (!(doubleMatrix2D instanceof DenseDoubleMatrix2D)) {
            super.zAssign8Neighbors(doubleMatrix2D, double9Function);
            return;
        }
        if (double9Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix2D);
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        int n3 = this.rowStride;
        int n4 = denseDoubleMatrix2D.rowStride;
        int n5 = this.columnStride;
        int n6 = denseDoubleMatrix2D.columnStride;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix2D.elements;
        if (dArray == null || dArray2 == null) {
            throw new InternalError();
        }
        int n7 = this.index(1, 1);
        int n8 = denseDoubleMatrix2D.index(1, 1);
        int n9 = 1;
        while (n9 < n) {
            int n10 = n8;
            int n11 = n7 - n3 - n5;
            int n12 = n11 + n3;
            int n13 = n12 + n3;
            double d = dArray[n11];
            double d2 = dArray[n11 += n5];
            double d3 = dArray[n12];
            double d4 = dArray[n12 += n5];
            double d5 = dArray[n13];
            double d6 = dArray[n13 += n5];
            int n14 = 1;
            while (n14 < n2) {
                double d7 = dArray[n11 += n5];
                double d8 = dArray[n12 += n5];
                double d9 = dArray[n13 += n5];
                dArray2[n10] = double9Function.apply(d, d2, d7, d3, d4, d8, d5, d6, d9);
                n10 += n6;
                d = d2;
                d2 = d7;
                d3 = d4;
                d4 = d8;
                d5 = d6;
                d6 = d9;
                ++n14;
            }
            n7 += n3;
            n8 += n4;
            ++n9;
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, double d, double d2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, false);
        }
        if (doubleMatrix1D2 == null) {
            doubleMatrix1D2 = new DenseDoubleMatrix1D(this.rows);
        }
        if (!(doubleMatrix1D instanceof DenseDoubleMatrix1D) || !(doubleMatrix1D2 instanceof DenseDoubleMatrix1D)) {
            return super.zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, bl);
        }
        if (this.columns != doubleMatrix1D.size || this.rows > doubleMatrix1D2.size) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D2.toStringShort());
        }
        DenseDoubleMatrix1D denseDoubleMatrix1D = (DenseDoubleMatrix1D)doubleMatrix1D;
        DenseDoubleMatrix1D denseDoubleMatrix1D2 = (DenseDoubleMatrix1D)doubleMatrix1D2;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix1D.elements;
        double[] dArray3 = denseDoubleMatrix1D2.elements;
        if (dArray == null || dArray2 == null || dArray3 == null) {
            throw new InternalError();
        }
        int n = this.columnStride;
        int n2 = denseDoubleMatrix1D.stride;
        int n3 = denseDoubleMatrix1D2.stride;
        int n4 = this.index(0, 0);
        int n5 = denseDoubleMatrix1D.index(0);
        int n6 = denseDoubleMatrix1D2.index(0);
        int n7 = this.columns;
        int n8 = this.rows;
        while (--n8 >= 0) {
            double d3 = 0.0;
            int n9 = n4 - n;
            int n10 = n5 - n2;
            int n11 = n7 % 4;
            while (--n11 >= 0) {
                d3 += dArray[n9 += n] * dArray2[n10 += n2];
            }
            int n12 = n7 / 4;
            while (--n12 >= 0) {
                int n13 = n9 + n;
                n9 = n13;
                int n14 = n10 + n2;
                n10 = n14;
                int n15 = n9 + n;
                n9 = n15;
                int n16 = n10 + n2;
                n10 = n16;
                n9 = n9 + n;
                n10 = n10 + n2;
                d3 += dArray[n13] * dArray2[n14] + dArray[n15] * dArray2[n16] + dArray[n9] * dArray2[n10] + dArray[n9 += n] * dArray2[n10 += n2];
            }
            dArray3[n6] = d * d3 + d2 * dArray3[n6];
            n4 += this.rowStride;
            n6 += n3;
        }
        return doubleMatrix1D2;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, double d, double d2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, false, bl2);
        }
        if (doubleMatrix2D instanceof SparseDoubleMatrix2D || doubleMatrix2D instanceof RCDoubleMatrix2D) {
            if (doubleMatrix2D2 == null) {
                return doubleMatrix2D.zMult(this, null, d, d2, !bl2, true).viewDice();
            }
            doubleMatrix2D.zMult(this, doubleMatrix2D2.viewDice(), d, d2, !bl2, true);
            return doubleMatrix2D2;
        }
        if (bl2) {
            return this.zMult(doubleMatrix2D.viewDice(), doubleMatrix2D2, d, d2, bl, false);
        }
        int n = this.rows;
        int n2 = this.columns;
        int n3 = doubleMatrix2D.columns;
        if (doubleMatrix2D2 == null) {
            doubleMatrix2D2 = new DenseDoubleMatrix2D(n, n3);
        }
        if (!(doubleMatrix2D2 instanceof DenseDoubleMatrix2D)) {
            return super.zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, bl, bl2);
        }
        if (doubleMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + doubleMatrix2D.toStringShort());
        }
        if (doubleMatrix2D2.rows != n || doubleMatrix2D2.columns != n3) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D2.toStringShort());
        }
        if (this == doubleMatrix2D2 || doubleMatrix2D == doubleMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)doubleMatrix2D;
        DenseDoubleMatrix2D denseDoubleMatrix2D2 = (DenseDoubleMatrix2D)doubleMatrix2D2;
        double[] dArray = this.elements;
        double[] dArray2 = denseDoubleMatrix2D.elements;
        double[] dArray3 = denseDoubleMatrix2D2.elements;
        if (dArray == null || dArray2 == null || dArray3 == null) {
            throw new InternalError();
        }
        int n4 = this.columnStride;
        int n5 = denseDoubleMatrix2D.columnStride;
        int n6 = denseDoubleMatrix2D2.columnStride;
        int n7 = this.rowStride;
        int n8 = denseDoubleMatrix2D.rowStride;
        int n9 = denseDoubleMatrix2D2.rowStride;
        int n10 = (30000 - n2) / (n2 + 1);
        if (n10 <= 0) {
            n10 = 1;
        }
        int n11 = n / n10;
        int n12 = 0;
        if (n % n10 != 0) {
            ++n11;
        }
        while (--n11 >= 0) {
            int n13 = denseDoubleMatrix2D.index(0, 0);
            int n14 = this.index(n12, 0);
            int n15 = denseDoubleMatrix2D2.index(n12, 0);
            n12 += n10;
            if (n11 == 0) {
                n10 += n - n12;
            }
            int n16 = n3;
            while (--n16 >= 0) {
                int n17 = n14;
                int n18 = n15;
                int n19 = n10;
                while (--n19 >= 0) {
                    int n20 = n17;
                    int n21 = n13;
                    double d3 = 0.0;
                    n20 -= n4;
                    n21 -= n8;
                    int n22 = n2 % 4;
                    while (--n22 >= 0) {
                        d3 += dArray[n20 += n4] * dArray2[n21 += n8];
                    }
                    int n23 = n2 / 4;
                    while (--n23 >= 0) {
                        int n24 = n20 + n4;
                        n20 = n24;
                        int n25 = n21 + n8;
                        n21 = n25;
                        int n26 = n20 + n4;
                        n20 = n26;
                        int n27 = n21 + n8;
                        n21 = n27;
                        n20 = n20 + n4;
                        n21 = n21 + n8;
                        d3 += dArray[n24] * dArray2[n25] + dArray[n26] * dArray2[n27] + dArray[n20] * dArray2[n21] + dArray[n20 += n4] * dArray2[n21 += n8];
                    }
                    dArray3[n18] = d * d3 + d2 * dArray3[n18];
                    n17 += n7;
                    n18 += n9;
                }
                n13 += n5;
                n15 += n6;
            }
        }
        return doubleMatrix2D2;
    }

    public double zSum() {
        double d = 0.0;
        double[] dArray = this.elements;
        if (dArray == null) {
            throw new InternalError();
        }
        int n = this.index(0, 0);
        int n2 = this.columnStride;
        int n3 = this.rowStride;
        int n4 = this.rows;
        while (--n4 >= 0) {
            int n5 = n;
            int n6 = this.columns;
            while (--n6 >= 0) {
                d += dArray[n5];
                n5 += n2;
            }
            n += n3;
        }
        return d;
    }
}

