/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassAction;
import com.odi.filter.ClassControl;
import com.odi.filter.FieldAction;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.classfile.AttributeVector;
import com.odi.filter.classfile.ClassField;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.ConstantPool;
import com.odi.filter.classfile.ExceptionTable;
import com.odi.filter.classfile.ExceptionsAttribute;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnTarget;
import com.odi.filter.classfile.InsnUtils;
import com.odi.filter.classfile.SourceFileAttribute;
import com.odi.filter.classfile.VMConstants;
import java.util.Enumeration;
import java.util.Vector;

class ClassInfoBuilder
implements VMConstants {
    ClassInfoBuilder() {
    }

    static ClassFile makeClassInfo(ClassAction ca, String classInfoClass, FilterEnv filterEnv) {
        ClassFile cinfo = new ClassFile(classInfoClass, "com/odi/ClassInfo");
        cinfo.setAccessFlags(17);
        ConstantPool pool = cinfo.pool();
        cinfo.addField(new ClassField(10, pool.addUtf8("fields"), pool.addUtf8("[Lcom/odi/Field;"), new AttributeVector()));
        cinfo.addMethod(ClassInfoBuilder.buildCreateMethod(pool, ca, ca.isInstantiable(), "create", "()Lcom/odi/IPersistent;"));
        cinfo.addMethod(ClassInfoBuilder.buildGetClassDescriptor(pool, ca));
        cinfo.addMethod(ClassInfoBuilder.buildGetFields(pool, ca, classInfoClass));
        cinfo.addMethod(ClassInfoBuilder.buildInit(pool, ca));
        cinfo.addMethod(ClassInfoBuilder.buildClinit(pool, ca, classInfoClass, filterEnv));
        cinfo.attributes().addElement(new SourceFileAttribute(pool.addUtf8("SourceFile"), pool.addUtf8("Generated.java")));
        return cinfo;
    }

    private static ClassMethod buildCreateMethod(ConstantPool pool, ClassAction ca, boolean isInstantiable, String methodName, String methodSignature) {
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod createMethod = new ClassMethod(1, pool.addUtf8(methodName), pool.addUtf8(methodSignature), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        if (isInstantiable) {
            insn = insn.append(Insn.create(187, pool.addClass(ca.className())));
            insn = insn.append(Insn.create(89));
            insn = insn.append(Insn.create(42));
            insn = insn.append(Insn.create(183, pool.addMethodRef(ca.className(), "<init>", "(Lcom/odi/ClassInfo;)V")));
            insn = insn.append(Insn.create(176));
        } else {
            insn = insn.append(Insn.create(1));
            insn = insn.append(Insn.create(176));
        }
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), isInstantiable ? 3 : 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return createMethod;
    }

    private static ClassMethod buildGetClassDescriptor(ConstantPool pool, ClassAction ca) {
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod getClassDescriptorMethod = new ClassMethod(1, pool.addUtf8("getClassDescriptor"), pool.addUtf8("()Ljava/lang/Class;"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(18, pool.addString(ca.userClassName())));
        insn = insn.append(Insn.create(184, pool.addMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;")));
        insn = insn.append(Insn.create(176));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        methodAttrs.addElement(new ExceptionsAttribute(pool.addUtf8("Exceptions"), pool.addClass("java/lang/ClassNotFoundException")));
        return getClassDescriptorMethod;
    }

    private static ClassMethod buildGetFields(ConstantPool pool, ClassAction ca, String thisClass) {
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod getFieldsMethod = new ClassMethod(1, pool.addUtf8("getFields"), pool.addUtf8("()[Lcom/odi/Field;"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(178, pool.addFieldRef(thisClass, "fields", "[Lcom/odi/Field;")));
        insn = insn.append(Insn.create(176));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return getFieldsMethod;
    }

    private static ClassMethod buildInit(ConstantPool pool, ClassAction ca) {
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod createMethod = new ClassMethod(1, pool.addUtf8("<init>"), pool.addUtf8("()V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        insn = insn.append(Insn.create(42));
        insn = insn.append(Insn.create(183, pool.addMethodRef("com/odi/ClassInfo", "<init>", "()V")));
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 1, 1, firstInsn, new ExceptionTable(), new AttributeVector()));
        return createMethod;
    }

    private static ClassMethod buildClinit(ConstantPool pool, ClassAction ca, String thisClass, FilterEnv filterEnv) {
        AttributeVector methodAttrs = new AttributeVector();
        ClassMethod createMethod = new ClassMethod(8, pool.addUtf8("<clinit>"), pool.addUtf8("()V"), methodAttrs);
        InsnTarget firstInsn = new InsnTarget();
        Insn insn = firstInsn;
        Vector<FieldAction> v = new Vector<FieldAction>();
        Enumeration e = ca.fieldActions();
        while (e.hasMoreElements()) {
            FieldAction fieldAct = (FieldAction)e.nextElement();
            if (!fieldAct.isPersistent()) continue;
            v.addElement(fieldAct);
        }
        insn = insn.append(InsnUtils.integerConstant(v.size(), pool));
        insn = insn.append(Insn.create(189, pool.addClass("com/odi/Field")));
        for (int i = 0; i < v.size(); ++i) {
            FieldAction fieldAct = (FieldAction)v.elementAt(i);
            String fieldName = fieldAct.fieldName();
            String createMethodName = fieldAct.createMethod();
            String createMethodSig = fieldAct.createMethodSig();
            String fieldClassName = fieldAct.fieldClassName();
            int nFieldDims = fieldAct.nDims();
            insn = insn.append(Insn.create(89));
            insn = insn.append(InsnUtils.integerConstant(i, pool));
            insn = insn.append(Insn.create(18, pool.addString(fieldName)));
            if (fieldClassName != null && !fieldClassName.equals("java/lang/String")) {
                insn = insn.append(Insn.create(18, pool.addString(ClassControl.userClassFromVMClass(fieldClassName))));
            }
            if (nFieldDims > 0) {
                insn = insn.append(InsnUtils.integerConstant(nFieldDims, pool));
            }
            insn = insn.append(Insn.create(184, pool.addMethodRef("com/odi/Field", createMethodName, createMethodSig)));
            if (fieldAct.isIndexable()) {
                insn = insn.append(Insn.create(182, pool.addMethodRef("com/odi/Field", "makeIndexable", "()Lcom/odi/Field;")));
            }
            if (fieldAct.isEmbeddable()) {
                if (fieldClassName.equals("java/lang/String")) {
                    int size = fieldAct.embeddedLength();
                    filterEnv.message("Embedded string field: " + fieldName + "[" + size + "]");
                    insn = insn.append(InsnUtils.integerConstant(size, pool));
                    insn = insn.append(Insn.create(182, pool.addMethodRef("com/odi/Field", "makeEmbedded", "(I)Lcom/odi/Field;")));
                } else {
                    throw new FilterError("Unknown embedded field type:" + fieldClassName);
                }
            }
            insn = insn.append(Insn.create(83));
        }
        insn = insn.append(Insn.create(179, pool.addFieldRef(thisClass, "fields", "[Lcom/odi/Field;")));
        insn = insn.append(Insn.create(177));
        methodAttrs.addElement(new CodeAttribute(pool.addUtf8("Code"), 6, 3, firstInsn, new ExceptionTable(), new AttributeVector()));
        return createMethod;
    }
}

