/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.DatabaseSegmentEnumeration;
import com.odi.FatalInternalException;
import com.odi.imp.Database;
import com.odi.imp.Segment;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DatabaseObjectIterator
implements Iterator {
    private Database database;
    private Class ofType;
    private DatabaseSegmentEnumeration segments;
    private Segment segment;
    private Iterator segmentObjects;
    private Object current;

    public DatabaseObjectIterator(Database database) {
        this(database, null);
    }

    public DatabaseObjectIterator(Database database, Class ofType) {
        this.database = database;
        this.ofType = ofType;
    }

    @Override
    public boolean hasNext() {
        if (this.segments == null) {
            this.advance();
        }
        return this.current != null;
    }

    public Object next() {
        if (this.hasNext()) {
            Object last = this.current;
            this.advance();
            return last;
        }
        throw new NoSuchElementException("No more elements in the iterator");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Iterator.remove() on a DatabaseObjectIterator is not supported");
    }

    private void advance() {
        if (this.segments == null) {
            this.initialize();
        }
        if (!this.segmentObjects.hasNext()) {
            if (!this.segments.hasMoreElements()) {
                this.current = null;
                return;
            }
            this.segment = (Segment)this.segments.nextElement();
            this.createObjectIterator();
            if (!this.segmentObjects.hasNext()) {
                this.advance();
                return;
            }
        }
        this.current = this.segmentObjects.next();
    }

    private void initialize() {
        if (this.segments == null) {
            this.segments = this.database.getSegments();
            if (!this.segments.hasMoreElements()) {
                throw new FatalInternalException("No segments in database");
            }
            this.segment = (Segment)this.segments.nextElement();
            this.createObjectIterator();
        }
    }

    private void createObjectIterator() {
        this.segmentObjects = this.ofType == null ? this.segment.getObjects() : this.segment.getObjects(this.ofType);
    }
}

