/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketBrokerConnectReply
extends PDUPacket {
    private int addr;
    private static final int BODY_WIRE_SIZE = 4;

    private PDUPacketBrokerConnectReply(int n) {
        super((short)6);
        this.setAddr(n);
    }

    private PDUPacketBrokerConnectReply(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 6) {
            throw new InternalError("BROKER CONNECT REPLY packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketBrokerConnectReply(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 6) {
            throw new InternalError("BROKER CONNECT REPLY packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeInt(this.addr);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() < this.getBodyWireSize()) {
                throw new EIOInsufficientDataException(this.getBodyWireSize() - dataInputStream.available());
            }
            this.setAddr(dataInputStream.readInt());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setAddr(PDUPacketHeader.askUnicastAddr("Replying broker unicast address", printStream, bufferedReader, 0));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    final int getBodyWireSize() {
        return 4;
    }

    @Override
    final String bodyToString() {
        return "[" + this.getAddr() + "]";
    }

    public static PDUPacketBrokerConnectReply create(int n) {
        return new PDUPacketBrokerConnectReply(n);
    }

    static PDUPacketBrokerConnectReply create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketBrokerConnectReply(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketBrokerConnectReply create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketBrokerConnectReply(pDUPacketHeader, printStream, bufferedReader);
    }

    public final void setAddr(int n) {
        this.addr = n;
    }

    public final int getAddr() {
        return this.addr;
    }
}

