/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class PDUPacketReply
extends PDUPacket {
    private long correlationId;
    private boolean status;
    private String desc;

    PDUPacketReply(short s, boolean bl, String string) {
        super(s);
        this.getHeader().setZeroLatency(true);
        this.getHeader().setSynchronous(true);
        this.setStatus(bl);
        this.setDesc(string);
    }

    PDUPacketReply(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
    }

    PDUPacketReply(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
    }

    @Override
    void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            String string = this.desc == null ? "" : this.desc;
            dataOutputStream.writeShort(this.getBodyWireSize() - 2);
            dataOutputStream.writeLong(this.correlationId);
            dataOutputStream.writeBoolean(this.status);
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() >= 2) {
                short s = dataInputStream.readShort();
                if (dataInputStream.available() < s) {
                    throw new EIOInsufficientDataException(s - dataInputStream.available());
                }
            } else {
                throw new EIOInsufficientDataException();
            }
            this.setCorrelationId(dataInputStream.readLong());
            this.setStatus(dataInputStream.readBoolean());
            this.setDesc(dataInputStream.readUTF());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setCorrelationId((long)SysInteractive.ask("Correlation id", printStream, bufferedReader, 0.0));
        this.setStatus(SysInteractive.ask("Success (true/false)", printStream, bufferedReader, true));
        this.setDesc(SysInteractive.ask("Status desc", printStream, bufferedReader, "ok"));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    int getBodyWireSize() {
        return 11 + (2 + (this.desc == null ? 0 : this.desc.length()));
    }

    @Override
    String bodyToString() {
        return "{" + this.correlationId + ", " + this.status + ", '" + this.desc + "'}";
    }

    public final void setStatus(boolean bl) {
        this.status = bl;
    }

    public final boolean getStatus() {
        return this.status;
    }

    public final void setDesc(String string) {
        this.desc = string;
    }

    public final String getDesc() {
        return this.desc;
    }

    public final void setCorrelationId(long l) {
        this.correlationId = l;
    }

    public final long getCorrelationId() {
        return this.correlationId;
    }
}

