/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.tools.interactive;

import com.progress.blackbird.evs.nio.EvsConfig;
import com.progress.blackbird.io.evs.IOConfig;
import com.progress.blackbird.io.multi.IOMultiConfig;
import com.progress.blackbird.nwlink.NwLinkConfig;
import com.progress.blackbird.pdu.PDUConfig;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysTrace;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;

public class Base {
    final PDUPacket createPacket(String string, BufferedReader bufferedReader) throws Exception {
        short s = PDUPacketHeader.stringToType(string);
        if (s != 0) {
            try {
                PDUPacket pDUPacket = PDUPacket.create(s, System.out, bufferedReader);
                if (pDUPacket != null) {
                    return pDUPacket;
                }
                System.out.println("Packet of type [" + string + "] cannot be created interactively");
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                System.out.println("Error [" + iOException.getMessage() + "]");
            }
        } else {
            System.out.println("Invalid packet type specified [" + string + "]");
        }
        return null;
    }

    final void processLevel(String string, String string2) {
        int n = SysTrace.getLevelFromString(string2);
        if (string.compareToIgnoreCase("link") == 0 || string.compareToIgnoreCase("all") == 0) {
            NwLinkConfig.flushConfig();
            SysConfig.setTraceLevel("COM.PROGRESS.BLACKBIRD.NWLINK", n);
            System.out.println("Set 'link' package trace level to '" + string2 + "'");
        }
        if (string.compareToIgnoreCase("evs") == 0 || string.compareToIgnoreCase("all") == 0) {
            EvsConfig.flushConfig();
            SysConfig.setTraceLevel("COM.PROGRESS.BLACKBIRD.EVS.NIO", n);
            System.out.println("Set 'evs' package trace level to '" + string2 + "'");
        }
        if (string.compareToIgnoreCase("io") == 0 || string.compareToIgnoreCase("all") == 0) {
            IOConfig.flushConfig();
            SysConfig.setTraceLevel("COM.PROGRESS.BLACKBIRD.IO.EVS", n);
            System.out.println("Set 'io' package trace level to '" + string2 + "'");
        }
        if (string.compareToIgnoreCase("multi") == 0 || string.compareToIgnoreCase("all") == 0) {
            IOMultiConfig.flushConfig();
            SysConfig.setTraceLevel("COM.PROGRESS.BLACKBIRD.IO.MULTI", n);
            System.out.println("Set 'multi' package trace level to '" + string2 + "'");
        }
        if (string.compareToIgnoreCase("pdu") == 0 || string.compareToIgnoreCase("all") == 0) {
            PDUConfig.flushConfig();
            SysConfig.setTraceLevel("COM.PROGRESS.BLACKBIRD.PDU", n);
            System.out.println("Set 'pdu' package trace level to '" + string2 + "'");
        }
    }

    final void processDumpLog() {
        SysConfig.getLogger().dumpHistory(System.out);
    }
}

