/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.MasterPage;
import com.sonicsw.mtstorage.impl.Page;
import com.sonicsw.mtstorage.impl.PageWriterQueue;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;

final class AsyncFile {
    private static final Logger LOGGER = Logger.getLogger("pse");
    private boolean isSnapshotStorage = false;
    private boolean isDSStorage = false;
    private String m_filename;
    private RandomAccessFile m_file;
    private PageWriterQueue m_pageQueue;
    private boolean m_syncMode;
    private boolean m_doSync;
    private boolean m_newFile;
    private PageWriterThread m_writer;
    private int m_writeFrequency;
    private long m_lastKnownDBTimestamp;
    private static String READ_WRITE = "rw";

    AsyncFile(String filename, boolean createFile, int queueSizeLimit, boolean doSync) throws IOException {
        this.isSnapshotStorage = filename.endsWith("/snapshot/data");
        this.isDSStorage = filename.indexOf("data.odb") > 0;
        this.m_filename = filename;
        this.m_pageQueue = new PageWriterQueue(queueSizeLimit);
        this.m_syncMode = true;
        this.m_doSync = doSync;
        this.m_writer = null;
        File f = new File(filename);
        boolean bl = this.m_newFile = !f.exists() || f.length() == 0L;
        if (!this.m_newFile && createFile) {
            throw new IOException(filename + " already exists.");
        }
        if (this.m_newFile && !createFile) {
            throw new IOException(filename + " is empty or missing.");
        }
        this.m_file = new RandomAccessFile(f, READ_WRITE);
    }

    boolean isNew() {
        return this.m_newFile;
    }

    void write(Page page) throws IOException {
        if (this.m_syncMode) {
            this.writeInternal(page);
            return;
        }
        Page queuedPage = new Page();
        queuedPage.copyBufferAndPageNum(page);
        this.m_pageQueue.queue(queuedPage);
    }

    void read(Page page) throws IOException {
        if (this.m_syncMode) {
            this.readInternal(page);
            return;
        }
        Page queuedPage = this.m_pageQueue.lookup(page.getPageKey());
        if (queuedPage == null) {
            this.readInternal(page);
        } else {
            page.copyBufferAndPageNum(queuedPage);
        }
    }

    void startAsyncMode(Integer asyncFrequency) {
        if (asyncFrequency == null) {
            return;
        }
        this.m_writer = new PageWriterThread();
        this.m_syncMode = false;
        this.m_writeFrequency = asyncFrequency;
        if (this.m_writeFrequency < 0) {
            this.m_writeFrequency = 0;
        }
        this.m_writer.setDaemon(true);
        this.m_writer.start();
    }

    boolean sync() throws IOException {
        boolean allPagesWritten = true;
        if (!this.m_syncMode) {
            this.m_writer.validateOK();
            allPagesWritten = this.m_pageQueue.waitForAllPagesToBeWritten();
        }
        if (allPagesWritten) {
            this.syncInternal();
        }
        return allPagesWritten;
    }

    long getAllocatedCount() throws IOException {
        if (!this.m_syncMode) {
            throw new Error("getAllocatedCount should not be called when not in synchronous mode");
        }
        return this.m_file.length() / (long)Page.PAGE_LENGTH;
    }

    void deallocate(long pageNum) throws IOException {
        if (!this.m_syncMode) {
            throw new Error("getAllocatedCount should not be called when not in synchronous mode");
        }
        this.m_file.setLength(pageNum * (long)Page.PAGE_LENGTH);
    }

    private synchronized void syncInternal() throws IOException {
        if (this.m_doSync) {
            this.m_file.getFD().sync();
        }
    }

    private synchronized void writeInternal(Page page) throws IOException {
        long dbTimestamp;
        if (this.isDSStorage && !this.isSnapshotStorage && page.getPageNum() == 0L && this.m_lastKnownDBTimestamp != (dbTimestamp = MasterPage.getDBTimestamp(page.getBuffer(), 0))) {
            String filename = this.m_filename.substring(0, this.m_filename.indexOf("data.odb") - 1);
            if (this.m_lastKnownDBTimestamp == 0L) {
                LOGGER.log(Level.INFO, "Setting storage timestamp for " + filename + " to " + dbTimestamp);
            } else {
                LOGGER.log(Level.SEVERE, "Resetting storage timestamp for " + filename + "  from " + this.m_lastKnownDBTimestamp + " to " + dbTimestamp + ", trace follows...", new Exception());
            }
            this.m_lastKnownDBTimestamp = dbTimestamp;
        }
        long address = (long)Page.PAGE_LENGTH * page.getPageNum();
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                this.m_file.seek(address);
                page.storeCRC();
                this.m_file.write(page.getBuffer());
            }
            catch (InterruptedIOException e) {
                interrupted = true;
            }
        } while (interrupted);
    }

    private synchronized void readInternal(Page page) throws IOException {
        long dbTimestamp;
        long address = (long)Page.PAGE_LENGTH * page.getPageNum();
        boolean interrupted = false;
        do {
            interrupted = false;
            try {
                this.m_file.seek(address);
                this.m_file.read(page.getBuffer());
                page.validateNotCorrupt();
            }
            catch (InterruptedIOException e) {
                interrupted = true;
            }
        } while (interrupted);
        if (this.isDSStorage && !this.isSnapshotStorage && page.getPageNum() == 0L && this.m_lastKnownDBTimestamp != (dbTimestamp = MasterPage.getDBTimestamp(page.getBuffer(), 0))) {
            String filename = this.m_filename.substring(0, this.m_filename.indexOf("data.odb") - 1);
            LOGGER.log(Level.INFO, "Storage timestamp for " + filename + " is " + dbTimestamp);
            this.m_lastKnownDBTimestamp = dbTimestamp;
        }
    }

    private synchronized void closeInternal() throws IOException {
        this.m_file.close();
    }

    synchronized long getFileSize() throws IOException {
        return this.m_file.length();
    }

    void close() throws IOException {
        try {
            if (!this.m_syncMode) {
                this.m_writer.terminate();
            }
            this.closeInternal();
        }
        catch (InterruptedException e) {
            throw new IOException(e.toString());
        }
    }

    final class PageWriterThread
    extends Thread {
        volatile Throwable m_failure;
        volatile boolean m_done;

        PageWriterThread() {
            super("Sonic DB Data Page Writer");
            this.m_failure = null;
            this.m_done = false;
        }

        private void sleep(int writeFrequency) {
            boolean interrupted = false;
            do {
                interrupted = false;
                try {
                    Thread.sleep(writeFrequency);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            } while (interrupted);
        }

        @Override
        public void run() {
            try {
                while (!this.m_done) {
                    Page page;
                    if (AsyncFile.this.m_writeFrequency > 0) {
                        this.sleep(AsyncFile.this.m_writeFrequency);
                    }
                    if ((page = AsyncFile.this.m_pageQueue.getFirstPageForWriting()) == null) continue;
                    AsyncFile.this.writeInternal(page);
                    AsyncFile.this.m_pageQueue.acknowledgePageWritten();
                }
            }
            catch (Throwable t) {
                this.m_failure = t;
            }
        }

        void terminate() throws InterruptedException {
            this.m_done = true;
            AsyncFile.this.m_pageQueue.terminate();
            this.join();
        }

        void validateOK() throws IOException {
            if (this.m_failure == null) {
                return;
            }
            if (this.m_failure instanceof IOException) {
                throw (IOException)this.m_failure;
            }
            IOException ioe = new IOException();
            ioe.initCause(this.m_failure);
            throw ioe;
        }
    }
}

