/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.ITransactionControl;
import com.sonicsw.mtstorage.impl.TransactionManager;
import java.io.IOException;

class CheckpointNote
extends AbstractNote
implements ITransactionControl {
    protected static byte NOTE_TYPE = (byte)42;
    TransactionManager m_transactionManager;

    CheckpointNote() {
    }

    TransactionManager getTransactionManager() {
        return this.m_transactionManager;
    }

    @Override
    public long getTransactionNum() {
        return 0L;
    }

    @Override
    public long getPageNum() {
        return 0L;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(NOTE_TYPE);
        byte[] serializedManager = this.m_transactionManager.serialize();
        writer.write(serializedManager, 0, serializedManager.length);
        return serializedManager.length + 1;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_transactionManager = TransactionManager.deSerialize(buffer, offset);
    }

    void initNote(TransactionManager transactionManager) {
        this.m_transactionManager = transactionManager;
    }
}

