/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.FatalInternalException;
import com.odi.Transaction;
import com.odi.TransactionException;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class AbortException
extends TransactionException {
    private Exception originalException;

    public AbortException(String message, Exception originalException) {
        this(message);
        this.originalException = originalException;
    }

    public AbortException(String message) {
        super(message);
        if (Transaction.inTransaction()) {
            try {
                Transaction.current().abort();
            }
            catch (Exception e) {
                String message2 = e.getMessage();
                if (message2 == null) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    PrintWriter pw = new PrintWriter(stream);
                    e.printStackTrace(pw);
                    pw.flush();
                    message2 = stream.toString();
                }
                throw new FatalInternalException(message + "\nGot the following exception while attempting to abort:\n" + message2);
            }
        }
    }

    public Exception getOriginalException() {
        return this.originalException;
    }
}

