/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.imp.TypeCodeConstants;
import com.odi.imp.Utilities;

class JavaPrimInfo
implements TypeCodeConstants {
    Class type;
    int typeCode;
    Class wrapperClass;
    String wrapperName;
    int wrapperTypeCode;
    private static final JavaPrimInfo[] javaPrimInfo = new JavaPrimInfo[]{null, new JavaPrimInfo(Byte.TYPE, 2, "java.lang.Byte", 103), new JavaPrimInfo(Character.TYPE, 12, "java.lang.Character", 113), new JavaPrimInfo(Short.TYPE, 4, "java.lang.Short", 105), new JavaPrimInfo(Integer.TYPE, 6, "java.lang.Integer", 107), new JavaPrimInfo(Long.TYPE, 8, "java.lang.Long", 109), new JavaPrimInfo(Float.TYPE, 13, "java.lang.Float", 114), new JavaPrimInfo(Double.TYPE, 14, "java.lang.Double", 115), new JavaPrimInfo(Boolean.TYPE, 11, "java.lang.Boolean", 112), new JavaPrimInfo(Utilities.javaLangStringType, Utilities.getStringTypeCode(), null, 0)};

    static int findTypeCode(Class type) {
        for (int i = 1; i < javaPrimInfo.length; ++i) {
            JavaPrimInfo jpi = javaPrimInfo[i];
            if (jpi.type == type) {
                return JavaPrimInfo.javaPrimInfo[i].typeCode;
            }
            if (jpi.wrapperClass != type) continue;
            return JavaPrimInfo.javaPrimInfo[i].wrapperTypeCode;
        }
        return 0;
    }

    static JavaPrimInfo findByWrapperClass(Class wrapperClass) {
        for (int i = 1; i < javaPrimInfo.length; ++i) {
            if (JavaPrimInfo.javaPrimInfo[i].wrapperClass != wrapperClass) continue;
            return javaPrimInfo[i];
        }
        return null;
    }

    static JavaPrimInfo findByWrapperTypeCode(int typeCode) {
        for (int i = 1; i < javaPrimInfo.length; ++i) {
            if (JavaPrimInfo.javaPrimInfo[i].wrapperTypeCode != typeCode) continue;
            return javaPrimInfo[i];
        }
        return null;
    }

    static JavaPrimInfo get(int javaType) {
        return javaPrimInfo[javaType];
    }

    private JavaPrimInfo(Class type, int typeCode, String wrapperName, int wrapperTypeCode) {
        this.type = type;
        this.typeCode = typeCode;
        this.wrapperTypeCode = wrapperTypeCode;
        this.wrapperName = wrapperName;
        if (wrapperName == null) {
            this.wrapperClass = null;
        } else {
            try {
                this.wrapperClass = Class.forName(wrapperName);
            }
            catch (ClassNotFoundException notFound) {
                throw new FatalInternalException("The ClassNotFoundException was signaled during ObjectStore initialization. The message string was: " + notFound.getMessage());
            }
        }
    }
}

