/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjectManager;
import com.odi.imp.mtsonic.Server;
import java.io.IOException;

public final class GenericObject
extends com.odi.imp.GenericObject {
    GenericObject(ObjectManager om) {
        super(om);
    }

    @Override
    public void fetch() {
        Server sv = (Server)this.objectManager.sv;
        try {
            sv.objectTable.readObject(this.objRef.getLocation(), this.rep, this.getLength());
        }
        catch (IOException e) {
            sv.IOFailure(e);
        }
    }

    @Override
    protected void serverStore(int alignment) {
        Server sv = (Server)this.objectManager.sv;
        int AFTypeCode = this.objRef.getAFTypeCode();
        try {
            sv.objectTable.writeObject(this.objRef.getLocation(), AFTypeCode, this.rep, this.getLength(), alignment);
        }
        catch (IOException e) {
            sv.IOFailure(e);
        }
    }

    @Override
    protected void serverCreateFullObject(int alignment) {
        Server sv = (Server)this.objectManager.sv;
        int AFTypeCode = this.objRef.getAFTypeCode();
        try {
            long location = sv.objectTable.allocateObject(this.getLength(), AFTypeCode, alignment);
            ((MutatingObjRef)this.objRef).setObjectId(this.objRef.getPlacement(), location);
            sv.objectTable.writeObject(location, AFTypeCode, this.rep, this.getLength(), alignment);
        }
        catch (IOException e) {
            sv.IOFailure(e);
        }
    }

    @Override
    public int serverStorageSize() {
        Server sv = (Server)this.objectManager.sv;
        int size = 0;
        try {
            size = sv.objectTable.getObjectSize(this.objRef.getLocation());
        }
        catch (IOException e) {
            sv.IOFailure(e);
        }
        return size;
    }
}

