/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.Cluster;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.Placement;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Ref8ByteLocal;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.mtsonic.Server;
import com.odi.util.BTree;
import com.odi.util.BTreeEntryNotFoundException;
import com.odi.util.BTreeIterator;
import com.odi.util.BTreeNode;
import com.odi.util.BitUtil;
import com.odi.util.StorageBTreeIteratorImpl;
import java.io.PrintStream;

public final class StorageBTreeImpl
extends BTree
implements IPersistent,
IPersistentHooks {
    private static final int STORED_REF_LENGTH = 8;
    private transient boolean transientSet = false;
    transient Cluster cluster;
    transient String pathInfo;
    public transient ObjectManager om;
    private transient ObjectReference ref;
    public transient byte objectState;
    private static final ClassInfo classInfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.StorageBTreeImpl"));
    private int size;
    private int modifications;
    private BTreeNode freeNode;
    private short extraShort1;
    private byte keySize;
    private boolean fixedSizeKeys;
    private boolean duplicateKeys;
    private byte extraByte;
    private int extraInt1;
    private int extraInt2;
    private int extraInt3;
    private int extraInt4;
    private int extraInt5;
    private int extraInt6;
    private int extraInt7;
    private int extraInt8;
    private int extraInt9;
    private int extraInt10;
    private int extraInt11;
    private int extraInt12;
    private Object extraObject1;
    private Object extraObject2;
    long treeID;

    @Override
    public void setPathInfo(String info) {
        this.pathInfo = info;
    }

    @Override
    public Object get(byte[] key) throws BTreeEntryNotFoundException {
        this.fetch();
        this.checkPersistent();
        byte[] valueBuffer = ((Server)this.om.sv).bTreeGet(this.treeID, key, this.pathInfo);
        return this.storedToObject(valueBuffer);
    }

    @Override
    public boolean containsKey(byte[] key) {
        this.fetch();
        this.checkPersistent();
        return ((Server)this.om.sv).bTreeContainsKey(this.treeID, key, this.pathInfo);
    }

    @Override
    public boolean contains(byte[] key, Object valueObject) {
        this.fetch();
        this.checkPersistent();
        try {
            return ((Server)this.om.sv).bTreeContains(this.treeID, key, this.objectToStored(valueObject), this.pathInfo);
        }
        catch (BTreeEntryNotFoundException e) {
            return false;
        }
    }

    @Override
    public Object put(byte[] key, Object valueObject) {
        this.fetch();
        this.checkPersistent();
        return this.putInternal(key, valueObject);
    }

    @Override
    public void insertKnownNewValue(byte[] key, Object valueObject) {
        this.fetch();
        this.checkPersistent();
        this.putInternal(key, valueObject);
    }

    @Override
    public Object insertUniqueKey(byte[] key, Object valueObject) {
        this.fetch();
        this.checkPersistent();
        return this.putInternal(key, valueObject);
    }

    @Override
    public int size() {
        int count = 0;
        BTreeIterator iterator = this.nolockIterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    @Override
    public int sizeEstimate() {
        return 0;
    }

    @Override
    public boolean isSizeMaintained() {
        return false;
    }

    @Override
    public void maintainSize(boolean maintainSize) {
    }

    @Override
    public Object remove(byte[] key) throws BTreeEntryNotFoundException {
        this.fetch();
        this.checkPersistent();
        byte[] valueBuffer = ((Server)this.om.sv).bTreeRemove(this.treeID, key, this.pathInfo);
        return this.storedToObject(valueBuffer);
    }

    @Override
    public void remove(byte[] key, Object valueObject) throws BTreeEntryNotFoundException {
        this.fetch();
        this.checkPersistent();
        ((Server)this.om.sv).bTreeRemove(this.treeID, key, this.objectToStored(valueObject), this.pathInfo);
    }

    private Object storedToObject(byte[] valueBuffer) {
        if (valueBuffer == null) {
            return null;
        }
        Reference reference = ((Ref8ByteLocal)ReferenceType.REF_8BYTE_LOCAL).makeReference(BitUtil.getLong(valueBuffer, 0));
        return reference.resolve(this.cluster, 0);
    }

    private byte[] objectToStored(Object valueObject) {
        byte[] valueBuffer = null;
        if (valueObject != null) {
            ObjectReference ref = this.om.findObjRef(valueObject, false);
            if (ref == null) {
                throw new BTreeEntryNotFoundException();
            }
            valueBuffer = this.referenceToStored(ref);
        }
        return valueBuffer;
    }

    private byte[] referenceToStored(ObjectReference value) {
        if (value.getPlacement() == null) {
            return null;
        }
        byte[] valueBuffer = new byte[8];
        BitUtil.putLong(valueBuffer, 0, value.getLocation());
        return valueBuffer;
    }

    @Override
    public void clear() {
        this.fetch();
        this.checkPersistent();
        ((Server)this.om.sv).bTreeClear(this.treeID, this.pathInfo);
    }

    @Override
    public byte[] getFirstKey() {
        this.fetch();
        this.checkPersistent();
        return ((Server)this.om.sv).bTreeGetFirstKey(this.treeID, this.pathInfo);
    }

    @Override
    public byte[] getLastKey() {
        this.fetch();
        this.checkPersistent();
        return ((Server)this.om.sv).bTreeGetLastKey(this.treeID, this.pathInfo);
    }

    @Override
    public int getKeySize() {
        this.fetch();
        this.checkPersistent();
        return this.keySize;
    }

    int getKeySizeInternal() {
        return this.keySize;
    }

    @Override
    public boolean hasFixedSizeKeys() {
        ObjectStore.fetch(this);
        return this.fixedSizeKeys;
    }

    @Override
    public boolean checkValid(PrintStream stream) {
        this.fetch();
        this.checkPersistent();
        stream.println("checkValid is not implemented for storage B-Trees");
        return true;
    }

    @Override
    public void printStats(PrintStream stream) {
        this.fetch();
        this.checkPersistent();
        stream.println("Size:                        " + this.size + "\n" + "Modifications:               " + this.modifications + "\n" + "Key size:                    " + this.keySize + "\n" + "Tree dbkey:                  " + this.treeID + "\n" + "Is size maintained:          " + false);
    }

    @Override
    public void printContents(PrintStream stream) {
        this.fetch();
        this.checkPersistent();
        stream.println("printContents is not implemented for storage B-Trees");
    }

    @Override
    public void initializeContents(GenericObject genericObject) {
        this.size = genericObject.getIntField(1, classInfo);
        this.modifications = genericObject.getIntField(2, classInfo);
        this.freeNode = (BTreeNode)genericObject.getClassField(3, classInfo);
        this.extraShort1 = genericObject.getShortField(4, classInfo);
        this.keySize = genericObject.getByteField(5, classInfo);
        this.fixedSizeKeys = genericObject.getBooleanField(6, classInfo);
        this.duplicateKeys = genericObject.getBooleanField(7, classInfo);
        this.extraByte = genericObject.getByteField(8, classInfo);
        this.extraInt1 = genericObject.getIntField(9, classInfo);
        this.extraInt2 = genericObject.getIntField(10, classInfo);
        this.extraObject1 = genericObject.getClassField(11, classInfo);
        this.extraObject2 = genericObject.getClassField(12, classInfo);
        this.extraInt11 = genericObject.getIntField(13, classInfo);
        this.extraInt4 = genericObject.getIntField(14, classInfo);
        this.extraInt5 = genericObject.getIntField(15, classInfo);
        this.extraInt3 = genericObject.getIntField(16, classInfo);
        this.extraInt10 = genericObject.getIntField(17, classInfo);
        this.extraInt12 = genericObject.getIntField(18, classInfo);
        this.extraInt6 = genericObject.getIntField(19, classInfo);
        this.extraInt7 = genericObject.getIntField(20, classInfo);
        this.extraInt9 = genericObject.getIntField(21, classInfo);
        this.extraInt8 = genericObject.getIntField(22, classInfo);
        this.treeID = genericObject.getLongField(23, classInfo);
    }

    @Override
    public void flushContents(GenericObject genericObject) {
        genericObject.setIntField(1, this.size, classInfo);
        genericObject.setIntField(2, this.modifications, classInfo);
        genericObject.setClassField(3, this.freeNode, classInfo);
        genericObject.setShortField(4, this.extraShort1, classInfo);
        genericObject.setByteField(5, this.keySize, classInfo);
        genericObject.setBooleanField(6, this.fixedSizeKeys, classInfo);
        genericObject.setBooleanField(7, this.duplicateKeys, classInfo);
        genericObject.setByteField(8, this.extraByte, classInfo);
        genericObject.setIntField(9, this.extraInt1, classInfo);
        genericObject.setIntField(10, this.extraInt2, classInfo);
        genericObject.setClassField(11, this.extraObject1, classInfo);
        genericObject.setClassField(12, this.extraObject2, classInfo);
        genericObject.setIntField(13, this.extraInt11, classInfo);
        genericObject.setIntField(14, this.extraInt4, classInfo);
        genericObject.setIntField(15, this.extraInt5, classInfo);
        genericObject.setIntField(16, this.extraInt3, classInfo);
        genericObject.setIntField(17, this.extraInt10, classInfo);
        genericObject.setIntField(18, this.extraInt12, classInfo);
        genericObject.setIntField(19, this.extraInt6, classInfo);
        genericObject.setIntField(20, this.extraInt7, classInfo);
        genericObject.setIntField(21, this.extraInt9, classInfo);
        genericObject.setIntField(22, this.extraInt8, classInfo);
        genericObject.setLongField(23, this.treeID, classInfo);
    }

    @Override
    public void clearContents() {
        this.size = 0;
        this.modifications = 0;
        this.freeNode = null;
        this.extraShort1 = 0;
        this.keySize = 0;
        this.fixedSizeKeys = false;
        this.duplicateKeys = false;
        this.extraByte = 0;
        this.extraInt1 = 0;
        this.extraInt2 = 0;
        this.extraObject1 = null;
        this.extraObject2 = null;
        this.extraInt11 = 0;
        this.extraInt4 = 0;
        this.extraInt5 = 0;
        this.extraInt3 = 0;
        this.extraInt10 = 0;
        this.extraInt12 = 0;
        this.extraInt6 = 0;
        this.extraInt7 = 0;
        this.extraInt9 = 0;
        this.extraInt8 = 0;
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public void postInitializeContents() {
        this.maybeSetTransientFields();
    }

    @Override
    public void preDestroyPersistent() {
        this.fetch();
        this.checkPersistent();
        ((Server)this.om.sv).bTreeDelete(this.treeID, this.pathInfo);
    }

    public StorageBTreeImpl(ClassInfo ignored) {
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte value) {
        this.objectState = value;
    }

    void fetch() {
        if (this.objectState < 0) {
            ObjectManager.fetch(this);
        }
    }

    StorageBTreeImpl(Placement placement, int keySize, int flags) {
        BTreeNode.odiAssert(keySize <= 127, "Key size too big");
        this.keySize = (byte)keySize;
        this.fixedSizeKeys = (flags & 1) != 0;
        this.duplicateKeys = (flags & 2) != 0;
        ObjectStore.migrate(this, placement);
        this.init(this.fixedSizeKeys, keySize);
    }

    void deallocateNode(BTreeNode node) {
    }

    void init(boolean fixedSizeKeys, int keySize) {
        this.fixedSizeKeys = fixedSizeKeys;
        BTreeNode.odiAssert(keySize <= 127, "Key size too big");
        this.keySize = (byte)keySize;
        this.maybeSetTransientFields();
        this.treeID = ((Server)this.om.sv).bTreeCreate(!this.duplicateKeys, this.pathInfo);
    }

    boolean getDuplicateKeys() {
        this.fetch();
        return this.duplicateKeys;
    }

    boolean getFixedSizeKeys() {
        this.fetch();
        return this.fixedSizeKeys;
    }

    private Object putInternal(byte[] key, Object valueObject) {
        ObjectReference ref;
        this.checkPersistent();
        BTreeNode.odiAssert(!this.fixedSizeKeys || BTreeNode.keyLength(key) <= this.keySize, "Bad key");
        if (valueObject == null) {
            ref = this.om.objRefFactory.getNull();
        } else {
            ref = this.om.findObjRef(valueObject, true);
            if (ref == null) {
                ObjectStore.migrate(valueObject, this.cluster);
                ref = this.om.getObjRef(valueObject);
            }
        }
        byte[] valueBuffer = this.referenceToStored(ref);
        byte[] oldValue = ((Server)this.om.sv).bTreePut(this.treeID, key, valueBuffer, this.pathInfo);
        return this.storedToObject(oldValue);
    }

    private BTreeIterator nolockIterator() {
        this.checkPersistent();
        return new StorageBTreeIteratorImpl(this);
    }

    @Override
    public BTreeIterator iterator() {
        this.checkPersistent();
        return new StorageBTreeIteratorImpl(this, false);
    }

    @Override
    public BTreeIterator reverseIterator() {
        this.checkPersistent();
        return new StorageBTreeIteratorImpl(this, true);
    }

    @Override
    public BTreeIterator iterator(byte[] initialKey) {
        this.checkPersistent();
        return new StorageBTreeIteratorImpl(this, initialKey, false);
    }

    @Override
    public BTreeIterator reverseIterator(byte[] initialKey) {
        this.checkPersistent();
        return new StorageBTreeIteratorImpl(this, initialKey, true);
    }

    private BTreeNode allocateNode(boolean isLeaf, boolean childrenAreLeaves) {
        return null;
    }

    private void maybeSetTransientFields() {
        if (this.transientSet) {
            return;
        }
        this.transientSet = true;
        this.cluster = Cluster.of(this);
        this.om = (ObjectManager)this.cluster.getSession();
    }

    private void checkPersistent() {
        if (!ObjectStore.isPersistent(this)) {
            throw new ObjectNotFoundException("Attempt to use a B-tree that was created in an aborted transaction or after the database containing it was closed with retainAsTransient set to true.");
        }
    }
}

