/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.io.EIOConnectionAlreadyConnectedException;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOConnectionNotConnectedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.EIOTimeoutException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionEventHandler;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOConnectionStatistics;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.io.IIOPacketSerializer;
import com.progress.blackbird.io.evs.IIONetworkConnectionPingPacketManager;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionActive;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionPassive;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.evs.IOObject;
import com.progress.blackbird.io.multi.IIOMultiConnectionFlowBalancer;
import com.progress.blackbird.io.multi.IIOMultiConnectionPacketManager;
import com.progress.blackbird.io.multi.IOMultiConnection;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysListHead;
import java.util.List;

public final class IOMultiNetworkConnection
extends IOObject
implements IIOConnection {
    private boolean active;
    private IOMultiNetworkConnectionActive activeConnection;
    private IOMultiNetworkConnectionPassive passiveConnection;

    private IOMultiNetworkConnection(IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive) {
        this.active = true;
        this.activeConnection = iOMultiNetworkConnectionActive;
    }

    private IOMultiNetworkConnection(boolean bl, String[] stringArray, boolean bl2, IONetworkConnection.Parameters[] parametersArray, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, Parameters parameters) throws EIOException {
        this.active = bl;
        this.threaded = bl2;
        if (bl) {
            this.activeConnection = new IOMultiNetworkConnectionActive(stringArray, bl2, parametersArray, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, iIOConnectionEventHandler, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, parameters);
        } else {
            this.passiveConnection = new IOMultiNetworkConnectionPassive(stringArray, bl2, parametersArray, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, iIOConnectionEventHandler, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, parameters);
        }
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.io.multi.trace");
        this.trace.outln("Created multi-network connection (active=" + bl + ") with parameters " + parameters, 4);
    }

    public static IIOConnection create(boolean bl, String[] stringArray, boolean bl2, IONetworkConnection.Parameters[] parametersArray, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, Parameters parameters) throws EIOException {
        if (stringArray == null) {
            throw new IllegalArgumentException("connection descriptor list cannot be null");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("descriptor list cannot be empty");
        }
        return new IOMultiNetworkConnection(bl, stringArray, bl2, parametersArray, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, iIOConnectionEventHandler, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, parameters == null ? Parameters.create() : parameters);
    }

    public final List getInDoubtPackets() throws EIOException {
        if (this.active) {
            return this.activeConnection.getInDoubtPackets();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    public final IONetworkConnection getUnderlyingConnection(String string) throws EIOException {
        if (this.active) {
            return this.activeConnection.getUnderlyingConnection(string);
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    @Override
    public final boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public final IIOConnectionStatistics getStatistics() {
        if (this.active) {
            return this.activeConnection.getStatistics();
        }
        return null;
    }

    @Override
    public final void connect() throws EIOConnectionAlreadyConnectedException, EIOConnectionClosedException, EIOException {
        if (!this.active) {
            throw new IllegalStateException("operation not permitted on a passive connection");
        }
        this.activeConnection.connect();
    }

    @Override
    public final boolean isConnected() throws EIOConnectionClosedException, EIOException {
        if (this.active) {
            return this.activeConnection.isConnected();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    @Override
    public final IIOConnection accept(int n) throws EIOConnectionClosedException, EIOTimeoutException, EIOException {
        if (!this.active) {
            return new IOMultiNetworkConnection(this.passiveConnection.accept(n));
        }
        throw new IllegalStateException("operation not permitted on an active connection");
    }

    @Override
    public final SysListHead receive(int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOTimeoutException, EIOInboundStreamOpenException, EIOException {
        if (this.active) {
            return this.activeConnection.receive(n);
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    @Override
    public final void read(IEvsDispatcher iEvsDispatcher, IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException {
        if (!this.active) {
            throw new IllegalStateException("operation not permitted on a passive connection");
        }
        this.activeConnection.read(iEvsDispatcher, iIOConnectionPacketHandler);
    }

    @Override
    public IIOConnectionPacketHandler setPacketHandler(IIOConnectionPacketHandler iIOConnectionPacketHandler) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (this.active) {
            return this.activeConnection.setPacketHandler(iIOConnectionPacketHandler);
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    @Override
    public final boolean write(IIOPacket iIOPacket, IIOConnection.FlushContext flushContext, int n) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (this.active) {
            return this.activeConnection.write(iIOPacket, flushContext, n);
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    @Override
    public final void flush(IIOConnection.FlushContext flushContext) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException {
        if (!this.active) {
            throw new IllegalStateException("operation not permitted on a passive connection");
        }
        this.activeConnection.flush(flushContext);
    }

    @Override
    public final boolean isInboundStreamOpen() throws EIOConnectionClosedException, EIOException {
        if (this.active) {
            return this.activeConnection.isInboundStreamOpen();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    @Override
    public final int getOutboundStreamBufferSize() throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOException {
        if (this.active) {
            return this.activeConnection.getOutboundStreamBufferSize();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    @Override
    public final void fail(Exception exception) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException {
        if (!this.active) {
            throw new IllegalStateException("operation not permitted on a passive connection");
        }
        this.activeConnection.fail(exception);
    }

    @Override
    public final void close() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        if (this.active) {
            this.activeConnection.close();
        } else {
            this.passiveConnection.close();
        }
    }

    @Override
    public final boolean isClosed() throws EIOException {
        if (this.active) {
            return this.activeConnection.isClosed();
        }
        return this.passiveConnection.isClosed();
    }

    @Override
    public final boolean isFailed() throws EIOConnectionClosedException, EIOException {
        if (this.active) {
            return this.activeConnection.isFailed();
        }
        throw new IllegalStateException("operation not permitted on a passive connection");
    }

    public static class Parameters
    extends IOObject {
        private final String name;
        private final int connectRetryInterval;
        private final int maxAcceptBacklog;
        private final int handshakeTimeout;
        private final IOMultiConnection.Parameters multiParameters;

        private Parameters(String string, int n, int n2, int n3, IOMultiConnection.Parameters parameters) {
            this.name = string;
            this.connectRetryInterval = n == 0 ? (int)SysConfig.getConfigValue(System.getProperties(), "bb.io.multi.nwconn.connectRetryInterval", 5.0) : n;
            this.maxAcceptBacklog = n2 == -1 ? (int)SysConfig.getConfigValue(System.getProperties(), "bb.io.multi.nwconn.maxAcceptBacklog", 0.0) : n2;
            this.handshakeTimeout = n3 == 0 ? (int)SysConfig.getConfigValue(System.getProperties(), "bb.io.multi.nwconn.handshakeTimeout", 5.0) : n3;
            this.multiParameters = parameters;
        }

        final String getName() {
            return this.name;
        }

        public final int getConnectRetryInterval() {
            return this.connectRetryInterval;
        }

        public final int getMaxAcceptBacklog() {
            return this.maxAcceptBacklog;
        }

        public final int getHandshakeTimeout() {
            return this.handshakeTimeout;
        }

        public final IOMultiConnection.Parameters getMultiParameters() {
            return this.multiParameters;
        }

        public static Parameters create(String string, int n, int n2, int n3, IOMultiConnection.Parameters parameters) {
            return new Parameters(string, n, n2, n3, parameters);
        }

        public static Parameters create() {
            return Parameters.create(null, 0, -1, 0, null);
        }

        public Object clone() {
            return Parameters.create(this.name, this.connectRetryInterval, this.maxAcceptBacklog, this.handshakeTimeout, (IOMultiConnection.Parameters)(this.multiParameters == null ? null : this.multiParameters.clone()));
        }

        public final String toString() {
            return "[name=" + this.getName() + " connectRetryInterval=" + this.getConnectRetryInterval() + " maxAcceptBacklog=" + this.getMaxAcceptBacklog() + " handshakeTimeout=" + this.getHandshakeTimeout() + "]";
        }
    }
}

