/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketMultiConnectionHandshakeReply
extends PDUPacket {
    private boolean status;
    private String desc;

    private PDUPacketMultiConnectionHandshakeReply(boolean bl, String string) {
        super((short)15);
        this.setStatus(bl);
        this.setDesc(string);
    }

    private PDUPacketMultiConnectionHandshakeReply(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
        if (this.checked && pDUPacketHeader.getType() != 15) {
            throw new InternalError("MCONN HANDSHAKE REPLY packet being constructed from stream but header indicates otherwise");
        }
    }

    private PDUPacketMultiConnectionHandshakeReply(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
        if (this.checked && pDUPacketHeader.getType() != 14) {
            throw new InternalError("MCONN HANDSHAKE REPLY packet being constructed interactively but header indicates otherwise");
        }
    }

    @Override
    final void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            String string = this.desc == null ? "" : this.desc;
            dataOutputStream.writeShort(this.getBodyWireSize() - 2);
            dataOutputStream.writeBoolean(this.status);
            dataOutputStream.writeUTF(string);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() >= 2) {
                short s = dataInputStream.readShort();
                if (dataInputStream.available() < s) {
                    throw new EIOInsufficientDataException(s - dataInputStream.available());
                }
            } else {
                throw new EIOInsufficientDataException();
            }
            this.setStatus(dataInputStream.readBoolean());
            this.setDesc(dataInputStream.readUTF());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setStatus(SysInteractive.ask("Success (true/false)", printStream, bufferedReader, true));
        this.setDesc(SysInteractive.ask("Status desc", printStream, bufferedReader, "ok"));
    }

    @Override
    final void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    final int getBodyWireSize() {
        return 3 + (2 + (this.desc == null ? 0 : this.desc.length()));
    }

    @Override
    final String bodyToString() {
        return "{" + this.status + ", '" + this.desc + "'}";
    }

    public final void setStatus(boolean bl) {
        this.status = bl;
    }

    public static PDUPacketMultiConnectionHandshakeReply create(boolean bl, String string) {
        return new PDUPacketMultiConnectionHandshakeReply(bl, string);
    }

    static PDUPacketMultiConnectionHandshakeReply create(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        return new PDUPacketMultiConnectionHandshakeReply(pDUPacketHeader, dataInputStream);
    }

    static PDUPacketMultiConnectionHandshakeReply create(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        return new PDUPacketMultiConnectionHandshakeReply(pDUPacketHeader, printStream, bufferedReader);
    }

    public final boolean getStatus() {
        return this.status;
    }

    public final void setDesc(String string) {
        this.desc = string;
    }

    public final String getDesc() {
        return this.desc;
    }
}

