/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory.impl;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryCacheService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.Version;
import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IBlob;
import com.sonicsw.mf.common.config.IChunkedBlobStreamer;
import com.sonicsw.mf.common.config.IDSHandler;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementChangeHandler;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IEnvelope;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.config.INameChangeHandler;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.IValidationElementChange;
import com.sonicsw.mf.common.config.MergeUtil;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.Blob;
import com.sonicsw.mf.common.config.impl.CannotAdjustToSuperModificationException;
import com.sonicsw.mf.common.config.impl.DSTransaction;
import com.sonicsw.mf.common.config.impl.DeltaElement;
import com.sonicsw.mf.common.config.impl.DirIdentity;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.EnvelopeElement;
import com.sonicsw.mf.common.config.impl.ICanReplaceRef;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.Identity;
import com.sonicsw.mf.common.config.impl.NextVersionToken;
import com.sonicsw.mf.common.config.impl.VersionMisMatchException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.BooleanExpression;
import com.sonicsw.mf.common.config.query.ElementComparator;
import com.sonicsw.mf.common.config.query.EqualExpression;
import com.sonicsw.mf.common.config.query.From;
import com.sonicsw.mf.common.config.query.FromDirectory;
import com.sonicsw.mf.common.config.query.FromElementList;
import com.sonicsw.mf.common.config.query.FromElementType;
import com.sonicsw.mf.common.config.query.FromFolder;
import com.sonicsw.mf.common.config.query.OrderedBy;
import com.sonicsw.mf.common.config.query.Query;
import com.sonicsw.mf.common.config.query.QueryBatch;
import com.sonicsw.mf.common.config.query.Select;
import com.sonicsw.mf.common.config.query.Where;
import com.sonicsw.mf.common.config.query.impl.ElementEvaluation;
import com.sonicsw.mf.common.config.query.impl.ElementSelection;
import com.sonicsw.mf.common.config.query.impl.ReferenceReplacer;
import com.sonicsw.mf.common.dirconfig.BackupAlreadyInProgress;
import com.sonicsw.mf.common.dirconfig.BackupPathExists;
import com.sonicsw.mf.common.dirconfig.BackupStatus;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceClosedException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.ElementInPathException;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.InvalidBackupPath;
import com.sonicsw.mf.common.dirconfig.InvalidPathException;
import com.sonicsw.mf.common.dirconfig.InvalidXMLException;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.runtime.IBackupStatus;
import com.sonicsw.mf.common.runtime.Level;
import com.sonicsw.mf.common.security.ConfigurePermissionDeniedException;
import com.sonicsw.mf.common.security.IManagementPermission;
import com.sonicsw.mf.common.security.InvalidManagementPermissionException;
import com.sonicsw.mf.common.security.ManagementPermissionDeniedException;
import com.sonicsw.mf.common.security.ManagementPermissionFactory;
import com.sonicsw.mf.common.view.IDeltaView;
import com.sonicsw.mf.common.view.INamingListener;
import com.sonicsw.mf.common.view.IView;
import com.sonicsw.mf.common.view.ViewException;
import com.sonicsw.mf.common.view.impl.DeltaView;
import com.sonicsw.mf.common.view.impl.LogicalNameSpace;
import com.sonicsw.mf.common.view.impl.NameReplacer;
import com.sonicsw.mf.common.view.impl.View;
import com.sonicsw.mf.common.xml.DirectoryBuilder;
import com.sonicsw.mf.common.xml.ElementBuilder;
import com.sonicsw.mf.common.xml.ElementListBuilder;
import com.sonicsw.mf.common.xml.Validator;
import com.sonicsw.mf.common.xml.XMLStringWriter;
import com.sonicsw.mf.framework.IAuditManager;
import com.sonicsw.mf.framework.IContainer;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.agent.TaskScheduler;
import com.sonicsw.mf.framework.directory.Convert5to6;
import com.sonicsw.mf.framework.directory.IClassLoaderUtility;
import com.sonicsw.mf.framework.directory.IDebuggingMasks;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import com.sonicsw.mf.framework.directory.ILogger;
import com.sonicsw.mf.framework.directory.IPersistSubscribers;
import com.sonicsw.mf.framework.directory.RepairNoStorageReferences;
import com.sonicsw.mf.framework.directory.SizedArrayList;
import com.sonicsw.mf.framework.directory.impl.AuthenticationConfigManager;
import com.sonicsw.mf.framework.directory.impl.BackReferenceMgr;
import com.sonicsw.mf.framework.directory.impl.ChangeAuditor;
import com.sonicsw.mf.framework.directory.impl.ClientTransaction;
import com.sonicsw.mf.framework.directory.impl.DSHandlers;
import com.sonicsw.mf.framework.directory.impl.DecryptionException;
import com.sonicsw.mf.framework.directory.impl.DirLockedException;
import com.sonicsw.mf.framework.directory.impl.DiskFileDSHandler;
import com.sonicsw.mf.framework.directory.impl.ExtendedSonicFSFileSystem;
import com.sonicsw.mf.framework.directory.impl.IDCache;
import com.sonicsw.mf.framework.directory.impl.IModificationManager;
import com.sonicsw.mf.framework.directory.impl.ImportManager;
import com.sonicsw.mf.framework.directory.impl.LocalFSListener;
import com.sonicsw.mf.framework.directory.impl.LocalListener;
import com.sonicsw.mf.framework.directory.impl.ModificationItem;
import com.sonicsw.mf.framework.directory.impl.ReadWriteLock;
import com.sonicsw.mf.framework.directory.impl.StandaloneURLStreamHandlerFactoryImpl;
import com.sonicsw.mf.framework.directory.impl.TransactionManager;
import com.sonicsw.mf.framework.directory.impl.TriggerValidator;
import com.sonicsw.mf.framework.directory.storage.DSEncryptionException;
import com.sonicsw.mf.framework.directory.storage.IStorage;
import com.sonicsw.mf.framework.directory.storage.PackedDirUtil;
import com.sonicsw.mf.framework.directory.storage.ParentDirDoesNotExistException;
import com.sonicsw.mf.framework.directory.storage.StorageException;
import com.sonicsw.mf.framework.directory.storage.fs.FSStorage;
import com.sonicsw.mf.framework.directory.storage.pse.PSEStorage;
import com.sonicsw.mf.framework.elementversion.IArrayElementNotificationListener;
import com.sonicsw.mf.framework.elementversion.INotificationConsumer;
import com.sonicsw.mf.framework.elementversion.NotificationConsumer;
import com.sonicsw.mx.config.util.SonicFSFile;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DirectoryService
implements IDirectoryService,
IPersistSubscribers,
IDirectoryCacheService,
IDebuggingMasks,
ILogger {
    public static final String SYSTEM_DIRECTORY_PATH = "/_MFSystem";
    public static final int DS_STORAGE_STRUCTURE_VERSION = 8;
    public static final int DS_API_VERSION = 4;
    private static final String VIRTUAL_DIRECTORY = "_MFVirtual";
    private static final String VIRTUAL_DIRECTORY_PATH = "/_MFVirtual";
    public static final String DOMAIN_PATH = "/domain";
    public static final String PERMISSIONS_PATH = "/permissions";
    private static final String DS_VERSION_INFO = "ds_version_info";
    private static final String BLOB_COPIES_DIR = "blob_copies";
    private static final String BLOB_COPIES_PREFIX = "_MFCP";
    static final String MF_CONFING_VERSION = "100";
    public static final String LOCK_ELEMENT = "lock";
    public static final String BACKUP_ELEMENT = "backup_state";
    public static final String OPEN_ELEMENT = "dsisopen";
    public static final String SUBSCRIBERS_ELEMENT = "subscribers";
    public static final String SUBSCRIBERS_COLLECTION_NAME = "ds_subscribers";
    public static final String BACKUP_VERSION_ELEMENT = "backup_version";
    public static final String BACKUP_STATUS_ELEMENT = "backup_status";
    public static final String BACKUP_STATUS_ELEMENT_PATH = "/_MFSystem/backup_status";
    public static final String BACKUP_VERSION_ELEMENT_PATH = "/_MFSystem/backup_version";
    public static final String DS_VERSION_INFO_PATH = "/_MFVirtual/ds_version_info";
    public static final String VERSION_ELEMENT = "version";
    public static final String VERSION_ELEMENT_PATH = "/_MFSystem/version";
    public static final String VIEW_ELEMENT = "/_MFSchema/view";
    static final String STORAGE_HINTS_ELEMENT = "/_MFSchema/storage_hints";
    private static final String HINTS_ATT = "HINTS_ATTRIBUTE";
    private static final String LOCK_ELEMENT_PATH = "/_MFSystem/lock";
    private static final String BACKUP_ELEMENT_PATH = "/_MFSystem/backup_state";
    private static final String OPEN_ELEMENT_PATH = "/_MFSystem/dsisopen";
    public static final String IDCACHE_ELEMENT = "/_MFSystem/idcache";
    private static final String SUBSCRIBERS_ELEMENT_PATH = "/_MFSystem/subscribers";
    private static final String SUSPEND_NOTIFICATIONS_ELEMENT_PATH = "/_MFSystem/suspend_notifications";
    private static final String RESERVED_CHARACTERS = "\\|";
    private static final String DOMAIN_ELEMENT_PATH = "/domain/domain";
    private static final String MANAGE_PERMISSIONS_PATH = "/permissions/manage";
    private static final String CONFIGURE_PERMISSIONS_PATH = "/permissions/configure";
    private static EntityName VIEW_ELEMENT_ENTITY_NAME = null;
    private static EntityName SYSTEM_DIRECTORY_PATH_ENTITY_NAME = null;
    private static EntityName LOCK_ELEMENT_ENTITY_NAME = null;
    private static EntityName BACKUP_ELEMENT_ENTITY_NAME = null;
    private static EntityName OPEN_ELEMENT_ENTITY_NAME = null;
    private static EntityName VERSION_ELEMENT_ENTITY_NAME = null;
    private static EntityName IDCACHE_ELEMENT_ENTITY_NAME = null;
    private static EntityName SUBSCRIBERS_ELEMENT_ENTITY_NAME = null;
    private static EntityName BACKUP_VERSION_ELEMENT_ENTITY_NAME = null;
    private static EntityName BACKUP_STATUS_ELEMENT_ENTITY_NAME = null;
    private static EntityName DOMAIN_PATH_ENTITY_NAME = null;
    private static EntityName DOMAIN_ELEMENT_ENTITY_NAME = null;
    private static EntityName PERMISSIONS_PATH_ENTITY_NAME = null;
    private static EntityName MANAGE_PERMISSIONS_ELEMENT_ENTITY_NAME = null;
    private static EntityName CONFIGURE_PERMISSIONS_ELEMENT_ENTITY_NAME = null;
    private static final int PERMISSION_CONFIGURE_FOLDER = 0;
    private static final int PERMISSION_CONFIGURE_ELEMENT = 1;
    private static final int PERMISSION_MANAGE_FOLDER = 2;
    private static final int PERMISSION_MANAGE_CONTAINER = 3;
    private static final int PERMISSION_MANAGE_COMPONENT = 4;
    private static EntityName SUSPEND_NOTIFICATIONS_ENTITY_NAME = null;
    private static final String GLOBAL_PERMISSIONS_GROUP_NAME = "Administrators";
    private static final String ROOT_DIRECTORY = "/";
    private static final String PERMISSIONS_VALUE_ATTRIBUTE_NAME = "VALUE";
    private static final String DOMAIN_ELEMENT_NAME = "/domain/domain";
    private static final String POLICIES_DIRECTORY = "/policies";
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL;
    private String m_domain;
    private File m_domainDir;
    private File m_blobCopiesDir;
    private IStorage m_storage;
    private IStorage m_blobStorage;
    private IStorage m_systemStorage;
    private Hashtable m_startup_properties;
    private boolean m_open;
    private IDCache m_idCache;
    private com.sonicsw.mf.common.ILogger m_logger;
    private Object m_subscribers_lock;
    private ImportManager m_importManager;
    private NotificationManager m_notificationManager;
    private long m_backupVersion;
    private String m_hostDir;
    private TriggerValidator m_validator;
    private DSHandlers m_dsHandlers;
    private IClassLoaderUtility m_loader;
    private IFrameworkComponentContext m_context;
    private AuthenticationConfigManager m_authentication;
    private int m_traceMask;
    private LocalListener m_localListener;
    private boolean m_noContainer;
    private boolean m_ciFirstPhase;
    private LogicalNameSpace m_logicalNameSpace;
    private boolean m_FSInterfaceIsUsed;
    private long m_copySequenceNum;
    private String m_storageType;
    private boolean m_useFS_STORAGE;
    private boolean m_usePSE_STORAGE;
    TransactionManager m_trManager;
    ReadWriteLock m_lock;
    BackReferenceMgr m_backRefMgr;
    BackupStatus m_backupStatus;
    HashMap m_hierarchicalTypes;
    HashMap m_suspendNotifications;
    private int m_zipFileCounter;
    private static volatile StandaloneURLStreamHandlerFactoryImpl m_URLHandlerFactory;
    private static Object LOCK_OBJ;

    public DirectoryService(Hashtable properties, String domain, com.sonicsw.mf.common.ILogger logger) throws DirectoryServiceException {
        this(properties, domain, logger, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryService(Hashtable properties, String domain, com.sonicsw.mf.common.ILogger logger, boolean noContainer, IClassLoaderUtility loader, IFrameworkComponentContext context) throws DirectoryServiceException {
        block18: {
            this.m_subscribers_lock = new Object();
            this.m_importManager = null;
            this.m_notificationManager = null;
            this.m_backupVersion = 0L;
            this.m_context = null;
            this.m_authentication = null;
            this.m_localListener = null;
            this.m_trManager = null;
            this.m_backRefMgr = null;
            this.m_backupStatus = new BackupStatus();
            this.m_hierarchicalTypes = null;
            this.m_suspendNotifications = null;
            this.m_zipFileCounter = 0;
            this.m_startup_properties = properties;
            this.m_domain = domain;
            Boolean isRestrictedBackupDSProperty = (Boolean)properties.get("IS_RESTRICTED_BACKUP");
            boolean isRestrictedBackupDS = isRestrictedBackupDSProperty == null ? false : isRestrictedBackupDSProperty;
            Boolean tmp = (Boolean)properties.get("CI_FIRST_PHASE");
            this.m_ciFirstPhase = tmp != null && tmp != false;
            this.m_lock = new ReadWriteLock(isRestrictedBackupDS);
            this.m_notificationManager = new NotificationManager(this);
            this.m_logger = logger;
            this.m_loader = loader;
            this.m_context = context;
            this.m_noContainer = noContainer;
            this.m_logicalNameSpace = null;
            this.m_FSInterfaceIsUsed = false;
            this.m_copySequenceNum = 0L;
            Integer traceMaskObject = (Integer)properties.get("TRACE_MASK");
            this.m_traceMask = traceMaskObject == null ? 0 : traceMaskObject;
            this.m_storageType = (String)properties.get("STORAGE_TYPE_ATTRIBUTE");
            this.m_useFS_STORAGE = this.m_storageType.equals("FS_STORAGE");
            this.m_usePSE_STORAGE = this.m_storageType.equals("PSE_STORAGE");
            Boolean testAuthentication = (Boolean)properties.get("TEST_AUTHENTICATION_ATTRIBUTE");
            if (this.m_storageType == null || !this.m_useFS_STORAGE && !this.m_usePSE_STORAGE) {
                throw new DirectoryServiceException("Only FILE_SYSTEM_STORAGE and PSE_STORAGE storage types are currently supported.");
            }
            String hostDirDepricated = (String)properties.get("FS_HOST_DIRECTORY_ATTRIBUTE");
            String hostDir = (String)properties.get("HOST_DIRECTORY_ATTRIBUTE");
            this.trace(16, "STARTUP: " + properties.toString());
            if (hostDirDepricated != null) {
                this.logMessage("The HOST_DIRECTORY attribute under the FILE_SYSTEM_STORAGE attribute set is deprecated", 2);
                if (hostDir != null) {
                    throw new DirectoryServiceException("Found two HOST_DIRECTORY attributes. Please remove the one under the FILE_SYSTEM_STORAGE attribute set.");
                }
                hostDir = hostDirDepricated;
            }
            this.m_hostDir = hostDir;
            this.createDomainDir(hostDir, domain, noContainer);
            this.cleanupBlobCopies();
            String password = (String)properties.get("PASSWORD");
            try {
                if (this.m_useFS_STORAGE) {
                    this.m_storage = password != null && password.length() != 0 ? new FSStorage(hostDir, domain, "data", password, true) : new FSStorage(hostDir, domain, "data", true);
                    this.m_systemStorage = new FSStorage(hostDir, domain, "data");
                    this.m_blobStorage = new FSStorage(hostDir, domain, "blobs", true);
                } else {
                    HashMap ftProps = new HashMap(this.m_startup_properties);
                    this.m_storage = password != null && password.length() != 0 ? new PSEStorage(hostDir, domain, "data", password, ftProps) : new PSEStorage(hostDir, domain, "data", null, ftProps);
                    this.m_systemStorage = new PSEStorage((PSEStorage)this.m_storage);
                    this.m_systemStorage.createCollectionIfNotCreated(SUBSCRIBERS_COLLECTION_NAME);
                    this.m_blobStorage = this.m_storage;
                }
                this.m_storage.setLogger(this);
                this.m_systemStorage.setLogger(this);
                this.m_blobStorage.setLogger(this);
                this.openStorage();
                this.m_open = true;
                this.createSchemaElements(isRestrictedBackupDS);
                this.createJNDIContext();
                this.initLogicalNameSpace();
                this.initSuspendNotifications();
            }
            catch (StorageException e) {
                this.close();
                throw this.convertException(e);
            }
            catch (DirectoryServiceException e) {
                boolean normalClose = !(e instanceof DirLockedException) && !(e instanceof DecryptionException);
                this.close(normalClose);
                throw e;
            }
            if (!this.m_ciFirstPhase) {
                this.m_validator = new TriggerValidator(this);
                this.m_dsHandlers = new DSHandlers(this);
            }
            this.trace(16, "Created the trigger validator.");
            if (!noContainer || testAuthentication != null && testAuthentication.booleanValue()) {
                this.m_authentication = new AuthenticationConfigManager(this, this, isRestrictedBackupDS);
                this.trace(16, "Created the authentication manager.");
            }
            if (noContainer) {
                try {
                    if (m_URLHandlerFactory == null) {
                        Object e = LOCK_OBJ;
                        synchronized (e) {
                            if (m_URLHandlerFactory == null) {
                                m_URLHandlerFactory = new StandaloneURLStreamHandlerFactoryImpl(this);
                                URL.setURLStreamHandlerFactory(m_URLHandlerFactory);
                            }
                            break block18;
                        }
                    }
                    m_URLHandlerFactory.setDirectoryService(this);
                }
                catch (Throwable e) {
                    this.logMessage("Failed to set URLStreamHandlerFactory, trace follows...", e, 1);
                }
            }
        }
    }

    private void leaveTransactionAndReleaseLock(boolean joinedTransaction, boolean transactOK) throws DirectoryServiceException {
        DirectoryServiceException commitException = null;
        Throwable otherThrowable = null;
        if (joinedTransaction) {
            try {
                this.m_trManager.leave(transactOK);
            }
            catch (DirectoryServiceException e) {
                commitException = e;
            }
            catch (Throwable t) {
                otherThrowable = t;
            }
        }
        this.m_lock.releaseLock();
        if (commitException != null) {
            throw commitException;
        }
        if (otherThrowable != null) {
            if (otherThrowable instanceof Error) {
                throw (Error)otherThrowable;
            }
            if (otherThrowable instanceof RuntimeException) {
                throw (RuntimeException)otherThrowable;
            }
            throw new Error(otherThrowable.toString());
        }
    }

    private void initLogicalNameSpace() throws DirectoryServiceException {
        this.m_logicalNameSpace = new LogicalNameSpace();
        this.m_logicalNameSpace.init((IDirectoryAdminService)this, STORAGE_HINTS_ELEMENT, HINTS_ATT);
        this.m_trManager.setLogicalNameSpace(this.m_logicalNameSpace);
    }

    public int getDirectoryServiceVersion() {
        return 4;
    }

    public String getDirectoryServiceReleaseVersion() {
        return Version.getReleaseName();
    }

    @Override
    public void setTraceMask(int traceMask) {
        this.m_traceMask = traceMask;
    }

    void runValidationTriggers(ArrayList modificationList, boolean isImportTransaction) throws DirectoryServiceException {
        if (this.m_validator != null) {
            this.m_validator.validate(modificationList, isImportTransaction);
        }
        IValidationElementChange[] changes = modificationList.toArray(new IValidationElementChange[0]);
        if (this.m_backRefMgr != null) {
            this.m_backRefMgr.updateBackReferences(changes);
        }
    }

    void runOnDeleteTriggers(ArrayList modificationList) throws DirectoryServiceException {
        if (this.m_validator != null) {
            this.m_validator.runOnDeleteTriggers(modificationList);
        }
    }

    void runAfterDeleteTriggers(ArrayList modificationList) throws DirectoryServiceException {
        if (this.m_validator != null) {
            this.m_validator.runAfterDeleteTriggers(modificationList);
        }
    }

    void runOnUpdateTriggers(ArrayList modificationList) throws DirectoryServiceException {
        if (this.m_validator != null) {
            this.m_validator.runOnUpdateTriggers(modificationList);
        }
    }

    void runAfterUpdateTriggers(ArrayList modificationList) throws DirectoryServiceException {
        if (this.m_validator != null) {
            this.m_validator.runAfterUpdateTriggers(modificationList);
        }
    }

    void runOnCreateTriggers(ArrayList modificationList) throws DirectoryServiceException {
        if (this.m_validator != null) {
            this.m_validator.runOnCreateTriggers(modificationList);
        }
    }

    void runAfterCreateTriggers(ArrayList modificationList) throws DirectoryServiceException {
        if (this.m_validator != null) {
            this.m_validator.runAfterCreateTriggers(modificationList);
        }
    }

    boolean hasConsumer() {
        return this.m_notificationManager.hasConsumer();
    }

    private void createDomainDir(String hostDirName, String domainName, boolean noContainer) throws DirectoryServiceException {
        if (domainName == null || domainName.length() == 0) {
            throw new DirectoryServiceException("A domain name is missing.");
        }
        if (hostDirName == null || hostDirName.length() == 0) {
            throw new DirectoryServiceException("The HOST_DIRECTORY attribute is missing.");
        }
        File hostDir = new File(hostDirName);
        if (!hostDir.exists()) {
            throw new DirectoryServiceException("Directory \"" + hostDirName + "\", does not exist.");
        }
        this.m_domainDir = new File(hostDir, domainName);
        if (!this.m_domainDir.exists()) {
            if (!noContainer || this.m_ciFirstPhase) {
                throw new DirectoryServiceException("Domain directory \"" + this.m_domainDir.getPath() + "\" was not found.");
            }
            if (!this.m_domainDir.mkdir()) {
                throw new DirectoryServiceException("Cannot create the root directory \"" + this.m_domainDir.getPath() + "\".");
            }
        }
        if (!this.m_domainDir.canWrite()) {
            throw new DirectoryServiceException("No write permission in directory \"" + this.m_domainDir.getPath() + "\".");
        }
    }

    private void cleanupBlobCopies() throws DirectoryServiceException {
        this.m_blobCopiesDir = new File(this.m_domainDir, BLOB_COPIES_DIR);
        if (!this.m_blobCopiesDir.exists() && !this.m_blobCopiesDir.mkdir()) {
            throw new DirectoryServiceException("Cannot create the directory \"" + DirectoryService.getCanonicalPath(this.m_blobCopiesDir) + "\".");
        }
        File[] deletionList = this.m_blobCopiesDir.listFiles();
        if (deletionList == null) {
            throw new DirectoryServiceException(DirectoryService.getCanonicalPath(this.m_blobCopiesDir) + " is corrupt. Remove it and restart the program.");
        }
        for (int i = 0; i < deletionList.length; ++i) {
            deletionList[i].delete();
        }
    }

    @Override
    public String getDomainDirectoryName() {
        if (this.m_domainDir != null) {
            return DirectoryService.getCanonicalPath(this.m_domainDir);
        }
        return "?";
    }

    String getBlobCopiesDir() {
        return DirectoryService.getCanonicalPath(this.m_blobCopiesDir);
    }

    public String getDomain() {
        return this.m_domain;
    }

    public IDirElement getElement(String elementName, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        this.trace(1024, "getElement " + elementName + " for update " + forUpdate);
        if (elementName.startsWith(VIRTUAL_DIRECTORY_PATH)) {
            if (forUpdate) {
                throw new DirectoryServiceException("Cannot update virtual data.");
            }
            String[] nameComp = DirectoryService.validateName(elementName).getNameComponents();
            if (nameComp.length > 1 && nameComp[0].equals(VIRTUAL_DIRECTORY) && nameComp[1].equals(DS_VERSION_INFO)) {
                IDirElement infoElement = ElementFactory.createElement((String)DS_VERSION_INFO_PATH, (String)"ds_info", (String)MF_CONFING_VERSION);
                IAttributeSet attributes = infoElement.getAttributes();
                try {
                    attributes.setLongAttribute("BACKUP_VERSION", new Long(this.m_backupVersion));
                }
                catch (ReadOnlyException e) {
                    throw new Error(e.toString());
                }
                catch (AttributeSetTypeException e) {
                    throw new Error(e.toString());
                }
                catch (ConfigException e) {
                    throw new Error(e.toString());
                }
                return infoElement;
            }
            return null;
        }
        return this.getElementInternal(elementName, forUpdate, false, getSubclassingDelta);
    }

    public IDirElement getElement(String elementName, boolean forUpdate) throws DirectoryServiceException {
        return this.getElement(elementName, forUpdate, false);
    }

    public IDirElement getElementAsIs(String elementName, boolean forUpdate) throws DirectoryServiceException {
        this.trace(1024, "getElementAsIs " + elementName + " for update " + forUpdate);
        return this.getElementInternal(elementName, forUpdate, true, false);
    }

    public IDirElement[] getElements(Query query, boolean forUpdate) throws DirectoryServiceException {
        return this.getElements(query, forUpdate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDirElement[] getElements(Query query, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        Select select;
        this.trace(1024, "getElements " + query + " for update " + forUpdate);
        if (query == null) {
            throw new DirectoryServiceException("The query parameter of the getElements call cannot be null.");
        }
        if ((this.m_traceMask & 1) > 0) {
            this.trace(1024, query.toString());
        }
        if ((select = query.getSelect()) != null && forUpdate) {
            throw new DirectoryServiceException("Elements from a query that contains a SELECT clause must be fetched for read-only.");
        }
        From from = this.retrieveFrom(query);
        try {
            this.m_lock.readLock();
            String[] elementList = null;
            if (from instanceof FromDirectory) {
                IElementIdentity[] ids = this.listElements(((FromDirectory)from).getDirectoryName());
                elementList = new String[ids.length];
                for (int i = 0; i < elementList.length; ++i) {
                    elementList[i] = ids[i].getName();
                }
            } else {
                if (from instanceof FromElementType) {
                    throw new DirectoryServiceException("'From Type' queries are not supported by the IDirectoryAdminService interface.");
                }
                elementList = ((FromElementList)from).getElementNames();
            }
            Where where = query.getWhere();
            ArrayList qualifiedElement = new ArrayList();
            HashMap<String, Boolean> alreadyConsideredTable = new HashMap<String, Boolean>();
            ElementSelection selector = null;
            if (select != null) {
                selector = new ElementSelection(select);
            }
            for (int i = 0; i < elementList.length; ++i) {
                if (alreadyConsideredTable.get(elementList[i]) != null) continue;
                boolean getForUpdate = select != null ? true : forUpdate;
                IDirElement[] candidates = this.getElements(elementList[i], getForUpdate, getSubclassingDelta);
                for (int j = 0; j < candidates.length; ++j) {
                    alreadyConsideredTable.put(candidates[j].getIdentity().getName(), Boolean.TRUE);
                    this.addQueryCandidate(candidates[j], qualifiedElement, where, selector);
                }
            }
            IDirElement[] result = new IDirElement[qualifiedElement.size()];
            this.createResults(qualifiedElement, result);
            if ((this.m_traceMask & 1) > 0) {
                for (int i = 0; i < result.length; ++i) {
                    this.trace(1024, result[i].toString());
                }
            }
            IDirElement[] iDirElementArray = result;
            return iDirElementArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void addQueryCandidate(IDirElement candidateParam, ArrayList selectedList, Where where, ElementSelection selector) {
        IDirElement candidate = candidateParam;
        if (where == null || where != null && ElementEvaluation.evaluate((IElement)candidate, (Where)where)) {
            if (selector != null) {
                try {
                    selector.removeUnselectedAttributes(candidate);
                }
                catch (Exception e) {
                    this.logMessage("Failed, trace follows...", e, 2);
                    throw new Error(e.toString());
                }
                candidate = (IDirElement)((Element)candidate).createClone();
                ((Element)candidate).setReadOnly(true);
            }
            selectedList.add(candidate);
        }
    }

    @Override
    public HashMap getStorageToLogicalMap() {
        this.trace(1024, "getStorageToLogicalMap");
        try {
            this.m_lock.readLock();
            HashMap hashMap = this.m_logicalNameSpace.getStorageToLogicalMap();
            return hashMap;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    @Override
    public void newTriggerValidator() {
        this.trace(1024, "newTriggerValidator");
        try {
            this.m_lock.readLock();
            this.m_validator = new TriggerValidator(this);
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    @Override
    public void newDSHandlers() {
        this.trace(1024, "newDSHandlers");
        try {
            this.m_lock.readLock();
            this.m_dsHandlers = new DSHandlers(this);
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void upgrade5to6(String configType, String configLogicalPath) throws DirectoryServiceException {
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            Convert5to6.doUpgrade5to6(this, configType, configLogicalPath);
            transactOK = true;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public void setElementReleaseVersion(String elementName, String newVersion) throws DirectoryServiceException {
        EntityName eName = DirectoryService.validateName(elementName);
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            IDirElement element = this.m_storage.getElement(eName);
            ElementIdentity id = (ElementIdentity)element.getIdentity();
            id.setType(id.getType(), newVersion);
            this.storeInternal(eName, element);
            String logicalName = null;
            try {
                logicalName = this.m_logicalNameSpace.logicalFromStorage(eName.getName());
                if (logicalName != null) {
                    Element logicalElement = (Element)this.getFSElement(logicalName, true);
                    logicalElement.addReleaseVersion(newVersion);
                    this.updateFSElement((IDeltaDirElement)logicalElement.doneUpdate());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            transactOK = true;
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    private IDirElement getElementInternal(String elementName, boolean forUpdate, boolean asIs, boolean attachDelta) throws DirectoryServiceException {
        try {
            IDSHandler handler;
            EntityName eName = this.lockAndValidate(elementName);
            if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(eName)) != null) {
                IDirElement iDirElement = this.m_dsHandlers.getElement(handler, elementName);
                return iDirElement;
            }
            if (this.m_idCache.get(eName) == null) {
                handler = null;
                return handler;
            }
            handler = this.prepareForShipment(this.m_storage.getElement(eName), forUpdate, asIs, attachDelta);
            return handler;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IDirElement[] getElements(String elementName, boolean forUpdate) throws DirectoryServiceException {
        return this.getElements(elementName, forUpdate, false);
    }

    public IDirElement[] getElements(String elementName, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        this.trace(1024, "getElements " + elementName + " for update " + forUpdate);
        this.validateOpen();
        EntityName eName = DirectoryService.validateName(elementName);
        if (PackedDirUtil.underPackedDir(eName)) {
            return this.getElementsAsIs(eName, forUpdate);
        }
        IDirElement element = this.getElement(elementName, forUpdate, getSubclassingDelta);
        if (element != null) {
            return new IDirElement[]{element};
        }
        return new IDirElement[0];
    }

    private DirectoryServiceException convertException(StorageException se) {
        Throwable directoryException = se instanceof ParentDirDoesNotExistException ? new DirectoryDoesNotExistException("Parent directory problem: see cause") : new DirectoryServiceException("Storage exception: see cause");
        directoryException.initCause((Throwable)se);
        return directoryException;
    }

    private IDirElement[] getElementsAsIs(EntityName eName, boolean forUpdate) throws DirectoryServiceException {
        try {
            IDirElement[] elements;
            block8: {
                this.m_lock.readLock();
                try {
                    elements = this.m_storage.getElements(eName);
                    if (elements != null) break block8;
                    IDirElement[] iDirElementArray = new IDirElement[]{};
                    return iDirElementArray;
                }
                catch (StorageException e) {
                    throw this.convertException(e);
                }
            }
            for (int i = 0; i < elements.length; ++i) {
                ((Element)elements[i]).setReadOnly(!forUpdate);
            }
            IDirElement[] iDirElementArray = elements;
            return iDirElementArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpandableBlob(EntityName eName) {
        this.m_lock.readLock();
        try {
            File blobFile = this.m_blobStorage.blobToFile(eName);
            boolean expandable = Blob.isExpandableFile((File)blobFile);
            if (this.m_blobStorage instanceof PSEStorage) {
                blobFile.delete();
            }
            boolean bl = expandable;
            return bl;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private IDirElement prepareForShipment(IDirElement elementParam, boolean forUpdate, boolean asIs, boolean attachDelta) throws DirectoryServiceException {
        IDirElement element = elementParam;
        if (element == null) {
            return null;
        }
        if (!asIs) {
            String superReference = element.getSuperElementName();
            boolean isSuper = ((Element)element).isSuperElement();
            if (superReference != null) {
                element = this.realizeSubClassedElement(element.getIdentity(), superReference, attachDelta);
            } else if (isSuper) {
                element = this.cleanupSuperElement((Element)element, false, false);
            }
        }
        ((Element)element).setReadOnly(!forUpdate);
        return element;
    }

    private Element cleanupSuperElement(Element element, boolean deleteAll, boolean clearTemplate) {
        return element.cleanupSuperElement(deleteAll, clearTemplate);
    }

    private IDirElement realizeSubClassedElement(IElementIdentity id, String superReference, boolean attachDelta) throws DirectoryServiceException {
        Element superElement = this.retrieveElementAsIs(superReference);
        return this.realizeSubClassedElement(superElement, id, attachDelta);
    }

    private IDirElement realizeSubClassedElement(Element superElement, IElementIdentity id, boolean attachDelta) {
        byte[] deltaBytes = superElement.getSubclassedDelta(id.getName());
        Element realizedElement = this.doRealizeSub(superElement, (byte[])(attachDelta ? deltaBytes : null), DeltaElement.fromBytes((byte[])deltaBytes), id.getName(), id);
        return realizedElement;
    }

    public IIdentity getIdentity(String name) throws DirectoryServiceException {
        this.trace(1024, "getIdentity " + name);
        try {
            this.m_lock.readLock();
            this.validateOpen();
            IIdentity iIdentity = this.m_idCache.get(DirectoryService.validateName(name));
            return iIdentity;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIdentity lookupIdentity(String name) throws DirectoryServiceException {
        this.trace(1024, "lookupIdentity " + name);
        try {
            IDSHandler handler;
            EntityName entity = this.lockAndValidate(name);
            String parent = entity.getParent();
            if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(parent)) != null) {
                IIdentity[] identities;
                for (IIdentity identity : identities = this.m_dsHandlers.listAll(handler, parent)) {
                    if (!identity.getName().equals(entity.getName())) continue;
                    IIdentity iIdentity = identity;
                    return iIdentity;
                }
            }
            IIdentity iIdentity = this.m_idCache.get(entity);
            return iIdentity;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IDirElement[] getAllElements(String dirName, boolean forUpdate) throws DirectoryServiceException {
        this.trace(1024, "getAllElements " + dirName + " for update " + forUpdate);
        try {
            IDSHandler handler;
            EntityName dirNameE = this.lockAndValidate(dirName);
            if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(dirNameE)) != null) {
                IDirElement[] iDirElementArray = this.m_dsHandlers.getAllElements(handler, dirName);
                return iDirElementArray;
            }
            IDirElement[] elements = this.m_storage.getAllElements(dirNameE);
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = this.prepareForShipment(elements[i], forUpdate, false, false);
            }
            IDirElement[] iDirElementArray = elements;
            return iDirElementArray;
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDirElement[] getAllElementsCompressed(String dirName, boolean forUpdate) throws DirectoryServiceException {
        this.trace(1024, "getAllElementsCompressed " + dirName + " for update " + forUpdate);
        try {
            this.m_lock.readLock();
            IDirElement[] iDirElementArray = this.getAllElements(dirName, forUpdate);
            return iDirElementArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean directoryExists(String dirName) throws DirectoryServiceException {
        try {
            this.m_lock.readLock();
            this.validateOpen();
            IIdentity id = null;
            try {
                id = this.m_idCache.get(DirectoryService.validateName(dirName));
            }
            catch (DirectoryServiceException directoryServiceException) {
                // empty catch block
            }
            if (id == null) {
                boolean bl = false;
                return bl;
            }
            if (!(id instanceof IDirIdentity)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIdentity[] listAll(String dirName) throws DirectoryServiceException {
        this.trace(1024, "listAll " + dirName);
        try {
            IDSHandler handler;
            EntityName dirNameE = this.lockAndValidate(dirName);
            if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(dirNameE)) != null) {
                IIdentity[] iIdentityArray = this.m_dsHandlers.listAll(handler, dirName);
                return iIdentityArray;
            }
            IIdentity[] iIdentityArray = this.m_idCache.list(dirNameE, true, true);
            return iIdentityArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException {
        this.trace(1024, "listDirectories " + dirName);
        try {
            IDSHandler handler;
            EntityName dirNameE = this.lockAndValidate(dirName);
            if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(dirNameE)) != null) {
                IDirIdentity[] iDirIdentityArray = this.m_dsHandlers.listDirectories(handler, dirName);
                return iDirIdentityArray;
            }
            IIdentity[] ids = this.m_idCache.list(dirNameE, true, false);
            IDirIdentity[] dirIds = new IDirIdentity[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                dirIds[i] = (IDirIdentity)ids[i];
            }
            IDirIdentity[] iDirIdentityArray = dirIds;
            return iDirIdentityArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IElementIdentity[] listElements(String dirName) throws DirectoryServiceException {
        this.trace(1024, "listElements " + dirName);
        try {
            IDSHandler handler;
            EntityName dirNameE = this.lockAndValidate(dirName);
            if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(dirNameE)) != null) {
                IElementIdentity[] iElementIdentityArray = this.m_dsHandlers.listElements(handler, dirName);
                return iElementIdentityArray;
            }
            IIdentity[] ids = this.m_idCache.list(dirNameE, false, true);
            IElementIdentity[] elementIds = new IElementIdentity[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                elementIds[i] = (IElementIdentity)ids[i];
            }
            IElementIdentity[] iElementIdentityArray = elementIds;
            return iElementIdentityArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private EntityName lockAndValidate(String elementName) throws DirectoryServiceException {
        this.m_lock.readLock();
        this.validateOpen();
        EntityName eName = DirectoryService.validateName(elementName);
        return eName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setElements(IDirElement[] elements) throws DirectoryServiceException {
        this.trace(1056, "setElements: " + elements.length + " are set.");
        this.traceResults(elements, 32);
        this.validateOpen();
        if (elements.length == 0) {
            return;
        }
        if (!this.m_notificationManager.inThrowAway()) {
            throw new DirectoryServiceException("setElements() must be called from the import manager.");
        }
        EntityName firstName = DirectoryService.validateName(elements[0].getIdentity().getName());
        String parentDir = firstName.getParent();
        boolean packerDir = PackedDirUtil.underPackedDir(firstName);
        this.authenticationOkToModify(firstName);
        try {
            this.m_lock.writeLock();
            EntityName[] eNames = new EntityName[elements.length];
            for (int i = 0; i < elements.length; ++i) {
                eNames[i] = DirectoryService.validateName(elements[i].getIdentity().getName());
                if (eNames[i].getParent().equals(parentDir)) continue;
                throw new DirectoryServiceException("All the elements must be under the same directory.");
            }
            boolean transactOK = false;
            try {
                this.m_trManager.join();
                if (packerDir) {
                    this.m_storage.setElements(elements, false);
                    for (int i = 0; i < eNames.length; ++i) {
                        this.m_idCache.addElement(eNames[i], elements[i].getIdentity());
                    }
                } else {
                    for (int i = 0; i < elements.length; ++i) {
                        this.storeInternal(eNames[i], elements[i]);
                    }
                }
                transactOK = true;
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
            finally {
                this.m_trManager.leave(transactOK);
            }
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void deleteElements(String[] elementNames) throws DirectoryServiceException {
        this.commonDeleteElements(elementNames, false);
    }

    public void importDeleteElements(String[] elementNames) throws DirectoryServiceException {
        this.commonDeleteElements(elementNames, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonDeleteElements(String[] elementNames, boolean importDelete) throws DirectoryServiceException {
        this.trace(1056, "deleteElements: " + elementNames.length + " are deleted.");
        this.validateOpen();
        if (elementNames.length == 0) {
            return;
        }
        EntityName firstName = DirectoryService.validateName(elementNames[0]);
        String parentDir = firstName.getParent();
        boolean packedDir = PackedDirUtil.underPackedDir(firstName);
        try {
            this.m_lock.writeLock();
            ArrayList<EntityName> nameList = new ArrayList<EntityName>();
            for (int i = 0; i < elementNames.length; ++i) {
                EntityName eName = DirectoryService.validateName(elementNames[i]);
                if (!eName.getParent().equals(parentDir)) {
                    throw new DirectoryServiceException("All deleted elements must be under the same directory.");
                }
                IIdentity id = this.m_idCache.get(eName);
                if (id == null) continue;
                if (!(id instanceof IElementIdentity)) {
                    throw new DirectoryServiceException('\"' + elementNames[i] + "\" is not an element.");
                }
                nameList.add(eName);
            }
            if (nameList.isEmpty()) {
                return;
            }
            EntityName[] eNames = new EntityName[nameList.size()];
            nameList.toArray(eNames);
            boolean transactOK = false;
            try {
                this.m_trManager.join();
                if (packedDir) {
                    int i;
                    ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
                    for (i = 0; i < eNames.length; ++i) {
                        IElementIdentity id = (IElementIdentity)this.m_idCache.get(eNames[i]);
                        Element beforeImage = (Element)this.getElementAsIs(id.getName(), false);
                        Element deletedElement = (Element)Element.createDeletedElement((IElementIdentity)id);
                        String logicalName = this.storageToLogical(id.getName());
                        ModificationItem modItem = new ModificationItem(beforeImage, deletedElement, logicalName, true);
                        modifications.add(modItem);
                    }
                    this.m_storage.deleteElements(eNames);
                    this.m_notificationManager.addGroupNotification(modifications, true);
                    for (i = 0; i < eNames.length; ++i) {
                        this.m_idCache.remove(eNames[i]);
                    }
                } else {
                    for (int i = 0; i < elementNames.length; ++i) {
                        this.commonDeleteElement(elementNames[i], null, importDelete);
                    }
                }
                transactOK = true;
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
            finally {
                this.m_trManager.leave(transactOK);
            }
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IElementIdentity commonDeleteElement(String elementName, IDeltaView view, boolean importDelete) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "deleteElement " + elementName + " view " + view);
        try {
            EntityName eName;
            IIdentity id;
            this.m_lock.writeLock();
            this.validateOpen();
            IDirElement viewElement = null;
            BeforeAfterPair pair = null;
            if (view != null) {
                pair = this.prepareToSet(((DeltaView)view).getElement(), null);
                viewElement = pair.m_after;
            }
            if ((id = this.m_idCache.get(eName = this.validateAndModify(elementName))) == null) {
                IElementIdentity iElementIdentity = null;
                return iElementIdentity;
            }
            if (!(id instanceof IElementIdentity)) {
                throw new DirectoryServiceException('\"' + elementName + "\" is not an element.");
            }
            IElementIdentity elementId = (IElementIdentity)id;
            Element oldElement = (Element)this.getElementAsIs(eName.getName(), false);
            ModificationItem modItem = null;
            Element oldRealized = null;
            Element beforeImage = oldElement;
            String logicalName = null;
            boolean transactOK = false;
            try {
                Integer state;
                IAttributeSet topSet;
                IAttributeSet systemAttrs;
                this.m_trManager.join();
                if (oldElement.isSuperElement()) {
                    throw new DirectoryServiceException('\"' + elementName + "\" is a super element, it can be deleted only after its sub-classed elements are unSubclassed or deleted.");
                }
                if (oldElement.isSubclassedElement()) {
                    beforeImage = oldRealized = (Element)this.getElement(id.getName(), false);
                    modItem = this.removeSubclassedFromSuper(oldElement.getSuperElementName(), eName.getName());
                }
                boolean importingBlob = false;
                if (importDelete && (systemAttrs = (IAttributeSet)(topSet = oldElement.getAttributes()).getAttribute("_MF_SYSTEM_ATTRIBUTES")) != null && (state = (Integer)systemAttrs.getAttribute("LARGE_FILE_STATE")) != null) {
                    importingBlob = true;
                }
                if (!importingBlob) {
                    this.m_storage.deleteElement(eName);
                }
                this.m_idCache.remove(eName);
                if (this.m_logicalNameSpace != null && (logicalName = this.storageToLogical(elementName)) != null) {
                    this.removePermissions(logicalName);
                }
                this.storeInternalViewElement(viewElement);
                transactOK = true;
                if (modItem != null) {
                    this.notifyMods(modItem, null);
                }
            }
            catch (StorageException e) {
                try {
                    throw this.convertException(e);
                }
                catch (Throwable throwable) {
                    if (modItem != null) {
                        this.notifyMods(modItem, null);
                    }
                    Element deletedElement = (Element)Element.createDeletedElement((IElementIdentity)elementId);
                    ModificationItem modification = new ModificationItem(beforeImage, deletedElement, logicalName, false);
                    this.notifyMods(modification, this.createViewMod(view, pair));
                    this.m_trManager.leave(transactOK);
                    throw throwable;
                }
            }
            Element deletedElement = (Element)Element.createDeletedElement((IElementIdentity)elementId);
            ModificationItem modification = new ModificationItem(beforeImage, deletedElement, logicalName, false);
            this.notifyMods(modification, this.createViewMod(view, pair));
            this.m_trManager.leave(transactOK);
            IElementIdentity iElementIdentity = elementId;
            return iElementIdentity;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IElementIdentity importDeleteElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.commonDeleteElement(elementName, view, true);
    }

    public IElementIdentity deleteElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.commonDeleteElement(elementName, view, false);
    }

    private ModificationItem createViewMod(IDeltaView view, BeforeAfterPair pair) {
        if (view == null) {
            return null;
        }
        return this.createViewMod(view, (Element)pair.m_before);
    }

    private ModificationItem createViewMod(IDeltaView view, Element beforeImage) {
        if (view == null) {
            return null;
        }
        return new ModificationItem((DeltaElement)((DeltaView)view).getElement(), beforeImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDirectory(String dirName) throws DirectoryServiceException {
        this.trace(1056, "createDirectory " + dirName);
        boolean transactionOk = false;
        boolean joinedTransaction = false;
        try {
            this.m_lock.writeLock();
            this.validateOpen();
            if (EntityName.containsAnyChar((String)dirName, (String)RESERVED_CHARACTERS)) {
                throw new DirectoryServiceException("Invalid name \"" + dirName + "\". Directory names cannot contain the characters: " + RESERVED_CHARACTERS);
            }
            EntityName dName = DirectoryService.validateName(dirName);
            if (this.m_dsHandlers != null && this.m_dsHandlers.getHandler(dName) != null) {
                throw new DirectoryServiceException(dirName + " is associated with a DS handler:  Cannot create " + dirName + " - DS handlers are read-only.");
            }
            IIdentity id = this.m_idCache.get(dName);
            if (id != null) {
                throw new DirectoryServiceException('\"' + dirName + "\" already exists.");
            }
            try {
                this.m_trManager.join();
                joinedTransaction = true;
                this.m_storage.createDirectory(dName);
                this.m_idCache.addDirectory(dName);
                transactionOk = true;
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactionOk);
        }
    }

    public void deleteDirectory(String dirName, IDeltaView view) throws DirectoryServiceException {
        this.deleteDirectory(dirName, view, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteDirectory(String dirName, IDeltaView view, boolean topLevel) throws DirectoryServiceException {
        this.trace(1056, "deleteDirectory " + dirName + " view " + view);
        this.validateOpen();
        EntityName dName = DirectoryService.validateName(dirName);
        try {
            if (this.m_authentication != null) {
                this.m_authentication.okToDeleteDir(dName);
                if (topLevel) {
                    this.m_authentication.startClosingDomain(dName.getName());
                }
            }
            this.m_lock.writeLock();
            IDirElement viewElement = null;
            BeforeAfterPair pair = null;
            if (view != null) {
                pair = this.prepareToSet(((DeltaView)view).getElement(), null);
                viewElement = pair.m_after;
            }
            boolean transactOK = false;
            try {
                this.m_trManager.join();
                IIdentity[] ids = this.listAll(dirName);
                ArrayList<String> elementsToDelete = new ArrayList<String>();
                ArrayList<String> dirsToDelete = new ArrayList<String>();
                for (int i = 0; i < ids.length; ++i) {
                    if (ids[i] instanceof IElementIdentity) {
                        elementsToDelete.add(ids[i].getName());
                        continue;
                    }
                    dirsToDelete.add(ids[i].getName());
                }
                String[] elementNames = new String[elementsToDelete.size()];
                elementsToDelete.toArray(elementNames);
                this.deleteElements(elementNames);
                for (int i = 0; i < dirsToDelete.size(); ++i) {
                    this.deleteDirectory((String)dirsToDelete.get(i), null, false);
                }
                this.deleteDirectory(dirName);
                this.storeInternalViewElement(viewElement);
                if (view != null) {
                    this.notifyMods(this.createViewMod(view, pair), null);
                }
                transactOK = true;
            }
            finally {
                this.m_trManager.leave(transactOK);
            }
        }
        finally {
            this.m_lock.releaseLock();
            if (this.m_authentication != null && topLevel) {
                this.m_authentication.endClosingDomain();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDirectory(String dirName) throws DirectoryServiceException {
        this.trace(1056, "deleteDirectory " + dirName);
        boolean transactionOk = false;
        boolean joinedTransaction = false;
        try {
            this.m_lock.writeLock();
            this.validateOpen();
            EntityName dName = DirectoryService.validateName(dirName);
            IIdentity[] ids = this.listAll(dirName);
            if (ids.length > 0) {
                throw new DirectoryServiceException(dirName + " is not empty.");
            }
            try {
                this.m_trManager.join();
                joinedTransaction = true;
                this.m_storage.deleteDirectory(dName);
                this.m_idCache.remove(dName);
                transactionOk = true;
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactionOk);
        }
    }

    NextVersionToken createNextVersionToken(boolean replaceToLogicalNames) {
        HashMap tokenTable = null;
        tokenTable = this.m_notificationManager != null ? this.m_notificationManager.getAndResetNewIds() : new HashMap();
        NextVersionToken token = new NextVersionToken(tokenTable);
        if (replaceToLogicalNames) {
            return token.replaceReferences((IReplaceRef)this.m_logicalNameSpace.createNameReplacer(false));
        }
        return token;
    }

    public INextVersionToken setElements(IBasicElement[] elements, String[] deleteList, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.setElements(elements, deleteList, view, false);
    }

    private IDirElement[] canBeDoneInBulk(IBasicElement[] elements) throws DirectoryServiceException {
        boolean bulkImport = true;
        IDirElement[] dirElements = null;
        if (elements != null && elements.length > 0) {
            EntityName firstName = DirectoryService.validateName(elements[0].getIdentity().getName());
            String parentDir = firstName.getParent();
            boolean packerDir = PackedDirUtil.underPackedDir(firstName);
            if (packerDir) {
                this.authenticationOkToModify(firstName);
                dirElements = new IDirElement[elements.length];
                for (int i = 0; i < elements.length; ++i) {
                    EntityName eName = DirectoryService.validateName(elements[i].getIdentity().getName());
                    if (!(elements[i] instanceof IDirElement) || !eName.getParent().equals(parentDir)) {
                        bulkImport = false;
                        break;
                    }
                    dirElements[i] = (IDirElement)((Element)elements[i]).createClone();
                }
            } else {
                bulkImport = false;
            }
        } else {
            bulkImport = false;
        }
        if (bulkImport) {
            return dirElements;
        }
        return null;
    }

    private void authenticationOkToModify(EntityName firstName) throws DirectoryServiceException {
        if (this.m_authentication != null) {
            this.m_authentication.okToModify(firstName);
        }
    }

    boolean canBeDoneInBulk(IDirElement[] elements) throws DirectoryServiceException {
        if (elements == null || elements.length == 0) {
            return false;
        }
        EntityName firstName = DirectoryService.validateName(elements[0].getIdentity().getName());
        String parentDir = firstName.getParent();
        boolean packerDir = PackedDirUtil.underPackedDir(firstName);
        if (!packerDir) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            EntityName eName = DirectoryService.validateName(elements[i].getIdentity().getName());
            if (eName.getParent().equals(parentDir)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INextVersionToken setElements(IBasicElement[] elements, String[] deleteList, IDeltaView view, boolean noBulk) throws DirectoryServiceException, VersionOutofSyncException {
        IDirElement[] dirElements = null;
        if (!(noBulk || deleteList != null && deleteList.length != 0)) {
            dirElements = this.canBeDoneInBulk(elements);
        }
        if (dirElements != null) {
            HashMap idList = this.importFromList(dirElements, null, true);
            INextVersionToken viewToken = null;
            if (view != null) {
                viewToken = this.setViewGetToken(view);
            }
            return new NextVersionToken(idList, (NextVersionToken)viewToken);
        }
        boolean transactOK = false;
        NextVersionToken token = null;
        boolean startedRememberIDs = false;
        boolean joinedTransaction = false;
        try {
            int i;
            startedRememberIDs = this.retrieveStartedRememberIDs(startedRememberIDs);
            this.m_trManager.join();
            joinedTransaction = true;
            if (deleteList != null) {
                for (i = 0; i < deleteList.length; ++i) {
                    if (deleteList[i] == null) continue;
                    this.deleteElement(deleteList[i], null);
                }
            }
            if (elements != null) {
                for (i = 0; i < elements.length; ++i) {
                    if (elements[i] == null) continue;
                    this.setElement(elements[i], null, true);
                }
            }
            if (view != null) {
                this.setView(view);
            }
            transactOK = true;
        }
        finally {
            if (startedRememberIDs) {
                token = this.createNextVersionToken(false);
            }
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return token;
    }

    public INextVersionToken setElement(IBasicElement element, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.setElement(true, element, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INextVersionToken setElement(boolean fireTriggers, IBasicElement element, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        NextVersionToken token = null;
        boolean startedRememberIDs = false;
        try {
            startedRememberIDs = this.retrieveStartedRememberIDs(startedRememberIDs);
            this.setElement(element, view, true, fireTriggers);
        }
        finally {
            if (startedRememberIDs) {
                token = this.createNextVersionToken(false);
            }
            this.m_lock.releaseLock();
        }
        return token;
    }

    private void setElement(IBasicElement element, IDeltaView view, boolean notifySubclassSetting) throws DirectoryServiceException, VersionOutofSyncException {
        this.setElement(element, view, notifySubclassSetting, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setElement(IBasicElement element, IDeltaView view, boolean notifySubclassSetting, boolean fireTriggers) throws DirectoryServiceException, VersionOutofSyncException {
        block18: {
            this.validateOpen();
            this.trace(1056, "setElement " + element + " view " + view);
            if (element == null) {
                throw new DirectoryServiceException("The element must not be null.");
            }
            try {
                this.m_lock.writeLock();
                if (this.m_authentication != null) {
                    this.m_authentication.okToModify(element.getIdentity().getName());
                }
                IDirElement oldElement = null;
                boolean isSubClassed = false;
                boolean isSuper = false;
                if (element instanceof IDirElement) {
                    if (((Element)element).isSuperElement() || ((Element)element).isSubclassedElement()) {
                        throw new Error("should never happen.");
                    }
                    EntityName nameE = DirectoryService.validateName(element.getIdentity().getName());
                    if (this.m_dsHandlers != null && this.m_dsHandlers.getHandler(nameE) != null) {
                        throw new DirectoryServiceException(nameE.getName() + " is associated with a DS handler:  Cannot set " + nameE.getName() + " - DS handlers are read-only.");
                    }
                    IIdentity id = this.m_idCache.get(nameE);
                    if (id != null && id instanceof DirIdentity) {
                        throw new DirectoryServiceException('\"' + element.getIdentity().getName() + "\" directory exists.");
                    }
                    if (((Element)element).getSuperToSubclassFrom() != null) {
                        this.subclassOnDSSide((Element)element, view);
                        return;
                    }
                } else {
                    oldElement = this.getElementAsIs(element.getIdentity().getName(), true);
                    if (oldElement != null) {
                        this.validateData(element, oldElement);
                        isSuper = ((Element)oldElement).isSuperElement();
                        isSubClassed = ((Element)oldElement).isSubclassedElement();
                    }
                }
                if (isSubClassed) {
                    this.setSubclassedElement((DeltaElement)element, (Element)oldElement, view, notifySubclassSetting, fireTriggers);
                    break block18;
                }
                if (isSuper) {
                    boolean transactOK = false;
                    HashMap allNotifications = null;
                    try {
                        this.m_trManager.join();
                        allNotifications = this.setSuperElement((DeltaElement)element, (Element)oldElement, view);
                        transactOK = true;
                    }
                    finally {
                        this.m_trManager.leave(transactOK);
                    }
                    this.m_notificationManager.addNotifications(allNotifications);
                    break block18;
                }
                this.setElementInternal(element, oldElement, view, true, fireTriggers);
            }
            finally {
                this.m_lock.releaseLock();
            }
        }
    }

    private void setSubclassedElement(DeltaElement deltaParam, Element oldElement, IDeltaView view, boolean notify, boolean fireTriggers) throws DirectoryServiceException, VersionOutofSyncException {
        DeltaElement delta = deltaParam;
        if (delta.isDeleted()) {
            throw new Error("deleteElement should be used for deleting elements.");
        }
        String superName = oldElement.getSuperElementName();
        Element superElement = (Element)this.getElementAsIs(superName, true);
        IElementIdentity deltaIdentity = delta.getIdentity();
        IElementIdentity oldIdentity = oldElement.getIdentity();
        if (superElement == null) {
            throw new DirectoryServiceException("The super element \"" + superName + "\" of \"" + deltaIdentity.getName() + "\" is missing.");
        }
        byte[] deltaBytes = superElement.getSubclassedDelta(deltaIdentity.getName());
        if (deltaBytes == null) {
            throw new DirectoryServiceException("The super element \"" + superName + "\" of \"" + deltaIdentity.getName() + "' does not contain the sub-classing information.");
        }
        DeltaElement subclassingDelta = DeltaElement.fromBytes((byte[])deltaBytes);
        if (deltaIdentity.getVersion() != oldIdentity.getVersion()) {
            this.throwVersionException(deltaIdentity.getName(), deltaIdentity.getName() + " was modified by another application.");
        }
        Element realizedOld = (Element)this.realizeSubClassedElement(superElement, oldIdentity, false);
        if (this.m_noContainer && delta != null) {
            delta = delta.createClone();
        }
        subclassingDelta.adjustToSubclassedModification(delta);
        superElement.addSubclassedElement(deltaIdentity.getName(), subclassingDelta.toBytes());
        boolean transactOK = false;
        BeforeAfterPair pair = null;
        try {
            this.m_trManager.join();
            this.storeInternal(DirectoryService.validateName(superName), (IDirElement)superElement);
            this.setElementAsIs(oldElement.doneUpdate(), null, false);
            pair = this.retrievePairAndStoreInternal(pair, view);
            transactOK = true;
            if (notify) {
                this.notifyMods(new ModificationItem(delta, realizedOld), this.createViewMod(view, pair));
            }
        }
        catch (ReadOnlyException e) {
            try {
                throw new Error(e.toString());
            }
            catch (Throwable throwable) {
                if (notify) {
                    this.notifyMods(new ModificationItem(delta, realizedOld), this.createViewMod(view, pair));
                }
                this.m_trManager.leave(transactOK, fireTriggers);
                throw throwable;
            }
        }
        this.m_trManager.leave(transactOK, fireTriggers);
    }

    private HashMap setSuperElement(DeltaElement superDelta, Element originalSuperElement, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        BeforeAfterPair pair = this.prepareToSet((IBasicElement)superDelta.createClone(), (IDirElement)originalSuperElement);
        Element newSuperElement = (Element)pair.m_after;
        String[] subList = originalSuperElement.getSubclassedList();
        HashMap<String, ModificationItem> allNotifications = new HashMap<String, ModificationItem>();
        for (int i = 0; i < subList.length; ++i) {
            String subclassedName = subList[i];
            Element subclassed = (Element)this.getElementAsIs(subclassedName, true);
            if (subclassed == null) {
                throw new DirectoryServiceException("Subclassed element \"" + subclassedName + "\" is missing.");
            }
            try {
                DeltaElement delta = superDelta;
                if (this.m_noContainer && superDelta != null) {
                    delta = superDelta.createClone();
                }
                ModificationItem modItem = this.updateSubClassed(originalSuperElement, newSuperElement, delta, subclassed);
                if (modItem.m_delta.emptyDelta()) continue;
                allNotifications.put(subclassedName, modItem);
                continue;
            }
            catch (CannotAdjustToSuperModificationException e) {
                String problematicAttribute = e.getFailingAttribute();
                this.throwVersionException(originalSuperElement.getIdentity().getName(), "Cannot modify super element \"" + originalSuperElement.getIdentity().getName() + "\" because of the \"" + problematicAttribute + "\" attribute of subclassed element \"" + subclassedName + "\". Please unSubclass \"" + subclassedName + "\" first.");
            }
        }
        EntityName superName = DirectoryService.validateName(newSuperElement.getIdentity().getName());
        this.storeInternal(superName, (IDirElement)newSuperElement);
        allNotifications.put(originalSuperElement.getIdentity().getName(), new ModificationItem(superDelta, (Element)pair.m_before));
        if (view != null) {
            BeforeAfterPair viewPair = this.prepareToSet(((DeltaView)view).getElement(), null);
            this.storeInternal(VIEW_ELEMENT_ENTITY_NAME, viewPair.m_after);
            allNotifications.put(VIEW_ELEMENT_ENTITY_NAME.getName(), new ModificationItem((DeltaElement)((DeltaView)view).getElement(), (Element)viewPair.m_before));
        }
        return allNotifications;
    }

    private ModificationItem updateSubClassed(Element originalSuperElement, Element newSuperElement, DeltaElement superDelta, Element subclassed) throws CannotAdjustToSuperModificationException, DirectoryServiceException, VersionOutofSyncException {
        IElementIdentity subclassedID = subclassed.getIdentity();
        String subClassedName = subclassedID.getName();
        DeltaElement oldSubclassingDelta = DeltaElement.fromBytes((byte[])originalSuperElement.getSubclassedDelta(subClassedName));
        Element oldRealized = this.doRealizeSub(originalSuperElement, null, oldSubclassingDelta, subClassedName, subclassedID);
        DeltaElement newSubclassedDelta = oldSubclassingDelta.createClone();
        newSubclassedDelta.adjustToSuperclassModification(superDelta);
        Element newRealized = this.doRealizeSub(newSuperElement, null, newSubclassedDelta, subClassedName, subclassed.getIdentity());
        newSuperElement.addSubclassedElement(subClassedName, newSubclassedDelta.toBytes());
        DeltaElement notificationDelta = oldRealized.createDelta(newRealized);
        if (!notificationDelta.emptyDelta()) {
            try {
                this.setElementAsIs(subclassed.doneUpdate(), null, false);
            }
            catch (ReadOnlyException e) {
                throw new Error(e.toString());
            }
        }
        return new ModificationItem(notificationDelta, oldRealized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setElementAsIs(IBasicElement element, IDeltaView view, boolean notifyMods) throws DirectoryServiceException, VersionOutofSyncException {
        this.validateOpen();
        this.trace(1056, "setElementAsIs " + element + " view " + view + "notify " + notifyMods);
        try {
            this.m_lock.writeLock();
            this.setElementInternal(element, null, view, notifyMods);
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void setElementInternal(IBasicElement element, IDirElement oldElement, IDeltaView view, boolean notifyMods) throws DirectoryServiceException, VersionOutofSyncException {
        this.setElementInternal(element, oldElement, view, notifyMods, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setElementInternal(IBasicElement element, IDirElement oldElement, IDeltaView view, boolean notifyMods, boolean fireTriggers) throws DirectoryServiceException, VersionOutofSyncException {
        IDirElement viewElement = null;
        BeforeAfterPair viewPair = null;
        if (view != null) {
            viewPair = this.prepareToSet(((DeltaView)view).getElement(), null);
            viewElement = viewPair.m_after;
        }
        BeforeAfterPair pair = this.prepareToSet(element, oldElement);
        IDirElement newElement = pair.m_after;
        boolean transactOK = false;
        try {
            this.m_trManager.join();
            this.storeInternal(DirectoryService.validateName(element.getIdentity().getName()), newElement);
            this.storeInternalViewElement(viewElement);
            transactOK = true;
        }
        finally {
            if (notifyMods) {
                ModificationItem modItem = null;
                modItem = element instanceof IDirElement ? new ModificationItem((Element)newElement) : new ModificationItem((DeltaElement)element, (Element)pair.m_before);
                this.notifyMods(modItem, this.createViewMod(view, viewPair));
            }
            this.m_trManager.leave(transactOK, fireTriggers);
        }
    }

    private void storeInternalViewElement(IDirElement viewElement) throws DirectoryServiceException {
        if (viewElement != null) {
            this.storeInternal(VIEW_ELEMENT_ENTITY_NAME, viewElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDirElement[] getUpdatedList(IElementIdentity[] identities, HashMap deletedConfs, long callerBackupVersion) throws DirectoryServiceException {
        this.trace(1152, "getUpdatedList " + identities.length + " identities");
        try {
            boolean backupVersionMismatch = this.retrieveBackupVersionMismatch(callerBackupVersion);
            SizedArrayList resultList = new SizedArrayList();
            IDirElement[] iDirElementArray = this.buildUpdateList(resultList, backupVersionMismatch, identities, deletedConfs);
            return iDirElementArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void markListUnfinished(SizedArrayList resultList) {
        Element firstElement = (Element)resultList.get(0);
        if (!(firstElement instanceof IEnvelope)) {
            firstElement = new EnvelopeElement((IElement)firstElement);
            resultList.set(0, firstElement);
        }
        ((IEnvelope)firstElement).setProperty("RNF", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDirElement[] getNewElements(String dirName, IElementIdentity[] identities) throws DirectoryServiceException {
        this.trace(1152, "getNewElements from " + dirName + " - " + identities.length + " identities ");
        try {
            this.m_lock.readLock();
            SizedArrayList resultList = new SizedArrayList();
            IDirElement[] elements = this.buildNewList(resultList, 0x100000, identities, new String[]{dirName});
            if (elements == null) {
                elements = new IDirElement[]{};
            }
            IDirElement[] iDirElementArray = elements;
            return iDirElementArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IDirElement[] getElementIfUpdated(long callerBackupVersion, String elementName, IElementIdentity id) throws DirectoryServiceException {
        if (id == null || callerBackupVersion != 0L && callerBackupVersion != this.m_backupVersion) {
            return new IDirElement[]{this.getElement(elementName, false)};
        }
        EntityName elementNameE = DirectoryService.validateName(elementName);
        IIdentity cacheObj = this.retrieveCacheElement(elementNameE);
        if (cacheObj == null || !(cacheObj instanceof IElementIdentity)) {
            return new IDirElement[1];
        }
        IElementIdentity cacheID = (IElementIdentity)cacheObj;
        if (cacheID.equalVersion(id)) {
            return null;
        }
        return new IDirElement[]{this.getElement(elementName, false)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDirElement[][] getCacheElements(long callerBackupVersion, IElementIdentity[] identities, HashMap deletedConfigurations, String[] dirNames) throws DirectoryServiceException {
        this.trace(1152, "getCacheElements " + identities.length + " identities, " + (deletedConfigurations == null ? "<null>" : Integer.toString(deletedConfigurations.size())) + " deletedConfigurations, " + (dirNames == null ? "<null>" : Integer.toString(dirNames.length)) + " dirNames");
        IDirElement[][] elements = new IDirElement[2][];
        try {
            boolean backupVersionMismatch = this.retrieveBackupVersionMismatch(callerBackupVersion);
            this.validateOpen();
            SizedArrayList resultList = null;
            int estimatedContentSize = 0;
            if (deletedConfigurations != null) {
                resultList = new SizedArrayList();
                elements[0] = this.buildUpdateList(resultList, backupVersionMismatch, identities, deletedConfigurations);
                estimatedContentSize = resultList.getEstimatedContentSize();
                if (estimatedContentSize >= 0x100000) {
                    elements[1] = new IDirElement[0];
                    IDirElement[][] iDirElementArrayArray = elements;
                    return iDirElementArrayArray;
                }
            }
            if (dirNames != null) {
                resultList = new SizedArrayList();
                int elementsLength = elements[0] != null ? elements[0].length : 0;
                block4: for (int i = 0; i < elementsLength; ++i) {
                    if (!(elements[0][i] instanceof IEnvelope) || ((IEnvelope)elements[0][i]).getProperty("DRE") == null) continue;
                    IElementIdentity oldID = ((IEnvelope)elements[0][i]).getEnvelopedElement().getIdentity();
                    IElementIdentity newID = ((IEnvelope)elements[0][++i]).getEnvelopedElement().getIdentity();
                    for (int j = 0; j < identities.length; ++j) {
                        if (!identities[j].equalEntity(oldID)) continue;
                        identities[j] = newID;
                        continue block4;
                    }
                }
                elements[1] = this.buildNewList(resultList, 0x100000 - estimatedContentSize, identities, dirNames);
            }
        }
        finally {
            this.m_lock.releaseLock();
        }
        return elements;
    }

    private boolean retrieveBackupVersionMismatch(long callerBackupVersion) {
        boolean backupVersionMismatch;
        this.m_lock.readLock();
        boolean bl = backupVersionMismatch = callerBackupVersion != 0L && callerBackupVersion != this.m_backupVersion;
        if (backupVersionMismatch) {
            this.trace(1152, "caller backup version: " + callerBackupVersion + " DS backup version: " + this.m_backupVersion);
        }
        return backupVersionMismatch;
    }

    private IDirElement[] buildNewList(SizedArrayList resultList, int availableElementsContentSize, IElementIdentity[] identities, String[] dirNames) throws DirectoryServiceException {
        try {
            block4: for (int i = 0; i < dirNames.length; ++i) {
                int j;
                IElementIdentity[] elementIds = null;
                try {
                    elementIds = this.listElements(dirNames[i]);
                }
                catch (DirectoryDoesNotExistException e) {
                    elementIds = new IElementIdentity[]{};
                }
                HashMap<String, IElementIdentity> oldIds = new HashMap<String, IElementIdentity>();
                EntityName dName = new EntityName(dirNames[i]);
                for (int j2 = 0; j2 < identities.length; ++j2) {
                    EntityName eName = new EntityName(identities[j2].getName());
                    if (!dName.isParent(eName)) continue;
                    oldIds.put(eName.getName(), identities[j2]);
                }
                ArrayList<IElementIdentity> newIds = new ArrayList<IElementIdentity>();
                for (j = 0; j < elementIds.length; ++j) {
                    IElementIdentity oldId = (IElementIdentity)oldIds.get(elementIds[j].getName());
                    if (oldId != null && oldId.equalEntity(elementIds[j])) continue;
                    newIds.add(elementIds[j]);
                }
                for (j = 0; j < newIds.size(); ++j) {
                    if (resultList.getEstimatedContentSize() > availableElementsContentSize) {
                        this.markListUnfinished(resultList);
                        continue block4;
                    }
                    IElementIdentity id = (IElementIdentity)newIds.get(j);
                    resultList.add(this.getElement(id.getName(), false));
                }
            }
            int resultSize = resultList.size();
            if (resultSize == 0) {
                return null;
            }
            IDirElement[] result = new IDirElement[resultSize];
            resultList.toArray(result);
            return this.traceResults(result);
        }
        catch (ConfigException e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    private IDirElement[] buildUpdateList(SizedArrayList resultList, boolean backupVersionMismatch, IElementIdentity[] identities, HashMap deletedConfs) throws DirectoryServiceException {
        this.validateOpen();
        for (int i = 0; i < identities.length && resultList.getEstimatedContentSize() < 0x100000; ++i) {
            EntityName elementName = DirectoryService.validateName(identities[i].getName());
            IIdentity cacheObj = this.retrieveCacheElement(elementName);
            if (cacheObj == null) {
                resultList.add(Element.createDeletedElement((IElementIdentity)identities[i]));
                continue;
            }
            if (!(cacheObj instanceof IElementIdentity)) {
                throw new Error(elementName.getName() + " is not an element.");
            }
            IElementIdentity cacheID = (IElementIdentity)cacheObj;
            if (cacheID.equalVersion(identities[i]) && !backupVersionMismatch) continue;
            boolean wasDeleted = false;
            if (!cacheID.equalEntity(identities[i]) || backupVersionMismatch) {
                wasDeleted = true;
                EnvelopeElement envelope = new EnvelopeElement((IElement)Element.createDeletedElement((IElementIdentity)identities[i]));
                envelope.setProperty("DRE", "true");
                resultList.add(envelope);
            }
            IDirElement elementToSend = this.getElement(elementName.getName(), false);
            if (wasDeleted) {
                elementToSend = new EnvelopeElement((IElement)elementToSend);
                ((IEnvelope)elementToSend).setProperty("R", "true");
            }
            resultList.add(elementToSend);
        }
        Iterator iterator = deletedConfs.keySet().iterator();
        while (iterator.hasNext() && resultList.getEstimatedContentSize() <= 0x100000) {
            IDirElement newElement = this.getElement((String)iterator.next(), false);
            if (newElement == null) continue;
            resultList.add(newElement);
        }
        if (resultList.getEstimatedContentSize() > 0x100000) {
            this.markListUnfinished(resultList);
        }
        int resultSize = resultList.size();
        if (backupVersionMismatch) {
            ++resultSize;
        }
        IDirElement[] result = new IDirElement[resultSize];
        this.createResults(resultList, result);
        if (backupVersionMismatch) {
            result[resultSize - 1] = this.getElement(DS_VERSION_INFO_PATH, false);
        }
        return this.traceResults(result);
    }

    private IIdentity retrieveCacheElement(EntityName elementName) throws DirectoryServiceException {
        IIdentity cacheObj = null;
        try {
            cacheObj = this.m_idCache.get(elementName);
        }
        catch (DirectoryDoesNotExistException directoryDoesNotExistException) {
            // empty catch block
        }
        return cacheObj;
    }

    private void createResults(ArrayList resultList, IDirElement[] result) {
        for (int i = 0; i < resultList.size(); ++i) {
            result[i] = (IDirElement)resultList.get(i);
        }
    }

    private IDirElement[] traceResults(IDirElement[] result) {
        this.traceResults(result, 128);
        return result;
    }

    private void traceResults(IDirElement[] result, int TRACE_CONTAINER_ACCESS) {
        if ((this.m_traceMask & 1) > 0) {
            for (int i = 0; i < result.length; ++i) {
                this.trace(TRACE_CONTAINER_ACCESS + 1024, result[i].toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap getUpdatedLogicalNames(HashMap names) {
        this.trace(1152, "getUpdatedLogicalNames: " + names.size() + " names");
        try {
            this.m_lock.readLock();
            HashMap<String, String> correctionMap = new HashMap<String, String>();
            for (String storageName : names.keySet()) {
                String logicalName = null;
                try {
                    logicalName = this.m_logicalNameSpace.logicalFromStorage(storageName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (logicalName != null && ((String)names.get(storageName)).equalsIgnoreCase(logicalName)) continue;
                correctionMap.put(storageName, logicalName);
            }
            HashMap<String, String> hashMap = correctionMap;
            return hashMap;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void unsubscribeNaming() {
        this.m_logicalNameSpace.unsubscribe();
    }

    @Override
    public void subscribeNaming(INamingListener listener) {
        this.m_logicalNameSpace.subscribe(listener);
        this.m_dsHandlers.subscribe(listener);
    }

    @Override
    public INotificationConsumer subscribeAll(IArrayElementNotificationListener listener) {
        NotificationConsumer consumer = new NotificationConsumer(listener);
        this.m_notificationManager.setConsumer(consumer);
        return consumer;
    }

    public IView getView() throws DirectoryServiceException {
        this.trace(1024, "getView");
        try {
            this.m_lock.readLock();
            View view = new View(this.getElement(VIEW_ELEMENT, true));
            return view;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IView storeViewInternal(IView view) throws DirectoryServiceException {
        this.trace(1056, "setView");
        try {
            this.storeInternal(VIEW_ELEMENT_ENTITY_NAME, ((View)view).getConfigElement(), true);
            return new View(this.m_storage.getElement(VIEW_ELEMENT_ENTITY_NAME));
        }
        catch (StorageException e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    public IView setView(IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "setView");
        try {
            this.m_lock.writeLock();
            this.setElement(((DeltaView)view).getElement(), null);
            IView iView = this.getView();
            return iView;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INextVersionToken setViewGetToken(IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "setViewGetToken");
        NextVersionToken token = null;
        boolean startedRememberIDs = false;
        try {
            startedRememberIDs = this.retrieveStartedRememberIDs(startedRememberIDs);
            this.setElement(((DeltaView)view).getElement(), null);
        }
        finally {
            if (startedRememberIDs) {
                token = this.createNextVersionToken(false);
            }
            this.m_lock.releaseLock();
        }
        return token;
    }

    private boolean retrieveStartedRememberIDs(boolean startedRememberIDsParam) throws DirectoryServiceException {
        boolean startedRememberIDs = startedRememberIDsParam;
        this.m_lock.writeLock();
        if (this.m_notificationManager != null) {
            startedRememberIDs = this.m_notificationManager.rememberNewIds();
        }
        return startedRememberIDs;
    }

    public IDirElement cloneElement(String elementName, String newName, boolean createTemplate, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneElementInternal(null, elementName, newName, createTemplate, view);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, boolean createTemplate, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneElementInternal(delta, null, newName, createTemplate, view);
    }

    public IDirElement cloneElement(String elementName, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneElementInternal(null, elementName, newName, false, view);
    }

    public IDirElement cloneElement(IBasicElement delta, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneElementInternal(delta, null, newName, false, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDirElement cloneElementInternal(IBasicElement delta, String oldName, String newName, boolean createTemplate, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        String elementName;
        String string = elementName = delta != null ? delta.getIdentity().getName() : oldName;
        if (delta != null && !(delta instanceof IDeltaElement)) {
            throw new DirectoryServiceException("The delta parameter must be the modified result of IDirElement.doneUpdate().");
        }
        this.trace(1056, "cloneElement from " + elementName + " to " + newName);
        try {
            this.m_lock.writeLock();
            if (this.m_authentication != null) {
                this.m_authentication.okToModify(newName);
            }
            Element original = this.retrieveElementAsIs(elementName);
            DeltaElement deltaClone = null;
            deltaClone = this.m_noContainer && delta != null ? ((DeltaElement)delta).createClone() : (DeltaElement)delta;
            if (original.isSubclassedElement()) {
                if (createTemplate) {
                    throw new DirectoryServiceException("Cannot create a template from sub-classed element \"" + elementName + "\".");
                }
                IDirElement iDirElement = this.cloneSubclassedElement(original, deltaClone, newName, view);
                return iDirElement;
            }
            boolean cloningSuper = original.isSuperElement();
            boolean isTemplate = original.isTemplate();
            Element newElement = (Element)original.createWritableClone();
            if (deltaClone != null) {
                newElement.doApplyDelta((IDeltaElement)deltaClone);
                if (createTemplate && !isTemplate) {
                    newElement.setTemplate();
                }
                if (newElement.getSuperElementName() != null) {
                    throw new DirectoryServiceException("doneUpdateForSubclassing() was called rather than doneUpdate().");
                }
                newElement.setReadOnly(false);
            } else if (createTemplate && !isTemplate) {
                newElement.setTemplate();
            }
            Identity id = (Identity)newElement.getIdentity();
            id.setName(newName);
            ((ElementIdentity)id).setVersion(0L);
            if (cloningSuper) {
                newElement = this.cleanupSuperElement(newElement, true, false);
            }
            this.setElement((IBasicElement)newElement, view);
            IDirElement iDirElement = this.getElement(newName, true);
            return iDirElement;
        }
        catch (VersionMisMatchException e) {
            this.throwVersionException(elementName, elementName + " was modified by another application.");
            IDirElement iDirElement = null;
            return iDirElement;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private Element retrieveElementAsIs(String superReference) throws DirectoryServiceException {
        Element superElement = (Element)this.getElementAsIs(superReference, false);
        if (superElement == null) {
            throw new DirectoryServiceException('\"' + superReference + "\" was deleted.");
        }
        return superElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDirElement cloneSubclassedElement(Element original, DeltaElement delta, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        String superName;
        Element superElement;
        IElementIdentity originalID = original.getIdentity();
        Element oldView = (Element)this.getElement(VIEW_ELEMENT, false);
        String originalName = originalID.getName();
        if (delta != null && delta.getIdentity().getVersion() != originalID.getVersion()) {
            this.throwVersionException(originalName, originalName + " was modified by another application.");
        }
        if ((superElement = (Element)this.getElementAsIs(superName = original.getSuperElementName(), true)) == null) {
            throw new DirectoryServiceException("The super element \"" + superName + "\" of \"" + originalName + "\" is missing.");
        }
        byte[] deltaBytes = superElement.getSubclassedDelta(originalName);
        if (deltaBytes == null) {
            throw new DirectoryServiceException("The super element \"" + superName + "\" of \"" + originalName + "\" does not contain the sub-classing information.");
        }
        DeltaElement subclassingDelta = DeltaElement.fromBytes((byte[])deltaBytes);
        DeltaElement subclassingDeltaCopy = subclassingDelta.createClone();
        ((ElementIdentity)subclassingDeltaCopy.getIdentity()).setVersion(superElement.getIdentity().getVersion());
        if (delta == null) {
            return (Element)this.subclassElement((IBasicElement)subclassingDeltaCopy, newName, view, true);
        }
        boolean transactOK = false;
        Element realizedElement = null;
        try {
            this.m_trManager.join();
            Element realizedFirstPhase = (Element)this.subclassElement((IBasicElement)subclassingDeltaCopy, newName, view, false);
            DeltaElement deltaCopy = delta.createClone();
            deltaCopy.setIdentity(((ElementIdentity)realizedFirstPhase.getIdentity()).createClone());
            this.setElement((IBasicElement)deltaCopy, null, false);
            transactOK = true;
        }
        finally {
            if (transactOK) {
                realizedElement = (Element)this.getElement(newName, false);
                this.notifyMods(new ModificationItem(realizedElement), this.createViewMod(view, oldView));
            }
            this.m_trManager.leave(transactOK);
        }
        return realizedElement != null ? (IDirElement)realizedElement.createWritableClone() : null;
    }

    private Element doRealizeSub(Element superElement, byte[] deltaBytes, DeltaElement delta, String newName, IElementIdentity subID) {
        try {
            return this.doRealizeSub0(superElement, deltaBytes, delta, newName, subID);
        }
        catch (VersionOutofSyncException e) {
            throw new Error(e.toString());
        }
    }

    private Element doRealizeSub(Element superElement, DeltaElement delta, String newName) throws VersionOutofSyncException {
        return this.doRealizeSub0(superElement, null, delta, newName, null);
    }

    private Element doRealizeSub0(Element superElement, byte[] deltaBytes, DeltaElement deltaParam, String newName, IElementIdentity subID) throws VersionOutofSyncException {
        DeltaElement delta = deltaParam;
        if (this.m_noContainer) {
            delta = delta.createClone();
        }
        try {
            Element newElement = (Element)superElement.createWritableClone();
            newElement = this.cleanupSuperElement(newElement, true, true);
            Identity id = (Identity)newElement.getIdentity();
            if (subID != null) {
                ((ElementIdentity)id).setVersion(delta.getIdentity().getVersion());
            }
            newElement.doApplyDelta((IDeltaElement)delta);
            id.setName(newName);
            if (deltaBytes != null) {
                newElement.setSubclassingDelta(deltaBytes);
            }
            if (subID == null) {
                DirectoryService.initializeElementVersion((ElementIdentity)id);
            }
            if (subID != null) {
                newElement.setNewIdentity(((ElementIdentity)subID).createClone());
            }
            return newElement;
        }
        catch (VersionMisMatchException e) {
            this.throwVersionException(delta.getIdentity().getName(), delta.getIdentity().getName() + " was modified by another application.");
            return null;
        }
    }

    static void initializeElementVersion(ElementIdentity id) {
        id.setVersion(1L);
        id.setCreationTimestamp(System.currentTimeMillis());
    }

    @Override
    public final void close() throws DirectoryServiceException {
        this.trace(1024, "close");
        this.close(true);
    }

    @Override
    public final void close(boolean normalClose) throws DirectoryServiceException {
        this.close(normalClose, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean normalClose, boolean forceDeleteLock) throws DirectoryServiceException {
        if (this.m_storage == null) {
            return;
        }
        if (this.m_authentication != null) {
            this.m_authentication.close();
        }
        boolean storageClosed = false;
        boolean systemClosed = false;
        try {
            if (!this.m_lock.hasNoWriteLock()) {
                this.m_lock.writeLock();
            }
            try {
                if (this.m_trManager != null) {
                    this.m_trManager.close();
                }
                if (this.m_usePSE_STORAGE && (normalClose || forceDeleteLock)) {
                    this.m_storage.startTransaction();
                }
                if (normalClose) {
                    if (!Boolean.getBoolean("DSDUMP")) {
                        this.m_storage.deleteElement(IDCACHE_ELEMENT_ENTITY_NAME, true);
                        if (this.m_idCache != null) {
                            this.m_storage.setElement(IDCACHE_ELEMENT_ENTITY_NAME, this.m_idCache.wrapAsElement(IDCACHE_ELEMENT));
                        }
                    }
                    this.m_storage.deleteElement(BACKUP_ELEMENT_ENTITY_NAME, true);
                    if (this.m_useFS_STORAGE) {
                        this.m_storage.deleteElement(LOCK_ELEMENT_ENTITY_NAME, true);
                    }
                    this.m_storage.deleteElement(OPEN_ELEMENT_ENTITY_NAME, true);
                }
                if (!normalClose && forceDeleteLock && this.m_useFS_STORAGE) {
                    this.m_storage.deleteElement(LOCK_ELEMENT_ENTITY_NAME, true);
                }
                if (this.m_usePSE_STORAGE && (normalClose || forceDeleteLock)) {
                    this.m_storage.commitTransaction();
                }
                this.m_storage.close();
                storageClosed = true;
                if (this.m_useFS_STORAGE && this.m_blobStorage != null) {
                    this.m_blobStorage.close();
                }
                if (this.m_systemStorage != null) {
                    this.m_systemStorage.close();
                }
                systemClosed = true;
            }
            catch (StorageException e) {
                this.logMessage("Close failed, trace follows...", e, 2);
                String addErrorMessage = "";
                try {
                    if (!storageClosed) {
                        this.m_storage.close();
                    }
                    if (!systemClosed) {
                        this.m_systemStorage.close();
                    }
                }
                catch (Exception e2) {
                    addErrorMessage = " Also unable to close the underlying DS storage: " + e2.toString();
                }
                Error error = new Error();
                error.initCause(e);
            }
            this.m_open = false;
            this.m_notificationManager.setConsumer(null);
            this.m_localListener = null;
            this.m_storage = null;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void closeFiles() throws DirectoryServiceException {
        try {
            if (this.m_useFS_STORAGE) {
                if (this.m_trManager != null) {
                    this.m_trManager.closeFiles();
                }
                if (this.m_blobStorage != null) {
                    this.m_blobStorage.closeFiles();
                }
            }
            if (this.m_storage != null) {
                this.m_storage.closeFiles();
            }
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
    }

    private void openFiles() throws DirectoryServiceException {
        try {
            if (this.m_useFS_STORAGE) {
                if (this.m_trManager != null) {
                    this.m_trManager.openFiles();
                }
                if (this.m_blobStorage != null) {
                    this.m_blobStorage.openFiles();
                }
            }
            if (this.m_storage != null) {
                this.m_storage.openFiles();
            }
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
    }

    IStorage getStorage() {
        return this.m_storage;
    }

    static EntityName validateName(String name) throws DirectoryServiceException {
        try {
            return new EntityName(name);
        }
        catch (ConfigException e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    private void validateOpen() throws DirectoryServiceException {
        if (!this.m_open) {
            throw new DirectoryServiceClosedException("The Directory Service object is closed.");
        }
    }

    private void openStorage() throws DirectoryServiceException {
        IAttributeSet attributes;
        boolean firstTime;
        block38: {
            firstTime = false;
            this.trace(1024, "Checking system elements...");
            try {
                if (!this.m_storage.directoryExists(SYSTEM_DIRECTORY_PATH_ENTITY_NAME)) {
                    this.mStorageStartTransaction();
                    this.m_storage.createDirectory(SYSTEM_DIRECTORY_PATH_ENTITY_NAME);
                    this.mStorageCommitTransaction();
                    firstTime = true;
                }
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
            try {
                IDirElement versionElement = this.m_storage.getElement(VERSION_ELEMENT_ENTITY_NAME);
                if (versionElement == null) {
                    versionElement = ElementFactory.createElement((String)VERSION_ELEMENT_PATH, (String)VERSION_ELEMENT, (String)MF_CONFING_VERSION);
                    attributes = versionElement.getAttributes();
                    attributes.setIntegerAttribute("VERSION", new Integer(8));
                    this.updateElementInTransaction(VERSION_ELEMENT_ENTITY_NAME, versionElement);
                } else {
                    attributes = versionElement.getAttributes();
                    Integer dsVersion = (Integer)attributes.getAttribute("VERSION");
                    if (dsVersion != 8) {
                        throw new DirectoryServiceException("The directory service storage version of domain \"" + this.m_domain + "\" mismatches the version of the software.\nStorage version is: " + dsVersion + ". Software version is: " + 8 + ".");
                    }
                }
            }
            catch (DSEncryptionException e) {
                throw new DecryptionException(e.getMessage());
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
            catch (ReadOnlyException e) {
                throw new Error(e.toString());
            }
            catch (AttributeSetTypeException e) {
                throw new Error(e.toString());
            }
            catch (ConfigException e) {
                throw new Error(e.toString());
            }
            try {
                IDirElement backupElement = this.m_storage.getElement(BACKUP_ELEMENT_ENTITY_NAME);
                if (backupElement != null) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("The domain storage reflects that either the store is currently being backed up or it is a backup copy that must be prepared for use.");
                    msg.append(IContainer.NEWLINE);
                    msg.append("You must either shutdown the currently running Directory Service (if appropriate) or run the dsAdmin script with the prepare_backup_image_for_restore option before restarting this container.");
                    throw new DirLockedException(msg.toString());
                }
                if (!this.m_useFS_STORAGE) break block38;
                IDirElement lockElement = this.m_storage.getElement(LOCK_ELEMENT_ENTITY_NAME);
                if (lockElement == null) {
                    lockElement = ElementFactory.createElement((String)LOCK_ELEMENT_PATH, (String)LOCK_ELEMENT, (String)MF_CONFING_VERSION);
                    this.updateElementInTransaction(LOCK_ELEMENT_ENTITY_NAME, lockElement);
                    break block38;
                }
                StringBuffer msg = new StringBuffer();
                msg.append("A lock was found on the \"").append(this.m_domain).append("\" domain storage.");
                msg.append(IContainer.NEWLINE);
                msg.append("There is either a Directory Service running already or the previous session was not properly terminated. ");
                msg.append("If you are sure there is no other Directory Service running then you may remove the ");
                msg.append((DirectoryService.getCanonicalPath(this.m_domainDir) + '/' + "data" + LOCK_ELEMENT_ENTITY_NAME.getName()).replace('/', File.separatorChar));
                msg.append(" file and restart this program.");
                throw new DirLockedException(msg.toString());
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
            catch (ReadOnlyException e) {
                throw new Error(e.toString());
            }
        }
        try {
            IDirElement backupVersionElement = this.m_storage.getElement(BACKUP_VERSION_ELEMENT_ENTITY_NAME);
            if (backupVersionElement == null) {
                backupVersionElement = ElementFactory.createElement((String)BACKUP_VERSION_ELEMENT_PATH, (String)BACKUP_VERSION_ELEMENT, (String)MF_CONFING_VERSION);
                attributes = backupVersionElement.getAttributes();
                this.m_backupVersion = System.currentTimeMillis();
                this.trace(16, "Creating an initial backup version " + this.m_backupVersion);
                attributes.setLongAttribute("BACKUP_VERSION", new Long(this.m_backupVersion));
                this.updateElementInTransaction(BACKUP_VERSION_ELEMENT_ENTITY_NAME, backupVersionElement);
            } else {
                attributes = backupVersionElement.getAttributes();
                this.m_backupVersion = (Long)attributes.getAttribute("BACKUP_VERSION");
                this.trace(16, "The backup version is " + this.m_backupVersion);
            }
            IDirElement backupStatus = this.m_storage.getElement(BACKUP_STATUS_ELEMENT_ENTITY_NAME);
            if (backupStatus == null) {
                backupStatus = ElementFactory.createElement((String)BACKUP_STATUS_ELEMENT_PATH, (String)"1", (String)MF_CONFING_VERSION);
                this.saveBackupStatusAttrs(backupStatus);
            } else {
                this.readBackupStatusAttrs(backupStatus);
            }
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
        catch (AttributeSetTypeException e) {
            throw new Error(e.toString());
        }
        catch (ConfigException e) {
            throw new Error(e.toString());
        }
        IDirElement cacheElement = null;
        this.m_idCache = null;
        try {
            IDirElement openElement = this.m_storage.getElement(OPEN_ELEMENT_ENTITY_NAME);
            if (openElement == null) {
                openElement = ElementFactory.createElement((String)OPEN_ELEMENT_PATH, (String)OPEN_ELEMENT, (String)MF_CONFING_VERSION);
                this.updateElementInTransaction(OPEN_ELEMENT_ENTITY_NAME, openElement);
                try {
                    cacheElement = this.m_storage.getElement(IDCACHE_ELEMENT_ENTITY_NAME);
                    this.m_idCache = new IDCache(cacheElement);
                }
                catch (Throwable t) {
                    if (!firstTime) {
                        this.logMessage("The Directory Service storage is damaged - automatic recovery will be performed", 2);
                    }
                }
            } else {
                this.logMessage("Prior shutdown did not execute correctly - automatic recovery will be performed", 2);
            }
            boolean needsRecovery = false;
            if (this.m_idCache == null && !firstTime) {
                needsRecovery = true;
            }
            if (needsRecovery) {
                this.logMessage("Starting Directory Service recovery...", 3);
            }
            this.m_trManager = this.m_usePSE_STORAGE ? new TransactionManager(this.m_domainDir, new IStorage[]{this.m_storage}, true, this.m_notificationManager, this.m_storageType) : new TransactionManager(this.m_domainDir, new IStorage[]{this.m_storage, this.m_blobStorage}, true, this.m_notificationManager, this.m_storageType);
            this.trace(16, "Created the transaction manager");
            if (this.m_idCache == null || this.m_idCache.isEmpty() || Boolean.getBoolean("DSDUMP")) {
                this.trace(16, "reading the ID cache...");
                this.m_idCache = new IDCache(this);
                this.trace(16, "...reading of ID cache done");
            }
            this.m_trManager.setCache(this.m_idCache);
            if (needsRecovery) {
                this.logMessage("...Directory Service recovery complete", 3);
            }
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
    }

    private void updateElementInTransaction(EntityName BACKUP_VERSION_ELEMENT_ENTITY_NAME, IDirElement backupVersionElement) throws ReadOnlyException, StorageException {
        this.mStorageStartTransaction();
        this.m_storage.setElement(BACKUP_VERSION_ELEMENT_ENTITY_NAME, (IDirElement)backupVersionElement.doneUpdate());
        this.mStorageCommitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCollectionSubscribers() throws DirectoryServiceException {
        try {
            Object object = this.m_subscribers_lock;
            synchronized (object) {
                return this.m_systemStorage.collectionToStringArray(SUBSCRIBERS_COLLECTION_NAME);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DirectoryServiceException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscribers(String[] subscribers) {
        try {
            Object object = this.m_subscribers_lock;
            synchronized (object) {
                this.m_systemStorage.removeFromCollection(SUBSCRIBERS_COLLECTION_NAME, subscribers);
            }
        }
        catch (Exception e) {
            this.logMessage("Failed to remove subscribers, trace follows...", e, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscriber(String subscriber) {
        try {
            Object object = this.m_subscribers_lock;
            synchronized (object) {
                this.m_systemStorage.addToCollection(SUBSCRIBERS_COLLECTION_NAME, subscriber);
            }
        }
        catch (Exception e) {
            this.logMessage("Failed to add subscriber, trace follows...", e, 2);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSubscribers() throws DirectoryServiceException {
        try {
            Object object = this.m_subscribers_lock;
            synchronized (object) {
                IDirElement subscribersElement = this.m_systemStorage.getElement(SUBSCRIBERS_ELEMENT_ENTITY_NAME);
                if (subscribersElement == null) {
                    return IEmptyArray.EMPTY_STRING_ARRAY;
                }
                return (String[])this.unwrapFromElement(subscribersElement);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubscribers(String[] subList) throws DirectoryServiceException {
        try {
            Object object = this.m_subscribers_lock;
            synchronized (object) {
                this.m_systemStorage.deleteElement(SUBSCRIBERS_ELEMENT_ENTITY_NAME);
                this.m_systemStorage.setElement(SUBSCRIBERS_ELEMENT_ENTITY_NAME, this.wrapObjectAsElement(subList, SUBSCRIBERS_ELEMENT_PATH, SUBSCRIBERS_ELEMENT));
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    private void createSchemaElements(boolean isRestrictedBackupDS) throws DirectoryServiceException {
        if (isRestrictedBackupDS) {
            this.m_backRefMgr = new BackReferenceMgr(this, isRestrictedBackupDS);
            return;
        }
        try {
            this.m_lock.writeLock();
            if (this.getIdentity("/_MFSchema") == null) {
                this.createDirectory("/_MFSchema");
            }
            this.m_backRefMgr = new BackReferenceMgr(this, false);
            try {
                if (this.getIdentity(VIEW_ELEMENT) == null) {
                    this.trace(16, "Creating the initial view element");
                    IDirElement viewElement = ElementFactory.createElement((String)VIEW_ELEMENT, (String)"_MFview", (String)"2.0");
                    this.setElement(viewElement.doneUpdate(), null);
                }
            }
            catch (ReadOnlyException e) {
                throw new Error(e.toString());
            }
            catch (VersionOutofSyncException e) {
                throw new Error(e.toString());
            }
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void createHintsElement() throws DirectoryServiceException {
        if (this.getIdentity(STORAGE_HINTS_ELEMENT) != null) {
            return;
        }
        try {
            this.trace(16, "Creating the initial storage hints element");
            IDirElement storageHints = ElementFactory.createElement((String)STORAGE_HINTS_ELEMENT, (String)"storage_hints", (String)MF_CONFING_VERSION);
            IAttributeSet atts = storageHints.getAttributes();
            atts.createAttributeSet(HINTS_ATT);
            this.setElement(storageHints.doneUpdate(), null);
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
        catch (VersionOutofSyncException e) {
            throw new Error(e.toString());
        }
        catch (AttributeSetTypeException e) {
            throw new Error(e.toString());
        }
        catch (ConfigException e) {
            throw new Error(e.toString());
        }
    }

    private void createJNDIContext() throws DirectoryServiceException {
        this.trace(16, "Creating the initial JNDI context");
        if (this.getIdentity("/_MFContext") == null) {
            try {
                this.m_lock.writeLock();
                this.createDirectory("/_MFContext");
            }
            finally {
                this.m_lock.releaseLock();
            }
        }
    }

    private void storeInternal(EntityName name, IDirElement element) throws DirectoryServiceException, VersionOutofSyncException {
        this.storeInternal(name, element, false);
    }

    private void storeInternal(EntityName name, IDirElement element, boolean byLogicalViewer) throws DirectoryServiceException, VersionOutofSyncException {
        if (name.getName().equals(VIEW_ELEMENT) && !byLogicalViewer && this.m_logicalNameSpace != null && !System.getProperty("MQ_UPGRADE", "false").equals("true")) {
            if (this.m_FSInterfaceIsUsed && !this.m_noContainer) {
                throw new DirectoryServiceException("The DS admin API cannot be used to update the view concurrently with FS API clients.");
            }
            this.m_logicalNameSpace.setNotConsistent();
        }
        try {
            this.m_storage.setElement(name, element);
            this.m_idCache.addElement(name, element.getIdentity());
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
    }

    void notifyMods(Element element, boolean noBeforeImage) {
        this.notifyMods(new ModificationItem(element, noBeforeImage), null);
        this.m_notificationManager.doNotify();
    }

    void notifyMods(Element element) {
        this.notifyMods(new ModificationItem(element), null);
        this.m_notificationManager.doNotify();
    }

    void groupNotifyMods(ArrayList group, boolean hasDelete) {
        this.m_notificationManager.addGroupNotification(group, hasDelete);
        this.m_notificationManager.doNotify();
    }

    void notifyMods(ModificationItem modItem0, ModificationItem modItem1) {
        IBasicElement mod0 = modItem0.getModification();
        IBasicElement mod1 = null;
        if (modItem1 != null) {
            mod1 = modItem1.getModification();
        }
        if (mod0 instanceof IDirElement) {
            ((Element)mod0).setReadOnly(true);
        }
        if (mod1 != null && mod1 instanceof IDirElement) {
            ((Element)mod1).setReadOnly(true);
        }
        int numMods = modItem1 == null ? 1 : 2;
        ModificationItem[] modList = new ModificationItem[numMods];
        modList[0] = modItem0;
        if (modItem1 != null) {
            modList[1] = modItem1;
        }
        this.m_notificationManager.addNotifications(modList);
    }

    /*
     * Unable to fully structure code
     */
    private BeforeAfterPair prepareToSet(IBasicElement element, IDirElement oldElement0) throws DirectoryServiceException, VersionOutofSyncException {
        elementName = element.getIdentity().getName();
        if (elementName.startsWith("/_MFSystem")) {
            throw new DirectoryServiceException("It is illegal to modify the \"/_MFSystem\" directory.");
        }
        eName = DirectoryService.validateName(elementName);
        elementVersion = element.getIdentity().getVersion();
        oldElement = (Element)oldElement0;
        if (oldElement == null) {
            try {
                oldElement = (Element)this.m_storage.getElement(eName);
                if (!(element instanceof Element) || oldElement == null || (blobImport = (Boolean)Blob.getBlobState((Element)((Element)element), (String)"BLOB_ENVELOPE_ELEMENT_IMPORT")) == null || !blobImport.booleanValue()) ** GOTO lbl17
                oldElement = null;
            }
            catch (StorageException e) {
                throw this.convertException(e);
            }
        } else {
            oldElement = (Element)oldElement.createClone();
            oldElement.setReadOnly(true);
        }
lbl17:
        // 3 sources

        delta = null;
        if (oldElement != null && element instanceof IDirElement) {
            this.throwVersionException(elementName, "Element \"" + elementName + "\" already exists.");
        }
        if (oldElement == null && element instanceof IDeltaDirElement) {
            this.throwVersionException(elementName, "Element \"" + elementName + "\" does not exist.");
        }
        v0 = oldElementIsSubclassed = oldElement != null && oldElement.getSuperElementName() != null;
        if (element instanceof IDirElement && elementVersion != 0L) {
            this.throwVersionException(elementName, "Element \"" + elementName + "\" is new but its version is " + elementVersion);
        }
        if (element instanceof IDeltaElement) {
            delta = this.m_noContainer != false ? ((DeltaElement)element).createClone() : (DeltaElement)element;
            if (delta.isDeleted()) {
                throw new Error("deleteElement should be used for deleting elements.");
            }
            this.validateData(delta, oldElement);
        }
        newElement = null;
        if (element instanceof IDirElement) {
            newElement = (IDirElement)((IDirElement)element).createWritableClone();
            id = (ElementIdentity)newElement.getIdentity();
            DirectoryService.initializeElementVersion(id);
        } else {
            newElement = (IDirElement)oldElement.createWritableClone();
            try {
                ((Element)newElement).doApplyDelta((IDeltaElement)delta);
                v1 = newElementIsSubclassed = newElement.getSuperElementName() != null;
                if (newElementIsSubclassed && !oldElementIsSubclassed) {
                    throw new DirectoryServiceException("doneUpdateForSubclassing() was called rather than doneUpdate().");
                }
                ((Element)newElement).setReadOnly(false);
            }
            catch (VersionMisMatchException e) {
                this.throwVersionException(oldElement.getIdentity().getName(), "Directory version: " + oldElement.getIdentity().getVersion() + "  Delta version: " + delta.getIdentity().getVersion());
            }
        }
        return new BeforeAfterPair((IDirElement)oldElement, newElement);
    }

    private <T0 extends IBasicElement, T1 extends IElement> void validateData(T0 delta, T1 oldElement) throws VersionOutofSyncException {
        IElementIdentity deltaIdentity = delta.getIdentity();
        IElementIdentity oldIdentity = oldElement.getIdentity();
        if (!oldIdentity.equalEntity(deltaIdentity)) {
            this.throwVersionException(deltaIdentity.getName(), "Element \"" + deltaIdentity.getName() + "\" with creation timestamp " + deltaIdentity.getCreationTimestamp() + " was not found. The creation timestamp in the directory is " + oldIdentity.getCreationTimestamp());
        }
    }

    public final void logMessage(String message, int severityLevel) {
        if (this.m_logger == null) {
            System.err.println("(" + Level.LEVEL_TEXT[severityLevel] + ") " + message);
        } else {
            this.m_logger.logMessage(message, severityLevel);
        }
    }

    public final void logMessage(String message, Throwable throwable, int severityLevel) {
        if (this.m_logger == null) {
            System.err.println("(" + Level.LEVEL_TEXT[severityLevel] + ") " + message);
            throwable.printStackTrace();
        } else {
            this.m_logger.logMessage(message, throwable, severityLevel);
        }
    }

    @Override
    public final void trace(int mask, String message) {
        boolean trace;
        boolean bl = trace = (this.m_traceMask & mask) != 0;
        if (!trace) {
            return;
        }
        if (this.m_logger == null) {
            System.err.println("(" + Level.LEVEL_TEXT[7] + ") " + message);
        } else {
            this.m_logger.logMessage(message, 7);
        }
    }

    @Override
    public void trace(int mask, String message, Throwable throwable) {
        boolean trace;
        boolean bl = trace = (this.m_traceMask & mask) != 0;
        if (!trace) {
            return;
        }
        if (this.m_logger == null) {
            System.err.println("(" + Level.LEVEL_TEXT[7] + ") " + message);
            throwable.printStackTrace();
        } else {
            this.m_logger.logMessage(message, throwable, 7);
        }
    }

    void throwVersionException(String elementName, String message) throws VersionOutofSyncException {
        throw new VersionOutofSyncException("[" + elementName + "] " + message);
    }

    private Object unwrapFromElement(IDirElement element) throws DirectoryServiceException {
        try {
            byte[] cacheData = (byte[])element.getAttributes().getAttribute("DATA_ATTRIBUTE");
            ByteArrayInputStream in = new ByteArrayInputStream(cacheData);
            ObjectInputStream objectIn = new ObjectInputStream(in);
            return objectIn.readObject();
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    private IDirElement wrapObjectAsElement(Object o, String elementName, String elementType) {
        try {
            IDirElement cacheElement = ElementFactory.createElement((String)elementName, (String)elementType, (String)MF_CONFING_VERSION);
            IAttributeSet attributes = cacheElement.getAttributes();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(o);
            byte[] bytes = out.toByteArray();
            objectOut.close();
            attributes.setBytesAttribute("DATA_ATTRIBUTE", bytes);
            return (IDirElement)cacheElement.doneUpdate();
        }
        catch (Exception e) {
            this.logMessage("Failed to wrap an object as an element, trace follows...", e, 2);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportElementsToXML(IDirElement[] elements) throws DirectoryServiceException {
        this.trace(1024, "exportElementsToXML");
        try {
            this.m_lock.readLock();
            ElementListBuilder builder = new ElementListBuilder(elements);
            builder.setDirectoryService((IDirectoryAdminService)this);
            builder.init();
            String string = builder.getXMLString();
            return string;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportDSBootFileString(String elementName) throws DirectoryServiceException {
        this.trace(1024, "exportDSBootFileString " + elementName);
        try {
            IDirElement el = this.retrieveAndValidateElement(elementName);
            IDirElement[] ftDSElements = this.checkFTDS(el);
            if (ftDSElements != null) {
                for (int i = 0; i < ftDSElements.length; ++i) {
                    ftDSElements[i] = DirectoryService.removeAttributesNotNeededForBoot(ftDSElements[i]);
                }
                String i = this.exportElementsToXML(ftDSElements);
                return i;
            }
            ElementBuilder builder = new ElementBuilder(el, (XMLStringWriter)null);
            builder.setDirectoryService((IDirectoryAdminService)this);
            builder.init();
            String string = builder.getXMLString();
            return string;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private static IDirElement removeAttributesNotNeededForBoot(IDirElement srcElement) {
        if (srcElement == null) {
            return null;
        }
        try {
            IDirElement writableCopy = (IDirElement)srcElement.createWritableClone();
            ((Element)writableCopy).removeSystemAttributes();
            writableCopy.getAttributes().deleteAttribute("CONFIG_ELEMENT_REFERENCES");
            writableCopy.doneUpdate();
            return writableCopy;
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
        catch (ConfigException e) {
            throw new Error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportElementToXML(String elementName) throws DirectoryServiceException {
        this.trace(1024, "exportElementToXML " + elementName);
        try {
            IDirElement el = this.retrieveAndValidateElement(elementName);
            ElementBuilder builder = new ElementBuilder(el, (XMLStringWriter)null);
            builder.setDirectoryService((IDirectoryAdminService)this);
            builder.init();
            String string = builder.getXMLString();
            return string;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private IDirElement retrieveAndValidateElement(String elementName) throws DirectoryServiceException {
        this.m_lock.readLock();
        IDirElement el = this.getElement(elementName, false);
        if (el == null) {
            throw new DirectoryServiceException(elementName + " doesn't exist.");
        }
        return el;
    }

    private IDirElement[] checkFTDS(IDirElement elParam) throws DirectoryServiceException {
        String replConnections;
        IDirElement el = elParam;
        IDirElement replConnectionsEl = null;
        boolean ftDS = false;
        String elType = el.getIdentity().getType();
        if (elType.equals("MF_BACKUP_DIRECTORY_SERVICE")) {
            el = this.getElement(el.getIdentity().getName(), true);
            this.copySharedAttributes(el);
        }
        if ((replConnections = this.getReplicationConnectionsElementID(el)) != null) {
            replConnectionsEl = this.getElement(replConnections, false);
            if (replConnectionsEl == null) {
                throw new DirectoryServiceException("Could not find the replication connections element while exporting the DS element " + el.getIdentity().getName());
            }
            ftDS = true;
        }
        if (ftDS) {
            return new IDirElement[]{el, replConnectionsEl};
        }
        return null;
    }

    private String getReplicationConnectionsElementID(IDirElement dsElement) throws DirectoryServiceException {
        Reference ref;
        Reference primary;
        IAttributeSet dsAttributes = dsElement.getAttributes();
        IAttributeSet references = (IAttributeSet)dsAttributes.getAttribute("CONFIG_ELEMENT_REFERENCES");
        if (references != null && dsElement.getIdentity().getType().equals("MF_BACKUP_DIRECTORY_SERVICE") && (primary = (Reference)references.getAttribute("PRIMARY_CONFIG_ELEMENT_REF")) != null) {
            IAttributeSet primaryAttrs = this.getElement(primary.getElementName(), false).getAttributes();
            references = (IAttributeSet)primaryAttrs.getAttribute("CONFIG_ELEMENT_REFERENCES");
        }
        if (references != null && (ref = (Reference)references.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF")) != null) {
            return ref.getElementName();
        }
        return null;
    }

    private void copySharedAttributes(IDirElement backupDS) throws DirectoryServiceException {
        String backupId = backupDS.getIdentity().getName();
        IAttributeSet backupAttrs = backupDS.getAttributes();
        IAttributeSet references = (IAttributeSet)backupAttrs.getAttribute("CONFIG_ELEMENT_REFERENCES");
        if (references == null) {
            throw new DirectoryServiceException("Backup DS configuration " + backupId + " does not reference a primary configuration");
        }
        Reference primaryRef = (Reference)references.getAttribute("PRIMARY_CONFIG_ELEMENT_REF");
        if (primaryRef == null) {
            throw new DirectoryServiceException("Backup DS configuration " + backupId + " does not reference a primary configuration");
        }
        IDirElement primaryEl = this.getElement(primaryRef.getElementName(), false);
        if (primaryEl != null) {
            IAttributeSet primaryAttrs = primaryEl.getAttributes();
            try {
                IAttributeSet primaryReplAttrs = (IAttributeSet)primaryAttrs.getAttribute("REPLICATION_PARAMETERS");
                IAttributeSet backupReplAttrs = backupAttrs.createAttributeSet("REPLICATION_PARAMETERS");
                if (primaryReplAttrs == null) {
                    IElement tmpPrimaryEl = primaryEl.createWritableClone();
                    IAttributeSet tmpPrimaryAtts = tmpPrimaryEl.getAttributes();
                    primaryReplAttrs = tmpPrimaryAtts.createAttributeSet("REPLICATION_PARAMETERS");
                }
                MergeUtil.mergeAddAndSet((IAttributeSet)backupReplAttrs, (IAttributeSet)primaryReplAttrs);
                backupAttrs.setStringAttribute("DOMAIN_NAME", (String)primaryAttrs.getAttribute("DOMAIN_NAME"));
                IAttributeSet primaryReferences = (IAttributeSet)primaryAttrs.getAttribute("CONFIG_ELEMENT_REFERENCES");
                if (primaryReferences != null) {
                    Object attrValue = primaryReferences.getAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF");
                    references.setReferenceAttribute("REPLICATION_CONNECTIONS_ELEMENT_REF", (Reference)attrValue);
                }
                IAttributeSet fileSystem = backupAttrs.createAttributeSet("FILE_SYSTEM_STORAGE");
                IAttributeSet primaryFileSystem = (IAttributeSet)primaryAttrs.getAttribute("FILE_SYSTEM_STORAGE");
                String hostDeprecated = (String)primaryFileSystem.getAttribute("HOST_DIRECTORY");
                String password = (String)primaryFileSystem.getAttribute("PASSWORD");
                fileSystem.setStringAttribute("HOST_DIRECTORY", hostDeprecated);
                fileSystem.setStringAttribute("PASSWORD", password);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DirectoryServiceException("Unable to copy the replication attributes onto the backup DS configuration " + backupId + ": " + e.toString());
            }
        } else {
            throw new DirectoryServiceException("Unable to find primary configuration for " + backupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportDirectoryToXML(String dirName) throws DirectoryServiceException {
        this.trace(1024, "exportDirectoryToXML " + dirName);
        try {
            this.m_lock.readLock();
            IIdentity dir = this.getIdentity(dirName);
            if (dir == null) {
                throw new DirectoryServiceException(dirName + " doesn't exist.");
            }
            DirectoryBuilder builder = new DirectoryBuilder(dirName);
            builder.setDirectoryService((IDirectoryAdminService)this);
            builder.init();
            String string = builder.getXMLString();
            return string;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void dumpContentsToXML() {
        this.trace(1024, "dumpContentsToXML");
        Thread dumper = new Thread("DS dumper"){

            @Override
            public void run() {
                File cwd = new File(".");
                int newVersion = 0;
                final String prefix = "dump." + DirectoryService.this.m_domain + '.';
                String suffix = ".xml";
                File[] existingDumps = cwd.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith(prefix) && name.endsWith(".xml");
                    }
                });
                if (existingDumps.length > 0) {
                    int latestVersion = -1;
                    int prefixLength = prefix.length();
                    int suffixLength = ".xml".length();
                    for (int i = 0; i < existingDumps.length; ++i) {
                        String tmp = existingDumps[i].getName().substring(prefixLength);
                        if ((tmp = tmp.substring(0, tmp.length() - suffixLength)).length() < 1) continue;
                        try {
                            int version = Integer.parseInt(tmp);
                            if (version <= latestVersion) continue;
                            latestVersion = version;
                            continue;
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    if (latestVersion > -1) {
                        newVersion = ++latestVersion;
                    }
                }
                File dumpFile = new File(cwd, prefix + newVersion + ".xml");
                try {
                    String contents = DirectoryService.this.exportDirectoryToXML(DirectoryService.ROOT_DIRECTORY);
                    FileOutputStream fos = new FileOutputStream(dumpFile);
                    fos.write(contents.getBytes());
                    fos.close();
                    DirectoryService.this.logMessage("Dumped DS contents to " + dumpFile.getCanonicalPath(), 3);
                }
                catch (Exception e) {
                    DirectoryService.this.logMessage("Failed to dump DS contents to " + DirectoryService.getCanonicalPath(dumpFile) + ", trace follows...", e, 2);
                }
            }
        };
        dumper.setDaemon(true);
        dumper.start();
    }

    private Validator createParser(String XMLDocument, boolean validate) {
        Validator xmlValidator = new Validator((Object)new StringReader(XMLDocument));
        xmlValidator.createSAXParser();
        xmlValidator.setDirectoryService((IDirectoryAdminService)this);
        if (validate) {
            xmlValidator.setValidation(true);
        }
        return xmlValidator;
    }

    @Override
    public void importFromList(IDirElement[] list, String[] deletionDirectories) throws DirectoryServiceException {
        this.importFromList(list, deletionDirectories, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap importFromList(IDirElement[] list, String[] deletionDirectoriesParam, boolean noReplace) throws DirectoryServiceException {
        String[] deletionDirectories = deletionDirectoriesParam;
        try {
            HashMap hashMap;
            this.m_lock.writeLock();
            if (deletionDirectories == null) {
                deletionDirectories = IEmptyArray.EMPTY_STRING_ARRAY;
            }
            this.m_importManager = new ImportManager(this, deletionDirectories, noReplace);
            this.m_notificationManager.startThrowAway();
            boolean transactOK = false;
            try {
                int i;
                this.m_trManager.join();
                for (i = 0; i < list.length; ++i) {
                    this.m_importManager.importedElement((Element)list[i]);
                }
                this.m_importManager.nextPhase();
                for (i = 0; i < list.length; ++i) {
                    this.m_importManager.importedElement((Element)list[i]);
                }
                this.m_importManager.nextPhase();
                for (i = 0; i < list.length; ++i) {
                    this.m_importManager.importedElement((Element)list[i]);
                }
                HashMap restList = this.m_importManager.createAllPackedElements();
                transactOK = true;
                hashMap = restList;
                this.m_notificationManager.stopThrowAway();
            }
            catch (Throwable throwable) {
                try {
                    this.m_notificationManager.stopThrowAway();
                    this.m_trManager.leave(transactOK, this.m_importManager, true);
                    throw throwable;
                }
                catch (VersionOutofSyncException e) {
                    this.logMessage("Failed import, trace follows...", e, 2);
                    Error error = new Error();
                    error.initCause(e);
                    throw e;
                }
            }
            this.m_trManager.leave(transactOK, this.m_importManager, true);
            return hashMap;
        }
        finally {
            this.m_notificationManager.stopThrowAway();
            this.m_importManager = null;
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromXML(String XMLDocument) throws DirectoryServiceException, InvalidXMLException {
        this.trace(1056, "importFromXML");
        try {
            this.m_lock.writeLock();
            this.m_importManager = new ImportManager(this);
            this.m_notificationManager.startThrowAway();
            if (XMLDocument.length() == 0 || XMLDocument == null) {
                throw new InvalidXMLException("XML file can't be empty");
            }
            boolean transactOK = false;
            try {
                this.m_trManager.join();
                Validator xmlValidator = this.createParser(XMLDocument, true);
                xmlValidator.setContentHandler(this.getDomain());
                xmlValidator.parseData();
                this.m_importManager.nextPhase();
                xmlValidator = this.createParser(XMLDocument, false);
                xmlValidator.setContentHandler(this.getDomain());
                xmlValidator.parseData();
                this.m_importManager.nextPhase();
                xmlValidator.resetXMLData((Object)new StringReader(XMLDocument));
                xmlValidator.parseData();
                this.m_importManager.createAllPackedElements();
                transactOK = true;
            }
            finally {
                this.m_notificationManager.stopThrowAway();
                this.m_trManager.leave(transactOK, this.m_importManager, true);
            }
        }
        catch (VersionOutofSyncException e) {
            this.logMessage("Failed to import from XML, trace follows...", e, 2);
        }
        finally {
            this.m_notificationManager.stopThrowAway();
            if (this.m_importManager.wasLogicalNameSpaceModified()) {
                this.m_logicalNameSpace.reset();
            }
            this.m_importManager = null;
            this.m_lock.releaseLock();
        }
    }

    public void attachBlob(IBasicElement element, InputStream stream, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        if (stream == null) {
            throw new DirectoryServiceException("The blob stream object cannot be null.");
        }
        try {
            BufferedInputStream bStream = new BufferedInputStream(stream, 1000000);
            int src = 0;
            int readIn = 0;
            while (readIn != -1) {
                int chunkIndex = 0;
                ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                while (chunkIndex < 1000000 && readIn != -1) {
                    readIn = bStream.read();
                    if (readIn == -1) continue;
                    oStream.write(readIn);
                    ++chunkIndex;
                }
                oStream.close();
                byte[] blobPiece = oStream.toByteArray();
                this.appendBlob(element, blobPiece, src, readIn == -1, view);
                src += blobPiece.length;
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    public IBlob getBlob(String elementName, boolean forUpdate, int offset) throws DirectoryServiceException {
        return this.getBlob(elementName, forUpdate, offset, null);
    }

    private IBlob getBlob(String elementName, boolean forUpdate, int offset, String logicalPath) throws DirectoryServiceException {
        this.validateOpen();
        EntityName eName = DirectoryService.validateName(elementName);
        try {
            this.m_lock.readLock();
            IDirElement element = this.getElement(elementName, forUpdate);
            if (Blob.isIncompleteBlob((IDirElement)element)) {
                throw new DirectoryServiceException("File " + (logicalPath != null ? logicalPath : elementName) + " is incomplete - it must be restored.");
            }
            byte[] fileByteArray = null;
            long blobSize = this.m_blobStorage.getBlobSize(eName);
            if (blobSize != 0L) {
                Integer blobState = (long)(offset + 1000000) >= blobSize ? IBlob.END : IBlob.PARTIAL;
                fileByteArray = this.m_blobStorage.getBlob(eName, offset, 1000000);
                Blob.markBlobState((Element)((Element)element), (Object)blobState, (String)"BLOB_TRANSFER_STATE");
                ((Element)element).setReadOnly(!forUpdate);
            }
            Blob blob = new Blob(element, fileByteArray, (IChunkedBlobStreamer)this);
            return blob;
        }
        catch (Exception e) {
            if (e instanceof DirectoryServiceException) {
                throw (DirectoryServiceException)((Object)e);
            }
            DirectoryServiceException dirE = new DirectoryServiceException("Unable to get blob " + elementName);
            dirE.initCause((Throwable)e);
            throw dirE;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    @Override
    public IBlob getEntireBlob(String elementName, boolean forUpdate) throws DirectoryServiceException {
        this.validateOpen();
        EntityName eName = DirectoryService.validateName(elementName);
        try {
            this.m_lock.readLock();
            IDirElement element = this.getElement(elementName, forUpdate);
            if (Blob.isIncompleteBlob((IDirElement)element)) {
                throw new DirectoryServiceException("File " + elementName + " is incomplete - it must be restored.");
            }
            byte[] fileByteArray = null;
            Integer blobState = IBlob.END;
            long blobSize = this.m_blobStorage.getBlobSize(eName);
            if (blobSize != 0L) {
                fileByteArray = this.m_blobStorage.getBlob(eName, 0, (int)blobSize);
                Blob.markBlobState((Element)((Element)element), (Object)blobState, (String)"BLOB_TRANSFER_STATE");
                ((Element)element).setReadOnly(!forUpdate);
            }
            Blob blob = new Blob(element, fileByteArray, (IChunkedBlobStreamer)this);
            return blob;
        }
        catch (Exception e) {
            if (e instanceof DirectoryServiceException) {
                throw (DirectoryServiceException)((Object)e);
            }
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IBlob getBlob(String elementName, boolean forUpdate) throws DirectoryServiceException {
        return this.getBlob(elementName, forUpdate, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File blobToFile(String blobName) throws DirectoryServiceException {
        this.validateOpen();
        EntityName eName = DirectoryService.validateName(blobName);
        try {
            this.m_lock.readLock();
            IDirElement element = this.getElement(blobName, false);
            if (Blob.isIncompleteBlob((IDirElement)element)) {
                throw new DirectoryServiceException("File " + element.getIdentity().getName() + " + is incomplete - it must be restored.");
            }
            File file = this.copyBlob(eName.getName());
            return file;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private File copyBlob(String blobName) throws DirectoryServiceException {
        try {
            int bytesRead;
            IBlob blob = this.getBlob(blobName, false);
            InputStream is = blob.getBlobStream();
            File copyFile = new File(this.m_blobCopiesDir, BLOB_COPIES_PREFIX + new Long(System.currentTimeMillis()).toString() + "_" + this.m_copySequenceNum++);
            FileOutputStream fos = new FileOutputStream(copyFile);
            byte[] bytes = new byte[4096];
            while ((bytesRead = is.read(bytes)) >= 1) {
                fos.write(bytes, 0, bytesRead);
            }
            is.close();
            fos.close();
            return copyFile;
        }
        catch (IOException e) {
            throw new DirectoryServiceException("Failed to create copy for: " + blobName + " :" + e.toString());
        }
    }

    public void detachBlob(IDeltaDirElement delta, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        this.validateOpen();
        EntityName eName = DirectoryService.validateName(delta.getIdentity().getName());
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.setElement((IBasicElement)delta, view);
            this.m_blobStorage.deleteBlob(eName);
            transactOK = true;
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public void attachBlob(IBasicElement element, byte[] blob, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        this.validateBlobAndOpen(blob);
        EntityName eName = DirectoryService.validateName(element.getIdentity().getName());
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.m_blobStorage.setBlob(eName, blob);
            boolean expandable = this.isExpandableBlob(eName);
            if (element instanceof IElement) {
                Blob.markBlobState((Element)((Element)element), (Object)new Boolean(expandable), (String)"SONIC_EXPAND_IN_CACHE");
            }
            this.setElement(element, view);
            if (expandable && element instanceof IDeltaElement) {
                IDirElement storedElement = this.m_storage.getElement(eName);
                Blob.markBlobState((Element)((Element)storedElement), (Object)IBlob.EXPANDABLE, (String)"SONIC_EXPAND_IN_CACHE");
                this.storeInternal(eName, storedElement);
            }
            transactOK = true;
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        catch (DirectoryServiceException dirE) {
            throw dirE;
        }
        catch (Exception ex) {
            throw new DirectoryServiceException(ex.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    @Override
    public void appendBlob(IBasicElement element, byte[] blob, int from, boolean last, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        this.validateBlobAndOpen(blob);
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            EntityName eName = DirectoryService.validateName(element.getIdentity().getName());
            joinedTransaction = this.startJoinTransaction();
            if (element instanceof IDeltaElement) {
                IDirElement storedElement = this.m_storage.getElement(eName);
                Blob.markBlobState((Element)((Element)storedElement), (Object)(last ? IBlob.COMPLETE : IBlob.INCOMPLETE), (String)"LARGE_FILE_STATE");
                this.storeInternal(eName, storedElement);
            }
            this.m_blobStorage.appendBlob(eName, blob, from);
            if (last && element instanceof IElement) {
                Blob.markBlobState((Element)((Element)element), (Object)IBlob.COMPLETE, (String)"LARGE_FILE_STATE");
            }
            if (last) {
                boolean expandable = this.isExpandableBlob(eName);
                if (element instanceof IDeltaElement) {
                    IDirElement storedElement = this.m_storage.getElement(eName);
                    Blob.markBlobState((Element)((Element)storedElement), (Object)new Boolean(expandable), (String)"SONIC_EXPAND_IN_CACHE");
                } else {
                    Blob.markBlobState((Element)((Element)element), (Object)new Boolean(expandable), (String)"SONIC_EXPAND_IN_CACHE");
                }
                this.setElement(element, view);
            }
            transactOK = true;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    private void validateBlobAndOpen(byte[] blob) throws DirectoryServiceException {
        if (blob == null) {
            throw new DirectoryServiceException("The blob object cannot be null.");
        }
        this.validateOpen();
    }

    private IDirElement subclassOnDSSide(Element newInstance0, IDeltaView view) throws DirectoryServiceException {
        String newInstanceName = newInstance0.getIdentity().getName();
        String superName = newInstance0.getSuperToSubclassFrom();
        Element superElement = (Element)this.getElementAsIs(superName, true);
        if (superElement == null) {
            throw new DirectoryServiceException("Tried to subclass " + newInstanceName + " from non existent template " + superName);
        }
        if (!superElement.isTemplate()) {
            throw new DirectoryServiceException("Tried to subclass " + newInstanceName + " from a non template element " + superName);
        }
        Element newInstance = (Element)newInstance0.createWritableClone();
        try {
            newInstance.removeSystemAttributes();
            superElement.removeSystemAttributes();
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
        newInstance.addSuperAttribute(superName, false);
        DeltaElement delta = superElement.createDelta(newInstance);
        ((ElementIdentity)delta.getIdentity()).setVersion(superElement.getIdentity().getVersion());
        return this.subclassElement((IBasicElement)delta, newInstanceName, view);
    }

    public IDirElement subclassElement(IBasicElement delta, String newName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        return this.subclassElement(delta, newName, view, true);
    }

    public void registerElementChangeHandler(IElementChangeHandler handler) {
        this.checkOpen();
        this.createLocalListener();
        this.m_localListener.registerElementChangeHandler(handler);
    }

    public void registerElementChangeHandler(String elementName, IElementChangeHandler handler) {
        this.checkOpen();
        this.createLocalListener();
        this.m_localListener.registerElementChangeHandler(elementName, handler);
    }

    public void unregisterElementChangeHandler(IElementChangeHandler handler) {
        if (this.m_localListener == null) {
            return;
        }
        this.m_localListener.unregisterElementChangeHandler(handler);
    }

    public void unregisterElementChangeHandler(String elementName, IElementChangeHandler handler) {
        if (this.m_localListener == null) {
            return;
        }
        this.m_localListener.unregisterElementChangeHandler(elementName, handler);
    }

    public void registerNameChangeHandler(INameChangeHandler handler) {
        this.checkOpen();
        this.createLocalFSListener();
        ((LocalFSListener)this.m_localListener).registerNamingHandler(handler);
    }

    public void unregisterNameChangeHandler(INameChangeHandler handler) {
        if (this.m_localListener == null) {
            return;
        }
        ((LocalFSListener)this.m_localListener).unregisterNamingHandler(handler);
    }

    public void registerFSElementChangeHandler(IElementChangeHandler handler) {
        this.checkOpen();
        this.createLocalFSListener();
        this.m_localListener.registerElementChangeHandler(handler);
    }

    public void registerFSElementChangeHandler(String elementName, IElementChangeHandler handler) {
        this.checkOpen();
        this.createLocalFSListener();
        this.m_localListener.registerElementChangeHandler(elementName, handler);
    }

    private void checkOpen() {
        if (!this.m_open) {
            throw new RuntimeException("The DS is closed.");
        }
    }

    public void unregisterFSElementChangeHandler(IElementChangeHandler handler) {
        if (this.m_localListener == null) {
            return;
        }
        this.m_localListener.unregisterElementChangeHandler(handler);
    }

    public void unregisterFSElementChangeHandler(String elementName, IElementChangeHandler handler) {
        if (this.m_localListener == null) {
            return;
        }
        this.m_localListener.unregisterElementChangeHandler(elementName, handler);
    }

    private void createLocalListener() {
        if (this.m_localListener != null) {
            return;
        }
        if (this.hasConsumer()) {
            throw new RuntimeException("Cannot have more than a single listener.");
        }
        this.m_localListener = new LocalListener();
        this.subscribeAll(this.m_localListener);
    }

    private void createLocalFSListener() {
        if (this.m_localListener != null) {
            return;
        }
        if (this.hasConsumer()) {
            throw new RuntimeException("Cannot have more than a single listener.");
        }
        this.m_localListener = new LocalFSListener();
        this.subscribeAll(this.m_localListener);
        this.subscribeNaming((LocalFSListener)this.m_localListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDirElement subclassElement(IBasicElement delta, String newName0, IDeltaView view, boolean notifyModifications) throws DirectoryServiceException, VersionOutofSyncException {
        this.validateOpen();
        if (delta == null || newName0 == null) {
            throw new DirectoryServiceException("A super element delta object and the name for the subclassed element must be specified.");
        }
        EntityName newNameE = this.validateAndModify(newName0);
        String newName = newNameE.getName();
        if (!(delta instanceof IDeltaElement)) {
            throw new DirectoryServiceException("The delta parameter must be the modified result of IDirElement.doneUpdateForSubclassing().");
        }
        EntityName deltaNameE = DirectoryService.validateName(delta.getIdentity().getName());
        String deltaName = deltaNameE.getName();
        if (deltaName.equals(VIEW_ELEMENT)) {
            throw new DirectoryServiceException("The view cannot be sub-classed.");
        }
        if (!deltaNameE.getParent().equals(newNameE.getParent())) {
            throw new DirectoryServiceException("The super element and the sub-classed element must reside in the same directory.");
        }
        if (PackedDirUtil.underPackedDir(deltaNameE)) {
            throw new DirectoryServiceException("Packed element \"" + deltaName + "\" cannot be sub-classed.");
        }
        try {
            this.m_lock.writeLock();
            IIdentity newID = this.m_idCache.get(newNameE);
            if (newID != null) {
                throw new DirectoryServiceException("\"" + newName + "\" already exists.");
            }
            Element superElement = (Element)this.getElementAsIs(deltaName, true);
            if (superElement == null) {
                throw new DirectoryServiceException("\"" + deltaName + "\" was deleted.");
            }
            if (!superElement.isTemplate()) {
                throw new DirectoryServiceException("\"" + deltaName + "\" is not a template - cannot be sub-classed.");
            }
            Element superElementOld = (Element)superElement.createClone();
            superElementOld = this.cleanupSuperElement(superElementOld, false, false);
            if (superElement.isSubclassedElement()) {
                throw new DirectoryServiceException("\"" + deltaName + "\" is sub-classed from \"" + superElement.getSuperElementName() + "\". It cannot be sub-classed again.");
            }
            Element realizedSub = this.doRealizeSub(superElement, (DeltaElement)delta, newName);
            if (realizedSub.getSuperElementName() == null) {
                throw new DirectoryServiceException("The delta must be returned from a doneUpdateForSubclassing() call.");
            }
            byte[] serializedDelta = ((DeltaElement)delta).toBytes();
            DeltaElement superDelta = Element.addSubToSuperDelta((String)newName, (Element)superElement);
            superElement.addSubclassedElement(newName, serializedDelta);
            boolean transactOK = false;
            BeforeAfterPair pair = null;
            try {
                this.m_trManager.join();
                this.setElementAsIs((IBasicElement)((IDeltaElement)superElement.doneUpdate()), null, false);
                Element newSubClassed = new Element(realizedSub.getIdentity());
                newSubClassed.addSuperAttribute(deltaName);
                this.storeInternal(newNameE, (IDirElement)newSubClassed.doneUpdate());
                pair = this.retrievePairAndStoreInternal(pair, view);
                transactOK = true;
                if (notifyModifications) {
                    this.notifyMods(new ModificationItem(realizedSub), this.createViewMod(view, pair));
                }
                this.notifyMods(new ModificationItem(superDelta, superElementOld), null);
            }
            catch (Throwable throwable) {
                if (notifyModifications) {
                    this.notifyMods(new ModificationItem(realizedSub), this.createViewMod(view, pair));
                }
                this.notifyMods(new ModificationItem(superDelta, superElementOld), null);
                this.m_trManager.leave(transactOK);
                throw throwable;
            }
            this.m_trManager.leave(transactOK);
            IDirElement newElement = (IDirElement)realizedSub.createWritableClone();
            ((Element)newElement).setSubclassingDelta(serializedDelta);
            IDirElement iDirElement = newElement;
            return iDirElement;
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private EntityName validateAndModify(String elementName) throws DirectoryServiceException {
        EntityName eName = DirectoryService.validateName(elementName);
        if (this.m_authentication != null) {
            this.m_authentication.okToModify(eName);
        }
        return eName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubclassElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException {
        EntityName nameE = DirectoryService.validateName(elementName);
        try {
            this.m_lock.writeLock();
            Element realizedElement = (Element)this.getElement(elementName, true);
            String superName = realizedElement.getSuperElementName();
            if (superName == null) {
                throw new DirectoryServiceException("Element \"" + elementName + "\" is not sub-classed.");
            }
            BeforeAfterPair pair = null;
            ModificationItem modItem = null;
            boolean transactOK = false;
            try {
                this.m_trManager.join();
                modItem = this.removeSubclassedFromSuper(superName, nameE.getName());
                realizedElement.removeSuperElementName();
                this.storeInternal(nameE, (IDirElement)realizedElement);
                pair = this.retrievePairAndStoreInternal(pair, view);
                transactOK = true;
                this.notifyMods(modItem, this.createViewMod(view, pair));
            }
            catch (Throwable throwable) {
                this.notifyMods(modItem, this.createViewMod(view, pair));
                this.m_trManager.leave(transactOK);
                throw throwable;
            }
            this.m_trManager.leave(transactOK);
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private BeforeAfterPair retrievePairAndStoreInternal(BeforeAfterPair pairParam, IDeltaView view) throws DirectoryServiceException {
        BeforeAfterPair pair = pairParam;
        if (view != null) {
            pair = this.prepareToSet(((DeltaView)view).getElement(), null);
            this.storeInternal(VIEW_ELEMENT_ENTITY_NAME, pair.m_after);
        }
        return pair;
    }

    private ModificationItem removeSubclassedFromSuper(String superName, String subclassedName) throws DirectoryServiceException, VersionOutofSyncException {
        try {
            Element superElement = (Element)this.getElementAsIs(superName, true);
            if (superElement == null) {
                throw new DirectoryServiceException("Super element \"" + superName + "\" is missing.");
            }
            if (superElement.getSubclassedDelta(subclassedName) == null) {
                throw new DirectoryServiceException("Element \"" + subclassedName + "\" definition is missing at \"" + superName + "\".");
            }
            Element superElementOld = (Element)superElement.createClone();
            superElementOld = this.cleanupSuperElement(superElementOld, false, false);
            DeltaElement superDelta = superElement.findSuperDelta(subclassedName);
            this.setElementAsIs((IBasicElement)((IDeltaElement)superElement.doneUpdate()), null, false);
            return new ModificationItem(superDelta, superElementOld);
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
    }

    public void importedElement(IBasicElement element) throws DirectoryServiceException, VersionOutofSyncException {
        this.m_importManager.importedElement((Element)element);
    }

    @Override
    public long getBackupTimestamp() {
        return this.m_backupVersion;
    }

    Class loadClass(String className, String classpath) throws Exception {
        if (this.m_loader != null) {
            return this.m_loader.loadClass(className, this.expandClasspath(classpath));
        }
        return this.loadClassInternal(className, classpath);
    }

    private Class loadClassInternal(String className, String classpathParam) throws Exception {
        String classpath = classpathParam;
        classpath = this.expandClasspath(classpath);
        URLClassLoader urlLoader = new URLClassLoader(DirectoryService.getURLList(classpath));
        return Class.forName(className, false, urlLoader);
    }

    private String expandClasspath(String origClasspath) throws Exception {
        if (origClasspath == null) {
            return null;
        }
        StringBuffer newClasspath = new StringBuffer();
        StringTokenizer st = new StringTokenizer(origClasspath, ";");
        while (st.hasMoreTokens()) {
            String classpathToken = st.nextToken();
            if (classpathToken.length() > "sonicfs:///".length() && classpathToken.substring(0, "sonicfs:///".length()).equalsIgnoreCase("sonicfs:///")) {
                String logicalArchiveName = classpathToken.substring("sonicfs:///".length());
                String archive = null;
                File archiveFile = null;
                try {
                    archive = this.logicalToStorage('/' + logicalArchiveName);
                    archiveFile = this.blobToFile(archive);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (archiveFile == null) continue;
                classpathToken = archiveFile.toURL().toString();
            }
            if (newClasspath.length() > 0) {
                newClasspath.append(";");
            }
            newClasspath.append(classpathToken);
        }
        return newClasspath.toString();
    }

    static String listToClasspath(IAttributeList pluginArchiveList) {
        String classpath = "";
        if (pluginArchiveList != null) {
            for (int j = 0; j < pluginArchiveList.getCount(); ++j) {
                classpath = classpath + (String)pluginArchiveList.getItem(j);
                if (j + 1 >= pluginArchiveList.getCount()) continue;
                classpath = classpath + ";";
            }
        }
        return classpath;
    }

    private static URL[] getURLList(String path) throws Exception {
        if (path == null || path.length() == 0) {
            return new URL[0];
        }
        StringTokenizer st = new StringTokenizer(path, ";");
        URL[] urls = new URL[st.countTokens()];
        for (int i = 0; i < urls.length; ++i) {
            String token = st.nextToken();
            File file = new File(token);
            urls[i] = file.exists() ? file.toURL() : new URL(token);
        }
        return urls;
    }

    @Override
    public void newAuthenticationDescriptor(IElement element) {
        if (this.m_authentication != null) {
            this.m_authentication.modifyDomainConnectionParameters(element);
        }
    }

    @Override
    public String[] getExternalDomainsDescriptors() {
        if (this.m_authentication == null) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        return this.m_authentication.getExternalDomainsDescriptors();
    }

    boolean rememberNewIds() {
        if (this.m_notificationManager != null) {
            return this.m_notificationManager.rememberNewIds();
        }
        return false;
    }

    @Override
    public boolean isFSInterfaceInUse() {
        return this.m_FSInterfaceIsUsed;
    }

    @Override
    public IBasicElement[] translateElementsToLogical(IBasicElement[] elements) {
        ArrayList translatedList = this.translateElementsToLogicalInternal(elements);
        IBasicElement[] result = new IBasicElement[translatedList.size()];
        translatedList.toArray(result);
        return result;
    }

    private IDirElement[] translateElementsToLogical(IDirElement[] elements) {
        ArrayList translatedList = this.translateElementsToLogicalInternal((IBasicElement[])elements);
        IDirElement[] result = new IDirElement[translatedList.size()];
        translatedList.toArray(result);
        return result;
    }

    private ArrayList translateElementsToLogicalInternal(IBasicElement[] elements) {
        NameReplacer nameReplacer = this.m_logicalNameSpace.createNameReplacer(false);
        ArrayList<IElement> result = new ArrayList<IElement>();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] instanceof IDirElement && ((IDirElement)elements[i]).isDeleted() || elements[i] instanceof IEnvelope) continue;
            IElement clone = null;
            if (elements[i] instanceof Element) {
                clone = ((Element)elements[i]).createClone();
            } else if (elements[i] instanceof DeltaElement) {
                clone = ((DeltaElement)elements[i]).createClone();
            }
            if (clone == null) continue;
            String storageName = clone.getIdentity().getName();
            ((ICanReplaceRef)clone).replaceReferences(false, (IReplaceRef)nameReplacer);
            String logicalName = null;
            try {
                logicalName = nameReplacer.replace(storageName);
            }
            catch (Exception e) {
                continue;
            }
            this.setLogicalName((IBasicElement)clone, logicalName);
            result.add(clone);
        }
        return result;
    }

    public String logicalToStorage(String path) throws DirectoryServiceException {
        this.trace(1024, "logicalToStorage " + path);
        this.m_FSInterfaceIsUsed = true;
        try {
            this.m_lock.readLock();
            String string = this.m_logicalNameSpace.storageFromLogical(path);
            return string;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    String tempBlobLogicalToStorage(String path) throws DirectoryServiceException {
        try {
            this.m_lock.readLock();
            String string = this.m_logicalNameSpace.tempBlobStorageName(path);
            return string;
        }
        catch (ConfigException configE) {
            DirectoryServiceException dirE = new DirectoryServiceException(configE.toString());
            dirE.initCause((Throwable)configE);
            throw dirE;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String storageToLogical(String storageName) throws DirectoryServiceException {
        this.trace(1024, "storageToLogical " + storageName);
        try {
            this.m_lock.readLock();
            String logicalName = this.m_logicalNameSpace.logicalFromStorage(storageName);
            if (logicalName != null) {
                this.m_FSInterfaceIsUsed = true;
            }
            String string = logicalName;
            return string;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineFolderMetaAttributes(String[] attributeNames) throws DirectoryServiceException {
        this.trace(1056, "defineFolderMetaAttributes");
        this.m_FSInterfaceIsUsed = true;
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            for (int i = 0; i < attributeNames.length; ++i) {
                this.m_logicalNameSpace.defineFolderMetaAttribute(attributeNames[i]);
            }
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public String[] getDefinedFolderMetaAttributes() throws DirectoryServiceException {
        this.trace(1024, "getDefinedFolderMetaAttributes");
        this.m_FSInterfaceIsUsed = true;
        try {
            this.m_lock.readLock();
            String[] stringArray = this.m_logicalNameSpace.getDefinedFolderMetaAttributes();
            return stringArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineElementMetaAttributes(String[] attributeNames) throws DirectoryServiceException {
        this.trace(1056, "defineElementMetaAttributes");
        this.m_FSInterfaceIsUsed = true;
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            for (int i = 0; i < attributeNames.length; ++i) {
                this.m_logicalNameSpace.defineElementMetaAttribute(attributeNames[i]);
            }
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public String[] getDefinedElementMetaAttributes() throws DirectoryServiceException {
        this.trace(1024, "getDefinedElementMetaAttributes");
        this.m_FSInterfaceIsUsed = true;
        try {
            this.m_lock.readLock();
            String[] stringArray = this.m_logicalNameSpace.getDefinedElementMetaAttributes();
            return stringArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void renameFolder(String oldName, String newName) throws DirectoryServiceException {
        try {
            ExtendedSonicFSFileSystem extendedFS = new ExtendedSonicFSFileSystem(this, null, null);
            SonicFSFile oldFile = extendedFS.getFileDetails(extendedFS.getCanonical(oldName));
            if (oldFile == null || !oldFile.isDirectory()) {
                throw new DirectoryServiceException("\"" + oldName + "\" is not a folder");
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
        this.rename(oldName, newName);
    }

    public void renameFile(String oldName, String newName) throws DirectoryServiceException {
        try {
            ExtendedSonicFSFileSystem extendedFS = new ExtendedSonicFSFileSystem(this, null, null);
            SonicFSFile oldFile = extendedFS.getFileDetails(extendedFS.getCanonical(oldName));
            if (oldFile == null || !oldFile.isFile()) {
                throw new DirectoryServiceException("\"" + oldName + "\" is not a file");
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
        this.rename(oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldName, String newName) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "rename " + oldName + " to " + newName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(oldName)) != null) {
            this.m_dsHandlers.rename(handler, oldName, newName);
            return;
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            int pathType = 0;
            try {
                if (this.isPermissionsCheckingEnabled()) {
                    pathType = this.m_logicalNameSpace.getNameSpaceType(oldName);
                }
            }
            catch (Exception e) {
                throw new DirectoryServiceException("Unable to get the type of the original type to check permissions: " + e.toString());
            }
            this.m_logicalNameSpace.rename(oldName, newName);
            try {
                this.movePermissions(oldName, newName, pathType);
            }
            catch (InvalidManagementPermissionException invalid) {
                throw new DirectoryServiceException("Unable to move permissions after rename " + invalid.toString());
            }
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public void createFolder(String folderName) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1056, "createFolder " + folderName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(folderName)) != null) {
            this.m_dsHandlers.createFolder(handler, folderName);
            return;
        }
        this.processCreateFolder(folderName);
    }

    public void createFolder(String folderName, boolean existingFolderOk) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1056, "createFolder " + folderName + " existingFolderOk " + existingFolderOk);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(folderName)) != null) {
            this.m_dsHandlers.createFolder(handler, folderName, existingFolderOk);
            return;
        }
        HashMap test = this.getMetaAttributes(folderName);
        if (test != null && existingFolderOk) {
            return;
        }
        this.processCreateFolder(folderName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCreateFolder(String folderName) throws DirectoryServiceException {
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.m_logicalNameSpace.createFolder(folderName);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFolder(String folderName) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1056, "deleteFolder " + folderName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(folderName)) != null) {
            this.m_dsHandlers.deleteFolder(handler, folderName);
            return;
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            switch (this.m_logicalNameSpace.getNameSpaceType(folderName)) {
                case 0: {
                    this.deleteDirectory(this.m_logicalNameSpace.folderToDirectory(folderName));
                    break;
                }
                case 3: {
                    throw new DirectoryServiceException("Folder " + folderName + " does not exist.");
                }
                case 1: {
                    String[] list = this.m_logicalNameSpace.list(folderName);
                    if (list.length > 0) {
                        throw new DirectoryServiceException("Folder " + folderName + " cannot be deleted since it's not empty.");
                    }
                    this.m_logicalNameSpace.deleteFolder(folderName);
                    break;
                }
                case 2: {
                    String dirName = this.m_logicalNameSpace.storageFromLogical(folderName);
                    this.deleteDirectory(dirName, null);
                    this.m_logicalNameSpace.deleteFolder(folderName);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            this.removePermissions(folderName);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDirElement[] getFSElements(String folderName, boolean forUpdate) throws DirectoryServiceException {
        IDSHandler handler;
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(folderName)) != null) {
            return this.m_dsHandlers.getFSElements(handler, folderName, forUpdate);
        }
        try {
            String directoryName = this.m_logicalNameSpace.folderToDirectory(folderName);
            if (directoryName != null) {
                IDirElement[] elements = this.getAllElements(directoryName, forUpdate);
                IDirElement[] iDirElementArray = this.replaceReferencesForElements(elements);
                return iDirElementArray;
            }
            HashMap[] elementsAtt = this.listFSElements(folderName);
            ArrayList<IDirElement> elementList = new ArrayList<IDirElement>();
            for (int i = 0; i < elementsAtt.length; ++i) {
                IElementIdentity id = (IElementIdentity)elementsAtt[i].get("_ELEMENT_IDENTITY");
                if (id == null) continue;
                elementList.add(this.getFSElement(id.getName(), forUpdate, false));
            }
            IDirElement[] iDirElementArray = elementList.toArray(new IDirElement[0]);
            return iDirElementArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public HashMap[] listFSElements(String folderName) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "listFSElements " + folderName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(folderName)) != null) {
            return this.m_dsHandlers.listFSElements(handler, folderName);
        }
        ArrayList<HashMap> result = this.listFSAll(folderName, false, true, null);
        return result.toArray(new HashMap[0]);
    }

    public HashMap[] listAllFolders() throws DirectoryServiceException {
        this.trace(1024, "listAllFolders");
        ArrayList result = new ArrayList();
        try {
            this.m_lock.readLock();
            HashMap<String, String> rootAttrs = new HashMap<String, String>();
            rootAttrs.put("_FOLDER_NAME", ROOT_DIRECTORY);
            result.add(rootAttrs);
            this._listAllFolders(ROOT_DIRECTORY, result);
        }
        finally {
            this.m_lock.releaseLock();
        }
        return result.toArray(new HashMap[0]);
    }

    private void _listAllFolders(String path, List res) throws DirectoryServiceException {
        ArrayList<HashMap> child = this.listFSAll(path, true, false, null);
        for (int i = 0; i < child.size(); ++i) {
            Map aChild = (Map)child.get(i);
            String name = (String)aChild.get("_FOLDER_NAME");
            res.add(aChild);
            this._listAllFolders(name, res);
        }
    }

    public HashMap[] listFolders(String folderName) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "listFolders " + folderName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(folderName)) != null) {
            return this.m_dsHandlers.listFolders(handler, folderName);
        }
        ArrayList<HashMap> result = this.listFSAll(folderName, true, false, null);
        return result.toArray(new HashMap[0]);
    }

    public HashMap[] listFSAll(String path) throws DirectoryServiceException {
        return this.listFSAll(path, true, null);
    }

    public HashMap[] listFSAll(String path, boolean getFolders, String extension) throws DirectoryServiceException {
        ArrayList<HashMap> result = this.listFSAll(path, getFolders, true, extension);
        return result.toArray(new HashMap[0]);
    }

    @Override
    public ArrayList<HashMap> listFSAll(String path, boolean getFolders, boolean getElements, String extension) throws DirectoryServiceException {
        this.m_FSInterfaceIsUsed = true;
        try {
            IDSHandler handler;
            if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(path)) != null) {
                ArrayList arrayList = this.m_dsHandlers.listFSAll(handler, path, getFolders, getElements, extension);
                return arrayList;
            }
            this.m_lock.readLock();
            String directoryName = this.m_logicalNameSpace.folderToDirectory(path);
            if (directoryName != null) {
                ArrayList arrayList = this.listFSAllComplex(path, directoryName, getFolders, getElements, extension);
                return arrayList;
            }
            String realPath = this.m_logicalNameSpace.getCaseSensitiveName(path);
            EntityName pathE = DirectoryService.validateName(realPath);
            String pathPrefix = pathE.isRoot() ? "" : pathE.getName();
            String[] subItems = this.m_logicalNameSpace.list(pathE.getName());
            ArrayList<HashMap> returnList = new ArrayList<HashMap>();
            for (int i = 0; i < subItems.length; ++i) {
                HashMap attrs;
                String itemName = pathPrefix + '/' + subItems[i];
                if (!this.qualifyAttributes(itemName, attrs = this.m_logicalNameSpace.getMetaAttributes(itemName), getFolders, getElements, extension)) continue;
                returnList.add(attrs);
            }
            ArrayList<HashMap> arrayList = returnList;
            return arrayList;
        }
        catch (Exception ex) {
            throw new DirectoryServiceException(ex.getMessage());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private boolean qualifyAttributes(String path, HashMap attrs, boolean getFolders, boolean getElements, String extension) throws DirectoryServiceException {
        int nameSpaceType = this.m_logicalNameSpace.getNameSpaceType(path);
        if (getFolders && (nameSpaceType == 1 || nameSpaceType == 2)) {
            attrs.put("_FOLDER_NAME", path);
            DirectoryService.putAttributeComplex(attrs, nameSpaceType);
            return true;
        }
        if (getElements && nameSpaceType == 3) {
            if (extension != null && !path.endsWith(extension)) {
                return false;
            }
            attrs.put("_ELEMENT_IDENTITY", this.getFSIdentity(path));
            return true;
        }
        return false;
    }

    private ArrayList listFSAllComplex(String logicalPath, String dirName, boolean getFolders, boolean getElements, String extension) throws DirectoryServiceException, ViewException, ConfigException {
        IIdentity[] ids = this.listAll(dirName);
        ArrayList returnList = new ArrayList();
        for (int i = 0; i < ids.length; ++i) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            if (getElements && ids[i] instanceof IElementIdentity) {
                ElementIdentity id = ((ElementIdentity)ids[i]).createClone();
                String logicalName = this.m_logicalNameSpace.logicalFromStorage(ids[i].getName());
                if (extension == null || logicalName.endsWith(extension)) {
                    this.setLogicalName((IElementIdentity)id, logicalName);
                    attrs.put("_ELEMENT_IDENTITY", id);
                    returnList.add(attrs);
                }
            }
            if (!getFolders || !(ids[i] instanceof IDirIdentity)) continue;
            attrs.put("_FOLDER_NAME", this.m_logicalNameSpace.getCaseSensitiveName(logicalPath) + '/' + DirectoryService.validateName(ids[i].getName()).getBaseName());
            returnList.add(attrs);
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaAttributes(String name, HashMap newAttributes) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1056, "setMetaAttributes for " + name);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(name)) != null) {
            this.m_dsHandlers.setMetaAttributes(handler, name, newAttributes);
            return;
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            HashMap modNewAttributes = (HashMap)newAttributes.clone();
            modNewAttributes.remove("_ELEMENT_IDENTITY");
            modNewAttributes.remove("_FOLDER_NAME");
            modNewAttributes.remove("_IS_COMPLEX");
            this.qualifyAttributes(name, modNewAttributes, true, true, null);
            this.m_logicalNameSpace.setMetaAttributes(name, modNewAttributes);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getMetaAttributes(String name) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "getMetaAttributes for " + name);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(name)) != null) {
            return this.m_dsHandlers.getMetaAttributes(handler, name);
        }
        try {
            this.m_lock.readLock();
            int nameSpaceType = this.m_logicalNameSpace.getNameSpaceType(name);
            if (nameSpaceType == 0) {
                EntityName nameE = new EntityName(name);
                String parentDir = this.m_logicalNameSpace.folderToDirectory(nameE.getParent());
                if (parentDir != null) {
                    IIdentity id = this.getIdentity(parentDir + '/' + nameE.getBaseName());
                    if (id != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        if (id instanceof IDirIdentity) {
                            map.put("_FOLDER_NAME", name);
                        } else {
                            map.put("_ELEMENT_IDENTITY", (String)this.getFSIdentity(name));
                        }
                        HashMap<String, String> hashMap = map;
                        return hashMap;
                    }
                    HashMap hashMap = null;
                    return hashMap;
                }
                HashMap hashMap = null;
                return hashMap;
            }
            HashMap attrs = this.m_logicalNameSpace.getMetaAttributes(name);
            if (nameSpaceType == 1 || nameSpaceType == 2) {
                attrs.put("_FOLDER_NAME", name);
                DirectoryService.putAttributeComplex(attrs, nameSpaceType);
            }
            if (nameSpaceType == 3) {
                attrs.put("_ELEMENT_IDENTITY", this.getFSIdentity(name));
            }
            HashMap hashMap = attrs;
            return hashMap;
        }
        catch (Exception e) {
            this.trace(1024, "Failed getting meta attributes, trace follows...", e);
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private static void putAttributeComplex(HashMap attrs, int nameSpaceType) {
        if (nameSpaceType == 2) {
            attrs.put("_IS_COMPLEX", Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackReferenceTypes(String[] typeList) throws DirectoryServiceException {
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.m_backRefMgr.setBackReferenceTypes(typeList);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public String[] getBackReferenceTypes() throws DirectoryServiceException {
        try {
            this.m_lock.readLock();
            String[] stringArray = this.m_backRefMgr.getBackReferenceTypes();
            return stringArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void resetBackReferences() throws DirectoryServiceException {
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.m_backRefMgr.resetBackReferences();
            this.m_backRefMgr.deleteBackRefDir();
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildBackReferences() throws DirectoryServiceException {
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.m_backRefMgr.deleteBackRefDir();
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        transactOK = false;
        joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.m_backRefMgr.scanDSandPopulateBackRefTree();
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public void setStorageHint(String elementType, String directoryName) throws DirectoryServiceException {
        this.trace(1024, "setStorageHint for type " + elementType + " at directory " + directoryName);
        this.setStorageHint(elementType, null, directoryName, false);
    }

    public void setStorageHint(String elementType, String postfix, String directoryName) throws DirectoryServiceException {
        this.trace(1024, "setStorageHint for type " + elementType + "." + postfix + " at directory " + directoryName);
        this.setStorageHint(elementType, postfix, directoryName, false);
    }

    public void setComplexStorageHint(String elementType, String directoryName) throws DirectoryServiceException {
        this.trace(1024, "setStorageHint complex for type " + elementType + " at directory " + directoryName);
        this.setStorageHint(elementType, null, directoryName, true);
    }

    private void setStorageHint(String elementType, String postfix, String directoryName, boolean complex) throws DirectoryServiceException {
        this.validateOpen();
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            this.createHintsElement();
            String hintID = LogicalNameSpace.createHintID((String)elementType, (String)postfix);
            IDirElement storageHints = this.getElement(STORAGE_HINTS_ELEMENT, true);
            IAttributeSet atts = storageHints.getAttributes();
            IAttributeSet hints = (IAttributeSet)atts.getAttribute(HINTS_ATT);
            IAttributeSet hint = hints.createAttributeSet(hintID);
            hint.setStringAttribute("HINT_DIRECTORY", new EntityName(directoryName).getName());
            if (complex) {
                hint.setBooleanAttribute("HINT_COMPLEX", Boolean.TRUE);
            }
            this.setElement(storageHints.doneUpdate(), null);
            this.m_logicalNameSpace.resetStorageHints((IAttributeSet)storageHints.getAttributes().getAttribute(HINTS_ATT));
            transactOK = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public IDirElement[] getFSElements(Query query, boolean forUpdate) throws DirectoryServiceException {
        return this.getFSElements(query, forUpdate, false);
    }

    private String[] getComplexDescriptors(String dirName, String type) throws DirectoryServiceException {
        ArrayList<String> resultList = new ArrayList<String>();
        IDirIdentity[] topDirIDs = this.listDirectories(dirName);
        for (int i = 0; i < topDirIDs.length; ++i) {
            IElementIdentity[] topElements = this.listElements(topDirIDs[i].getName());
            for (int j = 0; j < topElements.length; ++j) {
                if (!topElements[j].getType().equals(type)) continue;
                resultList.add(topElements[j].getName());
            }
        }
        return resultList.toArray(IEmptyArray.EMPTY_STRING_ARRAY);
    }

    public IDirElement[] getFSElements(Query query, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        return this.getFSElements(query, forUpdate, getSubclassingDelta, null).getElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryBatch getFSElements(Query query, boolean forUpdate, boolean getSubclassingDelta, QueryBatch batch) throws DirectoryServiceException {
        this.trace(1024, "getFSElements");
        this.m_FSInterfaceIsUsed = true;
        IDirElement[] candidates = null;
        Object batchResult = null;
        try {
            QueryBatch queryBatch;
            this.m_lock.readLock();
            From from = this.retrieveFrom(query);
            if (from instanceof FromElementList) {
                candidates = this.getFSElementsInternal(query, forUpdate, getSubclassingDelta);
            } else if (from instanceof FromElementType && this.m_logicalNameSpace.complexDirForType(((FromElementType)from).getType()) != null) {
                String descriptorType = ((FromElementType)from).getType();
                String topDir = this.m_logicalNameSpace.complexDirForType(descriptorType);
                String[] elementNames = this.getComplexDescriptors(topDir, descriptorType);
                for (int i = 0; i < elementNames.length; ++i) {
                    elementNames[i] = this.m_logicalNameSpace.logicalFromStorage(elementNames[i]);
                }
                Query q = new Query().setSelect(query.getSelect()).setFrom((From)new FromElementList(elementNames)).setWhere(query.getWhere());
                candidates = this.getFSElementsInternal(q, forUpdate, getSubclassingDelta);
            } else if (from instanceof FromElementType) {
                String type = ((FromElementType)from).getType();
                ArrayList dirList = this.m_logicalNameSpace.directoriesForType(type);
                if (dirList == null || dirList.isEmpty()) {
                    throw new DirectoryServiceException("Element type " + type + " doesn't have a storage hint.");
                }
                ArrayList<IDirElement> allElements = new ArrayList<IDirElement>();
                for (int i = 0; i < dirList.size(); ++i) {
                    FromDirectory dirFrom = new FromDirectory((String)dirList.get(i));
                    Query q = new Query().setSelect(query.getSelect()).setFrom((From)dirFrom).setWhere(query.getWhere());
                    IDirElement[] elements = this.getFSElementsInternal(q, forUpdate, getSubclassingDelta);
                    for (int j = 0; j < elements.length; ++j) {
                        allElements.add(elements[j]);
                    }
                }
                candidates = new IDirElement[allElements.size()];
                if (candidates.length > 0) {
                    allElements.toArray(candidates);
                }
            } else if (from instanceof FromFolder) {
                ArrayList<HashMap> elements = this.listFSAll(((FromFolder)from).getFolderName(), false, true, null);
                if (!elements.isEmpty()) {
                    String[] elementNames = new String[elements.size()];
                    for (int i = 0; i < elements.size(); ++i) {
                        String name;
                        elementNames[i] = name = ((IElementIdentity)elements.get(i).get("_ELEMENT_IDENTITY")).getName();
                    }
                    FromElementList fromList = new FromElementList(elementNames);
                    Query q = new Query().setSelect(query.getSelect()).setFrom((From)fromList).setWhere(query.getWhere());
                    candidates = this.getFSElementsInternal(q, forUpdate, getSubclassingDelta);
                } else {
                    candidates = new IDirElement[]{};
                }
            } else {
                throw new DirectoryServiceException("The IDirectoryFileSystemService interface does not support the 'from directory' clause.");
            }
            OrderedBy o = query.getOrderedBy();
            if (o != null) {
                DirectoryService.quickSortElements(candidates, (ElementComparator<IDirElement>)o.getComparator());
            }
            if (batch != null) {
                batch.next(candidates);
                queryBatch = batch;
                return queryBatch;
            }
            queryBatch = new QueryBatch(candidates, null);
            return queryBatch;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private From retrieveFrom(Query query) throws DirectoryServiceException {
        From from = query.getFrom();
        if (from == null) {
            throw new DirectoryServiceException("The query must contain a FROM clause.");
        }
        return from;
    }

    private IDirElement[] getFSElementsInternal(Query query0, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        Query query = ReferenceReplacer.replaceReferences((Query)query0, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(true));
        IDirElement[] elements = this.getElements(query, forUpdate, getSubclassingDelta);
        return this.replaceReferencesForElements(elements);
    }

    private IDirElement[] replaceReferencesForElements(IDirElement[] elements) throws VersionOutofSyncException {
        NameReplacer nameReplacer = this.m_logicalNameSpace.createNameReplacer(false);
        for (int i = 0; i < elements.length; ++i) {
            String storageName = elements[i].getIdentity().getName();
            ((Element)elements[i]).replaceReferences(false, (IReplaceRef)nameReplacer);
            this.setLogicalName((IBasicElement)elements[i], nameReplacer.replace(storageName));
        }
        return elements;
    }

    public IDirElement getFSElement(String elementName, boolean forUpdate) throws DirectoryServiceException {
        IDSHandler handler;
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(elementName)) != null) {
            return this.m_dsHandlers.getFSElement(handler, elementName, forUpdate);
        }
        return this.getFSElement(elementName, forUpdate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDirElement getFSElement(String elementName, boolean forUpdate, boolean getSubclassingDelta) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "getFSElement " + elementName + " for update " + forUpdate);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(elementName)) != null) {
            return this.m_dsHandlers.getFSElement(handler, elementName, forUpdate, getSubclassingDelta);
        }
        DirectoryService.validateName(elementName);
        try {
            this.m_lock.readLock();
            String storageName = null;
            try {
                storageName = this.m_logicalNameSpace.createNameReplacer(true).replace(elementName);
            }
            catch (Exception e) {
                this.trace(1024, "getFSElement " + elementName + " not found, trace follows...", e);
                IDirElement iDirElement = null;
                this.m_lock.releaseLock();
                return iDirElement;
            }
            IDirElement element = this.getElement(storageName, forUpdate, getSubclassingDelta);
            this.validateAndReplaceReferences(element, elementName, storageName);
            this.setLogicalName((IBasicElement)element, this.m_logicalNameSpace.logicalFromStorage(storageName));
            IDirElement iDirElement = element;
            return iDirElement;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    @Override
    public IElement getElementByLogicalName(String logicalName) throws DirectoryServiceException {
        return this.getElementByLogicalName(logicalName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IElement getElementByLogicalName(String logicalName, boolean throwExceptionIfMissing) throws DirectoryServiceException {
        this.trace(1024, "getElementByLogicalName " + logicalName);
        DirectoryService.validateName(logicalName);
        String expandableBlobName = null;
        try {
            this.m_lock.readLock();
            String storageName = null;
            try {
                storageName = this.m_logicalNameSpace.storageFromLogical(logicalName);
            }
            catch (ElementInPathException elInPathE) {
                storageName = elInPathE.getStorageName();
                expandableBlobName = elInPathE.getLogicalName();
            }
            catch (Exception e) {
                this.trace(1024, "getFSElement " + logicalName + " not found, trace follows...", e);
                IElement iElement = null;
                this.m_lock.releaseLock();
                return iElement;
            }
            IDirElement element = this.getElement(storageName, false, false);
            if (element == null && throwExceptionIfMissing) {
                throw new DirectoryServiceException("Could not find element " + logicalName + " - storage name " + storageName + " is invalid.");
            }
            if (expandableBlobName != null && element != null) {
                IAttributeSet topSet = element.getAttributes();
                IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
                if (systemAttrs != null) {
                    Boolean expandInCache = (Boolean)systemAttrs.getAttribute("SONIC_EXPAND_IN_CACHE");
                    if (expandInCache != null && expandInCache.equals(IBlob.EXPANDABLE)) {
                        try {
                            Blob.markBlobState((Element)((Element)element), (Object)expandableBlobName, (String)"ARCHIVE_NAME");
                        }
                        catch (Exception e) {
                            element = null;
                        }
                    } else {
                        element = null;
                    }
                } else {
                    element = null;
                }
            }
            IDirElement iDirElement = element;
            return iDirElement;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IBlob getBlobByLogicalName(String unused, String blobName) throws DirectoryServiceException {
        return this.getBlobByLogicalName(blobName);
    }

    public IBlob getBlobByLogicalName(String logicalName) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "getBlobByLogicalName " + logicalName);
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(logicalName)) != null) {
            return this.m_dsHandlers.getBlobByLogicalName(handler, logicalName);
        }
        try {
            String archiveLogicalName;
            this.m_lock.readLock();
            IElement element = this.getElementByLogicalName(logicalName);
            if (element == null) {
                IBlob iBlob = null;
                return iBlob;
            }
            IBlob retBlob = this.getBlob(element.getIdentity().getName(), false, 0, logicalName);
            IAttributeSet topSet = element.getAttributes();
            IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
            if (systemAttrs != null && (archiveLogicalName = (String)systemAttrs.getAttribute("ARCHIVE_NAME")) != null) {
                Blob.markBlobState((Element)((Element)retBlob.getElement()), (Object)archiveLogicalName, (String)"ARCHIVE_NAME");
            }
            IBlob iBlob = retBlob;
            return iBlob;
        }
        catch (DirectoryServiceException dirE) {
            throw dirE;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IElement[] getElementsByLogicalNames(String[] logicalNames) throws DirectoryServiceException {
        this.trace(1024, "getElementsByLogicalNames");
        try {
            this.m_lock.readLock();
            IElement[] elements = new IElement[logicalNames.length];
            for (int i = 0; i < elements.length; ++i) {
                IDSHandler dsHandler;
                elements[i] = this.getElementByLogicalName(logicalNames[i], false);
                if (elements[i] != null || (dsHandler = this.m_dsHandlers.getHandler(logicalNames[i])) == null) continue;
                elements[i] = dsHandler.getFSElement(logicalNames[i], false);
            }
            IElement[] iElementArray = elements;
            return iElementArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void setLogicalName(IElementIdentity id, String name) {
        try {
            ((Identity)id).setName(new EntityName(name).getName());
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    private void setLogicalName(IBasicElement element, String name) {
        try {
            String canonicalName = name;
            if (!name.startsWith("DELETED:")) {
                canonicalName = new EntityName(name).getName();
            }
            ((Identity)element.getIdentity()).setName(canonicalName);
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeName[] getReferences(String elementPath) throws DirectoryServiceException {
        try {
            this.m_lock.readLock();
            String storagePath = this.m_logicalNameSpace.createNameReplacer(true).replace(elementPath);
            AttributeName[] attributeNames = this.m_backRefMgr.getReferences(storagePath);
            NameReplacer replacer = this.m_logicalNameSpace.createNameReplacer(false);
            for (int i = 0; i < attributeNames.length; ++i) {
                try {
                    String logicalName = replacer.replace(attributeNames[i].getElementName());
                    attributeNames[i].setElementName(logicalName);
                    continue;
                }
                catch (VersionOutofSyncException versionOutofSyncException) {
                    // empty catch block
                }
            }
            AttributeName[] attributeNameArray = attributeNames;
            return attributeNameArray;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IElementIdentity getFSIdentity(String elementName) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "getFSIdentity " + elementName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(elementName)) != null) {
            return this.m_dsHandlers.getFSIdentity(handler, elementName);
        }
        try {
            this.m_lock.readLock();
            String storageName = this.m_logicalNameSpace.storageFromLogical(elementName);
            IIdentity id = this.getIdentity(storageName);
            if (id == null) {
                IElementIdentity iElementIdentity = null;
                return iElementIdentity;
            }
            if (id instanceof IElementIdentity) {
                id = ((ElementIdentity)id).createClone();
                this.setLogicalName((IElementIdentity)id, this.m_logicalNameSpace.logicalFromStorage(storageName));
                IElementIdentity iElementIdentity = (IElementIdentity)id;
                return iElementIdentity;
            }
            throw new DirectoryServiceException(elementName + " is not an element.");
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IElementIdentity deleteFSElement(String elementName) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        this.trace(1056, "deleteFSElement " + elementName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(elementName)) != null) {
            return this.m_dsHandlers.deleteFSElement(handler, elementName);
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IElementIdentity id = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            int nameSpaceType = this.m_logicalNameSpace.getNameSpaceType(elementName);
            if (nameSpaceType == 0) {
                String storageName = null;
                try {
                    storageName = this.m_logicalNameSpace.storageFromLogical(elementName);
                    id = this.getFSIdentity(elementName);
                    if (id == null && storageName != null) {
                        throw new DirectoryServiceException(elementName + " is not an element.");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (storageName == null) {
                    EntityName elementNameE = null;
                    try {
                        elementNameE = new EntityName(elementName);
                        if (this.getMetaAttributes(elementNameE.getParent()) != null) {
                            IElementIdentity iElementIdentity = null;
                            return iElementIdentity;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw new DirectoryServiceException(elementNameE.getParent() + " does not exist.");
                }
                this.deleteElement(storageName, null);
                this.m_logicalNameSpace.deleteElement(elementName, true);
                transactOK = true;
                IElementIdentity iElementIdentity = id;
                return iElementIdentity;
            }
            if (nameSpaceType != 3) {
                throw new DirectoryServiceException(elementName + " is not an element.");
            }
            id = this.getFSIdentity(elementName);
            IElementIdentity storageID = this.deleteElement(this.m_logicalNameSpace.storageFromLogical(elementName), null);
            if (storageID != null) {
                this.m_logicalNameSpace.deleteElement(elementName);
            }
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return id;
    }

    public INextVersionToken createFSElement(IDirElement logicalElement) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(logicalElement.getIdentity().getName())) != null) {
            return this.m_dsHandlers.createFSElement(handler, logicalElement);
        }
        return this.createFSElement(logicalElement, null);
    }

    INextVersionToken createFSElement(IDirElement logicalElement, String storageName0) throws DirectoryServiceException, VersionOutofSyncException {
        return this.createFSElement(logicalElement, storageName0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    INextVersionToken createFSElement(IDirElement logicalElement, String storageName0, ArrayList elementsWithNoStorageRef) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "createFSElement " + logicalElement);
        this.m_FSInterfaceIsUsed = true;
        IDirElement element = logicalElement;
        if (this.m_noContainer) {
            element = (IDirElement)((Element)logicalElement).createClone();
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        INextVersionToken token = null;
        try {
            IAttributeSet descAttributes;
            Boolean external;
            joinedTransaction = this.startJoinTransaction();
            String storageName = storageName0 != null ? storageName0 : this.assignStorageName((IBasicElement)element);
            boolean storageOK = ((Element)element).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(true));
            if (!storageOK && elementsWithNoStorageRef != null) {
                elementsWithNoStorageRef.add(logicalElement.getIdentity().getName());
            }
            ((Identity)element.getIdentity()).setName(storageName);
            token = this.setElement((IBasicElement)element, null);
            if (this.m_authentication != null && logicalElement.getIdentity().getType().equals("MF_AUTHENTICATION_DOMAIN") && (external = (Boolean)(descAttributes = logicalElement.getAttributes()).getAttribute("EXTERNAL")) != null && external.booleanValue()) {
                this.m_authentication.createExternalDirectories(DirectoryService.validateName(storageName).getParent());
            }
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return this.replaceReferences(token);
    }

    INextVersionToken createFSElements(IDirElement[] logicalElements, String[] storageNames) throws DirectoryServiceException, VersionOutofSyncException {
        this.m_FSInterfaceIsUsed = true;
        IDirElement[] storageElements = new IDirElement[logicalElements.length];
        for (int i = 0; i < logicalElements.length; ++i) {
            storageElements[i] = this.m_noContainer ? (IDirElement)((Element)logicalElements[i]).createClone() : logicalElements[i];
            ((Element)storageElements[i]).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(true));
            ((Identity)storageElements[i].getIdentity()).setName(storageNames[i]);
        }
        INextVersionToken token = this.setElements((IBasicElement[])storageElements, null, null);
        return this.replaceReferences(token);
    }

    boolean isHandledByHandler(IBasicElement element) throws DirectoryServiceException {
        if (this.m_dsHandlers != null) {
            String elementName = element.getIdentity().getName();
            IDSHandler handler = this.m_dsHandlers.getHandler(elementName);
            return handler != null;
        }
        return false;
    }

    private String assignStorageName(IBasicElement element, boolean modView) throws DirectoryServiceException {
        IElementIdentity id = element.getIdentity();
        return this.assignStorageName(id.getName(), id.getType(), modView);
    }

    private String assignStorageName(String logicalName, String type, boolean modView) throws DirectoryServiceException {
        String storageName = this.m_logicalNameSpace.createElement(logicalName, type, modView);
        this.ensureParentDirExists(storageName);
        return storageName;
    }

    String assignStorageName(IBasicElement element) throws DirectoryServiceException {
        return this.assignStorageName(element, true);
    }

    String assignStorageName(String logicalName, String type) throws DirectoryServiceException {
        return this.assignStorageName(logicalName, type, true);
    }

    private void ensureParentDirExists(String storageName) throws DirectoryServiceException {
        try {
            EntityName parentE = new EntityName(storageName).getParentEntity();
            if (this.m_idCache.get(parentE) == null) {
                this.createDirectory(parentE.getName());
            }
        }
        catch (ConfigException e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    String[] assignStorageNames(IDirElement[] elements, boolean fromBulk) throws DirectoryServiceException {
        String[] result = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            IElementIdentity id = elements[i].getIdentity();
            result[i] = this.m_logicalNameSpace.createElement(id.getName(), id.getType());
            if (i != 0 && fromBulk) continue;
            this.ensureParentDirExists(result[i]);
        }
        return result;
    }

    public INextVersionToken updateFSElement(IDeltaDirElement logicalDelta) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(logicalDelta.getIdentity().getName())) != null) {
            return this.m_dsHandlers.updateFSElement(handler, logicalDelta);
        }
        return this.updateFSElement(logicalDelta, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INextVersionToken updateFSElement(IDeltaDirElement logicalDelta, ArrayList elementsWithNoStorageRef) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "updateFSElement " + logicalDelta);
        this.m_FSInterfaceIsUsed = true;
        IDeltaDirElement delta = this.createClone(logicalDelta);
        boolean transactOK = false;
        boolean joinedTransaction = false;
        INextVersionToken token = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            String storageName = this.m_logicalNameSpace.storageFromLogical(logicalDelta.getIdentity().getName());
            boolean storageOK = ((DeltaElement)delta).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(true));
            if (!storageOK && elementsWithNoStorageRef != null) {
                elementsWithNoStorageRef.add(logicalDelta.getIdentity().getName());
            }
            ((Identity)delta.getIdentity()).setName(storageName);
            if (delta.getIdentity().getName().equals("/domain/domain")) {
                this.domainElementAttributeChecks(delta);
            }
            token = this.setElement((IBasicElement)delta, null);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return this.replaceReferences(token);
    }

    private INextVersionToken replaceReferences(INextVersionToken token) {
        if (token != null) {
            return ((NextVersionToken)token).replaceReferences((IReplaceRef)this.m_logicalNameSpace.createNameReplacer(false));
        }
        return null;
    }

    public void copyFiles(String srcPath, String trgtPath) throws DirectoryServiceException {
        this.trace(1056, "copyFiles from " + srcPath + " to " + trgtPath);
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            ExtendedSonicFSFileSystem fs = new ExtendedSonicFSFileSystem(this, TaskScheduler.getCurrentUserID(), this.m_domainDir);
            fs.copyFiles(srcPath, trgtPath);
            transactOK = true;
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public IDirElement cloneFSBlob(String fromElementName, String toElementName) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "cloneFSBlob from " + fromElementName + " to " + toElementName);
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IDirElement copied = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            copied = this.cloneFSElement(fromElementName, toElementName);
            IAttributeSet topSet = copied.getAttributes();
            Object systemAttrs = topSet.getAttribute("_MF_SYSTEM_ATTRIBUTES");
            Integer blobState = null;
            if (systemAttrs != null) {
                blobState = (Integer)((IAttributeSet)systemAttrs).getAttribute("LARGE_FILE_STATE");
            }
            if (blobState == null || blobState.equals(IBlob.COMPLETE)) {
                String fromStorageName = this.m_logicalNameSpace.storageFromLogical(fromElementName);
                String toStorageName = this.m_logicalNameSpace.storageFromLogical(toElementName);
                EntityName fromEntityName = DirectoryService.validateName(fromStorageName);
                EntityName toEntityName = DirectoryService.validateName(toStorageName);
                this.m_blobStorage.copyBlob(fromEntityName, toEntityName);
            }
            transactOK = true;
        }
        catch (StorageException stE) {
            throw this.convertException(stE);
        }
        catch (Exception otherE) {
            throw new DirectoryServiceException(otherE.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return copied;
    }

    public IDirElement cloneFSElement(String elementName, String newName) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneFSElementInternal(null, elementName, newName, false, null);
    }

    public IDirElement cloneFSElement(IBasicElement delta, String newName) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneFSElementInternal(delta, null, newName, false, null);
    }

    public IDirElement cloneFSElement(String elementName, String newName, boolean createTemplate) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneFSElementInternal(null, elementName, newName, createTemplate, null);
    }

    public IDirElement cloneFSElement(IBasicElement delta, String newName, boolean createTemplate) throws DirectoryServiceException, VersionOutofSyncException {
        return this.cloneFSElementInternal(delta, null, newName, createTemplate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDirElement cloneFSElementInternal(IBasicElement logicalDelta, String oldName, String newName, boolean createTemplate, String storageName0) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "cloneFSElement " + newName);
        this.m_FSInterfaceIsUsed = true;
        if (newName == null) {
            throw new DirectoryServiceException("cloneFSElement: + the name of the new element must not be null.");
        }
        if (logicalDelta == null && oldName == null) {
            throw new DirectoryServiceException("cloneFSElement: + the name or delta of the original element must be passed.");
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IDirElement newElement = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            NameReplacer nameReplacer = this.m_logicalNameSpace.createNameReplacer(true);
            DeltaElement storageDelta = (DeltaElement)logicalDelta;
            String oldStorageName = null;
            String elementType = null;
            if (oldName != null) {
                oldStorageName = this.m_logicalNameSpace.storageFromLogical(oldName);
                try {
                    elementType = ((IElementIdentity)this.m_idCache.get(new EntityName(oldStorageName))).getType();
                }
                catch (ConfigException e) {
                    e.printStackTrace();
                    throw new Error(e.toString());
                }
            } else {
                elementType = logicalDelta.getIdentity().getType();
                oldStorageName = this.m_logicalNameSpace.storageFromLogical(logicalDelta.getIdentity().getName());
                storageDelta = this.createCloneAndReplace(storageDelta, logicalDelta, (IReplaceRef)nameReplacer, oldStorageName);
            }
            String newStorageName = storageName0 != null ? storageName0 : this.assignStorageName(newName, elementType);
            newElement = this.cloneElementInternal((IBasicElement)storageDelta, oldStorageName, newStorageName, createTemplate, null);
            newElement = (IDirElement)((Element)newElement).createClone();
            transactOK = this.configLogicalName(newElement, newStorageName);
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return newElement;
    }

    public void attachFSBlob(IBasicElement element, InputStream blobStream) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        if (blobStream == null) {
            throw new DirectoryServiceException("The blob stream object cannot be null.");
        }
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(element.getIdentity().getName())) != null) {
            this.m_dsHandlers.attachFSBlob(handler, element, blobStream);
            return;
        }
        try {
            BufferedInputStream bStream = new BufferedInputStream(blobStream, 1000000);
            int src = 0;
            int readIn = 0;
            while (readIn != -1) {
                int chunkIndex = 0;
                ByteArrayOutputStream oStream = new ByteArrayOutputStream();
                while (chunkIndex < 1000000 && readIn != -1) {
                    readIn = bStream.read();
                    if (readIn == -1) continue;
                    oStream.write(readIn);
                    ++chunkIndex;
                }
                oStream.close();
                byte[] blobPiece = oStream.toByteArray();
                this.appendFSBlob(element, blobPiece, src, readIn == -1);
                src += blobPiece.length;
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.toString());
        }
    }

    public void attachFSBlob(IBasicElement element, byte[] blob) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(element.getIdentity().getName())) != null) {
            this.m_dsHandlers.attachFSBlob(handler, element, blob);
            return;
        }
        this.attachFSBlobInternal(element, blob, null);
    }

    void attachFSBlobInternal(IBasicElement element0, byte[] blobBytes, String storageName0) throws DirectoryServiceException, VersionOutofSyncException {
        this.attachFSBlobInternal(element0, blobBytes, storageName0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachFSBlobInternal(IBasicElement element0, byte[] blobBytes, String storageName0, ArrayList elementsWithNoStorageRef) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "attachFSBlob " + element0.getIdentity().getName());
        this.m_FSInterfaceIsUsed = true;
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IBasicElement element = element0;
        Object storageName = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            element = this.cloneElementAndConfigStorageName(element, element0, elementsWithNoStorageRef, storageName0);
            this.attachBlob(element, blobBytes, null);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachFSBlobInternal(IBasicElement element0, InputStream blobStream, String storageName0, ArrayList elementsWithNoStorageRef) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        this.trace(1056, "attachFSBlob " + element0.getIdentity().getName());
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(element0.getIdentity().getName())) != null) {
            this.m_dsHandlers.attachFSBlob(handler, element0, blobStream);
            return;
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IBasicElement element = element0;
        Object storageName = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            element = this.cloneElementAndConfigStorageName(element, element0, elementsWithNoStorageRef, storageName0);
            this.attachBlob(element, blobStream, null);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    private IBasicElement cloneElementAndConfigStorageName(IBasicElement elementParam, IBasicElement element0, ArrayList elementsWithNoStorageRef, String storageName0) throws DirectoryServiceException {
        IBasicElement element = elementParam;
        String storageName = null;
        storageName = (element = this.retrieveElement0Clone(element, element0)) instanceof Element ? (storageName0 != null ? storageName0 : this.assignStorageName(element)) : this.m_logicalNameSpace.storageFromLogical(element.getIdentity().getName());
        this.configIdentityNameAsStorageName(element, element0, elementsWithNoStorageRef, storageName);
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendFSBlobInternal(IBasicElement element0, byte[] blobPiece, int offset, String storageName0, ArrayList elementsWithNoStorageRef) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        this.trace(1056, "appendFSBlobInternal " + element0.getIdentity().getName());
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(element0.getIdentity().getName())) != null) {
            this.m_dsHandlers.appendFSBlob(handler, element0, blobPiece, offset, true);
            return;
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IBasicElement element = element0;
        String storageName = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            element = this.retrieveElement0Clone(element, element0);
            String logicalName = element.getIdentity().getName();
            storageName = element instanceof Element && offset == 0 ? (storageName0 != null ? storageName0 : this.assignStorageName(element)) : (storageName0 != null ? storageName0 : this.m_logicalNameSpace.storageFromLogical(logicalName));
            this.configIdentityNameAsStorageName(element, element0, elementsWithNoStorageRef, storageName);
            this.appendBlob(element, blobPiece, offset, true, null);
            if (element instanceof Element && offset != 0) {
                this.m_logicalNameSpace.addViewLink(logicalName, storageName);
            }
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    private void configIdentityNameAsStorageName(IBasicElement element, IBasicElement element0, ArrayList elementsWithNoStorageRef, String storageName) {
        boolean storageOK = ((ICanReplaceRef)element).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(true));
        if (!storageOK && elementsWithNoStorageRef != null) {
            elementsWithNoStorageRef.add(element0.getIdentity().getName());
        }
        ((Identity)element.getIdentity()).setName(storageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendFSBlob(IBasicElement element0, byte[] blob, int offset, boolean last) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1056, "appendFSBlob " + element0.getIdentity().getName());
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(element0.getIdentity().getName())) != null) {
            this.m_dsHandlers.appendFSBlob(handler, element0, blob, offset, last);
            return;
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IBasicElement element = element0;
        String storageName = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            element = this.retrieveElement0Clone(element, element0);
            try {
                storageName = this.m_logicalNameSpace.storageFromLogical(element.getIdentity().getName());
            }
            catch (DirectoryServiceException dirEx) {
                if (element instanceof Element) {
                    storageName = offset != 0 ? this.tempBlobLogicalToStorage(element.getIdentity().getName()) : this.assignStorageName(element, false);
                }
                throw dirEx;
            }
            String logicalName = element.getIdentity().getName();
            ((Identity)element.getIdentity()).setName(storageName);
            if (last) {
                ((ICanReplaceRef)element).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(true));
                if (element instanceof Element) {
                    this.m_logicalNameSpace.addViewLink(logicalName, storageName);
                }
            }
            this.appendBlob(element, blob, offset, last, null);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    private IBasicElement retrieveElement0Clone(IBasicElement elementParam, IBasicElement element0) {
        Object element = elementParam;
        if (this.m_noContainer) {
            element = element instanceof Element ? ((Element)element0).createClone() : ((DeltaElement)element0).createClone();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlob getFSBlob(String elementName, boolean forUpdate, int offset) throws DirectoryServiceException {
        IDSHandler handler;
        this.trace(1024, "getFSBlob " + elementName);
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(elementName)) != null) {
            return this.m_dsHandlers.getFSBlob(handler, elementName, forUpdate, offset);
        }
        DirectoryService.validateName(elementName);
        try {
            this.m_lock.readLock();
            String storageName = null;
            try {
                storageName = this.m_logicalNameSpace.storageFromLogical(elementName);
            }
            catch (Exception e) {
                this.trace(1024, "getFSElement " + elementName + " not found: " + e.toString());
                IBlob iBlob = null;
                this.m_lock.releaseLock();
                return iBlob;
            }
            Blob blob = (Blob)this.getBlob(storageName, forUpdate, offset, elementName);
            IDirElement element = blob.getElement();
            this.validateAndReplaceReferences(element, elementName, storageName);
            blob.setLogical(true);
            this.setLogicalName((IBasicElement)element, this.m_logicalNameSpace.logicalFromStorage(storageName));
            Blob blob2 = blob;
            return blob2;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void validateAndReplaceReferences(IDirElement element, String elementName, String storageName) throws DirectoryServiceException {
        if (element == null) {
            throw new DirectoryServiceException("Could not find element " + elementName + " - storage name " + storageName + " is invalid.");
        }
        ((Element)element).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(false));
    }

    public IBlob getFSBlob(String elementName, boolean forUpdate) throws DirectoryServiceException {
        IDSHandler handler;
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(elementName)) != null) {
            return this.m_dsHandlers.getFSBlob(handler, elementName, forUpdate);
        }
        return this.getFSBlob(elementName, forUpdate, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFSBlob(IDeltaDirElement logicalDelta) throws DirectoryServiceException, VersionOutofSyncException {
        IDSHandler handler;
        this.trace(1056, "detachFSBlob " + logicalDelta.getIdentity().getName());
        this.m_FSInterfaceIsUsed = true;
        if (this.m_dsHandlers != null && (handler = this.m_dsHandlers.getHandler(logicalDelta.getIdentity().getName())) != null) {
            this.m_dsHandlers.detachFSBlob(handler, logicalDelta);
            return;
        }
        IDeltaDirElement delta = this.createClone(logicalDelta);
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            String storageName = this.m_logicalNameSpace.storageFromLogical(logicalDelta.getIdentity().getName());
            ((DeltaElement)delta).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(true));
            ((Identity)delta.getIdentity()).setName(storageName);
            this.detachBlob(delta, null);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    private IDeltaDirElement createClone(IDeltaDirElement logicalDelta) {
        IDeltaDirElement delta = logicalDelta;
        if (this.m_noContainer) {
            delta = ((DeltaElement)logicalDelta).createClone();
        }
        return delta;
    }

    public void repairReferences(String[] exclusions) throws DirectoryServiceException {
        try {
            RepairNoStorageReferences.repairReferences((IDirectoryFileSystemService)this, exclusions);
        }
        catch (Exception e) {
            DirectoryServiceException dse = new DirectoryServiceException("Failed to repair referenaces, see cause");
            dse.initCause((Throwable)e);
            throw dse;
        }
    }

    public IDirElement subclassFSElement(IBasicElement logicalDelta, String newName) throws DirectoryServiceException, VersionOutofSyncException {
        return this.subclassFSElementInternal(logicalDelta, newName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDirElement subclassFSElementInternal(IBasicElement logicalDelta, String newName, String storageName0) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "subclassFSElement " + newName);
        this.m_FSInterfaceIsUsed = true;
        if (newName == null) {
            throw new DirectoryServiceException("subclassFSElement: + the name of the new element must not be null.");
        }
        if (logicalDelta == null) {
            throw new DirectoryServiceException("subclassFSElement: + the template delta must not be null.");
        }
        boolean transactOK = false;
        boolean joinedTransaction = false;
        IDirElement newElement = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            NameReplacer nameReplacer = this.m_logicalNameSpace.createNameReplacer(true);
            DeltaElement storageDelta = (DeltaElement)logicalDelta;
            String oldStorageName = this.m_logicalNameSpace.storageFromLogical(logicalDelta.getIdentity().getName());
            storageDelta = this.createCloneAndReplace(storageDelta, logicalDelta, (IReplaceRef)nameReplacer, oldStorageName);
            String newStorageName = storageName0 != null ? storageName0 : this.assignStorageName(newName, logicalDelta.getIdentity().getType());
            newElement = this.subclassElement((IBasicElement)storageDelta, newStorageName, null);
            newElement = (IDirElement)((Element)newElement).createClone();
            transactOK = this.configLogicalName(newElement, newStorageName);
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return newElement;
    }

    private DeltaElement createCloneAndReplace(DeltaElement storageDeltaParam, IBasicElement logicalDelta, IReplaceRef nameReplacer, String oldStorageName) {
        DeltaElement storageDelta = storageDeltaParam;
        if (this.m_noContainer) {
            storageDelta = ((DeltaElement)logicalDelta).createClone();
        }
        storageDelta.replaceReferences(false, nameReplacer);
        ((Identity)storageDelta.getIdentity()).setName(oldStorageName);
        return storageDelta;
    }

    private boolean configLogicalName(IDirElement newElement, String newStorageName) throws DirectoryServiceException {
        ((Element)newElement).replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(false));
        this.setLogicalName((IBasicElement)newElement, this.m_logicalNameSpace.logicalFromStorage(newStorageName));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubclassFSElement(String elementName) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "unSubclassFSElement " + elementName);
        this.m_FSInterfaceIsUsed = true;
        boolean transactOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            String storageName = this.m_logicalNameSpace.storageFromLogical(elementName);
            this.unSubclassElement(storageName, null);
            transactOK = true;
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
    }

    public IDSTransaction createTransaction() {
        return new DSTransaction();
    }

    public INextVersionToken executeTransaction(IDSTransaction transaction) throws DirectoryServiceException, VersionOutofSyncException {
        return this.executeTransaction(transaction, null);
    }

    @Override
    public INextVersionToken executeTransaction(IDSTransaction transaction, IFrameworkComponentContext context) throws DirectoryServiceException, VersionOutofSyncException {
        this.trace(1056, "executeTransaction start...");
        this.m_FSInterfaceIsUsed = true;
        INextVersionToken token = new ClientTransaction((DSTransaction)transaction, this, context).performActions();
        this.trace(1056, "executeTransaction done");
        return token;
    }

    public IDirElement revertToTemplate(String elementName, AttributeName[] attributes) throws DirectoryServiceException {
        this.trace(1056, "revertToTemplate " + elementName);
        this.m_FSInterfaceIsUsed = true;
        boolean transactOK = false;
        boolean joinedTransaction = false;
        Element sub = null;
        Element newSub = null;
        Element returnSub = null;
        Element subAsIs = null;
        try {
            joinedTransaction = this.startJoinTransaction();
            subAsIs = (Element)this.getElementAsIs(this.m_logicalNameSpace.storageFromLogical(elementName), true);
            String parentName = subAsIs.getSuperElementName();
            if (parentName == null) {
                throw new DirectoryServiceException(elementName + " is not a subclassed element");
            }
            Element parent = (Element)this.getElementAsIs(parentName, true).createWritableClone();
            sub = (Element)this.realizeSubClassedElement(parent, subAsIs.getIdentity(), true);
            parent.revertToTemplate(attributes, sub.getIdentity().getName());
            newSub = (Element)this.realizeSubClassedElement(parent, sub.getIdentity(), true);
            this.setElementInternal((IBasicElement)((IDeltaElement)parent.doneUpdate()), null, null, false);
            this.setElementAsIs(subAsIs.doneUpdate(), null, false);
            returnSub = (Element)this.getElement(sub.getIdentity().getName(), true, true);
            returnSub.replaceReferences(false, (IReplaceRef)this.m_logicalNameSpace.createNameReplacer(false));
            this.setLogicalName((IBasicElement)returnSub, this.m_logicalNameSpace.logicalFromStorage(sub.getIdentity().getName()));
            DeltaElement delta = sub.createDelta(newSub);
            this.notifyMods(new ModificationItem(delta, sub), null);
            transactOK = true;
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactOK);
        }
        return returnSub;
    }

    public String[] listExternalDomainWithManagementSPI() throws DirectoryServiceException {
        IIdentity[] ids = this.listAll("/authentication/domains");
        if (ids == null) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> mfDomainDescriptorList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            Reference ref;
            AttributeName attrName;
            IIdentity id = ids[i];
            String mfDomainDescriptor = id.getName() + '/' + "_MFDomainDescriptor";
            IDirElement element = this.getElement(mfDomainDescriptor, true);
            Boolean b = (Boolean)element.getAttribute(attrName = new AttributeName("EXTERNAL"));
            if (b == null || !b.booleanValue() || (ref = (Reference)element.getAttribute(attrName = new AttributeName("MGMT_SPI"))) == null) continue;
            mfDomainDescriptorList.add(mfDomainDescriptor);
        }
        String[] retVal = new String[mfDomainDescriptorList.size()];
        mfDomainDescriptorList.toArray(retVal);
        return retVal;
    }

    public Boolean reloadExternalAuthenticationDomain(String mfDomainDescriptor) throws DirectoryServiceException {
        try {
            this.trace(1056, "reloadExternalAuthenticationDomain " + mfDomainDescriptor);
            if (mfDomainDescriptor == null || mfDomainDescriptor.trim().length() == 0) {
                return Boolean.FALSE;
            }
            this.validateOpen();
            IDirElement element = this.getElement(mfDomainDescriptor, true);
            AttributeName attrName = new AttributeName("EXTERNAL");
            Boolean isExternalDomain = (Boolean)element.getAttribute(attrName);
            if (isExternalDomain == null || !isExternalDomain.booleanValue()) {
                return Boolean.FALSE;
            }
            attrName = new AttributeName("MGMT_SPI");
            Reference ref = (Reference)element.getAttribute(attrName);
            if (ref == null) {
                return Boolean.FALSE;
            }
            int pos = mfDomainDescriptor.lastIndexOf(47);
            if (pos == -1) {
                return Boolean.FALSE;
            }
            String domainID = mfDomainDescriptor.substring(0, pos);
            String[] domainDescriptors = this.m_authentication.getExternalDomainsDescriptors();
            if (domainDescriptors == null) {
                return Boolean.FALSE;
            }
            if (domainDescriptors.length == 0) {
                Boolean b = this.m_authentication.reloadExternalAuthenticationDomain(domainID);
                return b;
            }
            for (int i = 0; i < domainDescriptors.length; ++i) {
                if (!domainDescriptors[i].equals(mfDomainDescriptor)) continue;
                this.newAuthenticationDescriptor((IElement)element);
                return Boolean.TRUE;
            }
        }
        catch (VersionOutofSyncException e) {
            throw this.printStackTrace((DirectoryServiceException)((Object)e));
        }
        catch (DirectoryServiceException e) {
            throw this.printStackTrace(e);
        }
        catch (Exception e) {
            throw new DirectoryServiceException(e.getMessage());
        }
        return Boolean.FALSE;
    }

    private DirectoryServiceException printStackTrace(DirectoryServiceException e) {
        return e;
    }

    @Override
    public boolean isHandlerPath(String path) throws DirectoryServiceException {
        if (this.m_dsHandlers != null) {
            return this.m_dsHandlers.getHandler(path) != null;
        }
        return false;
    }

    static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (Exception e) {
            return file.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackup(String backupDir, boolean overwrite) throws DirectoryServiceException {
        BackupStatus backupStatus = this.m_backupStatus;
        synchronized (backupStatus) {
            if (this.m_backupStatus.isInProgress()) {
                throw new BackupAlreadyInProgress("Last backup started on " + DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.m_backupStatus.getStartTime())));
            }
            this.m_backupStatus.startBackup(backupDir);
        }
        final String finalBackupDir = backupDir;
        final File domainDir = new File(backupDir);
        final File parentDir = domainDir.getParentFile();
        final String leafDir = domainDir.getName();
        long startTime = this.m_backupStatus.getStartTime();
        try {
            if (parentDir == null) {
                this.failBackup(backupDir, backupDir + " is an invalid backup path. The path must specify the Domain Directory where the DS storage should be placed. Example:  ./Domain1.backup");
                throw new InvalidBackupPath(backupDir + " is an invalid backup path. The path must specify the Domain Directory where the DS storage should be placed. Example:  ./Domain1.backup");
            }
            if (!parentDir.exists()) {
                this.failBackup(backupDir, parentDir.getAbsolutePath() + " does not exist");
                throw new InvalidBackupPath(parentDir.getAbsolutePath() + " does not exist");
            }
            if (domainDir.exists() && new File(domainDir, "data" + PSEStorage.DB_EXTENSION).exists() && !overwrite) {
                this.failBackup(backupDir, backupDir + " exists and overwrite flag is false");
                throw new BackupPathExists(backupDir);
            }
            domainDir.mkdir();
            if (!domainDir.exists()) {
                this.failBackup(backupDir, "Directory Service backup could not find/create the backup domain directory");
                throw new DirectoryServiceException("Directory Service backup could not find/create the backup domain directory");
            }
            try {
                if (domainDir.getCanonicalPath().equals(this.m_domainDir.getCanonicalPath())) {
                    this.failBackup(backupDir, "Cannot backup Directory Service into the original DS directory; please use a different directory");
                    throw new DirectoryServiceException("Cannot backup Directory Service into the original DS directory; please use a different directory");
                }
            }
            catch (IOException ioEx) {
                this.failBackup(backupDir, ioEx.toString());
                throw new DirectoryServiceException("Error while trying to backup Directory Service " + ioEx.toString());
            }
        }
        catch (DirectoryServiceException dirE) {
            throw dirE;
        }
        catch (Exception e) {
            String errorMessage = "Unable to persist last backup state for backup started on " + DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.m_backupStatus.getStartTime())) + " at location " + this.m_backupStatus.getLocation() + ", trace follows...";
            this.logMessage(errorMessage, e, 1);
            throw new DirectoryServiceException(errorMessage);
        }
        Thread backupThread = new Thread(){

            @Override
            public void run() {
                File dataDir = new File(domainDir, "data");
                try {
                    DirectoryService.this.m_storage.backup(DirectoryService.getCanonicalPath(dataDir));
                    DirectoryService.this.updateBackupTimestamp(parentDir.getCanonicalPath(), leafDir);
                    try {
                        DirectoryService.this.finishBackup(finalBackupDir);
                    }
                    catch (Exception e3) {
                        DirectoryService.this.logMessage("Unable to persist backup status data for successful backup started on " + ((SimpleDateFormat)DATE_PARSER_THREAD_LOCAL.get()).format(new Date(DirectoryService.this.m_backupStatus.getStartTime())) + " to location " + finalBackupDir + ", trace follows...", e3, 1);
                    }
                }
                catch (Throwable e) {
                    try {
                        DirectoryService.this.failBackup(finalBackupDir, e);
                    }
                    catch (Throwable e2) {
                        DirectoryService.this.logMessage("Unable to persist backup status data for failed backup started at " + ((SimpleDateFormat)DATE_PARSER_THREAD_LOCAL.get()).format(new Date(DirectoryService.this.m_backupStatus.getStartTime())) + " to location " + finalBackupDir + ", trace follows...", e2, 1);
                    }
                }
            }
        };
        backupThread.setDaemon(true);
        backupThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failBackup(String backupDir, Throwable t) throws StorageException, AttributeSetTypeException, ConfigException, DirectoryServiceException {
        BackupStatus backupStatus = this.m_backupStatus;
        synchronized (backupStatus) {
            this.logMessage("Backup to " + backupDir + " started on " + DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.m_backupStatus.getStartTime())) + " has failed, trace follows...", t, 1);
            this.failBackupAndSaveStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failBackup(String backupDir, String message) throws StorageException, AttributeSetTypeException, ConfigException, DirectoryServiceException {
        BackupStatus backupStatus = this.m_backupStatus;
        synchronized (backupStatus) {
            this.logMessage("Backup to " + backupDir + " started on " + DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.m_backupStatus.getStartTime())) + " has failed: " + message, 1);
            this.failBackupAndSaveStatus();
        }
    }

    private void failBackupAndSaveStatus() throws ConfigException, DirectoryServiceException, StorageException {
        this.m_backupStatus.failBackup();
        IDirElement backupStatus = this.m_storage.getElement(BACKUP_STATUS_ELEMENT_ENTITY_NAME);
        this.saveBackupStatusAttrs(backupStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishBackup(String backupDir) throws StorageException, AttributeSetTypeException, ConfigException, DirectoryServiceException {
        BackupStatus backupStatus = this.m_backupStatus;
        synchronized (backupStatus) {
            this.logMessage("DS online backup started on " + DATE_PARSER_THREAD_LOCAL.get().format(new Date(this.m_backupStatus.getStartTime())) + " to directory " + backupDir + " succeeded", 3);
            this.m_backupStatus.finishBackup();
            IDirElement backupStatus2 = this.m_storage.getElement(BACKUP_STATUS_ELEMENT_ENTITY_NAME);
            this.saveBackupStatusAttrs(backupStatus2);
        }
    }

    private void updateBackupTimestamp(String parentDir, String leafDir) throws DirectoryServiceException {
        PSEStorage backedUpStorage = null;
        File dsDir = new File(parentDir, leafDir);
        String dsDirCanonical = parentDir;
        try {
            dsDirCanonical = dsDir.getCanonicalPath();
            String password = (String)this.m_startup_properties.get("PASSWORD");
            backedUpStorage = password != null && password.length() != 0 ? new PSEStorage(parentDir, leafDir, "data", password, null) : new PSEStorage(parentDir, leafDir, "data", null, null);
            IDirElement backupVersionElement = backedUpStorage.getElement(BACKUP_VERSION_ELEMENT_ENTITY_NAME);
            if (backupVersionElement == null) {
                backupVersionElement = ElementFactory.createElement((String)BACKUP_VERSION_ELEMENT_PATH, (String)BACKUP_VERSION_ELEMENT, (String)"2.0");
            } else {
                ((Element)backupVersionElement).setReadOnly(false);
            }
            IAttributeSet attributes = backupVersionElement.getAttributes();
            attributes.setLongAttribute("BACKUP_VERSION", new Long(System.currentTimeMillis()));
            ((Element)backupVersionElement).setReadOnly(true);
            backedUpStorage.startTransaction();
            backedUpStorage.setElement(BACKUP_VERSION_ELEMENT_ENTITY_NAME, backupVersionElement);
            backedUpStorage.deleteElement(OPEN_ELEMENT_ENTITY_NAME, true);
            backedUpStorage.deleteElement(IDCACHE_ELEMENT_ENTITY_NAME, true);
            if (this.m_idCache != null) {
                backedUpStorage.setElement(IDCACHE_ELEMENT_ENTITY_NAME, IDCache.createEmptyForOnlineBackup(IDCACHE_ELEMENT));
            }
            backedUpStorage.commitTransaction();
        }
        catch (ReadOnlyException readE) {
            throw new Error("Unable to update the backup version element for backup DS in " + dsDirCanonical + ": " + readE.toString());
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to update the backup version element for backup DS in " + dsDirCanonical + ": " + e.toString());
        }
        finally {
            if (backedUpStorage != null) {
                try {
                    backedUpStorage.close();
                }
                catch (Exception e) {
                    throw new DirectoryServiceException("Unable to close the backed up storage after updating the backup timestamp in " + dsDirCanonical);
                }
            }
        }
    }

    public IBackupStatus getBackupStatus() {
        return this.m_backupStatus;
    }

    public IDirElement getDomainElement(boolean forUpdate) throws DirectoryServiceException {
        this.initDomainDirectory();
        return this.getElement("/domain/domain", forUpdate, false);
    }

    private void domainElementAttributeChecks(IDeltaDirElement delta) {
        IDeltaAttributeSet deltaAttributeSet = (IDeltaAttributeSet)delta.getDeltaAttributes();
        String[] attributeNames = deltaAttributeSet.getNewAttributesNames();
        if (attributeNames.length > 0) {
            this.administratorCheckForAttributeNames(attributeNames);
        }
        if ((attributeNames = deltaAttributeSet.getModifiedAttributesNames()).length > 0) {
            this.administratorCheckForAttributeNames(attributeNames);
        }
        if ((attributeNames = deltaAttributeSet.getDeletedAttributesNames()).length > 0) {
            this.administratorCheckForAttributeNames(attributeNames);
        }
    }

    private void administratorCheckForAttributeNames(String[] attributeNames) {
        for (int i = 0; i < attributeNames.length; ++i) {
            this.administratorCheckForAuthenticationDomainAttr(attributeNames, i);
        }
    }

    public void setDomainElement(IDeltaDirElement delta) throws DirectoryServiceException {
        try {
            Object newValue;
            int i;
            boolean dirty = true;
            this.m_lock.writeLock();
            IDeltaAttributeSet deltaAttributeSet = (IDeltaAttributeSet)delta.getDeltaAttributes();
            IDirElement domainElement = this.getElement("/domain/domain", true, false);
            IAttributeSet domainAttributes = domainElement.getAttributes();
            String[] attributeNames = deltaAttributeSet.getNewAttributesNames();
            if (attributeNames.length > 0) {
                for (i = 0; i < attributeNames.length; ++i) {
                    this.administratorCheckForAuthenticationDomainAttr(attributeNames, i);
                    newValue = deltaAttributeSet.getNewValue(attributeNames[i]);
                    if (attributeNames[i].equals("AUTHENTICATION_DOMAIN") && newValue == null || newValue.equals("")) continue;
                    domainAttributes.setObjectAttribute(attributeNames[i], newValue);
                }
                dirty = true;
            }
            if ((attributeNames = deltaAttributeSet.getModifiedAttributesNames()).length > 0) {
                for (i = 0; i < attributeNames.length; ++i) {
                    this.administratorCheckForAuthenticationDomainAttr(attributeNames, i);
                    newValue = deltaAttributeSet.getNewValue(attributeNames[i]);
                    if (attributeNames[i].equals("AUTHENTICATION_DOMAIN") && newValue == null || newValue.equals("")) {
                        domainAttributes.deleteAttribute(attributeNames[i]);
                        continue;
                    }
                    domainAttributes.setObjectAttribute(attributeNames[i], newValue);
                }
                dirty = true;
            }
            if ((attributeNames = deltaAttributeSet.getDeletedAttributesNames()).length > 0) {
                for (i = 0; i < attributeNames.length; ++i) {
                    this.administratorCheckForAuthenticationDomainAttr(attributeNames, i);
                    domainAttributes.deleteAttribute(attributeNames[i]);
                }
                dirty = true;
            }
            if (dirty) {
                this.setElement(domainElement.doneUpdate(), null, true);
            }
        }
        catch (VersionOutofSyncException e) {
            throw new Error(e.toString());
        }
        catch (ConfigException e) {
            throw new Error(e.toString());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void administratorCheckForAuthenticationDomainAttr(String[] attributeNames, int i) {
        if (attributeNames[i].equals("AUTHENTICATION_DOMAIN")) {
            this.administratorCheck();
        }
    }

    private void administratorCheck() {
        if (TaskScheduler.isExecutionThread()) {
            String currentUser = TaskScheduler.getCurrentUserID();
            if (currentUser == null || currentUser.length() == 0) {
                throw new ManagementPermissionDeniedException("No user identity associated with mangement request, check management security settings");
            }
            if (!currentUser.equals("Administrator")) {
                throw new ConfigurePermissionDeniedException("Permission denied (not \"Administrator\"): user identity=" + currentUser, null, 0);
            }
        }
    }

    public IManagementPermission[][] getManagementPermissions(String[] paths, String type) throws DirectoryServiceException {
        return this.getManagementPermissions(paths, type, null, true);
    }

    @Override
    public IManagementPermission[][] getManagementPermissions(String[] paths, String type, IFrameworkComponentContext context, boolean checkPath) throws DirectoryServiceException {
        ManagementPermissionFactory factory = new ManagementPermissionFactory();
        IManagementPermission[][] permissions = new IManagementPermission[paths.length][];
        IDirElement permissionsEl = null;
        try {
            permissionsEl = type.equals("configure") ? this.getElement(CONFIGURE_PERMISSIONS_PATH, false) : this.getElement(MANAGE_PERMISSIONS_PATH, false);
        }
        catch (DirectoryDoesNotExistException e) {
            this.initPermissionsDirectory();
            return this.getManagementPermissions(paths, type, context, checkPath);
        }
        catch (Exception e) {
            DirectoryServiceException dse = new DirectoryServiceException("Unable to get the " + type + " permissions element");
            dse.initCause((Throwable)e);
            throw dse;
        }
        IAttributeSet topSet = permissionsEl.getAttributes();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            ManagementPermission mp = new ManagementPermission(path, type, checkPath);
            if (context != null) {
                mp.getInformationCheck(context);
            }
            String getPermissionsPath = mp.getStoredPath();
            String escapedPath = getPermissionsPath.replaceAll(ROOT_DIRECTORY, "_0x2F_");
            IAttributeSet pathPermissions = (IAttributeSet)topSet.getAttribute(escapedPath = escapedPath.replaceAll(" ", "_0x20_"));
            if (pathPermissions == null) {
                permissions[i] = new IManagementPermission[0];
                continue;
            }
            HashMap allPrincipalPerms = pathPermissions.getAttributes();
            Set principals = allPrincipalPerms.keySet();
            Iterator it = principals.iterator();
            int index = 0;
            IManagementPermission[] permissionArray = new IManagementPermission[principals.size()];
            while (it.hasNext()) {
                String principal = (String)it.next();
                short principalType = 0;
                principalType = context != null && context.getPermissionsManager() != null ? context.getPermissionsManager().getPrincipalType(principal) : this.getPrincipalType(principal);
                IAttributeSet perms = (IAttributeSet)allPrincipalPerms.get(principal);
                String permsVal = (String)perms.getAttribute(PERMISSIONS_VALUE_ATTRIBUTE_NAME);
                Integer scope = new Integer(permsVal.substring(0, permsVal.indexOf(":")));
                Integer princPerms = new Integer(permsVal.substring(permsVal.indexOf(":") + 1));
                IManagementPermission managementPerm = factory.createManagementPermission(principal, principalType, scope.intValue(), princPerms.intValue());
                permissionArray[index++] = managementPerm;
            }
            permissions[i] = permissionArray;
        }
        return permissions;
    }

    private short getPrincipalType(String principal) throws DirectoryServiceException {
        EntityName en;
        IDirElement domainElement = this.getDomainElement(false);
        if (domainElement == null) {
            return 0;
        }
        IAttributeSet topSet = domainElement.getAttributes();
        Reference authDomainRef = (Reference)topSet.getAttribute("AUTHENTICATION_DOMAIN");
        if (authDomainRef == null) {
            return 0;
        }
        String domainElName = authDomainRef.getElementName();
        try {
            en = new EntityName(domainElName);
        }
        catch (ConfigException ce) {
            throw new DirectoryServiceException("Unable to check principal type for " + principal + ": " + ce.toString());
        }
        String parentDir = en.getParent();
        Query findPrincipalQuery = new Query();
        findPrincipalQuery.setFrom((From)new FromDirectory(parentDir + '/' + "_MFUsers"));
        EqualExpression comparison = new EqualExpression(new AttributeName("USER_NAME"), principal);
        Where nameWhere = new Where((BooleanExpression[])new EqualExpression[]{comparison});
        findPrincipalQuery.setWhere(nameWhere);
        IDirElement[] users = this.getElements(findPrincipalQuery, false);
        if (users.length > 0) {
            return 1;
        }
        findPrincipalQuery.setFrom((From)new FromDirectory(parentDir + '/' + "_MFGroups"));
        comparison = new EqualExpression(new AttributeName("GROUP_NAME"), principal);
        nameWhere = new Where((BooleanExpression[])new EqualExpression[]{comparison});
        findPrincipalQuery.setWhere(nameWhere);
        IDirElement[] groups = this.getElements(findPrincipalQuery, false);
        if (groups.length > 0) {
            return 2;
        }
        return 0;
    }

    public void setManagementPermissions(String[] paths, String type, IManagementPermission[][] permissions) throws DirectoryServiceException, InvalidManagementPermissionException {
        this.setManagementPermissions(paths, type, permissions, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setManagementPermissions(String[] paths, String type, IManagementPermission[][] permissions, IFrameworkComponentContext context) throws DirectoryServiceException, InvalidManagementPermissionException {
        this.m_lock.writeLock();
        try {
            this.initPermissionsDirectory();
            if (paths.length != permissions.length) {
                throw new DirectoryServiceException("The number of paths and the number of permission arrays does not match");
            }
            for (int i = 0; i < permissions.length; ++i) {
                for (int j = 0; j < permissions[i].length; ++j) {
                    if (!permissions[i][j].getPrincipal().equals("Administrator")) continue;
                    throw new InvalidManagementPermissionException("Permissions cannot be defined for the user \"Administrator\"");
                }
            }
            IDirElement permissionsEl = null;
            try {
                permissionsEl = this.retrievePermissionElement(type);
            }
            catch (Exception e) {
                throw new DirectoryServiceException("setManagementPermissions: Unable to get " + type + " permissions element: " + e.toString());
            }
            IAttributeSet topSet = permissionsEl.getAttributes();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                try {
                    ManagementPermission mp = new ManagementPermission(path, type, true);
                    this.populatePermissionCheck(context, mp);
                    IManagementPermission[] pathPermissions = permissions[i];
                    String storedPath = mp.getStoredPath();
                    String hierarchicalPath = this.getHierarchicalPath(storedPath);
                    if (hierarchicalPath != null && !hierarchicalPath.equals(storedPath) && !this.isHierarchicalPath(storedPath)) {
                        throw new InvalidManagementPermissionException("Cannot set permissions on subconfigurations of hierarchical configurations: " + storedPath);
                    }
                    String escapedPath = storedPath.replaceAll(ROOT_DIRECTORY, "_0x2F_");
                    escapedPath = escapedPath.replaceAll(" ", "_0x20_");
                    IAttributeSet permissionsSet = this.retrieveAttribute(topSet, escapedPath);
                    for (int j = 0; j < pathPermissions.length; ++j) {
                        IManagementPermission perm = pathPermissions[j];
                        mp.setPermission(perm, permissionsSet, context);
                    }
                    continue;
                }
                catch (InvalidManagementPermissionException invalidPerm) {
                    throw invalidPerm;
                }
                catch (InvalidPathException invalidPath) {
                    throw invalidPath;
                }
                catch (ConfigurePermissionDeniedException denied) {
                    throw denied;
                }
                catch (Exception e) {
                    throw new DirectoryServiceException("Unable to set the " + type + " permissions on path " + path + ": " + e.toString());
                }
            }
            try {
                this.setElement(permissionsEl.doneUpdate(), null);
            }
            catch (Exception e) {
                throw new DirectoryServiceException("Unable to store the modified " + type + " permissions element: " + e.toString());
            }
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void removeManagementPermissions(String[] paths, String type) throws DirectoryServiceException {
        this.removeManagementPermissions(paths, type, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeManagementPermissions(String[] paths, String type, IFrameworkComponentContext context, boolean checkPath) throws DirectoryServiceException {
        this.m_lock.writeLock();
        try {
            boolean dirty = false;
            IDirElement permissionsElement = this.intPermissionAndRetrieveDirElement(type);
            IAttributeSet permissionsAttrs = permissionsElement.getAttributes();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                ManagementPermission permission = new ManagementPermission(path, type, checkPath);
                String storedPath = permission.getStoredPath();
                String escapedPath = storedPath.replaceAll(ROOT_DIRECTORY, "_0x2F_");
                IAttributeSet pathPermissions = (IAttributeSet)permissionsAttrs.getAttribute(escapedPath = escapedPath.replaceAll(" ", "_0x20_"));
                if (pathPermissions == null) continue;
                try {
                    this.populatePermissionCheck(context, permission);
                    permissionsAttrs.deleteAttribute(escapedPath);
                    dirty = true;
                    continue;
                }
                catch (ConfigException configE) {
                    throw new DirectoryServiceException("Unable to remove permissions for path " + path + ": " + configE.toString());
                }
            }
            this.updateElement(dirty, permissionsElement, type);
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void removeManagementPermissions(String[] paths, String type, String[][] principals) throws DirectoryServiceException, InvalidManagementPermissionException {
        this.removeManagementPermissions(paths, type, principals, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeManagementPermissions(String[] paths, String type, String[][] principals, IFrameworkComponentContext context, boolean checkPath) throws DirectoryServiceException, InvalidManagementPermissionException {
        this.m_lock.writeLock();
        try {
            boolean dirty = false;
            IDirElement permissionsElement = this.intPermissionAndRetrieveDirElement(type);
            IAttributeSet permissionsAttrs = permissionsElement.getAttributes();
            for (int i = 0; i < paths.length; ++i) {
                String path = paths[i];
                ManagementPermission permission = new ManagementPermission(path, type, checkPath);
                this.populatePermissionCheck(context, permission);
                String storedPath = permission.getStoredPath();
                String escapedPath = storedPath.replaceAll(ROOT_DIRECTORY, "_0x2F_");
                escapedPath = escapedPath.replaceAll(" ", "_0x20_");
                IAttributeSet pathPermissions = (IAttributeSet)permissionsAttrs.getAttribute(escapedPath);
                if (pathPermissions != null) {
                    String[] toRemove = principals[i];
                    if (toRemove != null) {
                        for (int j = 0; j < toRemove.length; ++j) {
                            String principal = toRemove[j];
                            try {
                                permission.deletePermission(principal, pathPermissions);
                                dirty = true;
                                continue;
                            }
                            catch (ConfigException configE) {
                                throw new DirectoryServiceException("Unable to remove permissions for path " + path + " and principal " + principal + ": " + configE.toString());
                            }
                        }
                    }
                    if (pathPermissions.getAttributes().size() != 0) continue;
                    try {
                        permissionsAttrs.deleteAttribute(escapedPath);
                        dirty = true;
                        continue;
                    }
                    catch (ConfigException configE) {
                        throw new DirectoryServiceException("Unable to remove permissions for path " + path + ": " + configE.toString());
                    }
                }
                throw new InvalidPathException("Path " + path + " has no " + type + " permissions set");
            }
            this.updateElement(dirty, permissionsElement, type);
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private IDirElement intPermissionAndRetrieveDirElement(String type) throws DirectoryServiceException {
        this.initPermissionsDirectory();
        IDirElement permissionsElement = null;
        try {
            permissionsElement = this.retrievePermissionElement(type);
        }
        catch (Exception getE) {
            throw new DirectoryServiceException("removeManagementPermissions: Unable to get " + type + " permissions element: " + getE.toString());
        }
        return permissionsElement;
    }

    private void updateElement(boolean dirty, IDirElement permissionsElement, String type) throws DirectoryServiceException {
        try {
            if (dirty) {
                this.setElement(permissionsElement.doneUpdate(), null);
            }
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to set the modified " + type + " permissions element: " + e.toString());
        }
    }

    private IDirElement retrievePermissionElement(String type) throws DirectoryServiceException {
        IDirElement permissionsElement = null;
        permissionsElement = type.equals("configure") ? this.getElement(CONFIGURE_PERMISSIONS_PATH, true) : this.getElement(MANAGE_PERMISSIONS_PATH, true);
        return permissionsElement;
    }

    private void populatePermissionCheck(IFrameworkComponentContext context, ManagementPermission permission) {
        if (context != null) {
            permission.setPermissionsCheck(context);
        }
    }

    private void movePermissions(String oldPath, String newPath, int pathType) throws DirectoryServiceException, InvalidManagementPermissionException {
        if (this.isPermissionsCheckingEnabled()) {
            boolean isFolder;
            String oldPermissionsPath = oldPath;
            String newPermissionsPath = newPath;
            boolean bl = isFolder = pathType == 1;
            if (isFolder) {
                if (!oldPath.endsWith(ROOT_DIRECTORY)) {
                    oldPermissionsPath = oldPath + ROOT_DIRECTORY;
                }
                if (!newPath.endsWith(ROOT_DIRECTORY)) {
                    newPermissionsPath = newPath + ROOT_DIRECTORY;
                }
            }
            IManagementPermission[][] configurePerms = this.getManagementPermissions(new String[]{oldPermissionsPath}, "configure", null, false);
            IManagementPermission[][] managePerms = this.getManagementPermissions(new String[]{oldPermissionsPath}, "manage", null, false);
            this.populateManagementPermissions(configurePerms, newPermissionsPath);
            if (managePerms[0].length > 0) {
                this.setManagementPermissions(new String[]{newPermissionsPath}, "manage", managePerms);
            }
            this.removeManagementPermissions(new String[]{oldPermissionsPath}, "configure", null, false);
            this.removeManagementPermissions(new String[]{oldPermissionsPath}, "manage", null, false);
        }
    }

    void copyConfigurePermissions(String srcPath, String trgtPath, int pathType) throws DirectoryServiceException, InvalidManagementPermissionException {
        boolean isFsrcer;
        String srcPermissionsPath = srcPath;
        String trgtPermissionsPath = trgtPath;
        boolean bl = isFsrcer = pathType == 1;
        if (isFsrcer) {
            if (!srcPath.endsWith(ROOT_DIRECTORY)) {
                srcPermissionsPath = srcPath + ROOT_DIRECTORY;
            }
            if (!trgtPath.endsWith(ROOT_DIRECTORY)) {
                trgtPermissionsPath = trgtPath + ROOT_DIRECTORY;
            }
        }
        IManagementPermission[][] configurePerms = this.getManagementPermissions(new String[]{srcPermissionsPath}, "configure", null, false);
        this.populateManagementPermissions(configurePerms, trgtPermissionsPath);
    }

    private void populateManagementPermissions(IManagementPermission[][] configurePerms, String trgtPermissionsPath) throws DirectoryServiceException, InvalidManagementPermissionException {
        if (configurePerms[0].length > 0) {
            this.setManagementPermissions(new String[]{trgtPermissionsPath}, "configure", configurePerms);
        }
    }

    public void removeAllManagementPermissions() throws DirectoryServiceException {
        this.administratorCheck();
        this.initPermissionsDirectory();
        boolean transactionOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            IDirElement permissions = this.getElement(MANAGE_PERMISSIONS_PATH, true);
            IAttributeSet topSet = permissions.getAttributes();
            HashMap attrs = topSet.getAttributes();
            Set keys = attrs.keySet();
            Iterator keysIT = keys.iterator();
            while (keysIT.hasNext()) {
                topSet.deleteAttribute((String)keysIT.next());
            }
            this.setElement(permissions.doneUpdate(), null);
            permissions = this.getElement(CONFIGURE_PERMISSIONS_PATH, true);
            topSet = permissions.getAttributes();
            attrs = topSet.getAttributes();
            keys = attrs.keySet();
            keysIT = keys.iterator();
            while (keysIT.hasNext()) {
                topSet.deleteAttribute((String)keysIT.next());
            }
            this.setElement(permissions.doneUpdate(), null);
            transactionOK = true;
        }
        catch (Exception storeE) {
            throw new DirectoryServiceException("Unable to remove all permissions: " + storeE.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactionOK);
        }
    }

    public void setDefaultManagementPermissions() throws DirectoryServiceException {
        this.administratorCheck();
        this.initPermissionsDirectory();
        boolean transactionOK = false;
        boolean joinedTransaction = false;
        try {
            joinedTransaction = this.startJoinTransaction();
            IDirElement permissions = this.getElement(MANAGE_PERMISSIONS_PATH, true);
            IAttributeSet topSet = permissions.getAttributes();
            String escapedPath = ROOT_DIRECTORY.replaceAll(ROOT_DIRECTORY, "_0x2F_");
            escapedPath = escapedPath.replaceAll(" ", "_0x20_");
            IAttributeSet rootManagePath = this.retrieveAttribute(topSet, escapedPath);
            IAttributeSet adminPerm = (IAttributeSet)rootManagePath.getAttribute(GLOBAL_PERMISSIONS_GROUP_NAME);
            if (adminPerm != null) {
                rootManagePath.deleteAttribute(GLOBAL_PERMISSIONS_GROUP_NAME);
            }
            adminPerm = rootManagePath.createAttributeSet(GLOBAL_PERMISSIONS_GROUP_NAME);
            int adminManageScope = 21;
            int adminManagePerms = 1365;
            adminPerm.setStringAttribute(PERMISSIONS_VALUE_ATTRIBUTE_NAME, new String(adminManageScope + ":" + adminManagePerms));
            this.setElement(permissions.doneUpdate(), null);
            permissions = this.getElement(CONFIGURE_PERMISSIONS_PATH, true);
            topSet = permissions.getAttributes();
            rootManagePath = (IAttributeSet)topSet.getAttribute(escapedPath);
            if (rootManagePath == null) {
                rootManagePath = topSet.createAttributeSet(escapedPath);
            }
            if ((adminPerm = (IAttributeSet)rootManagePath.getAttribute(GLOBAL_PERMISSIONS_GROUP_NAME)) != null) {
                rootManagePath.deleteAttribute(GLOBAL_PERMISSIONS_GROUP_NAME);
            }
            adminPerm = rootManagePath.createAttributeSet(GLOBAL_PERMISSIONS_GROUP_NAME);
            int adminConfigurePerm = 85;
            int adminConfigureScope = 11;
            adminPerm.setStringAttribute(PERMISSIONS_VALUE_ATTRIBUTE_NAME, new String(adminConfigureScope + ":" + adminConfigurePerm));
            this.setElement(permissions.doneUpdate(), null);
            transactionOK = true;
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to add default management permissions: " + e.toString());
        }
        finally {
            this.leaveTransactionAndReleaseLock(joinedTransaction, transactionOK);
        }
    }

    private IAttributeSet retrieveAttribute(IAttributeSet topSet, String escapedPath) throws ConfigException {
        IAttributeSet rootManagePath = (IAttributeSet)topSet.getAttribute(escapedPath);
        if (rootManagePath == null) {
            rootManagePath = topSet.createAttributeSet(escapedPath);
        }
        return rootManagePath;
    }

    private boolean startJoinTransaction() throws DirectoryServiceException {
        this.m_lock.writeLock();
        this.m_trManager.join();
        return true;
    }

    private void initDomainDirectory() throws DirectoryServiceException {
        try {
            this.validateAndCreateDirectory(DOMAIN_PATH_ENTITY_NAME, DOMAIN_PATH);
            IDirElement domain = this.m_storage.getElement(DOMAIN_ELEMENT_ENTITY_NAME);
            if (domain == null) {
                domain = ElementFactory.createElement((String)"/domain/domain", (String)"1.0", (String)"MF_DOMAIN");
                IAttributeSet domainAttributes = domain.getAttributes();
                domainAttributes.setBooleanAttribute("AUDIT_CONFIGURE_EVENTS", Boolean.FALSE);
                domainAttributes.setBooleanAttribute("AUDIT_MANAGE_EVENTS", Boolean.FALSE);
                domainAttributes.setBooleanAttribute("ENABLE_CENTRALIZED_AUDIT", Boolean.FALSE);
                domainAttributes.setStringAttribute("DEFAULT_MANAGEMENT_AUDIT_CONFIG", "sonicfs:///Security/DefaultAuditDestinations.xml");
                this.setElement(domain.doneUpdate(), null);
            }
        }
        catch (AttributeSetTypeException e) {
            throw new Error(e.toString());
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
        catch (ConfigException e) {
            throw new Error(e.toString());
        }
    }

    private void initPermissionsDirectory() throws DirectoryServiceException {
        try {
            this.validateAndCreateDirectory(PERMISSIONS_PATH_ENTITY_NAME, PERMISSIONS_PATH);
            IDirElement permissions = this.m_storage.getElement(MANAGE_PERMISSIONS_ELEMENT_ENTITY_NAME);
            if (permissions == null) {
                permissions = ElementFactory.createElement((String)MANAGE_PERMISSIONS_PATH, (String)"MF_MANAGEMENT_PERMISSIONS", (String)"1.0");
                this.setElement(permissions.doneUpdate(), null);
            }
            if ((permissions = this.m_storage.getElement(CONFIGURE_PERMISSIONS_ELEMENT_ENTITY_NAME)) == null) {
                permissions = ElementFactory.createElement((String)CONFIGURE_PERMISSIONS_PATH, (String)"MF_MANAGEMENT_PERMISSIONS", (String)"1.0");
                this.setElement(permissions.doneUpdate(), null);
            }
            this.initDomainDirectory();
        }
        catch (StorageException e) {
            throw this.convertException(e);
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
    }

    private void validateAndCreateDirectory(EntityName PERMISSIONS_PATH_ENTITY_NAME, String PERMISSIONS_PATH) throws DirectoryServiceException {
        if (!this.m_storage.directoryExists(PERMISSIONS_PATH_ENTITY_NAME)) {
            this.createDirectory(PERMISSIONS_PATH);
        }
    }

    private IStorage getSystemStorage() {
        return this.m_systemStorage;
    }

    private void saveBackupStatusAttrs(IDirElement backupStatus) throws AttributeSetTypeException, ConfigException, StorageException, DirectoryServiceException {
        ((Element)backupStatus).setReadOnly(false);
        IAttributeSet topSet = backupStatus.getAttributes();
        topSet.setStringAttribute("LOCATION", this.m_backupStatus.getLocation());
        topSet.setLongAttribute("START_TIME", new Long(this.m_backupStatus.getStartTime()));
        topSet.setLongAttribute("COMPLETION_TIME", new Long(this.m_backupStatus.getCompletionTime()));
        try {
            this.m_lock.writeLock();
            this.mStorageStartTransaction();
            ((Element)backupStatus).setReadOnly(true);
            this.m_storage.setElement(BACKUP_STATUS_ELEMENT_ENTITY_NAME, backupStatus);
            this.mStorageCommitTransaction();
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void mStorageStartTransaction() throws StorageException {
        if (this.m_usePSE_STORAGE) {
            this.m_storage.startTransaction();
        }
    }

    private void mStorageCommitTransaction() throws StorageException {
        if (this.m_usePSE_STORAGE) {
            this.m_storage.commitTransaction();
        }
    }

    private void readBackupStatusAttrs(IDirElement backupStatus) {
        IAttributeSet topSet = backupStatus.getAttributes();
        this.m_backupStatus.setCompletionTime((Long)topSet.getAttribute("COMPLETION_TIME"));
        this.m_backupStatus.setStartTime((Long)topSet.getAttribute("START_TIME"));
        this.m_backupStatus.setLocation((String)topSet.getAttribute("LOCATION"));
    }

    @Override
    public int getNameSpaceType(String path) {
        return this.m_logicalNameSpace.getNameSpaceType(path);
    }

    @Override
    public boolean isPermissionsCheckingEnabled() throws DirectoryServiceException {
        IDirElement domainEl = null;
        try {
            domainEl = this.getElement("/domain/domain", false, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (domainEl != null) {
            IAttributeSet topset = domainEl.getAttributes();
            Reference authDomainRef = (Reference)topset.getAttribute("AUTHENTICATION_DOMAIN");
            return authDomainRef != null && authDomainRef.getElementName() != null && authDomainRef.getElementName().length() > 0;
        }
        return false;
    }

    @Override
    public String getPermissionsPath(String path) throws DirectoryServiceException {
        try {
            String hierarchicalPath = this.getHierarchicalPath(path);
            if (hierarchicalPath == null) {
                return path;
            }
            return hierarchicalPath;
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to verify permissions for " + path + ": " + e.toString());
        }
    }

    public String getHierarchicalPath(String path, ArrayList choices) throws DirectoryServiceException {
        try {
            if (path.length() == 0) {
                return null;
            }
            if (this.isPathInChoices(path, choices)) {
                return path;
            }
            EntityName eName = new EntityName(path);
            String[] nameComponents = eName.getNameComponents();
            String parentPath = null;
            EntityName parentEName = null;
            for (int length = 1; length <= nameComponents.length; ++length) {
                parentEName = new EntityName(nameComponents, length);
                parentPath = parentEName.toString();
                if (!this.isPathInChoices(parentPath, choices)) continue;
                return parentPath;
            }
            return null;
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to determine hierarchical path for " + path + ": " + e.toString());
        }
    }

    @Override
    public String getHierarchicalPath(String path) throws DirectoryServiceException {
        try {
            if (path.length() == 0) {
                return null;
            }
            EntityName eName = new EntityName(path);
            String[] nameComponents = eName.getNameComponents();
            String parentPath = null;
            EntityName parentEName = null;
            for (int length = 1; length <= nameComponents.length; ++length) {
                parentEName = new EntityName(nameComponents, length);
                parentPath = parentEName.toString();
                if (!this.isHierarchicalPath(parentPath)) continue;
                return parentPath;
            }
            return null;
        }
        catch (DirectoryServiceException dirE) {
            throw dirE;
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to determine hierarchical path for " + path + ": " + e.toString());
        }
    }

    public boolean isHierarchicalConfig(String version, String type) {
        if (this.m_hierarchicalTypes != null) {
            String hierarchicalType = (String)this.m_hierarchicalTypes.get("/mx/hierarchicalTypes/" + version + '/' + type);
            return hierarchicalType != null;
        }
        return false;
    }

    public boolean isPathInChoices(String path, ArrayList choices) {
        if (choices != null) {
            for (int i = 0; i < choices.size(); ++i) {
                if (!path.equals((String)choices.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isHierarchicalPath(String path) throws DirectoryServiceException {
        try {
            int versionIndex;
            int typeIndex;
            HashMap metaAttrs = this.getMetaAttributes(path);
            ElementIdentity id = null;
            if (metaAttrs == null) {
                return false;
            }
            String toolAttrs = (String)metaAttrs.get("TOOL_ATTRIBUTES");
            if (toolAttrs == null) {
                id = (ElementIdentity)metaAttrs.get("_ELEMENT_IDENTITY");
                if (id == null) {
                    return false;
                }
                toolAttrs = "TYPE=" + id.getType() + ";CONFIG_VERSION=" + id.getReleaseVersion();
            }
            if ((typeIndex = toolAttrs.indexOf("TYPE=")) == -1) {
                return false;
            }
            String type = toolAttrs.substring(typeIndex + 5);
            if (type == null) {
                return false;
            }
            int endOfType = type.indexOf(";");
            if (endOfType != -1) {
                type = type.substring(0, endOfType);
            }
            if ((versionIndex = toolAttrs.indexOf("CONFIG_VERSION=")) == -1) {
                return false;
            }
            String version = toolAttrs.substring(versionIndex + 15);
            if (version == null) {
                return false;
            }
            int endOfVersion = version.indexOf(";");
            if (endOfVersion != -1) {
                version = version.substring(0, endOfVersion);
            }
            return this.isHierarchicalConfig(version, type);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to get the type and version from the meta attributes of " + path + ": " + e.toString());
        }
    }

    private void removePermissions(String path) throws DirectoryServiceException {
        if (this.isPermissionsCheckingEnabled()) {
            boolean isFolder = this.getNameSpaceType(path) == 1;
            String pathToRemove = isFolder ? path + ROOT_DIRECTORY : path;
            this.removeManagementPermissions(new String[]{pathToRemove}, "configure", null, false);
            this.removeManagementPermissions(new String[]{pathToRemove}, "manage", null, false);
        }
    }

    @Override
    public void setHierarchicalTypes(HashMap map) {
        this.m_hierarchicalTypes = map;
    }

    private void createSuspendNotificationsElement() throws DirectoryServiceException {
        try {
            IDirElement suspendEl = this.m_storage.getElement(SUSPEND_NOTIFICATIONS_ENTITY_NAME);
            if (suspendEl != null) {
                return;
            }
            this.m_lock.writeLock();
            this.trace(16, "Creating the initial suspend notifications element");
            suspendEl = ElementFactory.createElement((String)SUSPEND_NOTIFICATIONS_ELEMENT_PATH, (String)"suspend_notifications", (String)MF_CONFING_VERSION);
            this.m_storage.startTransaction();
            this.m_storage.setElement(SUSPEND_NOTIFICATIONS_ENTITY_NAME, (IDirElement)suspendEl.doneUpdate());
            this.m_storage.commitTransaction();
        }
        catch (ReadOnlyException e) {
            throw new Error(e.toString());
        }
        catch (ConfigException e) {
            throw new Error(e.toString());
        }
        catch (StorageException storeE) {
            DirectoryServiceException dirE = new DirectoryServiceException("Unable to create /_MFSystem/suspend_notifications");
            dirE.initCause((Throwable)storeE);
            throw dirE;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public void suspendChangeNotifications(String targetContainerPath, String[] allowTypesParam) throws DirectoryServiceException {
        String[] allowTypes = allowTypesParam;
        this.validateOpen();
        this.trace(256, "suspendChangeNotifications " + targetContainerPath);
        try {
            this.m_lock.writeLock();
            if (targetContainerPath == null) {
                throw new DirectoryServiceException("Container path cannot be null in suspendChangeNotifications");
            }
            String containerName = targetContainerPath.substring(targetContainerPath.lastIndexOf(47) + 1);
            this.createSuspendNotificationsElement();
            IDirElement suspendEl = this.m_storage.getElement(SUSPEND_NOTIFICATIONS_ENTITY_NAME);
            IAttributeSet atts = DirectoryService.deleteAttributeContainerName(containerName, suspendEl);
            if (allowTypes == null) {
                allowTypes = new String[]{};
            }
            IAttributeList containerList = atts.createAttributeList(containerName);
            for (int i = 0; i < allowTypes.length; ++i) {
                containerList.addStringItem(allowTypes[i]);
            }
            this.mStorageSuspendElTransaction(suspendEl);
            this.m_suspendNotifications.put(containerName, allowTypes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private void initSuspendNotifications() throws DirectoryServiceException, StorageException {
        this.m_suspendNotifications = new HashMap();
        IDirElement suspendEl = this.m_storage.getElement(SUSPEND_NOTIFICATIONS_ENTITY_NAME);
        if (suspendEl != null) {
            IAttributeSet topSet = suspendEl.getAttributes();
            HashMap attrMap = topSet.getAttributes();
            Set attrKeys = attrMap.keySet();
            for (String containerName : attrKeys) {
                IAttributeList allowAList = (IAttributeList)topSet.getAttribute(containerName);
                ArrayList allowList = allowAList.getItems();
                String[] allowArray = new String[allowList.size()];
                allowList.toArray(allowArray);
                this.m_suspendNotifications.put(containerName, allowArray);
            }
        }
    }

    @Override
    public boolean areNotificationsSuspended(String containerRuntimeID) {
        boolean suspended;
        String containerName = containerRuntimeID.substring(containerRuntimeID.indexOf(".") + 1);
        boolean bl = suspended = this.m_suspendNotifications.get(containerName) != null;
        if ((this.m_traceMask & 1) > 0) {
            this.trace(256, "DirectoryService.areNotificationsSuspended returning " + suspended + " for container ID " + containerRuntimeID);
        }
        return suspended;
    }

    @Override
    public void resumeChangeNotifications(String containerPath) throws DirectoryServiceException {
        String containerName = null;
        this.validateOpen();
        this.trace(256, "DirectoryService.resumeChangeNotifications " + containerPath);
        try {
            this.m_lock.writeLock();
            if (containerPath == null) {
                throw new DirectoryServiceException("Container path cannot be null in resumeChangeNotifications");
            }
            containerName = containerPath.substring(containerPath.indexOf(46) + 1);
            IDirElement suspendEl = this.m_storage.getElement(SUSPEND_NOTIFICATIONS_ENTITY_NAME);
            if (suspendEl == null) {
                this.logMessage("Notifications were never suspended for container " + containerPath, 2);
                return;
            }
            IAttributeSet atts = DirectoryService.deleteAttributeContainerName(containerName, suspendEl);
            this.mStorageSuspendElTransaction(suspendEl);
            this.m_suspendNotifications.remove(containerName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private static IAttributeSet deleteAttributeContainerName(String containerName, IDirElement suspendEl) throws ConfigException {
        ((Element)suspendEl).setReadOnly(false);
        IAttributeSet atts = suspendEl.getAttributes();
        if (atts.getAttribute(containerName) != null) {
            atts.deleteAttribute(containerName);
        }
        return atts;
    }

    private void mStorageSuspendElTransaction(IDirElement suspendEl) throws StorageException {
        this.m_storage.startTransaction();
        this.m_storage.setElement(SUSPEND_NOTIFICATIONS_ENTITY_NAME, suspendEl);
        this.m_storage.commitTransaction();
    }

    public void resumeAllChangeNotifications() throws DirectoryServiceException {
        this.validateOpen();
        this.trace(256, "DirectoryService.resumeAllChangeNotifications ");
        try {
            this.m_lock.writeLock();
            this.m_storage.startTransaction();
            this.m_storage.deleteElement(SUSPEND_NOTIFICATIONS_ENTITY_NAME);
            this.m_storage.commitTransaction();
            this.m_suspendNotifications = new HashMap();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DirectoryServiceException(e.toString());
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private static void quickSortElements(IDirElement[] els, ElementComparator<IDirElement> c) {
        if (els == null || els.length == 0) {
            return;
        }
        DirectoryService.quicksort(els, 0, els.length - 1, c);
    }

    static void quicksort(IDirElement[] a, int low, int high, ElementComparator<IDirElement> c) {
        int i = low;
        int j = high;
        IDirElement pivot = a[low + (high - low) / 2];
        while (i <= j) {
            while (c.compare((Object)a[i], (Object)pivot) < 0) {
                ++i;
            }
            while (c.compare((Object)a[j], (Object)pivot) > 0) {
                --j;
            }
            if (i > j) continue;
            DirectoryService.exchange(a, i, j);
            ++i;
            --j;
        }
        if (low < j) {
            DirectoryService.quicksort(a, low, j, c);
        }
        if (i < high) {
            DirectoryService.quicksort(a, i, high, c);
        }
    }

    private static void exchange(IDirElement[] a, int i, int j) {
        IDirElement temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlob getFiles(String path, boolean recurse, String extension) throws DirectoryServiceException {
        this.trace(1024, "getFiles ");
        this.m_FSInterfaceIsUsed = true;
        try {
            this.m_lock.readLock();
            ArrayList<HashMap> filesToGet = this.recursiveList(path, false, true, extension);
            String[] fileNames = new String[filesToGet.size()];
            int arrayIndex = 0;
            for (HashMap map : filesToGet) {
                fileNames[arrayIndex++] = ((IElementIdentity)map.get("_ELEMENT_IDENTITY")).getName();
            }
            IBlob iBlob = this.getFiles(fileNames);
            return iBlob;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IBlob getFiles(String[] fileElementNames) throws DirectoryServiceException {
        this.trace(1024, "getFiles ");
        this.m_FSInterfaceIsUsed = true;
        try {
            this.m_lock.readLock();
            IBlob iBlob = this.zipFiles(fileElementNames);
            return iBlob;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    public IBlob zipFiles(String[] fileElementNames) throws DirectoryServiceException {
        if (fileElementNames == null || fileElementNames.length == 0) {
            return null;
        }
        String baseName = this.generateZipFileName();
        File zipFile = new File(this.m_blobCopiesDir, baseName);
        String zipFileName = null;
        FileOutputStream zipFileStream = null;
        ZipOutputStream zipOutStream = null;
        Object zipFileBlob = null;
        boolean hasEntries = false;
        try {
            zipFileName = zipFile.getCanonicalPath();
            zipFileStream = new FileOutputStream(zipFile);
            zipOutStream = new ZipOutputStream(zipFileStream);
            for (String elementName : fileElementNames) {
                int bytesRead;
                IBlob blob = this.getFSBlob(elementName, false, 0);
                if (blob == null) continue;
                zipOutStream.putNextEntry(new ZipEntry(elementName));
                InputStream blobStream = blob.getBlobStream();
                byte[] bytes = new byte[4096];
                while ((bytesRead = blobStream.read(bytes)) >= 1) {
                    zipOutStream.write(bytes, 0, bytesRead);
                }
                blobStream.close();
                zipOutStream.closeEntry();
                hasEntries = true;
            }
            if (hasEntries) {
                zipOutStream.close();
                String blobName = DiskFileDSHandler.getHandlerName() + '/' + baseName;
                return this.getFSBlob(blobName, false, 0);
            }
            zipFileStream.close();
            if (zipFile.exists()) {
                zipFile.delete();
            }
            return null;
        }
        catch (Exception ex) {
            DirectoryServiceException dirE = new DirectoryServiceException("Unable to save zip file " + zipFileName);
            dirE.initCause((Throwable)ex);
            throw dirE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<HashMap> recursiveList(String path, boolean getFolders, boolean getElements, String extension) throws DirectoryServiceException {
        this.trace(1024, "recursiveList " + path);
        this.m_FSInterfaceIsUsed = true;
        try {
            this.m_lock.readLock();
            ArrayList<HashMap> recursiveResult = new ArrayList<HashMap>();
            HashMap pathAttributes = this.getMetaAttributes(path);
            if (pathAttributes.get("_FOLDER_NAME") == null) {
                throw new DirectoryServiceException(path + " is not a folder name");
            }
            recursiveResult.add(pathAttributes);
            ArrayList<HashMap> localResult = this.listFSAll(path, getFolders, true, extension);
            for (HashMap childMap : localResult) {
                String folderName = (String)childMap.get("_FOLDER_NAME");
                IElementIdentity elementID = (IElementIdentity)childMap.get("_ELEMENT_IDENTITY");
                if (folderName != null) {
                    recursiveResult.addAll(this.recursiveList(folderName, getFolders, getElements, extension));
                    continue;
                }
                recursiveResult.add(childMap);
            }
            ArrayList<HashMap> arrayList = recursiveResult;
            return arrayList;
        }
        finally {
            this.m_lock.releaseLock();
        }
    }

    private synchronized String generateZipFileName() {
        if (this.m_zipFileCounter + 1 == Integer.MAX_VALUE) {
            this.m_zipFileCounter = 0;
        }
        return "filesZipFile_" + System.currentTimeMillis() + "_" + this.m_zipFileCounter++;
    }

    static {
        try {
            VIEW_ELEMENT_ENTITY_NAME = new EntityName(VIEW_ELEMENT);
            SYSTEM_DIRECTORY_PATH_ENTITY_NAME = new EntityName(SYSTEM_DIRECTORY_PATH);
            LOCK_ELEMENT_ENTITY_NAME = new EntityName(LOCK_ELEMENT_PATH);
            BACKUP_ELEMENT_ENTITY_NAME = new EntityName(BACKUP_ELEMENT_PATH);
            OPEN_ELEMENT_ENTITY_NAME = new EntityName(OPEN_ELEMENT_PATH);
            VERSION_ELEMENT_ENTITY_NAME = new EntityName(VERSION_ELEMENT_PATH);
            IDCACHE_ELEMENT_ENTITY_NAME = new EntityName(IDCACHE_ELEMENT);
            SUBSCRIBERS_ELEMENT_ENTITY_NAME = new EntityName(SUBSCRIBERS_ELEMENT_PATH);
            BACKUP_VERSION_ELEMENT_ENTITY_NAME = new EntityName(BACKUP_VERSION_ELEMENT_PATH);
            BACKUP_STATUS_ELEMENT_ENTITY_NAME = new EntityName(BACKUP_STATUS_ELEMENT_PATH);
            DOMAIN_PATH_ENTITY_NAME = new EntityName(DOMAIN_PATH);
            DOMAIN_ELEMENT_ENTITY_NAME = new EntityName("/domain/domain");
            PERMISSIONS_PATH_ENTITY_NAME = new EntityName(PERMISSIONS_PATH);
            MANAGE_PERMISSIONS_ELEMENT_ENTITY_NAME = new EntityName(MANAGE_PERMISSIONS_PATH);
            CONFIGURE_PERMISSIONS_ELEMENT_ENTITY_NAME = new EntityName(CONFIGURE_PERMISSIONS_PATH);
            SUSPEND_NOTIFICATIONS_ENTITY_NAME = new EntityName(SUSPEND_NOTIFICATIONS_ELEMENT_PATH);
        }
        catch (ConfigException e) {
            e.printStackTrace();
            throw new Error(e.toString());
        }
        DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yy/MM/dd HH:mm:ss");
            }
        };
        m_URLHandlerFactory = null;
        LOCK_OBJ = new Object();
    }

    private final class NotificationManager
    implements IModificationManager {
        private GroupArrayList m_notificationList;
        private boolean m_throwAway;
        private NotificationConsumer m_consumer;
        private DirectoryService m_ds;
        private HashMap m_newIdsTable;
        private boolean m_inDeleteTriggers;
        private boolean m_hasDelete;
        private boolean m_hasUpdate;
        private boolean m_hasAdded;

        NotificationManager(DirectoryService ds) {
            this.m_ds = ds;
            this.m_notificationList = new GroupArrayList();
            this.m_throwAway = false;
            this.m_consumer = null;
            this.m_newIdsTable = null;
            this.m_inDeleteTriggers = false;
            this.m_hasDelete = false;
            this.m_hasUpdate = false;
            this.m_hasAdded = false;
        }

        boolean rememberNewIds() {
            if (this.m_newIdsTable != null) {
                return false;
            }
            this.m_newIdsTable = new HashMap();
            return true;
        }

        HashMap getAndResetNewIds() {
            HashMap result = this.m_newIdsTable;
            this.m_newIdsTable = null;
            return result;
        }

        void setConsumer(NotificationConsumer consumer) {
            this.m_consumer = consumer;
        }

        boolean hasConsumer() {
            return this.m_consumer != null;
        }

        void startThrowAway() {
            this.m_throwAway = true;
        }

        void stopThrowAway() {
            this.m_throwAway = false;
        }

        boolean inThrowAway() {
            return this.m_throwAway;
        }

        void addNotifications(HashMap modifications) {
            ModificationItem[] modList = new ModificationItem[modifications.size()];
            Iterator iterator = modifications.values().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                modList[i++] = (ModificationItem)iterator.next();
            }
            this.addNotifications(modList);
        }

        void addNotifications(ModificationItem[] modifications) {
            if (this.m_throwAway) {
                return;
            }
            for (int i = 0; i < modifications.length; ++i) {
                if (modifications[i].getChangeType() == 2) {
                    this.m_hasDelete = true;
                }
                if (modifications[i].getChangeType() == 0) {
                    this.m_hasAdded = true;
                }
                if (modifications[i].getChangeType() == 1) {
                    this.m_hasUpdate = true;
                }
                this.m_notificationList.add(modifications[i]);
                if (this.m_newIdsTable == null) continue;
                IElementIdentity id = modifications[i].getModificationID();
                IBasicElement modification = modifications[i].getModification();
                if (modification != null && modification instanceof IDirElement && ((IDirElement)modification).isDeleted() || this.m_inDeleteTriggers || id == null) continue;
                this.m_newIdsTable.put(id.getName(), id);
            }
        }

        void addGroupNotification(ArrayList modifications, boolean hasDelete) {
            if (this.m_throwAway) {
                return;
            }
            if (hasDelete) {
                this.m_hasDelete = true;
            }
            this.m_notificationList.addGroup(modifications);
        }

        @Override
        public void onDelete() throws DirectoryServiceException {
            if (!this.m_hasDelete || System.getProperty("MQ_UPGRADE", "false").equals("true")) {
                return;
            }
            try {
                this.m_inDeleteTriggers = true;
                this.m_ds.runOnDeleteTriggers(this.m_notificationList);
            }
            finally {
                this.m_inDeleteTriggers = false;
            }
        }

        @Override
        public void afterDelete() throws DirectoryServiceException {
            if (!this.m_hasDelete || System.getProperty("MQ_UPGRADE", "false").equals("true")) {
                return;
            }
            try {
                this.m_inDeleteTriggers = true;
                this.m_ds.runAfterDeleteTriggers(this.m_notificationList);
            }
            finally {
                this.m_inDeleteTriggers = false;
            }
        }

        @Override
        public void validate() throws DirectoryServiceException {
            this.m_ds.runValidationTriggers(this.m_notificationList, false);
        }

        @Override
        public void onUpdate() throws DirectoryServiceException {
            if (!this.m_hasUpdate || System.getProperty("MQ_UPGRADE", "false").equals("true")) {
                return;
            }
            try {
                this.m_inDeleteTriggers = true;
                this.m_ds.runOnUpdateTriggers(this.m_notificationList);
            }
            finally {
                this.m_inDeleteTriggers = false;
            }
        }

        @Override
        public void afterUpdate() throws DirectoryServiceException {
            if (!this.m_hasUpdate || System.getProperty("MQ_UPGRADE", "false").equals("true")) {
                return;
            }
            try {
                this.m_inDeleteTriggers = true;
                this.m_ds.runAfterUpdateTriggers(this.m_notificationList);
            }
            finally {
                this.m_inDeleteTriggers = false;
            }
        }

        @Override
        public void onCreate() throws DirectoryServiceException {
            if (!this.m_hasAdded || System.getProperty("MQ_UPGRADE", "false").equals("true")) {
                return;
            }
            try {
                this.m_inDeleteTriggers = true;
                this.m_ds.runOnCreateTriggers(this.m_notificationList);
            }
            finally {
                this.m_inDeleteTriggers = false;
            }
        }

        @Override
        public void afterCreate() throws DirectoryServiceException {
            if (!this.m_hasAdded || System.getProperty("MQ_UPGRADE", "false").equals("true")) {
                return;
            }
            try {
                this.m_inDeleteTriggers = true;
                this.m_ds.runAfterCreateTriggers(this.m_notificationList);
            }
            finally {
                this.m_inDeleteTriggers = false;
            }
        }

        @Override
        public void audit() throws DirectoryServiceException {
            if (DirectoryService.this.m_context == null) {
                return;
            }
            IAuditManager auditManager = DirectoryService.this.m_context.getAuditManager();
            if (auditManager == null) {
                return;
            }
            if (!auditManager.configureAuditingEnabled()) {
                return;
            }
            if (DirectoryService.this.m_logicalNameSpace == null) {
                return;
            }
            ChangeAuditor auditor = new ChangeAuditor(this.m_ds, auditManager);
            this.auditModifications(auditor, this.m_notificationList);
            this.auditNamingChanges(auditor, DirectoryService.this.m_logicalNameSpace.getAuditRecords());
            auditor.recordAudit();
        }

        private void auditModifications(ChangeAuditor auditor, List modifications) throws DirectoryServiceException {
            block6: for (ModificationItem modItem : modifications) {
                switch (modItem.m_type) {
                    case 1: {
                        Element newElement = modItem.m_newElement;
                        auditor.auditCreate((IElement)newElement);
                        continue block6;
                    }
                    case 2: {
                        Element beforeImage = modItem.m_beforeImage;
                        String logicalName = modItem.m_deletedLogicalName;
                        auditor.auditDelete((IElement)beforeImage, logicalName);
                        continue block6;
                    }
                    case 4: {
                        Element deletedElement = modItem.m_deletedElement;
                        String logicalName = modItem.m_deletedLogicalName;
                        auditor.auditDelete((IElement)deletedElement, logicalName);
                        continue block6;
                    }
                    case 3: {
                        DeltaElement delta = modItem.m_delta;
                        Element beforeImage = modItem.m_beforeImage;
                        auditor.auditUpdate((IDeltaElement)delta, (IElement)beforeImage);
                        continue block6;
                    }
                }
                throw new DirectoryServiceException("Audit: unknown modification type");
            }
        }

        private void auditNamingChanges(ChangeAuditor auditor, List namingChanges) throws DirectoryServiceException {
            block5: for (LogicalNameSpace.AuditRecord rec : namingChanges) {
                switch (rec.getAction()) {
                    case 1: {
                        auditor.auditFolderCreate(rec.getNewPath());
                        continue block5;
                    }
                    case 2: {
                        auditor.auditFolderDelete(rec.getOldPath());
                        continue block5;
                    }
                    case 3: {
                        auditor.auditRename(rec.getOldPath(), rec.getNewPath(), rec.getStoragePath());
                        continue block5;
                    }
                }
                throw new DirectoryServiceException("Audit: unknown logical name change");
            }
        }

        @Override
        public void doNotify() {
            this.m_notificationList.addSingletonRanges();
            if (this.m_consumer != null) {
                for (int i = 0; i < this.m_notificationList.rangesCount(); ++i) {
                    this.doNotifyRange(this.m_notificationList.rangeIterator(i), this.m_notificationList.rangeSize(i), this.m_notificationList.rangeIsGroup(i));
                }
            }
            this.reset();
        }

        public void doNotifyRange(Iterator iterator, int size, boolean isGroup) {
            IBasicElement[] modList = new IBasicElement[size];
            int i = 0;
            while (iterator.hasNext()) {
                modList[i++] = ((ModificationItem)iterator.next()).getModification();
            }
            if (isGroup) {
                IDirElement[] elementList = new IDirElement[modList.length];
                System.arraycopy(modList, 0, elementList, 0, modList.length);
                if (DirectoryService.this.m_FSInterfaceIsUsed && DirectoryService.this.m_localListener instanceof LocalFSListener) {
                    elementList = DirectoryService.this.translateElementsToLogical(elementList);
                }
                this.m_consumer.elementsChanged(elementList);
            } else {
                if (DirectoryService.this.m_FSInterfaceIsUsed && DirectoryService.this.m_localListener instanceof LocalFSListener) {
                    modList = DirectoryService.this.translateElementsToLogical(modList);
                }
                this.m_consumer.elementsChanged(modList);
            }
        }

        @Override
        public void reset() {
            this.m_hasDelete = false;
            this.m_hasAdded = false;
            this.m_hasUpdate = false;
            this.m_notificationList = new GroupArrayList();
        }
    }

    private class BeforeAfterPair {
        IDirElement m_before;
        IDirElement m_after;

        BeforeAfterPair(IDirElement before, IDirElement after) {
            this.m_before = before;
            this.m_after = after;
        }
    }

    private class ManagementPermission {
        int m_pathType;
        String m_containerName;
        String m_componentName;
        String m_path;
        String m_principal;
        String m_permissionType;
        int m_scope;
        int m_permissions;
        String m_folderName = null;

        ManagementPermission(String path, String type, boolean checkPath) throws DirectoryServiceException {
            this.m_path = path;
            this.m_permissionType = type;
            try {
                if (checkPath) {
                    this.m_pathType = type.equals("configure") ? this.checkConfigurePath() : this.checkManagePath();
                }
            }
            catch (InvalidPathException invalidE) {
                throw invalidE;
            }
            catch (Exception e) {
                throw new DirectoryServiceException("Error while setting " + type + " permissions for " + path + ": " + e.toString());
            }
        }

        final int checkConfigurePath() throws DirectoryServiceException {
            int type = DirectoryService.this.m_logicalNameSpace.getNameSpaceType(this.m_path);
            if (type == 0) {
                if (this.m_path.endsWith("_MFDomainDescriptor") && DirectoryService.this.getFSElement(this.m_path, false) != null) {
                    return 1;
                }
                throw new InvalidPathException("Path " + this.m_path + " does not exist and thus cannot be used with the permissions API");
            }
            if (type == 3) {
                return 1;
            }
            if (type == 1 || type == 2) {
                if (!DirectoryService.this.isHierarchicalPath(this.m_path)) {
                    this.findFolderName();
                    return 0;
                }
                return 1;
            }
            throw new InvalidPathException("Path " + this.m_path + " is not a folder or an element and this cannot be used to set configure permissions");
        }

        final int checkManagePath() throws DirectoryServiceException, ConfigException, StorageException {
            int type = DirectoryService.this.m_logicalNameSpace.getNameSpaceType(this.m_path);
            if (type != 1) {
                if (type == 3) {
                    String storageName = DirectoryService.this.m_logicalNameSpace.storageFromLogical(this.m_path);
                    IDirElement el = DirectoryService.this.getElement(storageName, false);
                    if (!el.getIdentity().getType().equals("MF_CONTAINER")) {
                        throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
                    }
                    this.m_containerName = this.m_path;
                    return 3;
                }
                if (type == 2) {
                    throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
                }
                if (type == 0) {
                    String possibleContainerStorageName;
                    int colonIndex = this.m_path.indexOf(":");
                    if (colonIndex == -1) {
                        throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
                    }
                    int equalIndex = this.m_path.indexOf("=");
                    if (equalIndex == -1) {
                        throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
                    }
                    EntityName pathName = new EntityName(this.m_path);
                    String parentName = pathName.getParent();
                    String containerLogicalName = parentName + this.m_path.substring(parentName.length(), colonIndex);
                    try {
                        possibleContainerStorageName = DirectoryService.this.m_logicalNameSpace.storageFromLogical(containerLogicalName);
                    }
                    catch (Exception ve) {
                        throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission: " + ve.toString());
                    }
                    IDirElement possibleContainer = DirectoryService.this.getElement(possibleContainerStorageName, false);
                    if (possibleContainer == null || !possibleContainer.getIdentity().getType().equals("MF_CONTAINER")) {
                        throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
                    }
                    this.m_containerName = containerLogicalName;
                    String componentName = this.m_path.substring(equalIndex + 1);
                    IAttributeSet containerTopSet = possibleContainer.getAttributes();
                    IAttributeSet componentsSet = (IAttributeSet)containerTopSet.getAttribute("COMPONENTS");
                    if (componentsSet == null) {
                        throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
                    }
                    IAttributeSet componentSet = (IAttributeSet)componentsSet.getAttribute(componentName);
                    if (componentSet == null) {
                        throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
                    }
                    this.m_componentName = componentName;
                    return 4;
                }
                throw new InvalidPathException("Cannot identify " + this.m_path + " as a folder, container or component to be used in setting a manage permission");
            }
            this.findFolderName();
            return 2;
        }

        private void findFolderName() {
            this.m_folderName = this.m_path.charAt(this.m_path.length() - 1) != '/' ? this.m_path + '/' : this.m_path;
        }

        void setPermissionsCheck(IFrameworkComponentContext context) {
            if (context != null && context.getPermissionsManager() != null) {
                IPermissionsManager manager = context.getPermissionsManager();
                switch (this.m_pathType) {
                    case 0: 
                    case 2: {
                        manager.configurePermissionCheck(context, this.m_folderName, true, 64);
                        break;
                    }
                    case 1: 
                    case 3: {
                        manager.configurePermissionCheck(context, this.m_path, true, 64);
                        break;
                    }
                    case 4: {
                        manager.configurePermissionCheck(context, this.m_containerName, true, 64);
                    }
                }
            }
        }

        void getInformationCheck(IFrameworkComponentContext context) {
            if (context != null && context.getPermissionsManager() != null) {
                IPermissionsManager manager = context.getPermissionsManager();
                switch (this.m_pathType) {
                    case 0: 
                    case 2: {
                        manager.configurePermissionCheck(context, this.m_folderName, true, 1);
                        break;
                    }
                    case 1: 
                    case 3: {
                        manager.configurePermissionCheck(context, this.m_path, true, 1);
                        break;
                    }
                    case 4: {
                        manager.configurePermissionCheck(context, this.m_containerName, true, 1);
                    }
                }
            }
        }

        String getStoredPath() {
            if (this.m_folderName != null) {
                return this.m_folderName;
            }
            return this.m_path;
        }

        void setPermission(IManagementPermission perm, IAttributeSet permissionsSet, IFrameworkComponentContext context) throws InvalidManagementPermissionException, ConfigException, DirectoryServiceException {
            IPermissionsManager manager = null;
            if (context != null) {
                manager = context.getPermissionsManager();
            }
            this.m_scope = perm.getScope();
            this.m_principal = perm.getPrincipal();
            this.m_permissions = perm.getPermissions();
            short principalType = 0;
            this.checkPermissionScope();
            principalType = manager != null ? manager.getPrincipalType(this.m_principal) : DirectoryService.this.getPrincipalType(this.m_principal);
            if (principalType == 0) {
                throw new InvalidManagementPermissionException(this.m_principal + " is not a valid principal in the domain's authentication domain");
            }
            IAttributeSet permSet = (IAttributeSet)permissionsSet.getAttribute(this.m_principal);
            if (permSet != null) {
                String setting = (String)permSet.getAttribute(DirectoryService.PERMISSIONS_VALUE_ATTRIBUTE_NAME);
                int setScope = new Integer(setting.substring(0, setting.indexOf(":")));
                int setPermission = new Integer(setting.substring(setting.indexOf(":") + 1));
                if (setScope == this.m_scope && setPermission == this.m_permissions) {
                    return;
                }
            }
            if (permSet != null) {
                permissionsSet.deleteAttribute(this.m_principal);
            }
            permSet = permissionsSet.createAttributeSet(this.m_principal);
            permSet.setStringAttribute(DirectoryService.PERMISSIONS_VALUE_ATTRIBUTE_NAME, new String(this.m_scope + ":" + this.m_permissions));
        }

        void deletePermission(String principal, IAttributeSet permissionsSet) throws ConfigException, InvalidManagementPermissionException {
            if (principal != null) {
                IAttributeSet principalPermSet = (IAttributeSet)permissionsSet.getAttribute(principal);
                if (principalPermSet != null) {
                    permissionsSet.deleteAttribute(principal);
                } else {
                    throw new InvalidManagementPermissionException("Cannot remove permission for " + principal + " on path " + this.m_path + ": principal permissions does not exist");
                }
            }
        }

        private void checkPermissionScope() throws InvalidManagementPermissionException {
            switch (this.m_pathType) {
                case 0: {
                    this.checkConfigureFolderScope();
                    break;
                }
                case 1: {
                    this.checkConfigureElementScope();
                    break;
                }
                case 2: {
                    this.checkManageFolderScope();
                    break;
                }
                case 3: {
                    this.checkManageContainerScope();
                    break;
                }
                case 4: {
                    this.checkManageComponentScope();
                }
            }
        }

        private void checkConfigureFolderScope() throws InvalidManagementPermissionException {
            if ((this.m_scope & 4) == 4) {
                throw new InvalidManagementPermissionException("Permission scope " + this.m_scope + " includes incorrect permissions for folder " + this.m_path);
            }
        }

        private void checkConfigureElementScope() throws InvalidManagementPermissionException {
            if (this.m_scope != 4) {
                throw new InvalidManagementPermissionException("Permission scope " + this.m_scope + " includes incorrect permissions for element " + this.m_path);
            }
        }

        private void checkManageFolderScope() throws InvalidManagementPermissionException {
            if ((this.m_scope & 8) == 8 || (this.m_scope & 2) == 2) {
                throw new InvalidManagementPermissionException("Permission scope " + this.m_scope + " includes incorrect permissions for runtime folder " + this.m_path);
            }
        }

        private void checkManageContainerScope() throws InvalidManagementPermissionException {
            if ((this.m_scope & 4) == 4 || (this.m_scope & 1) == 1 || (this.m_scope & 8) == 8) {
                throw new InvalidManagementPermissionException("Permission scope " + this.m_scope + " includes incorrect scope for managed container " + this.m_path);
            }
        }

        private void checkManageComponentScope() throws InvalidManagementPermissionException {
            if (this.m_scope != 8) {
                throw new InvalidManagementPermissionException("Permission scope " + this.m_scope + " includes incorrect scope for component " + this.m_path);
            }
        }
    }

    private final class GroupArrayList
    extends ArrayList {
        ArrayList m_ranges = new ArrayList();

        GroupArrayList() {
        }

        void addSingletonRanges() {
            int firstIndex = 0;
            ArrayList<Range> allRanges = new ArrayList<Range>();
            for (int i = 0; i < this.m_ranges.size(); ++i) {
                Range groupRange = (Range)this.m_ranges.get(i);
                if (groupRange.m_start > firstIndex) {
                    allRanges.add(new Range(firstIndex, groupRange.m_start - firstIndex, false));
                    allRanges.add(groupRange);
                    firstIndex = groupRange.m_start + groupRange.m_size;
                    continue;
                }
                allRanges.add(groupRange);
                firstIndex = groupRange.m_start + groupRange.m_size;
            }
            if (firstIndex < this.size()) {
                allRanges.add(new Range(firstIndex, this.size() - firstIndex, false));
            }
            this.m_ranges = allRanges;
        }

        void addGroup(ArrayList group) {
            if (group == null || group.isEmpty()) {
                return;
            }
            this.m_ranges.add(new Range(this.size(), group.size(), true));
            for (int i = 0; i < group.size(); ++i) {
                this.add(group.get(i));
            }
        }

        int rangesCount() {
            return this.m_ranges.size();
        }

        int rangeSize(int rangeNum) {
            return ((Range)this.m_ranges.get((int)rangeNum)).m_size;
        }

        boolean rangeIsGroup(int rangeNum) {
            return ((Range)this.m_ranges.get((int)rangeNum)).m_group;
        }

        Iterator rangeIterator(int rangeNum) {
            Range groupRange = (Range)this.m_ranges.get(rangeNum);
            return new RangeIterator(groupRange.m_start, groupRange.m_size);
        }

        private final class Range {
            int m_start;
            int m_size;
            boolean m_group;

            Range(int start, int size, boolean group) {
                this.m_start = start;
                this.m_size = size;
                this.m_group = group;
            }
        }

        private class RangeIterator
        implements Iterator {
            int m_currentIndex;
            int m_last;

            RangeIterator(int first, int size) {
                this.m_currentIndex = first;
                this.m_last = first + size - 1;
            }

            @Override
            public boolean hasNext() {
                return this.m_currentIndex <= this.m_last;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                return GroupArrayList.this.get(this.m_currentIndex++);
            }

            @Override
            public void remove() {
                throw new IllegalStateException("remove() is not supported");
            }
        }
    }
}

