/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.IEvsPort;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.nio.EvsDispatcherEvent;
import com.progress.blackbird.evs.nio.EvsObject;
import com.progress.blackbird.evs.nio.EvsPortEvent;
import com.progress.blackbird.sys.SysAtomicInteger;

abstract class EvsPort
extends EvsObject
implements IEvsPort {
    private int type;
    private SysAtomicInteger heatLevel;

    EvsPort(int n, boolean bl) {
        super(bl);
        this.type = n;
        this.heatLevel = SysAtomicInteger.create(bl, 0);
    }

    final void setHot() {
        this.heatLevel.increment();
    }

    final void setCold() {
        if (this.checked && this.heatLevel.value == 0) {
            throw new InternalError("Internal error - Heat level being set to negative");
        }
        this.heatLevel.decrement();
    }

    final void dispatch(EvsPortEvent evsPortEvent) {
        if (evsPortEvent.getEventHandler() != null) {
            evsPortEvent.getEventHandler().handleEvent(evsPortEvent);
        }
    }

    final void setColdAndDispatch(EvsPortEvent evsPortEvent) {
        IEvsPortEventHandler iEvsPortEventHandler = evsPortEvent.getEventHandler();
        this.setCold();
        if (iEvsPortEventHandler != null) {
            iEvsPortEventHandler.handleEvent(evsPortEvent);
        }
    }

    abstract void handleEvent(EvsDispatcherEvent var1);

    @Override
    public final boolean isHot() {
        return this.heatLevel.value > 0;
    }

    @Override
    public final boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public final int getType() {
        return this.type;
    }
}

