/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class BTreeCreateLeafNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 13;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;
    boolean m_unique;

    BTreeCreateLeafNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum + " unique " + this.m_unique;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)13);
        writer.write((byte)(this.m_unique ? 1 : 0));
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 10;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_unique = buffer[currentOffset++] == 1;
        this.m_pageNum = BitUtil.getLong(buffer, currentOffset);
    }

    void initNote(long pageNum, boolean unique) {
        this.m_pageNum = pageNum;
        this.m_unique = unique;
    }
}

