/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IVisibleDbkLogicalNote;
import com.sonicsw.mtstorage.impl.LogicalNote;
import java.io.IOException;

abstract class BTreeLifeCycleAbstractLogicalNote
extends LogicalNote
implements BTreeNoteInterface,
IVisibleDbkLogicalNote {
    long m_treeDbk;
    boolean m_uniqueIndex;

    BTreeLifeCycleAbstractLogicalNote() {
    }

    @Override
    abstract byte getType();

    @Override
    public long getDbk() {
        return this.m_treeDbk;
    }

    boolean isUnique() {
        return this.m_uniqueIndex;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(this.getType());
        writer.write((byte)(this.m_start ? 1 : 0));
        writer.write((byte)(this.m_uniqueIndex ? 1 : 0));
        int noteLength = 3;
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        noteLength += 8;
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_treeDbk);
        writer.write(this.m_scratchBuffer, 0, 8);
        return noteLength += 8;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_start = buffer[currentOffset++] == 1;
        this.m_uniqueIndex = buffer[currentOffset++] == 1;
        this.m_transactionNum = BitUtil.getLong(buffer, currentOffset);
        this.m_treeDbk = BitUtil.getLong(buffer, currentOffset += 8);
        currentOffset += 8;
    }

    void initNote(boolean start, boolean uniqueIndex, long transactionNum, long treeDbk) {
        this.m_start = start;
        this.m_uniqueIndex = uniqueIndex;
        this.m_transactionNum = transactionNum;
        this.m_treeDbk = treeDbk;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " transaction: " + this.m_transactionNum + " start: " + this.m_start + " tree page: " + this.m_treeDbk;
    }
}

