/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.sonicsw.mtstorage.IStorage;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.replication.util.BitUtil;
import java.io.IOException;
import java.util.HashMap;

public class TestCreateStorage {
    private static String DB_NAME;
    private static int NUM_OBJECTS;
    private static int OBJ_SIZE;

    public static void main(String[] args) throws Exception {
        DB_NAME = args[0];
        if (args[1].equals("create")) {
            TestCreateStorage.createObjects();
        } else {
            TestCreateStorage.displayObjects();
        }
    }

    static void updateObjects(IStorage storage, int delayInSeconds) throws Exception {
        byte[] root = new byte[NUM_OBJECTS * 8];
        long rootDbkey = 1L;
        Long tr1 = storage.begin();
        storage.get(tr1, rootDbkey, root, 0);
        storage.commit(tr1);
        int rootPointer = 0;
        for (int i = 0; i < NUM_OBJECTS; ++i) {
            if (delayInSeconds > 0) {
                Thread.sleep(delayInSeconds * 1000);
            }
            Long tr = storage.begin();
            long id = BitUtil.getLong(root, rootPointer);
            byte[] data = new byte[OBJ_SIZE];
            storage.get(tr, id, data, 0);
            int value = BitUtil.getInt(data, 0);
            BitUtil.putInt(data, 0, value * 10);
            storage.update(tr, id, data, 0, data.length);
            storage.commit(tr);
            System.out.println("Update " + id + " to " + value * 10);
            rootPointer += 8;
        }
    }

    private static void displayObjects() throws IOException {
        Storage storage = new Storage();
        storage.open(DB_NAME, false, new HashMap());
        TestCreateStorage.lookupObjects(storage);
        storage.close();
    }

    static void displayObjects(IStorage storage) throws IOException {
        TestCreateStorage.lookupObjects(storage);
    }

    private static void lookupObjects(IStorage storage) throws IOException {
        Long tr = storage.begin();
        byte[] root = new byte[NUM_OBJECTS * 8];
        long rootDbkey = 1L;
        storage.get(tr, rootDbkey, root, 0);
        int rootPointer = 0;
        for (int i = 0; i < NUM_OBJECTS; ++i) {
            long id = BitUtil.getLong(root, rootPointer);
            byte[] data = new byte[OBJ_SIZE];
            storage.get(tr, id, data, 0);
            System.out.println("Found object id " + id + " value " + BitUtil.getInt(data, 0));
            rootPointer += 8;
        }
        storage.commit(tr);
    }

    static void createDeleteLoop(IStorage storage) throws IOException {
        for (int i = 0; i < 2000000000; ++i) {
            Long tr = storage.begin();
            byte[] data = new byte[OBJ_SIZE];
            long id = storage.allocate(tr, 0, (byte)102, data.length);
            storage.update(tr, id, data, 0, data.length);
            storage.commit(tr);
            tr = storage.begin();
            storage.delete(tr, id);
            storage.commit(tr);
            if (i % 10 != 0) continue;
            try {
                System.out.println("Sleeping for 100 millis at iteration " + i);
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void createObjects() throws IOException {
        Storage storage = new Storage();
        storage.open(DB_NAME, true, new HashMap());
        Long tr = storage.begin();
        byte[] root = new byte[NUM_OBJECTS * 8];
        long rootDbkey = storage.allocate(tr, 0, (byte)102, root.length);
        System.out.println("Create root " + rootDbkey);
        int rootPointer = 0;
        for (int i = 0; i < NUM_OBJECTS; ++i) {
            byte[] data = new byte[OBJ_SIZE];
            long id = storage.allocate(tr, 0, (byte)102, data.length);
            System.out.println("Create object " + i + " id " + id);
            BitUtil.putInt(data, 0, i);
            storage.update(tr, id, data, 0, data.length);
            BitUtil.putLong(root, rootPointer, id);
            rootPointer += 8;
        }
        storage.update(tr, rootDbkey, root, 0, root.length);
        storage.commit(tr);
        storage.close();
    }

    static {
        NUM_OBJECTS = 200;
        OBJ_SIZE = 120000;
    }
}

