/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassControl;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class FieldMap {
    Hashtable classTable = new Hashtable(7);
    Hashtable classValueTable = new Hashtable(7);

    public boolean classHasEntry(String className) {
        return this.classTable.get(className) != null;
    }

    public void addField(String fullFieldName) {
        int lastDot = fullFieldName.lastIndexOf(46);
        String className = ClassControl.vmClassFromUserClass(fullFieldName.substring(0, lastDot));
        String fieldName = fullFieldName.substring(lastDot + 1);
        this.addField(className, fieldName);
    }

    public void addField(String className, String fieldName) {
        Hashtable<String, Boolean> classHash = (Hashtable<String, Boolean>)this.classTable.get(className);
        if (classHash == null) {
            classHash = new Hashtable<String, Boolean>(7);
            this.classTable.put(className, classHash);
        }
        classHash.put(fieldName, new Boolean(false));
    }

    public void associateValue(String fullFieldName, Object value) {
        int lastDot = fullFieldName.lastIndexOf(46);
        String className = ClassControl.vmClassFromUserClass(fullFieldName.substring(0, lastDot));
        String fieldName = fullFieldName.substring(lastDot + 1);
        Hashtable<String, Object> classValueHash = (Hashtable<String, Object>)this.classValueTable.get(className);
        if (classValueHash == null) {
            classValueHash = new Hashtable<String, Object>(7);
            this.classValueTable.put(className, classValueHash);
        }
        classValueHash.put(fieldName, value);
    }

    Object getValue(String vmClassName, String fieldName) {
        Hashtable classValueHash = (Hashtable)this.classValueTable.get(vmClassName);
        if (classValueHash == null) {
            return null;
        }
        return classValueHash.get(fieldName);
    }

    boolean containsField(String vmClassName, String fieldName) {
        Hashtable classHash = (Hashtable)this.classTable.get(vmClassName);
        return classHash != null && classHash.get(fieldName) != null;
    }

    boolean isMarked(String vmClassName, String fieldName) {
        Boolean b;
        Hashtable classHash = (Hashtable)this.classTable.get(vmClassName);
        return classHash != null && (b = (Boolean)classHash.get(fieldName)) != null && b != false;
    }

    public void markField(String vmClassName, String fieldName) {
        Boolean b;
        Hashtable classHash = (Hashtable)this.classTable.get(vmClassName);
        if (classHash != null && (b = (Boolean)classHash.get(fieldName)) != null && !b.booleanValue()) {
            classHash.put(fieldName, new Boolean(true));
        }
    }

    public Enumerator entries() {
        return new Enumerator();
    }

    class Enumerator
    implements Enumeration {
        private Enumeration classEnumeration;
        private String className;
        private Hashtable currentClassFields;
        private Enumeration fieldEnumeration;
        private String fieldName;

        Enumerator() {
            this.classEnumeration = FieldMap.this.classTable.keys();
            this.checkNext();
        }

        @Override
        public boolean hasMoreElements() {
            return this.fieldName != null;
        }

        public Object nextElement() {
            String result = this.userFieldName();
            this.nextField();
            return result;
        }

        public String userFieldName() {
            if (this.fieldName == null) {
                throw new NoSuchElementException("No more elements");
            }
            return ClassControl.userClassFromVMClass(this.className) + "." + this.fieldName;
        }

        public String className() {
            if (this.fieldName == null) {
                throw new NoSuchElementException("No more elements");
            }
            return this.className;
        }

        public String fieldName() {
            if (this.fieldName == null) {
                throw new NoSuchElementException("No more elements");
            }
            return this.fieldName;
        }

        public boolean isMarked() {
            if (this.fieldName == null) {
                throw new NoSuchElementException("No more elements");
            }
            return (Boolean)this.currentClassFields.get(this.fieldName);
        }

        public void nextField() {
            if (this.fieldName == null) {
                throw new NoSuchElementException("No more elements");
            }
            this.checkNext();
        }

        private boolean checkNext() {
            if (this.classEnumeration == null) {
                return false;
            }
            boolean done = false;
            while (!done) {
                if (this.currentClassFields == null) {
                    if (!this.classEnumeration.hasMoreElements()) {
                        this.classEnumeration = null;
                        this.fieldName = null;
                        return false;
                    }
                    this.className = (String)this.classEnumeration.nextElement();
                    this.currentClassFields = (Hashtable)FieldMap.this.classTable.get(this.className);
                }
                if (this.fieldEnumeration == null) {
                    this.fieldEnumeration = this.currentClassFields.keys();
                }
                if (this.fieldEnumeration.hasMoreElements()) {
                    this.fieldName = (String)this.fieldEnumeration.nextElement();
                    done = true;
                    continue;
                }
                this.currentClassFields = null;
                this.fieldEnumeration = null;
            }
            return true;
        }
    }
}

