/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.FatalInternalException;
import com.odi.IPersistent;
import com.odi.ObjectException;
import com.odi.ObjectNotFoundException;
import com.odi.Persistent;
import com.odi.imp.HashBucket;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.Utilities;
import com.odi.imp.WeakCache;
import com.odi.imp.WeakKeyCache;
import com.odi.imp.WeakValueCache;
import java.util.Enumeration;
import java.util.Properties;

public final class ObjectTable {
    private ObjectManager om;
    private WeakValueCache refToObject;
    private WeakKeyCache weakObjectToRef;
    public static boolean debug = Boolean.getBoolean("com.odi.debugWeakReferences");
    public static int READ_BARRIER_UP = 1;
    public static int READ_BARRIER_CACHED = 2;
    public static int READ_BARRIER_DOWN = 3;
    private MutatingObjRef tempObjRef;

    ObjectTable(ObjectManager om) {
        this.om = om;
        this.tempObjRef = om.objRefFactory.createMutating();
        this.refToObject = new WeakValueCache(om, 101);
        this.weakObjectToRef = new WeakKeyCache(om, 101);
    }

    ObjectReference enterAssociation(ObjectReference objRef, Object object, int readBarrierType) {
        objRef = this.getObjRefForOTEntry(objRef, object);
        HashBucket newBucket = (HashBucket)((Object)objRef);
        this.refToObject.put(newBucket);
        if (object instanceof IPersistent) {
            IPersistent po = (IPersistent)object;
            po.ODIsetRef(objRef);
            this.adjustReadBarrier(po, objRef, readBarrierType);
        } else {
            this.weakObjectToRef.put(newBucket);
            this.adjustReadBarrier(object, objRef, readBarrierType);
        }
        return objRef;
    }

    ObjectReference setObjectToRefMapping(ObjectReference objRef, Object object) {
        objRef = this.getObjRefForOTEntry(objRef, object);
        HashBucket newBucket = (HashBucket)((Object)objRef);
        if (object instanceof IPersistent) {
            IPersistent po = (IPersistent)object;
            po.ODIsetRef(objRef);
        } else {
            this.weakObjectToRef.put(newBucket);
        }
        return objRef;
    }

    void removeObjectToRefMapping(ObjectReference objRef, Object object) {
        if (object instanceof IPersistent) {
            IPersistent po = (IPersistent)object;
            po.ODIsetRef(null);
        } else {
            this.weakObjectToRef.remove((HashBucket)((Object)objRef));
        }
    }

    ObjectReference enterWritableAssociation(ObjectReference objRef, Object object) {
        objRef = this.getObjRefForOTEntry(objRef, object);
        HashBucket newBucket = (HashBucket)((Object)objRef);
        this.refToObject.put(newBucket);
        if (object instanceof IPersistent) {
            ((IPersistent)object).ODIsetRef(objRef);
        } else {
            this.weakObjectToRef.put(newBucket);
        }
        this.makeWritable(object, objRef);
        return objRef;
    }

    private ObjectReference getObjRefForOTEntry(ObjectReference objRef, Object object) {
        return objRef.getClass() == MutatingObjRef.class ? this.om.objRefFactory.create(object, objRef) : objRef;
    }

    void destroyAssociation(Object object, ObjectReference objRef) {
        this.removeAssociation(object, objRef, true);
        ObjRefUtils.setDestroyed(objRef, true);
    }

    void removeAssociation(Object object, ObjectReference objRef) {
        this.removeAssociation(object, objRef, false);
    }

    private void removeAssociation(Object object, ObjectReference objRef, boolean rememberStale) {
        this.refToObject.remove((HashBucket)((Object)objRef));
        if (object instanceof IPersistent) {
            IPersistent pobject = (IPersistent)object;
            Persistent.makeHollow(pobject);
        } else {
            if (!rememberStale) {
                this.weakObjectToRef.remove((HashBucket)((Object)objRef));
            }
            ObjRefUtils.makeHollow(objRef);
        }
        ObjRefUtils.setStale(objRef);
    }

    void forgetStaleObjects() {
        WeakCache.WeakCacheEnumeration refs = this.weakObjectToRef.elements();
        while (refs.hasMoreElements()) {
            ObjectReference ref = (ObjectReference)refs.nextElement();
            this.weakObjectToRef.remove((HashBucket)((Object)ref));
        }
    }

    void makeWritable(Object object, ObjectReference objRef) {
        this.refToObject.makeWritable((HashBucket)((Object)objRef));
        if (object instanceof IPersistent) {
            Persistent.makeWritable((IPersistent)object);
        } else {
            ObjRefUtils.makeWritable(objRef);
        }
    }

    void adjustReadBarrier(IPersistent object, ObjectReference objRef, int readBarrierType) {
        if (readBarrierType == READ_BARRIER_DOWN) {
            this.refToObject.makeReadable((HashBucket)((Object)objRef));
            Persistent.makeReadable(object);
        } else if (readBarrierType == READ_BARRIER_CACHED) {
            this.refToObject.makeCached((HashBucket)((Object)objRef));
            Persistent.makeCached(object);
        } else {
            this.refToObject.makeHollow((HashBucket)((Object)objRef));
            Persistent.makeHollow(object);
        }
    }

    void adjustReadBarrier(Object object, ObjectReference objRef, int readBarrierType) {
        if (object instanceof IPersistent) {
            this.adjustReadBarrier((IPersistent)object, objRef, readBarrierType);
            return;
        }
        if (readBarrierType == READ_BARRIER_DOWN) {
            this.refToObject.makeReadable((HashBucket)((Object)objRef));
            ObjRefUtils.makeReadable(objRef);
        } else if (readBarrierType == READ_BARRIER_CACHED) {
            this.refToObject.makeCached((HashBucket)((Object)objRef));
            ObjRefUtils.makeCached(objRef);
        } else {
            this.refToObject.makeHollow((HashBucket)((Object)objRef));
            ObjRefUtils.makeHollow(objRef);
        }
    }

    void clearCachedObject(ObjectReference objRef) {
        this.refToObject.makeHollow((HashBucket)((Object)objRef));
        ObjRefUtils.makeHollow(objRef);
    }

    void validate() {
        ObjectManager.IdentitySet readableTable = null;
        ObjectManager.IdentitySet writableTable = null;
        boolean done = false;
        boolean ascertainProblem = false;
        while (!done) {
            int readableObjectCount = 0;
            int writableObjectCount = 0;
            int readableObjectCountVerify = 0;
            int writableObjectCountVerify = 0;
            if (ascertainProblem) {
                readableTable = new ObjectManager.IdentitySet();
                writableTable = new ObjectManager.IdentitySet();
                done = true;
            }
            WeakCache.WeakCacheEnumeration readableObjects = this.getReadableObjects();
            while (readableObjects.hasMoreElements()) {
                Object object = readableObjects.nextElement();
                if (object == null) continue;
                if (this.om.hasReadBarrier(object, (ObjectReference)readableObjects.currentKey())) {
                    throw new FatalInternalException(object + " is on readable list but has read barrier");
                }
                if (ascertainProblem) {
                    readableTable.put(object);
                }
                ++readableObjectCount;
            }
            WeakCache.WeakCacheEnumeration writableObjects = this.getWritableObjects();
            while (writableObjects.hasMoreElements()) {
                ObjectReference objRef;
                Object object = writableObjects.nextElement();
                if (this.om.hasWriteBarrier(object, objRef = (ObjectReference)writableObjects.currentKey()) || this.om.hasReadBarrier(object, objRef)) {
                    throw new FatalInternalException(object + " is on writable list but has read or write barrier up");
                }
                if (!this.om.hasWriteBarrier(object, objRef) && this.om.hasReadBarrier(object, objRef)) {
                    throw new FatalInternalException(object + " is on writable list but has read barrier");
                }
                if (ascertainProblem) {
                    writableTable.put(object);
                }
                ++writableObjectCount;
            }
            WeakCache.WeakCacheEnumeration allObjects = this.getObjects();
            while (allObjects.hasMoreElements()) {
                Object object = allObjects.nextElement();
                if (object == null) continue;
                ObjectReference objRef = (ObjectReference)allObjects.currentKey();
                if (Utilities.isPrimitiveWrapperInstance(object) || object instanceof String) continue;
                if (!this.om.hasWriteBarrier(object, objRef)) {
                    if (ascertainProblem && writableTable.get(object) == null) {
                        throw new FatalInternalException(object + " is writable but not on the writable list.");
                    }
                    ++writableObjectCountVerify;
                    continue;
                }
                if (this.om.hasReadBarrier(object, objRef)) continue;
                if (ascertainProblem && readableTable.get(object) == null) {
                    throw new FatalInternalException(object + " is readable but not on the readable list.");
                }
                ++readableObjectCountVerify;
            }
            if (ascertainProblem) continue;
            if (readableObjectCount != readableObjectCountVerify || writableObjectCount != writableObjectCountVerify) {
                ascertainProblem = true;
                continue;
            }
            done = true;
        }
    }

    synchronized Object findObject(byte[] buffer, int offset) {
        this.tempObjRef.setAttributes(buffer, offset);
        return this.findObject(this.tempObjRef);
    }

    Object findObject(ObjectReference objRef) {
        HashBucket bucket = this.refToObject.findBucket(objRef);
        if (bucket == null) {
            return null;
        }
        return bucket.getElement();
    }

    ObjectReference findObjRef(Object object) {
        return this.findObjRef(object, true, true);
    }

    ObjectReference findObjRef(Object object, boolean checkIsDestroyed) {
        return this.findObjRef(object, checkIsDestroyed, true);
    }

    ObjectReference findObjRef(Object object, boolean checkIsDestroyed, boolean checkStale) {
        ObjectReference ref;
        ObjectReference objectReference = ref = object instanceof IPersistent ? ((IPersistent)object).ODIgetRef() : (ObjectReference)this.weakObjectToRef.get(object);
        if (ref == null) {
            return ref;
        }
        if (checkIsDestroyed && ObjRefUtils.isDestroyed(ref)) {
            throw new ObjectNotFoundException("Attempt to access a destroyed persistent object: " + ObjectManager.objectIDString(object));
        }
        if (checkStale && ObjRefUtils.isStale(ref)) {
            throw new ObjectException("Attempt to access a stale persistent object: " + ObjectManager.objectIDString(object));
        }
        return ref;
    }

    boolean isPersistentThisTable(Object object) {
        if (object instanceof IPersistent) {
            return this.refToObject.get(((IPersistent)object).ODIgetRef()) == object;
        }
        return this.weakObjectToRef.get(object) != null;
    }

    void readableObjectCleanup(boolean assertNoReadableObjects) {
        this.refToObject.resetReadableList(assertNoReadableObjects);
    }

    void dirtyObjectCleanup(boolean assertNoWritableObjects) {
        this.refToObject.resetWritableList(assertNoWritableObjects);
    }

    Object pickDirtyObject() {
        HashBucket hb = this.refToObject.pickWritableList();
        return hb != null ? hb.getElement() : null;
    }

    ObjectReference pickDirtyObjectReference() {
        HashBucket hb = this.refToObject.pickWritableList();
        return hb != null ? (ObjectReference)hb.getKey() : null;
    }

    WeakCache.WeakCacheEnumeration getObjects() {
        return this.refToObject.elements();
    }

    WeakCache.WeakCacheEnumeration getWritableObjects() {
        return this.refToObject.writableElements();
    }

    WeakCache.WeakCacheEnumeration getReadableObjects() {
        return this.refToObject.readableElements();
    }

    WeakCache.WeakCacheEnumeration getOldestCachedObjects() {
        return this.refToObject.oldestCachedElements();
    }

    Object getOldestCachedObject() {
        return this.refToObject.oldestCachedObject();
    }

    ObjectReference getOldestCachedObjectReference() {
        return this.refToObject.oldestCachedObjectReference();
    }

    WeakCache.ChainedBucketEnumeration getOldestCachedBuckets() {
        return this.refToObject.oldestCachedElementBuckets();
    }

    Enumeration getBuckets() {
        return this.refToObject.buckets();
    }

    void updateCounters(Properties props, boolean reset) {
        this.refToObject.updateCounters(props, reset);
    }
}

