/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp.mtsonic;

import com.odi.DatabaseAlreadyExistsException;
import com.odi.DatabaseException;
import com.odi.ObjectStoreException;
import com.odi.ReplicationController;
import com.odi.ReplicationStateHandler;
import com.odi.Session;
import com.odi.imp.mtsonic.ObjectAccess8ByteObjRefFormat;
import com.odi.imp.mtsonic.SchemaManager;
import com.odi.imp.mtsonic.StorageObject;
import com.sonicsw.mtstorage.IStorage;
import com.sonicsw.mtstorage.impl.Storage;
import com.sonicsw.mtstorage.replication.ReplicationManager;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class DatabasesTable {
    static DatabasesTable m_databases = new DatabasesTable();
    HashMap m_table = new HashMap();

    DatabasesTable() {
    }

    synchronized void getMetrics(Properties props) {
        for (String storageName : this.m_table.keySet()) {
            StorageObject storage = this.getStorage(storageName);
            if (storage == null) continue;
            storage.getMetrics(props);
        }
    }

    private synchronized Object getSynchObject(String name) {
        StorageEntry synchObject = (StorageEntry)this.m_table.get(name);
        if (synchObject == null) {
            synchObject = new StorageEntry();
            this.m_table.put(name, synchObject);
        }
        return synchObject;
    }

    private synchronized int incCounter(String name) {
        StorageEntry synchObject = (StorageEntry)this.m_table.get(name);
        ++synchObject.m_counter;
        return synchObject.m_counter;
    }

    private synchronized int decCounter(String name) {
        StorageEntry synchObject = (StorageEntry)this.m_table.get(name);
        --synchObject.m_counter;
        return synchObject.m_counter;
    }

    private synchronized StorageObject getStorage(String name) {
        return ((StorageEntry)this.m_table.get((Object)name)).m_storage;
    }

    private synchronized void resetCounter(String name) {
        ((StorageEntry)this.m_table.get((Object)name)).m_counter = 0;
    }

    private synchronized void setStorage(String name, StorageObject storage) {
        ((StorageEntry)this.m_table.get((Object)name)).m_storage = storage;
    }

    private synchronized void setPhysicalStorage(String name, IStorage storage) {
        ((StorageEntry)this.m_table.get((Object)name)).m_physicalStorage = storage;
    }

    private synchronized IStorage getPhysicalStorage(String name) {
        return ((StorageEntry)this.m_table.get((Object)name)).m_physicalStorage;
    }

    private synchronized void setReplicationManager(String name, ReplicationManager replicationManager) {
        ((StorageEntry)this.m_table.get((Object)name)).m_replicationManager = replicationManager;
    }

    private synchronized ReplicationManager getReplicationManager(String name) {
        return ((StorageEntry)this.m_table.get((Object)name)).m_replicationManager;
    }

    private synchronized IStorage getPhysicalStorageFromRepOrStandalone(String name) throws ObjectStoreException {
        ReplicationManager repManager = this.getReplicationManager(name);
        if (repManager != null) {
            IStorage storage = repManager.getActiveStorage();
            if (storage == null) {
                throw new ObjectStoreException("Database " + name + " is not in active replication state.");
            }
            return storage;
        }
        return this.getPhysicalStorage(name);
    }

    private synchronized boolean hasStorage(String name) {
        return ((StorageEntry)this.m_table.get((Object)name)).m_counter > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openPhysicalStorage(ReplicationController controller, ReplicationStateHandler callerStateListener, String name, HashMap storageParameters, boolean createNew, boolean thisPrimary, boolean startActive, boolean autoDualActiveResolve, HashMap[] channelConfigs) throws ObjectStoreException {
        Object object = this.getSynchObject(name);
        synchronized (object) {
            ReplicationManager replicationManager;
            DatabasesTable databasesTable = this;
            synchronized (databasesTable) {
                if (this.getPhysicalStorage(name) != null || this.getReplicationManager(name) != null) {
                    throw new ObjectStoreException("Storage " + name + " is already open");
                }
            }
            try {
                replicationManager = new ReplicationManager(controller, callerStateListener, name, storageParameters, createNew, thisPrimary, startActive, autoDualActiveResolve, channelConfigs);
            }
            catch (IOException e) {
                throw new ObjectStoreException(e.getMessage());
            }
            DatabasesTable databasesTable2 = this;
            synchronized (databasesTable2) {
                this.setReplicationManager(name, replicationManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openPhysicalStorage(String name, boolean createDB, HashMap parameters) throws ObjectStoreException {
        Object object = this.getSynchObject(name);
        synchronized (object) {
            DatabasesTable databasesTable = this;
            synchronized (databasesTable) {
                if (this.getPhysicalStorage(name) != null || this.getReplicationManager(name) != null) {
                    throw new ObjectStoreException("Storage " + name + " is already open");
                }
            }
            Storage storage = new Storage();
            try {
                storage.open(name, createDB, parameters != null ? parameters : new HashMap());
            }
            catch (IOException e) {
                throw new ObjectStoreException(e.getMessage());
            }
            DatabasesTable databasesTable2 = this;
            synchronized (databasesTable2) {
                this.setPhysicalStorage(name, storage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closePhysicalStorage(String name) throws ObjectStoreException {
        Object object = this.getSynchObject(name);
        synchronized (object) {
            IStorage storage = null;
            ReplicationManager replicationManager = null;
            DatabasesTable databasesTable = this;
            synchronized (databasesTable) {
                storage = this.getPhysicalStorage(name);
                replicationManager = this.getReplicationManager(name);
                if (storage == null && replicationManager == null) {
                    return;
                }
            }
            try {
                if (storage != null) {
                    storage.close();
                } else {
                    replicationManager.close();
                }
            }
            catch (IOException e) {
                throw new ObjectStoreException(e.getMessage());
            }
            databasesTable = this;
            synchronized (databasesTable) {
                this.setPhysicalStorage(name, null);
                this.setReplicationManager(name, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StorageObject openStorage(String name, ObjectAccess8ByteObjRefFormat objectAccess, SchemaManager schemaManager, boolean openForWrite, HashMap parameters, int upgradeType_not_used, boolean exclusive_always_false) throws ObjectStoreException, DatabaseException {
        Object object = this.getSynchObject(name);
        synchronized (object) {
            DatabasesTable databasesTable = this;
            synchronized (databasesTable) {
                if (this.hasStorage(name)) {
                    this.incCounter(name);
                    return this.getStorage(name);
                }
            }
            StorageObject storageObject = new StorageObject();
            storageObject.init(this.getPhysicalStorageFromRepOrStandalone(name), schemaManager, objectAccess, null);
            try {
                storageObject.openDatabase(name, openForWrite, parameters, upgradeType_not_used, exclusive_always_false);
            }
            catch (IOException e) {
                throw new ObjectStoreException(e.getMessage());
            }
            DatabasesTable databasesTable2 = this;
            synchronized (databasesTable2) {
                this.setStorage(name, storageObject);
                this.incCounter(name);
                return storageObject;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StorageObject createStorage(String name, ObjectAccess8ByteObjRefFormat objectAccess, SchemaManager schemaManager, HashMap parameters) throws ObjectStoreException, DatabaseException {
        Object object = this.getSynchObject(name);
        synchronized (object) {
            File dataFile;
            StorageObject storageObject = new StorageObject();
            IStorage physicalStorage = this.getPhysicalStorageFromRepOrStandalone(name);
            if (physicalStorage == null && (dataFile = new File(name)).exists()) {
                throw new DatabaseAlreadyExistsException(name);
            }
            storageObject.init(physicalStorage, schemaManager, objectAccess, null);
            try {
                storageObject.createDatabase(name, parameters);
            }
            catch (IOException e) {
                throw new ObjectStoreException(e.getMessage());
            }
            DatabasesTable databasesTable = this;
            synchronized (databasesTable) {
                this.setStorage(name, storageObject);
                this.incCounter(name);
                return storageObject;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeStorage(String name, Session session, StorageObject storageObject, Long snapShot) throws IOException {
        if (snapShot != null) {
            storageObject.deleteSnapshot(snapShot);
        }
        Object object = this.getSynchObject(name);
        synchronized (object) {
            if (this.decCounter(name) == 0) {
                storageObject.closeDatabase(session);
                this.setStorage(name, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyStorage(String name, StorageObject storageObject) throws IOException {
        Object object = this.getSynchObject(name);
        synchronized (object) {
            storageObject.destroyDatabase();
            this.resetCounter(name);
            this.setStorage(name, null);
            this.setPhysicalStorage(name, null);
        }
    }

    private class StorageEntry {
        ReplicationManager m_replicationManager = null;
        StorageObject m_storage = null;
        int m_counter = 0;
        IStorage m_physicalStorage = null;

        StorageEntry() {
        }
    }
}

