/*
 * Decompiled with CFR 0.152.
 */
package com.odi.tools;

import com.odi.Session;
import com.odi.imp.Database;
import java.util.Properties;

class GCDB {
    GCDB() {
    }

    public static void main(String[] argv) {
        if (argv.length < 1) {
            System.err.println("usage: [-detail] dbname.odb ...");
            System.exit(1);
        }
        Session session = Session.create(null, null);
        session.join();
        boolean detail = false;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("-detail")) {
                detail = true;
                continue;
            }
            Database db = (Database)Database.open(argv[i], 7);
            db.close();
            Properties ret = db.GC(null);
            if (ret == null) {
                System.err.println("GC is not available");
                continue;
            }
            String gcObjectsString = ret.getProperty("Unreferenced Objects");
            if (gcObjectsString == null) {
                System.err.println("Unable to determine outcome of GC operation.");
            } else {
                System.out.println("Reclaimed " + gcObjectsString + " unreachable objects.");
            }
            if (!detail) continue;
            ret.list(System.out);
        }
    }

    static {
        try {
            Class.forName("com.odi.util.BTreeNodeFactory");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

