/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.ObjectStore;
import com.odi.imp.ObjectReference;
import com.odi.imp.Utilities;
import com.odi.util.IndexException;
import com.odi.util.query.Methods;
import com.odi.util.query.MethodsGenerator;
import com.odi.util.query.QPT;
import java.io.Serializable;

public class Path
implements IPersistent,
IPersistentHooks,
Serializable {
    static final long serialVersionUID = 2163990325894138269L;
    private transient Class theClass;
    private transient Class keyClass;
    private transient QPT qpt;
    private transient Methods methods;
    private transient int fieldIndex;
    private String classString;
    private String pathString;
    private static final ClassInfo classinfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.Path"));
    private transient ObjectReference ref;
    public transient byte objectState;

    @Override
    public void initializeContents(GenericObject genObject) {
        this.classString = genObject.getStringField(1, classinfo);
        this.pathString = genObject.getStringField(2, classinfo);
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void flushContents(GenericObject genObject) {
        genObject.setStringField(1, this.classString, classinfo);
        genObject.setStringField(2, this.pathString, classinfo);
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public void clearContents() {
        this.classString = null;
        this.pathString = null;
    }

    @Override
    public void preDestroyPersistent() {
        ObjectStore.fetch(this);
        ObjectStore.destroy(this.classString);
        ObjectStore.destroy(this.pathString);
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte objectState) {
        this.objectState = objectState;
    }

    public Path(ClassInfo ignored) {
    }

    public String getClassString() {
        ObjectStore.fetch(this);
        return this.classString;
    }

    public synchronized Class getElementType() {
        ObjectStore.fetch(this);
        if (this.theClass == null) {
            this.checkPath();
        }
        return this.theClass;
    }

    public String getPathString() {
        ObjectStore.fetch(this);
        return this.pathString;
    }

    public synchronized Class getKeyType() {
        ObjectStore.fetch(this);
        if (this.keyClass == null) {
            this.checkPath();
        }
        return this.keyClass;
    }

    private void checkPath() {
        if (this.qpt != null) {
            return;
        }
        try {
            this.theClass = Utilities.findRegisteredClass(this.classString);
        }
        catch (ClassNotFoundException e) {
            throw new IndexException("class not found: " + this.classString);
        }
        this.qpt = new QPT(this.theClass, this.pathString, null, 2);
        this.keyClass = this.qpt.getRoot().getResultType();
        this.theClass = this.qpt.getRoot().getThisClass();
        if (this.theClass == null) {
            throw new IndexException("not a valid index path for this class: " + this.classString + "." + this.pathString);
        }
        if (!this.classString.equals(this.theClass.getName())) {
            ObjectStore.destroy(this.classString);
            this.classString = new String(this.theClass.getName());
        }
    }

    public synchronized Object getKey(Object obj) {
        if (obj == null) {
            Utilities.throwNullArgumentException("Path", "getKey", "obj");
        }
        ObjectStore.fetch(this);
        if (this.methods == null) {
            this.checkPath();
            MethodsGenerator generator = new MethodsGenerator(this.qpt.freeVariables, this.theClass);
            this.fieldIndex = generator.addGetField(this.qpt.getRoot());
            this.methods = generator.createInstance(this.theClass.getClassLoader());
        }
        if (obj instanceof IPersistent) {
            ObjectStore.fetch((IPersistent)obj);
        }
        return this.methods.getField(this.fieldIndex, obj);
    }

    public Path(Class elementType, String pathStr) {
        this(elementType, pathStr, true);
    }

    Path(Class elementType, String pathStr, boolean checkPath) {
        this.theClass = elementType;
        this.classString = new String(this.theClass.getName());
        this.pathString = new String(pathStr);
        if (checkPath) {
            this.checkPath();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path that = (Path)obj;
        ObjectStore.fetch(this);
        ObjectStore.fetch(that);
        return this.classString.equals(that.classString) && this.pathString.equals(that.pathString);
    }

    public int hashCode() {
        ObjectStore.fetch(this);
        return this.classString.hashCode() + this.pathString.hashCode();
    }
}

