/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.util.CharIterator;
import com.odi.util.StringCharIterator;
import com.odi.util.query.InvalidPatternException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public final class PatternMatcher {
    public static final char ONE_CHAR = '?';
    public static final char MANY_CHARS = '*';
    public static final char ESCAPE_CHAR = '&';
    public static final char CASE_INSENSITIVE_ESCAPE_CHAR = 'i';
    public static final char[] CHARS_NEEDING_ESCAPE = new char[]{'?', '*', '&', '[', ']', '(', ')', '|'};
    public static final char[] CHARS_ILLEGAL_UNESCAPED = new char[]{'[', ']', '(', ')', '|'};
    static final int ONE_INPUT = 65536;
    static final int MANY_INPUTS = 131072;
    static final int ILLEGAL_INPUT = -1;
    DFA dfa;
    private boolean caseInsensitive;
    static boolean debug = Boolean.getBoolean("com.odi.util.query.PatternMatcher.debug");
    private StringCharIterator stringCharIterator;

    public static void main(String[] args) {
        PatternMatcher matcher;
        System.out.println("Pattern:\n  " + args[0]);
        try {
            matcher = new PatternMatcher(args[0]);
        }
        catch (InvalidPatternException e) {
            System.out.println("Invalid pattern:\n  " + e.getMessage());
            return;
        }
        if (args.length == 1) {
            return;
        }
        System.out.println("Match results:");
        for (int i = 1; i < args.length; ++i) {
            System.out.println("  " + args[i] + " => " + matcher.match(args[i]));
        }
    }

    public PatternMatcher(String pattern) {
        if (pattern != null) {
            int[] intPattern = PatternMatcher.parse(pattern);
            this.dfa = new DFA(intPattern, PatternMatcher.isCaseInsensitive(pattern));
        }
    }

    public boolean match(CharIterator text) {
        if (debug) {
            System.err.println("Debug matcher: Reading text:");
            final CharIterator original = text;
            text = new CharIterator(){

                @Override
                public boolean hasNext() {
                    return original.hasNext();
                }

                @Override
                public char next() {
                    try {
                        char result = original.next();
                        System.err.println("  " + PatternMatcher.inputString(result));
                        return result;
                    }
                    catch (NoSuchElementException e) {
                        System.err.println("  Done");
                        throw e;
                    }
                }

                @Override
                public boolean isNull() {
                    boolean result = original.isNull();
                    if (result) {
                        System.err.println("  Null");
                    }
                    return result;
                }
            };
        }
        boolean result = this.dfa == null ? false : (text.isNull() ? false : this.dfa.match(text));
        if (debug) {
            System.err.println("Debug matcher: Match result: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(String text) {
        boolean result;
        if (text == null) {
            result = false;
        } else if (this.dfa == null) {
            result = false;
        } else {
            PatternMatcher patternMatcher = this;
            synchronized (patternMatcher) {
                if (this.stringCharIterator == null) {
                    this.stringCharIterator = new StringCharIterator(text);
                } else {
                    this.stringCharIterator.reset(text);
                }
                result = this.dfa.match(this.stringCharIterator);
            }
        }
        if (debug) {
            System.err.println("Debug matcher: Text: " + text);
            System.err.println("Debug matcher: Match result: " + result);
        }
        return result;
    }

    public static String constantPrefix(String pattern) {
        int input;
        if (pattern == null) {
            return null;
        }
        int[] inputPattern = PatternMatcher.parse(pattern);
        boolean caseInsensitive = PatternMatcher.isCaseInsensitive(pattern);
        int max = inputPattern.length;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < max && (input = inputPattern[i]) != 65536 && input != 131072; ++i) {
            char c = (char)input;
            if (caseInsensitive) {
                char upper = Character.toUpperCase(c);
                char lower = Character.toLowerCase(c);
                c = lower < upper ? lower : upper;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String simpleSubstring(String pattern) {
        if (pattern == null) {
            return null;
        }
        int[] inputPattern = PatternMatcher.parse(pattern);
        int max = inputPattern.length;
        if (max < 2 || inputPattern[0] != 131072) {
            return null;
        }
        if (inputPattern[max - 1] == 131072) {
            --max;
        }
        for (int i = 1; i < max; ++i) {
            if (inputPattern[i] >= 0 && inputPattern[i] < 65536) continue;
            return null;
        }
        char[] result = new char[max - 1];
        for (int i = 1; i < max; ++i) {
            result[i - 1] = (char)inputPattern[i];
        }
        return new String(result);
    }

    public static int[] parse(String pattern) {
        int i;
        if (pattern == null) {
            return null;
        }
        if (debug) {
            System.err.println("Debug matcher: Parsing \"" + pattern + "\"");
        }
        boolean inEscape = false;
        boolean caseInsensitive = false;
        int resultLength = 0;
        int length = pattern.length();
        int[] result = new int[length];
        for (i = 0; i < length; ++i) {
            char c = pattern.charAt(i);
            int input = -1;
            boolean literal = true;
            if (inEscape) {
                if (PatternMatcher.member(c, CHARS_NEEDING_ESCAPE)) {
                    input = c;
                } else if (c == 'i') {
                    if (i != 1) {
                        throw new InvalidPatternException("The escape sequence for a case insensitive search, \"&i\", must appear at the start of the pattern.", i);
                    }
                    caseInsensitive = true;
                } else {
                    throw new InvalidPatternException("The '" + c + "' character is not permitted " + "after the escape character '" + '&' + "'.", i);
                }
                inEscape = false;
            } else if (c == '&') {
                inEscape = true;
            } else if (c == '?') {
                literal = false;
                input = 65536;
            } else if (c == '*') {
                literal = false;
                input = 131072;
            } else {
                if (PatternMatcher.member(c, CHARS_ILLEGAL_UNESCAPED)) {
                    throw new InvalidPatternException("The '" + c + "' character is only permitted " + "after the escape character '" + '&' + "'.", i);
                }
                input = c;
            }
            if (input == -1) continue;
            if (literal && caseInsensitive) {
                input = Character.toLowerCase((char)input);
            }
            result[resultLength++] = input;
        }
        if (inEscape) {
            throw new InvalidPatternException("The pattern ends with the escape character '&'.", length - 1);
        }
        if (resultLength != length) {
            int[] realResult = new int[resultLength];
            System.arraycopy(result, 0, realResult, 0, resultLength);
            result = realResult;
        }
        if (debug) {
            if (caseInsensitive) {
                System.err.println("Debug matcher: Pattern is case insensitive");
            }
            System.err.print("Debug matcher: Parse result:");
            for (i = 0; i < result.length; ++i) {
                int input = result[i];
                System.err.print(' ');
                System.err.print(PatternMatcher.inputString(input));
            }
            System.err.println("");
        }
        return result;
    }

    public static boolean isCaseInsensitive(String pattern) {
        return pattern != null && pattern.length() >= 2 && pattern.charAt(0) == '&' && pattern.charAt(1) == 'i';
    }

    private static boolean member(char c, char[] array) {
        int max = array.length;
        for (int i = 0; i < max; ++i) {
            if (array[i] != c) continue;
            return true;
        }
        return false;
    }

    static String inputString(int input) {
        if (input == 65536) {
            return "ONE";
        }
        if (input == 131072) {
            return "MANY";
        }
        if (input < 256) {
            return " '" + (char)input + '\'';
        }
        return "'\\u" + Integer.toHexString(input) + '\'';
    }

    static final class DFA
    extends FA {
        private boolean caseInsensitive;

        DFA(int[] pattern, boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            NFA nfa = new NFA(pattern);
            Hashtable<BitSet, BitSet> unmarked = new Hashtable<BitSet, BitSet>();
            Hashtable<BitSet, Integer> stateSetToDFAState = new Hashtable<BitSet, Integer>();
            BitSet startSet = new BitSet(nfa.numStates);
            startSet.set(0);
            this.addState();
            DFA.updateStateAccepting(this.getStateData(0), DFA.getStateAccepting(nfa.getStateData(0)));
            stateSetToDFAState.put(startSet, new Integer(0));
            unmarked.put(startSet, startSet);
            InputIterator inputs = new InputIterator();
            while (!unmarked.isEmpty()) {
                Enumeration iterateUnmarked = unmarked.elements();
                while (iterateUnmarked.hasMoreElements()) {
                    BitSet stateSet = (BitSet)iterateUnmarked.nextElement();
                    int DFAState = (Integer)stateSetToDFAState.get(stateSet);
                    unmarked.remove(stateSet);
                    inputs.reset(nfa, stateSet);
                    while (inputs.hasNext()) {
                        int nextDFAState;
                        int input = inputs.next();
                        BitSet nextSet = this.move(nfa, stateSet, input);
                        Object nextDFAStateObject = stateSetToDFAState.get(nextSet);
                        if (nextDFAStateObject != null) {
                            nextDFAState = (Integer)nextDFAStateObject;
                        } else {
                            nextDFAState = this.addState();
                            stateSetToDFAState.put(nextSet, new Integer(nextDFAState));
                            int accepting = 0;
                            for (int state = 0; state < nfa.numStates; ++state) {
                                if (!nextSet.get(state)) continue;
                                accepting = DFA.getStateAccepting(nfa.getStateData(state));
                                DFA.updateStateAccepting(this.getStateData(nextDFAState), accepting);
                                if (accepting == 3) break;
                            }
                            if (accepting != 3) {
                                unmarked.put(nextSet, nextSet);
                            }
                        }
                        this.addTransition(DFAState, input, nextDFAState);
                    }
                }
            }
            if (debug) {
                System.err.println("Debug matcher: " + this);
                System.err.println("Debug matcher: NFA state sets to DFA states:\n" + stateSetToDFAState);
            }
        }

        boolean match(CharIterator text) {
            int state = 0;
            while (text.hasNext() && state >= 0) {
                int[] stateData = this.getStateData(state);
                if (DFA.getStateAccepting(stateData) == 3) {
                    return true;
                }
                state = this.getNext(state, text.next());
            }
            if (state < 0) {
                return false;
            }
            if (DFA.getStateAccepting(this.getStateData(state)) != 0) {
                return true;
            }
            if (debug) {
                System.err.println("Debug matcher: Mismatch: No more input in state " + state);
            }
            return false;
        }

        private int getNext(int state, char input) {
            if (this.caseInsensitive) {
                input = Character.toLowerCase(input);
            }
            int[] stateData = this.getStateData(state);
            int max = DFA.getStateNumTransitions(stateData);
            int result = -1;
            for (int i = 0; i < max; ++i) {
                int transitionInput = DFA.getStateTransitionInput(stateData, i);
                if (transitionInput == input) {
                    return DFA.getStateTransitionNext(stateData, i);
                }
                if (transitionInput != 65536) continue;
                result = DFA.getStateTransitionNext(stateData, i);
            }
            if (debug && result == -1) {
                System.err.println("Debug matcher: Mismatch: Input " + PatternMatcher.inputString(input) + ", state = " + state);
            }
            return result;
        }

        private BitSet move(NFA nfa, BitSet from, int input) {
            BitSet result = new BitSet(nfa.numStates);
            for (int state = 0; state < nfa.numStates; ++state) {
                if (!from.get(state)) continue;
                int[] stateData = nfa.getStateData(state);
                int numTransitions = DFA.getStateNumTransitions(stateData);
                for (int i = 0; i < numTransitions; ++i) {
                    int transitionInput = DFA.getStateTransitionInput(stateData, i);
                    if (transitionInput != input && transitionInput != 65536) continue;
                    result.set(DFA.getStateTransitionNext(stateData, i));
                }
            }
            return result;
        }

        static class InputIterator {
            private BitSet found = new BitSet(65536);
            private int[] unique = new int[128];
            private int pos;
            private int length;

            InputIterator() {
            }

            boolean hasNext() {
                return this.pos < this.length;
            }

            int next() {
                if (this.pos < this.length) {
                    return this.unique[this.pos++];
                }
                throw new NoSuchElementException();
            }

            void reset(NFA nfa, BitSet stateSet) {
                this.found.xor(this.found);
                this.pos = 0;
                this.length = 0;
                for (int state = 0; state < nfa.numStates; ++state) {
                    if (!stateSet.get(state)) continue;
                    int[] stateData = nfa.getStateData(state);
                    int numTransitions = FA.getStateNumTransitions(stateData);
                    for (int i = 0; i < numTransitions; ++i) {
                        int input = FA.getStateTransitionInput(stateData, i);
                        if (this.found.get(input)) continue;
                        this.found.set(input);
                        if (this.length >= this.unique.length) {
                            int[] newUnique = new int[this.unique.length + 128];
                            System.arraycopy(this.unique, 0, newUnique, 0, this.unique.length);
                            this.unique = newUnique;
                        }
                        this.unique[this.length++] = input;
                    }
                }
            }
        }
    }

    static final class NFA
    extends FA {
        NFA(int[] pattern) {
            int state = this.addState();
            int max = pattern.length;
            int input = -1;
            for (int i = 0; i < max; ++i) {
                input = pattern[i];
                if (input == 131072) {
                    this.addTransition(state, 65536, state);
                    continue;
                }
                int next = this.addState();
                this.addTransition(state, input, next);
                state = next;
            }
            NFA.updateStateAccepting(this.getStateData(state), input == 131072 ? 3 : 1);
            if (debug) {
                System.err.println("Debug matcher: " + this);
            }
        }
    }

    static abstract class FA {
        private static final int STATES_INCREMENT = 20;
        private static final int TRANSITIONS_INCREMENT = 3;
        protected static final int ILLEGAL_STATE = -1;
        protected static final int ACCEPT_NONE = 0;
        protected static final int ACCEPT_FINAL = 1;
        protected static final int ACCEPT_ANY = 3;
        protected static final int ACCEPT_MASK = 3;
        private int[][] states = new int[20][];
        public int numStates;

        FA() {
        }

        final int addState() {
            if (this.numStates == this.states.length) {
                int[][] newStates = new int[this.numStates + 20][];
                System.arraycopy(this.states, 0, newStates, 0, this.numStates);
                this.states = newStates;
            }
            int[] data = new int[7];
            this.states[this.numStates] = data;
            return this.numStates++;
        }

        final void addTransition(int state, int input, int next) {
            int[] stateData = this.getStateData(state);
            int numTransitions = FA.getStateNumTransitions(stateData);
            int offset = 1 + numTransitions * 2;
            if (offset == stateData.length) {
                int[] newData = new int[stateData.length + 6];
                System.arraycopy(stateData, 0, newData, 0, stateData.length);
                this.states[state] = newData;
                stateData = newData;
            }
            stateData[offset] = input;
            stateData[offset + 1] = next;
            FA.incrStateNumTransitions(stateData);
        }

        final int[] getStateData(int state) {
            return this.states[state];
        }

        static final int getStateAccepting(int[] stateData) {
            return stateData[0] & 3;
        }

        static final void updateStateAccepting(int[] stateData, int value) {
            stateData[0] = stateData[0] | value;
        }

        static final int getStateNumTransitions(int[] stateData) {
            return stateData[0] >> 2;
        }

        private static void incrStateNumTransitions(int[] stateData) {
            stateData[0] = stateData[0] + 4;
        }

        static final int getStateTransitionInput(int[] stateData, int transition) {
            return stateData[1 + transition * 2];
        }

        static final int getStateTransitionNext(int[] stateData, int transition) {
            return stateData[2 + transition * 2];
        }

        public final String toString() {
            StringBuffer buf = new StringBuffer(super.toString());
            buf.append(" {\n");
            for (int state = 0; state < this.numStates; ++state) {
                int[] stateData = this.getStateData(state);
                buf.append("  ");
                buf.append(state);
                if (FA.getStateAccepting(stateData) == 1) {
                    buf.append(" (accepting final):\n");
                } else if (FA.getStateAccepting(stateData) == 3) {
                    buf.append(" (accepting any):\n");
                } else {
                    buf.append(":\n");
                }
                int numTransitions = FA.getStateNumTransitions(stateData);
                for (int i = 0; i < numTransitions; ++i) {
                    int input = FA.getStateTransitionInput(stateData, i);
                    int next = FA.getStateTransitionNext(stateData, i);
                    buf.append("    ");
                    buf.append(PatternMatcher.inputString(input));
                    buf.append(" => ");
                    buf.append(next);
                    buf.append('\n');
                }
            }
            buf.append('}');
            return buf.toString();
        }
    }
}

